/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsRegistrationCallback;

public interface IImsRegistration
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.IImsRegistration";

    public int getRegistrationTechnology() throws RemoteException;

    public void addRegistrationCallback(IImsRegistrationCallback var1) throws RemoteException;

    public void removeRegistrationCallback(IImsRegistrationCallback var1) throws RemoteException;

    public void triggerFullNetworkRegistration(int var1, String var2) throws RemoteException;

    public void triggerUpdateSipDelegateRegistration() throws RemoteException;

    public void triggerSipDelegateDeregistration() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsRegistration {
        static final int TRANSACTION_getRegistrationTechnology = 1;
        static final int TRANSACTION_addRegistrationCallback = 2;
        static final int TRANSACTION_removeRegistrationCallback = 3;
        static final int TRANSACTION_triggerFullNetworkRegistration = 4;
        static final int TRANSACTION_triggerUpdateSipDelegateRegistration = 5;
        static final int TRANSACTION_triggerSipDelegateDeregistration = 6;

        public Stub() {
            this.attachInterface(this, IImsRegistration.DESCRIPTOR);
        }

        public static IImsRegistration asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IImsRegistration.DESCRIPTOR);
            if (iin != null && iin instanceof IImsRegistration) {
                return (IImsRegistration)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getRegistrationTechnology";
                }
                case 2: {
                    return "addRegistrationCallback";
                }
                case 3: {
                    return "removeRegistrationCallback";
                }
                case 4: {
                    return "triggerFullNetworkRegistration";
                }
                case 5: {
                    return "triggerUpdateSipDelegateRegistration";
                }
                case 6: {
                    return "triggerSipDelegateDeregistration";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IImsRegistration.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _result = this.getRegistrationTechnology();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IImsRegistrationCallback _arg0 = IImsRegistrationCallback.Stub.asInterface(data.readStrongBinder());
                    this.addRegistrationCallback(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IImsRegistrationCallback _arg0 = IImsRegistrationCallback.Stub.asInterface(data.readStrongBinder());
                    this.removeRegistrationCallback(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.triggerFullNetworkRegistration(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.triggerUpdateSipDelegateRegistration();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.triggerSipDelegateDeregistration();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IImsRegistration impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IImsRegistration getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IImsRegistration {
            private IBinder mRemote;
            public static IImsRegistration sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IImsRegistration.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRegistrationTechnology() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getRegistrationTechnology();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addRegistrationCallback(c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeRegistrationCallback(c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void triggerFullNetworkRegistration(int sipCode, String sipReason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    _data.writeInt(sipCode);
                    _data.writeString(sipReason);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().triggerFullNetworkRegistration(sipCode, sipReason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void triggerUpdateSipDelegateRegistration() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().triggerUpdateSipDelegateRegistration();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void triggerSipDelegateDeregistration() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().triggerSipDelegateDeregistration();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsRegistration {
        @Override
        public int getRegistrationTechnology() throws RemoteException {
            return 0;
        }

        @Override
        public void addRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
        }

        @Override
        public void removeRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
        }

        @Override
        public void triggerFullNetworkRegistration(int sipCode, String sipReason) throws RemoteException {
        }

        @Override
        public void triggerUpdateSipDelegateRegistration() throws RemoteException {
        }

        @Override
        public void triggerSipDelegateDeregistration() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

