/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Editable;
import android.text.Layout;
import android.text.PackedIntVector;
import android.text.PackedObjectVector;
import android.text.PrecomputedText;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ReplacementSpan;
import android.text.style.UpdateLayout;
import android.text.style.WrapTogetherSpan;
import android.util.ArraySet;
import android.util.Pools;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.lang.ref.WeakReference;

public class DynamicLayout
extends Layout {
    private static final int PRIORITY = 128;
    private static final int BLOCK_MINIMUM_CHARACTER_LENGTH = 400;
    private CharSequence mBase;
    private CharSequence mDisplay;
    private ChangeWatcher mWatcher;
    private boolean mIncludePad;
    private boolean mFallbackLineSpacing;
    private boolean mEllipsize;
    private int mEllipsizedWidth;
    private TextUtils.TruncateAt mEllipsizeAt;
    private int mBreakStrategy;
    private int mHyphenationFrequency;
    private int mJustificationMode;
    private PackedIntVector mInts;
    private PackedObjectVector<Layout.Directions> mObjects;
    public static final int INVALID_BLOCK_INDEX = -1;
    private int[] mBlockEndLines;
    private int[] mBlockIndices;
    private ArraySet<Integer> mBlocksAlwaysNeedToBeRedrawn;
    private int mNumberOfBlocks;
    private int mIndexFirstChangedBlock;
    private int mTopPadding;
    private int mBottomPadding;
    private Rect mTempRect = new Rect();
    @UnsupportedAppUsage
    private static StaticLayout sStaticLayout = null;
    private static StaticLayout.Builder sBuilder = null;
    private static final Object[] sLock = new Object[0];
    private static final int START = 0;
    private static final int DIR = 0;
    private static final int TAB = 0;
    private static final int TOP = 1;
    private static final int DESCENT = 2;
    private static final int EXTRA = 3;
    private static final int HYPHEN = 4;
    private static final int MAY_PROTRUDE_FROM_TOP_OR_BOTTOM = 4;
    private static final int COLUMNS_NORMAL = 5;
    private static final int ELLIPSIS_START = 5;
    private static final int ELLIPSIS_COUNT = 6;
    private static final int COLUMNS_ELLIPSIZE = 7;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int DIR_SHIFT = 30;
    private static final int TAB_MASK = 0x20000000;
    private static final int HYPHEN_MASK = 255;
    private static final int MAY_PROTRUDE_FROM_TOP_OR_BOTTOM_MASK = 256;
    private static final int ELLIPSIS_UNDEFINED = Integer.MIN_VALUE;

    @Deprecated
    public DynamicLayout(CharSequence base, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(base, base, paint, width, align, spacingmult, spacingadd, includepad);
    }

    @Deprecated
    public DynamicLayout(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(base, display, paint, width, align, spacingmult, spacingadd, includepad, null, 0);
    }

    @Deprecated
    public DynamicLayout(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        this(base, display, paint, width, align, TextDirectionHeuristics.FIRSTSTRONG_LTR, spacingmult, spacingadd, includepad, 0, 0, 0, ellipsize, ellipsizedWidth);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public DynamicLayout(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad, int breakStrategy, int hyphenationFrequency, int justificationMode, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        super(DynamicLayout.createEllipsizer(ellipsize, display), paint, width, align, textDir, spacingmult, spacingadd);
        Builder b = Builder.obtain(base, paint, width).setAlignment(align).setTextDirection(textDir).setLineSpacing(spacingadd, spacingmult).setEllipsizedWidth(ellipsizedWidth).setEllipsize(ellipsize);
        this.mDisplay = display;
        this.mIncludePad = includepad;
        this.mBreakStrategy = breakStrategy;
        this.mJustificationMode = justificationMode;
        this.mHyphenationFrequency = hyphenationFrequency;
        this.generate(b);
        Builder.recycle(b);
    }

    private DynamicLayout(Builder b) {
        super(DynamicLayout.createEllipsizer(b.mEllipsize, b.mDisplay), b.mPaint, b.mWidth, b.mAlignment, b.mTextDir, b.mSpacingMult, b.mSpacingAdd);
        this.mDisplay = b.mDisplay;
        this.mIncludePad = b.mIncludePad;
        this.mBreakStrategy = b.mBreakStrategy;
        this.mJustificationMode = b.mJustificationMode;
        this.mHyphenationFrequency = b.mHyphenationFrequency;
        this.generate(b);
    }

    private static CharSequence createEllipsizer(TextUtils.TruncateAt ellipsize, CharSequence display) {
        if (ellipsize == null) {
            return display;
        }
        if (display instanceof Spanned) {
            return new Layout.SpannedEllipsizer(display);
        }
        return new Layout.Ellipsizer(display);
    }

    private void generate(Builder b) {
        int[] start;
        this.mBase = b.mBase;
        this.mFallbackLineSpacing = b.mFallbackLineSpacing;
        if (b.mEllipsize != null) {
            this.mInts = new PackedIntVector(7);
            this.mEllipsizedWidth = b.mEllipsizedWidth;
            this.mEllipsizeAt = b.mEllipsize;
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = b.mEllipsizedWidth;
            e.mMethod = b.mEllipsize;
            this.mEllipsize = true;
        } else {
            this.mInts = new PackedIntVector(5);
            this.mEllipsizedWidth = b.mWidth;
            this.mEllipsizeAt = null;
        }
        this.mObjects = new PackedObjectVector(1);
        if (b.mEllipsize != null) {
            start = new int[7];
            start[5] = Integer.MIN_VALUE;
        } else {
            start = new int[5];
        }
        Layout.Directions[] dirs = new Layout.Directions[]{DIRS_ALL_LEFT_TO_RIGHT};
        Paint.FontMetricsInt fm = b.mFontMetricsInt;
        b.mPaint.getFontMetricsInt(fm);
        int asc = fm.ascent;
        int desc = fm.descent;
        start[0] = 0x40000000;
        start[1] = 0;
        start[2] = desc;
        this.mInts.insertAt(0, start);
        start[1] = desc - asc;
        this.mInts.insertAt(1, start);
        this.mObjects.insertAt(0, (Layout.Directions[])dirs);
        this.reflow(this.mBase, 0, 0, this.mDisplay.length());
        if (this.mBase instanceof Spannable) {
            if (this.mWatcher == null) {
                this.mWatcher = new ChangeWatcher(this);
            }
            Spannable sp = (Spannable)this.mBase;
            int baseLength = this.mBase.length();
            ChangeWatcher[] spans = sp.getSpans(0, baseLength, ChangeWatcher.class);
            for (int i = 0; i < spans.length; ++i) {
                sp.removeSpan(spans[i]);
            }
            sp.setSpan(this.mWatcher, 0, baseLength, 8388626);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void reflow(CharSequence s, int where, int before, int after) {
        if (s != this.mBase) {
            return;
        }
        CharSequence text = this.mDisplay;
        int len = text.length();
        int find = TextUtils.lastIndexOf(text, '\n', where - 1);
        find = find < 0 ? 0 : ++find;
        int diff = where - find;
        before += diff;
        int look = TextUtils.indexOf(text, '\n', (where -= diff) + (after += diff));
        look = look < 0 ? len : ++look;
        int change = look - (where + after);
        before += change;
        after += change;
        if (text instanceof Spanned) {
            boolean again;
            Spanned sp = (Spanned)text;
            do {
                again = false;
                WrapTogetherSpan[] force = sp.getSpans(where, where + after, WrapTogetherSpan.class);
                for (int i = 0; i < force.length; ++i) {
                    int diff2;
                    int st = sp.getSpanStart(force[i]);
                    int en = sp.getSpanEnd(force[i]);
                    if (st < where) {
                        again = true;
                        diff2 = where - st;
                        before += diff2;
                        after += diff2;
                        where -= diff2;
                    }
                    if (en <= where + after) continue;
                    again = true;
                    diff2 = en - (where + after);
                    before += diff2;
                    after += diff2;
                }
            } while (again);
        }
        int startline = this.getLineForOffset(where);
        int startv = this.getLineTop(startline);
        int endline = this.getLineForOffset(where + before);
        if (where + after == len) {
            endline = this.getLineCount();
        }
        int endv = this.getLineTop(endline);
        boolean islast = endline == this.getLineCount();
        Object[] objectArray = sLock;
        synchronized (sLock) {
            int[] ints;
            StaticLayout reflowed = sStaticLayout;
            StaticLayout.Builder b = sBuilder;
            sStaticLayout = null;
            sBuilder = null;
            // ** MonitorExit[var17_21] (shouldn't be in output)
            if (reflowed == null) {
                reflowed = new StaticLayout(null);
                b = StaticLayout.Builder.obtain(text, where, where + after, this.getPaint(), this.getWidth());
            }
            b.setText(text, where, where + after).setPaint(this.getPaint()).setWidth(this.getWidth()).setTextDirection(this.getTextDirectionHeuristic()).setLineSpacing(this.getSpacingAdd(), this.getSpacingMultiplier()).setUseLineSpacingFromFallbacks(this.mFallbackLineSpacing).setEllipsizedWidth(this.mEllipsizedWidth).setEllipsize(this.mEllipsizeAt).setBreakStrategy(this.mBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency).setJustificationMode(this.mJustificationMode).setAddLastLineLineSpacing(!islast);
            reflowed.generate(b, false, true);
            int n = reflowed.getLineCount();
            if (where + after != len && reflowed.getLineStart(n - 1) == where + after) {
                --n;
            }
            this.mInts.deleteAt(startline, endline - startline);
            this.mObjects.deleteAt(startline, endline - startline);
            int ht = reflowed.getLineTop(n);
            int toppad = 0;
            int botpad = 0;
            if (this.mIncludePad && startline == 0) {
                this.mTopPadding = toppad = reflowed.getTopPadding();
                ht -= toppad;
            }
            if (this.mIncludePad && islast) {
                this.mBottomPadding = botpad = reflowed.getBottomPadding();
                ht += botpad;
            }
            this.mInts.adjustValuesBelow(startline, 0, after - before);
            this.mInts.adjustValuesBelow(startline, 1, startv - endv + ht);
            if (this.mEllipsize) {
                ints = new int[7];
                ints[5] = Integer.MIN_VALUE;
            } else {
                ints = new int[5];
            }
            Layout.Directions[] objects = new Layout.Directions[1];
            for (int i = 0; i < n; ++i) {
                int start;
                ints[0] = start = reflowed.getLineStart(i);
                ints[0] = ints[0] | reflowed.getParagraphDirection(i) << 30;
                ints[0] = ints[0] | (reflowed.getLineContainsTab(i) ? 0x20000000 : 0);
                int top = reflowed.getLineTop(i) + startv;
                if (i > 0) {
                    top -= toppad;
                }
                ints[1] = top;
                int desc = reflowed.getLineDescent(i);
                if (i == n - 1) {
                    desc += botpad;
                }
                ints[2] = desc;
                ints[3] = reflowed.getLineExtra(i);
                objects[0] = reflowed.getLineDirections(i);
                int end = i == n - 1 ? where + after : reflowed.getLineStart(i + 1);
                ints[4] = StaticLayout.packHyphenEdit(reflowed.getStartHyphenEdit(i), reflowed.getEndHyphenEdit(i));
                ints[4] = ints[4] | (this.contentMayProtrudeFromLineTopOrBottom(text, start, end) ? 256 : 0);
                if (this.mEllipsize) {
                    ints[5] = reflowed.getEllipsisStart(i);
                    ints[6] = reflowed.getEllipsisCount(i);
                }
                this.mInts.insertAt(startline + i, ints);
                this.mObjects.insertAt(startline + i, (Layout.Directions[])objects);
            }
            this.updateBlocks(startline, endline - 1, n);
            b.finish();
            Object[] objectArray2 = sLock;
            synchronized (sLock) {
                sStaticLayout = reflowed;
                sBuilder = b;
                // ** MonitorExit[var23_30] (shouldn't be in output)
                return;
            }
        }
    }

    private boolean contentMayProtrudeFromLineTopOrBottom(CharSequence text, int start, int end) {
        Spanned spanned;
        if (text instanceof Spanned && (spanned = (Spanned)text).getSpans(start, end, ReplacementSpan.class).length > 0) {
            return true;
        }
        TextPaint paint = this.getPaint();
        if (text instanceof PrecomputedText) {
            PrecomputedText precomputed = (PrecomputedText)text;
            precomputed.getBounds(start, end, this.mTempRect);
        } else {
            paint.getTextBounds(text, start, end, this.mTempRect);
        }
        Paint.FontMetricsInt fm = paint.getFontMetricsInt();
        return this.mTempRect.top < fm.top || this.mTempRect.bottom > fm.bottom;
    }

    private void createBlocks() {
        int offset = 400;
        this.mNumberOfBlocks = 0;
        CharSequence text = this.mDisplay;
        while (true) {
            if ((offset = TextUtils.indexOf(text, '\n', offset)) < 0) break;
            this.addBlockAtOffset(offset);
            offset += 400;
        }
        this.addBlockAtOffset(text.length());
        this.mBlockIndices = new int[this.mBlockEndLines.length];
        for (int i = 0; i < this.mBlockEndLines.length; ++i) {
            this.mBlockIndices[i] = -1;
        }
    }

    public ArraySet<Integer> getBlocksAlwaysNeedToBeRedrawn() {
        return this.mBlocksAlwaysNeedToBeRedrawn;
    }

    private void updateAlwaysNeedsToBeRedrawn(int blockIndex) {
        int startLine = blockIndex == 0 ? 0 : this.mBlockEndLines[blockIndex - 1] + 1;
        int endLine = this.mBlockEndLines[blockIndex];
        for (int i = startLine; i <= endLine; ++i) {
            if (!this.getContentMayProtrudeFromTopOrBottom(i)) continue;
            if (this.mBlocksAlwaysNeedToBeRedrawn == null) {
                this.mBlocksAlwaysNeedToBeRedrawn = new ArraySet();
            }
            this.mBlocksAlwaysNeedToBeRedrawn.add(blockIndex);
            return;
        }
        if (this.mBlocksAlwaysNeedToBeRedrawn != null) {
            this.mBlocksAlwaysNeedToBeRedrawn.remove(blockIndex);
        }
    }

    private void addBlockAtOffset(int offset) {
        int line = this.getLineForOffset(offset);
        if (this.mBlockEndLines == null) {
            this.mBlockEndLines = ArrayUtils.newUnpaddedIntArray(1);
            this.mBlockEndLines[this.mNumberOfBlocks] = line;
            this.updateAlwaysNeedsToBeRedrawn(this.mNumberOfBlocks);
            ++this.mNumberOfBlocks;
            return;
        }
        int previousBlockEndLine = this.mBlockEndLines[this.mNumberOfBlocks - 1];
        if (line > previousBlockEndLine) {
            this.mBlockEndLines = GrowingArrayUtils.append(this.mBlockEndLines, this.mNumberOfBlocks, line);
            this.updateAlwaysNeedsToBeRedrawn(this.mNumberOfBlocks);
            ++this.mNumberOfBlocks;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void updateBlocks(int startLine, int endLine, int newLineCount) {
        int newFirstChangedBlock;
        int i;
        int numRemovedBlocks;
        int newNumberOfBlocks;
        int i2;
        if (this.mBlockEndLines == null) {
            this.createBlocks();
            return;
        }
        int firstBlock = -1;
        int lastBlock = -1;
        for (i2 = 0; i2 < this.mNumberOfBlocks; ++i2) {
            if (this.mBlockEndLines[i2] < startLine) continue;
            firstBlock = i2;
            break;
        }
        for (i2 = firstBlock; i2 < this.mNumberOfBlocks; ++i2) {
            if (this.mBlockEndLines[i2] < endLine) continue;
            lastBlock = i2;
            break;
        }
        int lastBlockEndLine = this.mBlockEndLines[lastBlock];
        boolean createBlockBefore = startLine > (firstBlock == 0 ? 0 : this.mBlockEndLines[firstBlock - 1] + 1);
        boolean createBlock = newLineCount > 0;
        boolean createBlockAfter = endLine < this.mBlockEndLines[lastBlock];
        int numAddedBlocks = 0;
        if (createBlockBefore) {
            ++numAddedBlocks;
        }
        if (createBlock) {
            ++numAddedBlocks;
        }
        if (createBlockAfter) {
            ++numAddedBlocks;
        }
        if ((newNumberOfBlocks = this.mNumberOfBlocks + numAddedBlocks - (numRemovedBlocks = lastBlock - firstBlock + 1)) == 0) {
            this.mBlockEndLines[0] = 0;
            this.mBlockIndices[0] = -1;
            this.mNumberOfBlocks = 1;
            return;
        }
        if (newNumberOfBlocks > this.mBlockEndLines.length) {
            int[] blockEndLines = ArrayUtils.newUnpaddedIntArray(Math.max(this.mBlockEndLines.length * 2, newNumberOfBlocks));
            int[] blockIndices = new int[blockEndLines.length];
            System.arraycopy(this.mBlockEndLines, 0, blockEndLines, 0, firstBlock);
            System.arraycopy(this.mBlockIndices, 0, blockIndices, 0, firstBlock);
            System.arraycopy(this.mBlockEndLines, lastBlock + 1, blockEndLines, firstBlock + numAddedBlocks, this.mNumberOfBlocks - lastBlock - 1);
            System.arraycopy(this.mBlockIndices, lastBlock + 1, blockIndices, firstBlock + numAddedBlocks, this.mNumberOfBlocks - lastBlock - 1);
            this.mBlockEndLines = blockEndLines;
            this.mBlockIndices = blockIndices;
        } else if (numAddedBlocks + numRemovedBlocks != 0) {
            System.arraycopy(this.mBlockEndLines, lastBlock + 1, this.mBlockEndLines, firstBlock + numAddedBlocks, this.mNumberOfBlocks - lastBlock - 1);
            System.arraycopy(this.mBlockIndices, lastBlock + 1, this.mBlockIndices, firstBlock + numAddedBlocks, this.mNumberOfBlocks - lastBlock - 1);
        }
        if (numAddedBlocks + numRemovedBlocks != 0 && this.mBlocksAlwaysNeedToBeRedrawn != null) {
            ArraySet<Integer> set = new ArraySet<Integer>();
            int changedBlockCount = numAddedBlocks - numRemovedBlocks;
            for (i = 0; i < this.mBlocksAlwaysNeedToBeRedrawn.size(); ++i) {
                Integer block = this.mBlocksAlwaysNeedToBeRedrawn.valueAt(i);
                if (block < firstBlock) {
                    set.add(block);
                }
                if (block <= lastBlock) continue;
                block = block + changedBlockCount;
                set.add(block);
            }
            this.mBlocksAlwaysNeedToBeRedrawn = set;
        }
        this.mNumberOfBlocks = newNumberOfBlocks;
        int deltaLines = newLineCount - (endLine - startLine + 1);
        if (deltaLines != 0) {
            i = newFirstChangedBlock = firstBlock + numAddedBlocks;
            while (i < this.mNumberOfBlocks) {
                int n = i++;
                this.mBlockEndLines[n] = this.mBlockEndLines[n] + deltaLines;
            }
        } else {
            newFirstChangedBlock = this.mNumberOfBlocks;
        }
        this.mIndexFirstChangedBlock = Math.min(this.mIndexFirstChangedBlock, newFirstChangedBlock);
        int blockIndex = firstBlock;
        if (createBlockBefore) {
            this.mBlockEndLines[blockIndex] = startLine - 1;
            this.updateAlwaysNeedsToBeRedrawn(blockIndex);
            this.mBlockIndices[blockIndex] = -1;
            ++blockIndex;
        }
        if (createBlock) {
            this.mBlockEndLines[blockIndex] = startLine + newLineCount - 1;
            this.updateAlwaysNeedsToBeRedrawn(blockIndex);
            this.mBlockIndices[blockIndex] = -1;
            ++blockIndex;
        }
        if (createBlockAfter) {
            this.mBlockEndLines[blockIndex] = lastBlockEndLine + deltaLines;
            this.updateAlwaysNeedsToBeRedrawn(blockIndex);
            this.mBlockIndices[blockIndex] = -1;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void setBlocksDataForTest(int[] blockEndLines, int[] blockIndices, int numberOfBlocks, int totalLines) {
        this.mBlockEndLines = new int[blockEndLines.length];
        this.mBlockIndices = new int[blockIndices.length];
        System.arraycopy(blockEndLines, 0, this.mBlockEndLines, 0, blockEndLines.length);
        System.arraycopy(blockIndices, 0, this.mBlockIndices, 0, blockIndices.length);
        this.mNumberOfBlocks = numberOfBlocks;
        while (this.mInts.size() < totalLines) {
            this.mInts.insertAt(this.mInts.size(), new int[5]);
        }
    }

    @UnsupportedAppUsage
    public int[] getBlockEndLines() {
        return this.mBlockEndLines;
    }

    @UnsupportedAppUsage
    public int[] getBlockIndices() {
        return this.mBlockIndices;
    }

    public int getBlockIndex(int index) {
        return this.mBlockIndices[index];
    }

    public void setBlockIndex(int index, int blockIndex) {
        this.mBlockIndices[index] = blockIndex;
    }

    @UnsupportedAppUsage
    public int getNumberOfBlocks() {
        return this.mNumberOfBlocks;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getIndexFirstChangedBlock() {
        return this.mIndexFirstChangedBlock;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setIndexFirstChangedBlock(int i) {
        this.mIndexFirstChangedBlock = i;
    }

    @Override
    public int getLineCount() {
        return this.mInts.size() - 1;
    }

    @Override
    public int getLineTop(int line) {
        return this.mInts.getValue(line, 1);
    }

    @Override
    public int getLineDescent(int line) {
        return this.mInts.getValue(line, 2);
    }

    @Override
    public int getLineExtra(int line) {
        return this.mInts.getValue(line, 3);
    }

    @Override
    public int getLineStart(int line) {
        return this.mInts.getValue(line, 0) & 0x1FFFFFFF;
    }

    @Override
    public boolean getLineContainsTab(int line) {
        return (this.mInts.getValue(line, 0) & 0x20000000) != 0;
    }

    @Override
    public int getParagraphDirection(int line) {
        return this.mInts.getValue(line, 0) >> 30;
    }

    @Override
    public Layout.Directions getLineDirections(int line) {
        return this.mObjects.getValue(line, 0);
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    @Override
    public int getStartHyphenEdit(int line) {
        return StaticLayout.unpackStartHyphenEdit(this.mInts.getValue(line, 4) & 0xFF);
    }

    @Override
    public int getEndHyphenEdit(int line) {
        return StaticLayout.unpackEndHyphenEdit(this.mInts.getValue(line, 4) & 0xFF);
    }

    private boolean getContentMayProtrudeFromTopOrBottom(int line) {
        return (this.mInts.getValue(line, 4) & 0x100) != 0;
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    @Override
    public int getEllipsisStart(int line) {
        if (this.mEllipsizeAt == null) {
            return 0;
        }
        return this.mInts.getValue(line, 5);
    }

    @Override
    public int getEllipsisCount(int line) {
        if (this.mEllipsizeAt == null) {
            return 0;
        }
        return this.mInts.getValue(line, 6);
    }

    private static class ChangeWatcher
    implements TextWatcher,
    SpanWatcher {
        private WeakReference<DynamicLayout> mLayout;

        public ChangeWatcher(DynamicLayout layout2) {
            this.mLayout = new WeakReference<DynamicLayout>(layout2);
        }

        private void reflow(CharSequence s, int where, int before, int after) {
            DynamicLayout ml = (DynamicLayout)this.mLayout.get();
            if (ml != null) {
                ml.reflow(s, where, before, after);
            } else if (s instanceof Spannable) {
                ((Spannable)s).removeSpan(this);
            }
        }

        @Override
        public void beforeTextChanged(CharSequence s, int where, int before, int after) {
        }

        @Override
        public void onTextChanged(CharSequence s, int where, int before, int after) {
            this.reflow(s, where, before, after);
        }

        @Override
        public void afterTextChanged(Editable s) {
        }

        @Override
        public void onSpanAdded(Spannable s, Object o, int start, int end) {
            if (o instanceof UpdateLayout) {
                this.reflow(s, start, end - start, end - start);
            }
        }

        @Override
        public void onSpanRemoved(Spannable s, Object o, int start, int end) {
            if (o instanceof UpdateLayout) {
                this.reflow(s, start, end - start, end - start);
            }
        }

        @Override
        public void onSpanChanged(Spannable s, Object o, int start, int end, int nstart, int nend) {
            if (o instanceof UpdateLayout) {
                if (start > end) {
                    start = 0;
                }
                this.reflow(s, start, end - start, end - start);
                this.reflow(s, nstart, nend - nstart, nend - nstart);
            }
        }
    }

    public static class Builder {
        private CharSequence mBase;
        private CharSequence mDisplay;
        private TextPaint mPaint;
        private int mWidth;
        private Layout.Alignment mAlignment;
        private TextDirectionHeuristic mTextDir;
        private float mSpacingMult;
        private float mSpacingAdd;
        private boolean mIncludePad;
        private boolean mFallbackLineSpacing;
        private int mBreakStrategy;
        private int mHyphenationFrequency;
        private int mJustificationMode;
        private TextUtils.TruncateAt mEllipsize;
        private int mEllipsizedWidth;
        private final Paint.FontMetricsInt mFontMetricsInt = new Paint.FontMetricsInt();
        private static final Pools.SynchronizedPool<Builder> sPool = new Pools.SynchronizedPool(3);

        private Builder() {
        }

        public static Builder obtain(CharSequence base, TextPaint paint, int width) {
            Builder b = sPool.acquire();
            if (b == null) {
                b = new Builder();
            }
            b.mBase = base;
            b.mDisplay = base;
            b.mPaint = paint;
            b.mWidth = width;
            b.mAlignment = Layout.Alignment.ALIGN_NORMAL;
            b.mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            b.mSpacingMult = 1.0f;
            b.mSpacingAdd = 0.0f;
            b.mIncludePad = true;
            b.mFallbackLineSpacing = false;
            b.mEllipsizedWidth = width;
            b.mEllipsize = null;
            b.mBreakStrategy = 0;
            b.mHyphenationFrequency = 0;
            b.mJustificationMode = 0;
            return b;
        }

        private static void recycle(Builder b) {
            b.mBase = null;
            b.mDisplay = null;
            b.mPaint = null;
            sPool.release(b);
        }

        public Builder setDisplayText(CharSequence display) {
            this.mDisplay = display;
            return this;
        }

        public Builder setAlignment(Layout.Alignment alignment) {
            this.mAlignment = alignment;
            return this;
        }

        public Builder setTextDirection(TextDirectionHeuristic textDir) {
            this.mTextDir = textDir;
            return this;
        }

        public Builder setLineSpacing(float spacingAdd, float spacingMult) {
            this.mSpacingAdd = spacingAdd;
            this.mSpacingMult = spacingMult;
            return this;
        }

        public Builder setIncludePad(boolean includePad) {
            this.mIncludePad = includePad;
            return this;
        }

        public Builder setUseLineSpacingFromFallbacks(boolean useLineSpacingFromFallbacks) {
            this.mFallbackLineSpacing = useLineSpacingFromFallbacks;
            return this;
        }

        public Builder setEllipsizedWidth(int ellipsizedWidth) {
            this.mEllipsizedWidth = ellipsizedWidth;
            return this;
        }

        public Builder setEllipsize(TextUtils.TruncateAt ellipsize) {
            this.mEllipsize = ellipsize;
            return this;
        }

        public Builder setBreakStrategy(int breakStrategy) {
            this.mBreakStrategy = breakStrategy;
            return this;
        }

        public Builder setHyphenationFrequency(int hyphenationFrequency) {
            this.mHyphenationFrequency = hyphenationFrequency;
            return this;
        }

        public Builder setJustificationMode(int justificationMode) {
            this.mJustificationMode = justificationMode;
            return this;
        }

        public DynamicLayout build() {
            DynamicLayout result = new DynamicLayout(this);
            Builder.recycle(this);
            return result;
        }
    }
}

