/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.graphics.Rect;
import android.text.TextUtils;
import android.text.method.TransformationMethod;
import android.text.method.TransformationMethod2;
import android.util.Log;
import android.view.View;
import android.view.translation.TranslationResponseValue;
import android.view.translation.ViewTranslationResponse;
import java.util.regex.Pattern;

public class TranslationTransformationMethod
implements TransformationMethod2 {
    private static final String TAG = "TranslationTransformationMethod";
    private static final Pattern PATTERN_WHITESPACE = Pattern.compile("\\s+");
    private final ViewTranslationResponse mTranslationResponse;
    private TransformationMethod mOriginalTranslationMethod;
    private boolean mAllowLengthChanges;

    public TranslationTransformationMethod(ViewTranslationResponse response, TransformationMethod method) {
        this.mTranslationResponse = response;
        this.mOriginalTranslationMethod = method;
    }

    public TransformationMethod getOriginalTransformationMethod() {
        return this.mOriginalTranslationMethod;
    }

    @Override
    public CharSequence getTransformation(CharSequence source, View view) {
        if (!this.mAllowLengthChanges) {
            Log.w(TAG, "Caller did not enable length changes; not transforming to translated text");
            return source;
        }
        TranslationResponseValue value = this.mTranslationResponse.getValue("android:text");
        CharSequence translatedText = value.getStatusCode() == 0 ? value.getText() : "";
        if (TextUtils.isEmpty(translatedText) || this.isWhitespace(translatedText.toString())) {
            return source;
        }
        return translatedText;
    }

    @Override
    public void onFocusChanged(View view, CharSequence sourceText, boolean focused, int direction, Rect previouslyFocusedRect) {
    }

    @Override
    public void setLengthChangesAllowed(boolean allowLengthChanges) {
        this.mAllowLengthChanges = allowLengthChanges;
    }

    private boolean isWhitespace(String text) {
        return PATTERN_WHITESPACE.matcher(text.substring(0, text.length())).matches();
    }
}

