/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.SystemClock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class LocalLog {
    private final Deque<String> mLog;
    private final int mMaxLines;
    private final boolean mUseLocalTimestamps;

    @UnsupportedAppUsage
    public LocalLog(int maxLines) {
        this(maxLines, true);
    }

    public LocalLog(int maxLines, boolean useLocalTimestamps) {
        this.mMaxLines = Math.max(0, maxLines);
        this.mLog = new ArrayDeque<String>(this.mMaxLines);
        this.mUseLocalTimestamps = useLocalTimestamps;
    }

    @UnsupportedAppUsage
    public void log(String msg) {
        if (this.mMaxLines <= 0) {
            return;
        }
        String logLine = this.mUseLocalTimestamps ? LocalDateTime.now() + " - " + msg : SystemClock.elapsedRealtime() + " / " + Instant.now() + " - " + msg;
        this.append(logLine);
    }

    private synchronized void append(String logLine) {
        while (this.mLog.size() >= this.mMaxLines) {
            this.mLog.remove();
        }
        this.mLog.add(logLine);
    }

    @UnsupportedAppUsage
    public synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.dump(pw);
    }

    public synchronized void dump(PrintWriter pw) {
        this.dump("", pw);
    }

    public synchronized void dump(String indent, PrintWriter pw) {
        Iterator<String> itr = this.mLog.iterator();
        while (itr.hasNext()) {
            pw.printf("%s%s\n", indent, itr.next());
        }
    }

    public synchronized void reverseDump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.reverseDump(pw);
    }

    public synchronized void reverseDump(PrintWriter pw) {
        Iterator<String> itr = this.mLog.descendingIterator();
        while (itr.hasNext()) {
            pw.println(itr.next());
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public ReadOnlyLocalLog readOnlyLocalLog() {
        return new ReadOnlyLocalLog(this);
    }

    public static class ReadOnlyLocalLog {
        private final LocalLog mLog;

        ReadOnlyLocalLog(LocalLog log) {
            this.mLog = log;
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            this.mLog.dump(pw);
        }

        public void dump(PrintWriter pw) {
            this.mLog.dump(pw);
        }

        public void reverseDump(FileDescriptor fd, PrintWriter pw, String[] args) {
            this.mLog.reverseDump(pw);
        }

        public void reverseDump(PrintWriter pw) {
            this.mLog.reverseDump(pw);
        }
    }
}

