/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.util.ContainerHelpers;
import android.util.UtilConfig;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.android.internal.util.Preconditions;
import libcore.util.EmptyArray;

public class LongSparseLongArray
implements Cloneable {
    @UnsupportedAppUsage(maxTargetSdk=28)
    private long[] mKeys;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private long[] mValues;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mSize;

    public LongSparseLongArray() {
        this(10);
    }

    public LongSparseLongArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = EmptyArray.LONG;
            this.mValues = EmptyArray.LONG;
        } else {
            this.mKeys = ArrayUtils.newUnpaddedLongArray(initialCapacity);
            this.mValues = new long[this.mKeys.length];
        }
        this.mSize = 0;
    }

    public LongSparseLongArray clone() {
        LongSparseLongArray clone = null;
        try {
            clone = (LongSparseLongArray)super.clone();
            clone.mKeys = (long[])this.mKeys.clone();
            clone.mValues = (long[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public long get(long key) {
        return this.get(key, 0L);
    }

    public long get(long key, long valueIfKeyNotFound) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return this.mValues[i];
    }

    public void delete(long key) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.removeAt(i);
        }
    }

    public void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - (index + 1));
        --this.mSize;
    }

    public void put(long key, long value) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, i ^= 0xFFFFFFFF, key);
            this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, i, value);
            ++this.mSize;
        }
    }

    public int size() {
        return this.mSize;
    }

    public long keyAt(int index) {
        if (index >= this.mSize && UtilConfig.sThrowExceptionForUpperArrayOutOfBounds) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.mKeys[index];
    }

    public long valueAt(int index) {
        if (index >= this.mSize && UtilConfig.sThrowExceptionForUpperArrayOutOfBounds) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.mValues[index];
    }

    public int indexOfKey(long key) {
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
    }

    public int indexOfValue(long value) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void append(long key, long value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, key);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, value);
        ++this.mSize;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            long key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            long value = this.valueAt(i);
            buffer.append(value);
        }
        buffer.append('}');
        return buffer.toString();
    }

    static /* synthetic */ long[] access$102(LongSparseLongArray x0, long[] x1) {
        x0.mKeys = x1;
        return x1;
    }

    static /* synthetic */ long[] access$202(LongSparseLongArray x0, long[] x1) {
        x0.mValues = x1;
        return x1;
    }

    public static class Parcelling
    implements com.android.internal.util.Parcelling<LongSparseLongArray> {
        @Override
        public void parcel(LongSparseLongArray array2, Parcel dest, int parcelFlags) {
            if (array2 == null) {
                dest.writeInt(-1);
                return;
            }
            dest.writeInt(array2.mSize);
            dest.writeLongArray(array2.mKeys);
            dest.writeLongArray(array2.mValues);
        }

        @Override
        public LongSparseLongArray unparcel(Parcel source) {
            int size = source.readInt();
            if (size == -1) {
                return null;
            }
            LongSparseLongArray array2 = new LongSparseLongArray(0);
            array2.mSize = size;
            LongSparseLongArray.access$102(array2, source.createLongArray());
            LongSparseLongArray.access$202(array2, source.createLongArray());
            Preconditions.checkArgument(array2.mKeys.length >= size);
            Preconditions.checkArgument(array2.mValues.length >= size);
            if (size > 0) {
                long last = array2.mKeys[0];
                for (int i = 1; i < size; ++i) {
                    Preconditions.checkArgument(last < array2.mKeys[i]);
                }
            }
            return array2;
        }
    }
}

