/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.SystemClock;
import android.os.Trace;
import android.os._Original_Build;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TimingsTraceLog {
    private static final boolean DEBUG_BOOT_TIME = !_Original_Build.IS_USER;
    private static final int MAX_NESTED_CALLS = 10;
    private final String[] mStartNames;
    private final long[] mStartTimes;
    private final String mTag;
    private final long mTraceTag;
    private final long mThreadId;
    private final int mMaxNestedCalls;
    private int mCurrentLevel = -1;

    public TimingsTraceLog(String tag, long traceTag) {
        this(tag, traceTag, DEBUG_BOOT_TIME ? 10 : -1);
    }

    @VisibleForTesting
    public TimingsTraceLog(String tag, long traceTag, int maxNestedCalls) {
        this.mTag = tag;
        this.mTraceTag = traceTag;
        this.mThreadId = Thread.currentThread().getId();
        this.mMaxNestedCalls = maxNestedCalls;
        if (maxNestedCalls > 0) {
            this.mStartNames = new String[maxNestedCalls];
            this.mStartTimes = new long[maxNestedCalls];
        } else {
            this.mStartNames = null;
            this.mStartTimes = null;
        }
    }

    public void traceBegin(String name) {
        this.assertSameThread();
        Trace.traceBegin(this.mTraceTag, name);
        if (!DEBUG_BOOT_TIME) {
            return;
        }
        if (this.mCurrentLevel + 1 >= this.mMaxNestedCalls) {
            Slog.w(this.mTag, "not tracing duration of '" + name + "' because already reached " + this.mMaxNestedCalls + " levels");
            return;
        }
        ++this.mCurrentLevel;
        this.mStartNames[this.mCurrentLevel] = name;
        this.mStartTimes[this.mCurrentLevel] = SystemClock.elapsedRealtime();
    }

    public void traceEnd() {
        this.assertSameThread();
        Trace.traceEnd(this.mTraceTag);
        if (!DEBUG_BOOT_TIME) {
            return;
        }
        if (this.mCurrentLevel < 0) {
            Slog.w(this.mTag, "traceEnd called more times than traceBegin");
            return;
        }
        String name = this.mStartNames[this.mCurrentLevel];
        long duration = SystemClock.elapsedRealtime() - this.mStartTimes[this.mCurrentLevel];
        --this.mCurrentLevel;
        this.logDuration(name, duration);
    }

    private void assertSameThread() {
        Thread currentThread = Thread.currentThread();
        if (currentThread.getId() != this.mThreadId) {
            throw new IllegalStateException("Instance of TimingsTraceLog can only be called from the thread it was created on (tid: " + this.mThreadId + "), but was from " + currentThread.getName() + " (tid: " + currentThread.getId() + ")");
        }
    }

    public void logDuration(String name, long timeMs) {
        Slog.d(this.mTag, name + " took to complete: " + timeMs + "ms");
    }

    public List<String> getUnfinishedTracesForDebug() {
        if (this.mStartTimes == null || this.mCurrentLevel < 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(this.mCurrentLevel + 1);
        for (int i = 0; i <= this.mCurrentLevel; ++i) {
            list.add(this.mStartNames[i]);
        }
        return list;
    }
}

