/*
 * Decompiled with CFR 0.152.
 */
package android.util.imetracing;

import android.inputmethodservice.AbstractInputMethodService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.imetracing.ImeTracing;
import android.util.proto.ProtoOutputStream;
import android.view.inputmethod.InputMethodManager;
import java.io.PrintWriter;

class ImeTracingClientImpl
extends ImeTracing {
    ImeTracingClientImpl() throws ServiceManager.ServiceNotFoundException, RemoteException {
        sEnabled = this.mService.isImeTraceEnabled();
    }

    @Override
    public void addToBuffer(ProtoOutputStream proto, int source) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerClientDump(String where, InputMethodManager immInstance, ProtoOutputStream icProto) {
        if (!this.isEnabled() || !this.isAvailable()) {
            return;
        }
        Object object = this.mDumpInProgressLock;
        synchronized (object) {
            if (this.mDumpInProgress) {
                return;
            }
            this.mDumpInProgress = true;
        }
        try {
            ProtoOutputStream proto = new ProtoOutputStream();
            immInstance.dumpDebug(proto, icProto);
            this.sendToService(proto.getBytes(), 0, where);
        }
        catch (RemoteException e) {
            Log.e("imeTracing", "Exception while sending ime-related client dump to server", e);
        }
        finally {
            this.mDumpInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerServiceDump(String where, AbstractInputMethodService service, ProtoOutputStream icProto) {
        if (!this.isEnabled() || !this.isAvailable()) {
            return;
        }
        Object object = this.mDumpInProgressLock;
        synchronized (object) {
            if (this.mDumpInProgress) {
                return;
            }
            this.mDumpInProgress = true;
        }
        try {
            ProtoOutputStream proto = new ProtoOutputStream();
            service.dumpProtoInternal(proto, icProto);
            this.sendToService(proto.getBytes(), 1, where);
        }
        catch (RemoteException e) {
            Log.e("imeTracing", "Exception while sending ime-related service dump to server", e);
        }
        finally {
            this.mDumpInProgress = false;
        }
    }

    @Override
    public void triggerManagerServiceDump(String where) {
    }

    @Override
    public void startTrace(PrintWriter pw) {
    }

    @Override
    public void stopTrace(PrintWriter pw) {
    }
}

