/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.AdapterState;
import android.uwb.IUwbAdapter;
import android.uwb.IUwbAdapterStateCallbacks;
import android.uwb.StateChangeReason;
import android.uwb.UwbManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdapterStateListener
extends IUwbAdapterStateCallbacks.Stub {
    private static final String TAG = "Uwb.StateListener";
    private final IUwbAdapter mAdapter;
    private boolean mIsRegistered = false;
    private final Map<UwbManager.AdapterStateCallback, Executor> mCallbackMap = new HashMap<UwbManager.AdapterStateCallback, Executor>();
    private int mAdapterStateChangeReason = 4;
    private int mAdapterState = 0;

    public AdapterStateListener(IUwbAdapter adapter) {
        this.mAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Executor executor, UwbManager.AdapterStateCallback callback) {
        AdapterStateListener adapterStateListener = this;
        synchronized (adapterStateListener) {
            if (this.mCallbackMap.containsKey(callback)) {
                return;
            }
            this.mCallbackMap.put(callback, executor);
            if (!this.mIsRegistered) {
                try {
                    this.mAdapter.registerAdapterStateCallbacks(this);
                    this.mIsRegistered = true;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to register adapter state callback");
                    throw e.rethrowFromSystemServer();
                }
            } else {
                this.sendCurrentState(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(UwbManager.AdapterStateCallback callback) {
        AdapterStateListener adapterStateListener = this;
        synchronized (adapterStateListener) {
            if (!this.mCallbackMap.containsKey(callback)) {
                return;
            }
            this.mCallbackMap.remove(callback);
            if (this.mCallbackMap.isEmpty() && this.mIsRegistered) {
                try {
                    this.mAdapter.unregisterAdapterStateCallbacks(this);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to unregister AdapterStateCallback with service");
                    throw e.rethrowFromSystemServer();
                }
                this.mIsRegistered = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean isEnabled) {
        AdapterStateListener adapterStateListener = this;
        synchronized (adapterStateListener) {
            try {
                this.mAdapter.setEnabled(isEnabled);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to set adapter state");
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public int getAdapterState() {
        AdapterStateListener adapterStateListener = this;
        synchronized (adapterStateListener) {
            try {
                return this.mAdapter.getAdapterState();
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to get adapter state");
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCurrentState(UwbManager.AdapterStateCallback callback) {
        AdapterStateListener adapterStateListener = this;
        synchronized (adapterStateListener) {
            Executor executor = this.mCallbackMap.get(callback);
            long identity = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> callback.onStateChanged(this.mAdapterState, this.mAdapterStateChangeReason));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAdapterStateChanged(int state, int reason) {
        AdapterStateListener adapterStateListener = this;
        synchronized (adapterStateListener) {
            int localReason = AdapterStateListener.convertToStateChangedReason(reason);
            int localState = AdapterStateListener.convertToState(state);
            this.mAdapterStateChangeReason = localReason;
            this.mAdapterState = localState;
            for (UwbManager.AdapterStateCallback cb : this.mCallbackMap.keySet()) {
                this.sendCurrentState(cb);
            }
        }
    }

    private static int convertToStateChangedReason(@StateChangeReason int reason) {
        switch (reason) {
            case 2: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }

    private static int convertToState(@AdapterState int state) {
        switch (state) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }
}

