/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.uwb.IUwbAdapterStateCallbacks;
import android.uwb.IUwbRangingCallbacks;
import android.uwb.SessionHandle;

public interface IUwbAdapter
extends IInterface {
    public static final String DESCRIPTOR = "android.uwb.IUwbAdapter";
    public static final int RANGING_SESSION_OPEN_THRESHOLD_MS = 3000;
    public static final int RANGING_SESSION_START_THRESHOLD_MS = 3000;
    public static final int RANGING_SESSION_CLOSE_THRESHOLD_MS = 3000;

    public void registerAdapterStateCallbacks(IUwbAdapterStateCallbacks var1) throws RemoteException;

    public void unregisterAdapterStateCallbacks(IUwbAdapterStateCallbacks var1) throws RemoteException;

    public long getTimestampResolutionNanos() throws RemoteException;

    public PersistableBundle getSpecificationInfo() throws RemoteException;

    public void openRanging(AttributionSource var1, SessionHandle var2, IUwbRangingCallbacks var3, PersistableBundle var4) throws RemoteException;

    public void startRanging(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void reconfigureRanging(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void stopRanging(SessionHandle var1) throws RemoteException;

    public void closeRanging(SessionHandle var1) throws RemoteException;

    public void setEnabled(boolean var1) throws RemoteException;

    public int getAdapterState() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUwbAdapter {
        static final int TRANSACTION_registerAdapterStateCallbacks = 1;
        static final int TRANSACTION_unregisterAdapterStateCallbacks = 2;
        static final int TRANSACTION_getTimestampResolutionNanos = 3;
        static final int TRANSACTION_getSpecificationInfo = 4;
        static final int TRANSACTION_openRanging = 5;
        static final int TRANSACTION_startRanging = 6;
        static final int TRANSACTION_reconfigureRanging = 7;
        static final int TRANSACTION_stopRanging = 8;
        static final int TRANSACTION_closeRanging = 9;
        static final int TRANSACTION_setEnabled = 10;
        static final int TRANSACTION_getAdapterState = 11;

        public Stub() {
            this.attachInterface(this, IUwbAdapter.DESCRIPTOR);
        }

        public static IUwbAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUwbAdapter.DESCRIPTOR);
            if (iin != null && iin instanceof IUwbAdapter) {
                return (IUwbAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerAdapterStateCallbacks";
                }
                case 2: {
                    return "unregisterAdapterStateCallbacks";
                }
                case 3: {
                    return "getTimestampResolutionNanos";
                }
                case 4: {
                    return "getSpecificationInfo";
                }
                case 5: {
                    return "openRanging";
                }
                case 6: {
                    return "startRanging";
                }
                case 7: {
                    return "reconfigureRanging";
                }
                case 8: {
                    return "stopRanging";
                }
                case 9: {
                    return "closeRanging";
                }
                case 10: {
                    return "setEnabled";
                }
                case 11: {
                    return "getAdapterState";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUwbAdapter.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    IUwbAdapterStateCallbacks _arg0 = IUwbAdapterStateCallbacks.Stub.asInterface(data.readStrongBinder());
                    this.registerAdapterStateCallbacks(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IUwbAdapterStateCallbacks _arg0 = IUwbAdapterStateCallbacks.Stub.asInterface(data.readStrongBinder());
                    this.unregisterAdapterStateCallbacks(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    long _result = this.getTimestampResolutionNanos();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    PersistableBundle _result = this.getSpecificationInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    SessionHandle _arg1 = 0 != data.readInt() ? SessionHandle.CREATOR.createFromParcel(data) : null;
                    IUwbRangingCallbacks _arg2 = IUwbRangingCallbacks.Stub.asInterface(data.readStrongBinder());
                    PersistableBundle _arg3 = 0 != data.readInt() ? PersistableBundle.CREATOR.createFromParcel(data) : null;
                    this.openRanging(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    SessionHandle _arg0 = 0 != data.readInt() ? SessionHandle.CREATOR.createFromParcel(data) : null;
                    PersistableBundle _arg1 = 0 != data.readInt() ? PersistableBundle.CREATOR.createFromParcel(data) : null;
                    this.startRanging(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    SessionHandle _arg0 = 0 != data.readInt() ? SessionHandle.CREATOR.createFromParcel(data) : null;
                    PersistableBundle _arg1 = 0 != data.readInt() ? PersistableBundle.CREATOR.createFromParcel(data) : null;
                    this.reconfigureRanging(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    SessionHandle _arg0 = 0 != data.readInt() ? SessionHandle.CREATOR.createFromParcel(data) : null;
                    this.stopRanging(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    SessionHandle _arg0 = 0 != data.readInt() ? SessionHandle.CREATOR.createFromParcel(data) : null;
                    this.closeRanging(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _result = this.getAdapterState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IUwbAdapter impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IUwbAdapter getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IUwbAdapter {
            private IBinder mRemote;
            public static IUwbAdapter sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUwbAdapter.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAdapterStateCallbacks(IUwbAdapterStateCallbacks adapterStateCallbacks) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongBinder(adapterStateCallbacks != null ? adapterStateCallbacks.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerAdapterStateCallbacks(adapterStateCallbacks);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAdapterStateCallbacks(IUwbAdapterStateCallbacks callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongBinder(callbacks != null ? callbacks.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterAdapterStateCallbacks(callbacks);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getTimestampResolutionNanos() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().getTimestampResolutionNanos();
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getSpecificationInfo() throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        PersistableBundle persistableBundle = Stub.getDefaultImpl().getSpecificationInfo();
                        return persistableBundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PersistableBundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openRanging(AttributionSource attributionSource, SessionHandle sessionHandle, IUwbRangingCallbacks rangingCallbacks, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionHandle != null) {
                        _data.writeInt(1);
                        sessionHandle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(rangingCallbacks != null ? rangingCallbacks.asBinder() : null);
                    if (parameters != null) {
                        _data.writeInt(1);
                        parameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().openRanging(attributionSource, sessionHandle, rangingCallbacks, parameters);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    if (sessionHandle != null) {
                        _data.writeInt(1);
                        sessionHandle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (parameters != null) {
                        _data.writeInt(1);
                        parameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startRanging(sessionHandle, parameters);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reconfigureRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    if (sessionHandle != null) {
                        _data.writeInt(1);
                        sessionHandle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (parameters != null) {
                        _data.writeInt(1);
                        parameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reconfigureRanging(sessionHandle, parameters);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRanging(SessionHandle sessionHandle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    if (sessionHandle != null) {
                        _data.writeInt(1);
                        sessionHandle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopRanging(sessionHandle);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeRanging(SessionHandle sessionHandle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    if (sessionHandle != null) {
                        _data.writeInt(1);
                        sessionHandle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().closeRanging(sessionHandle);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setEnabled(enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAdapterState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getAdapterState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IUwbAdapter {
        @Override
        public void registerAdapterStateCallbacks(IUwbAdapterStateCallbacks adapterStateCallbacks) throws RemoteException {
        }

        @Override
        public void unregisterAdapterStateCallbacks(IUwbAdapterStateCallbacks callbacks) throws RemoteException {
        }

        @Override
        public long getTimestampResolutionNanos() throws RemoteException {
            return 0L;
        }

        @Override
        public PersistableBundle getSpecificationInfo() throws RemoteException {
            return null;
        }

        @Override
        public void openRanging(AttributionSource attributionSource, SessionHandle sessionHandle, IUwbRangingCallbacks rangingCallbacks, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void startRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void reconfigureRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void stopRanging(SessionHandle sessionHandle) throws RemoteException {
        }

        @Override
        public void closeRanging(SessionHandle sessionHandle) throws RemoteException {
        }

        @Override
        public void setEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public int getAdapterState() throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

