/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.HardwareRenderer;
import android.graphics.RenderNode;
import android.os.Handler;
import android.view.Display;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.WindowManagerImpl;
import com.android.layoutlib.common.util.ReflectionUtils;

public class AttachInfo_Accessor {
    public static void setAttachInfo(ViewGroup view, final HardwareRenderer renderer) {
        Context context = view.getContext();
        WindowManagerImpl wm = (WindowManagerImpl)context.getSystemService("window");
        wm.setBaseRootView(view);
        Display display = wm.getDefaultDisplay();
        ViewRootImpl root = new ViewRootImpl(context, display);
        root.mAttachInfo.mThreadedRenderer = new ThreadedRenderer(context, false, "delegate-renderer"){

            @Override
            public void registerAnimatingRenderNode(RenderNode animator2) {
                if (renderer != null) {
                    renderer.registerAnimatingRenderNode(animator2);
                } else {
                    super.registerAnimatingRenderNode(animator2);
                }
            }
        };
        View.AttachInfo info = new View.AttachInfo(ReflectionUtils.createProxy(IWindowSession.class), ReflectionUtils.createProxy(IWindow.class), display, root, new Handler(), null, context);
        info.mHasWindowFocus = true;
        info.mWindowVisibility = 0;
        info.mInTouchMode = false;
        info.mHardwareAccelerated = true;
        info.mThreadedRenderer = new ThreadedRenderer(context, false, "layoutlib-renderer");
        view.dispatchAttachedToWindow(info, 0);
    }

    public static void dispatchOnPreDraw(View view) {
        view.mAttachInfo.mTreeObserver.dispatchOnPreDraw();
    }

    public static void detachFromWindow(View view) {
        if (view != null) {
            View.AttachInfo attachInfo = view.mAttachInfo;
            view.dispatchDetachedFromWindow();
            if (attachInfo != null) {
                ThreadedRenderer rootRenderer;
                ThreadedRenderer threadedRenderer = attachInfo.mThreadedRenderer;
                if (threadedRenderer != null) {
                    threadedRenderer.destroy();
                }
                if ((rootRenderer = attachInfo.mViewRootImpl.mAttachInfo.mThreadedRenderer) != null) {
                    rootRenderer.destroy();
                }
            }
        }
    }

    public static ViewRootImpl getRootView(View view) {
        return view.mAttachInfo != null ? view.mAttachInfo.mViewRootImpl : null;
    }
}

