/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.IAssistDataReceiver;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.graphics.Insets;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.IAppTransitionAnimationSpecsFuture;
import android.view.ICrossWindowBlurEnabledListener;
import android.view.IDisplayFoldListener;
import android.view.IDisplayWindowInsetsController;
import android.view.IDisplayWindowListener;
import android.view.IDisplayWindowRotationController;
import android.view.IOnKeyguardExitResult;
import android.view.IPinnedTaskListener;
import android.view.IRotationWatcher;
import android.view.IScrollCaptureResponseListener;
import android.view.ISystemGestureExclusionListener;
import android.view.IWallpaperVisibilityListener;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InsetsState;
import android.view.RemoteAnimationAdapter;
import android.view.SurfaceControl;
import android.view.WindowContentFrameStats;
import android.view.WindowManager;
import android.view.displayhash.DisplayHash;
import android.view.displayhash.VerifiedDisplayHash;
import com.android.internal.os.IResultReceiver;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IShortcutService;

public interface IWindowManager
extends IInterface {
    public static final int FIXED_TO_USER_ROTATION_DEFAULT = 0;
    public static final int FIXED_TO_USER_ROTATION_DISABLED = 1;
    public static final int FIXED_TO_USER_ROTATION_ENABLED = 2;

    public boolean startViewServer(int var1) throws RemoteException;

    public boolean stopViewServer() throws RemoteException;

    public boolean isViewServerRunning() throws RemoteException;

    public IWindowSession openSession(IWindowSessionCallback var1) throws RemoteException;

    public boolean useBLAST() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:105:1:105:25")
    public void getInitialDisplaySize(int var1, Point var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:107:1:107:25")
    public void getBaseDisplaySize(int var1, Point var2) throws RemoteException;

    public void setForcedDisplaySize(int var1, int var2, int var3) throws RemoteException;

    public void clearForcedDisplaySize(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:111:1:111:25")
    public int getInitialDisplayDensity(int var1) throws RemoteException;

    public int getBaseDisplayDensity(int var1) throws RemoteException;

    public void setForcedDisplayDensityForUser(int var1, int var2, int var3) throws RemoteException;

    public void clearForcedDisplayDensityForUser(int var1, int var2) throws RemoteException;

    public void setForcedDisplayScalingMode(int var1, int var2) throws RemoteException;

    public void setEventDispatching(boolean var1) throws RemoteException;

    public boolean isWindowToken(IBinder var1) throws RemoteException;

    public void addWindowToken(IBinder var1, int var2, int var3, Bundle var4) throws RemoteException;

    public void removeWindowToken(IBinder var1, int var2) throws RemoteException;

    public void setDisplayWindowRotationController(IDisplayWindowRotationController var1) throws RemoteException;

    public SurfaceControl addShellRoot(int var1, IWindow var2, int var3) throws RemoteException;

    public void setShellRootAccessibilityWindow(int var1, int var2, IWindow var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:170:1:170:25")
    public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture var1, IRemoteCallback var2, boolean var3, int var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:174:1:174:25")
    public void overridePendingAppTransitionRemote(RemoteAnimationAdapter var1, int var2) throws RemoteException;

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:182:1:182:69")
    public void endProlongedAnimations() throws RemoteException;

    public void startFreezingScreen(int var1, int var2) throws RemoteException;

    public void stopFreezingScreen() throws RemoteException;

    @Deprecated
    public void disableKeyguard(IBinder var1, String var2, int var3) throws RemoteException;

    @Deprecated
    public void reenableKeyguard(IBinder var1, int var2) throws RemoteException;

    public void exitKeyguardSecurely(IOnKeyguardExitResult var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:194:1:194:25")
    public boolean isKeyguardLocked() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:196:1:196:69")
    public boolean isKeyguardSecure(int var1) throws RemoteException;

    public void dismissKeyguard(IKeyguardDismissCallback var1, CharSequence var2) throws RemoteException;

    public void setSwitchingUser(boolean var1) throws RemoteException;

    public void closeSystemDialogs(String var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:206:1:206:25")
    public float getAnimationScale(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:208:1:208:69")
    public float[] getAnimationScales() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:210:1:210:25")
    public void setAnimationScale(int var1, float var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:212:1:212:69")
    public void setAnimationScales(float[] var1) throws RemoteException;

    public float getCurrentAnimatorScale() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:218:1:218:44")
    public void setInTouchMode(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:226:1:226:44")
    public void showStrictModeViolation(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:233:1:233:69")
    public void setStrictModeVisualIndicatorPreference(String var1) throws RemoteException;

    public void refreshScreenCaptureDisabled(int var1) throws RemoteException;

    public void updateRotation(boolean var1, boolean var2) throws RemoteException;

    public int getDefaultDisplayRotation() throws RemoteException;

    public int watchRotation(IRotationWatcher var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:272:1:272:25")
    public void removeRotationWatcher(IRotationWatcher var1) throws RemoteException;

    public int getPreferredOptionsPanelGravity(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:288:1:288:25")
    public void freezeRotation(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:295:1:295:25")
    public void thawRotation() throws RemoteException;

    public boolean isRotationFrozen() throws RemoteException;

    public void freezeDisplayRotation(int var1, int var2) throws RemoteException;

    public void thawDisplayRotation(int var1) throws RemoteException;

    public boolean isDisplayRotationFrozen(int var1) throws RemoteException;

    public void setFixedToUserRotation(int var1, int var2) throws RemoteException;

    public void setIgnoreOrientationRequest(int var1, boolean var2) throws RemoteException;

    public Bitmap screenshotWallpaper() throws RemoteException;

    public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener var1, int var2) throws RemoteException;

    public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener var1, int var2) throws RemoteException;

    public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener var1, int var2) throws RemoteException;

    public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener var1, int var2) throws RemoteException;

    public boolean requestAssistScreenshot(IAssistDataReceiver var1) throws RemoteException;

    public void hideTransientBars(int var1) throws RemoteException;

    public void setRecentsVisibility(boolean var1) throws RemoteException;

    public void updateStaticPrivacyIndicatorBounds(int var1, Rect[] var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:397:1:397:25")
    public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:405:1:405:25")
    public boolean hasNavigationBar(int var1) throws RemoteException;

    public int getNavBarPosition(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:416:1:416:69")
    public void lockNow(Bundle var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:422:1:422:25")
    public boolean isSafeModeEnabled() throws RemoteException;

    public void enableScreenIfNeeded() throws RemoteException;

    public boolean clearWindowContentFrameStats(IBinder var1) throws RemoteException;

    public WindowContentFrameStats getWindowContentFrameStats(IBinder var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:449:1:449:25")
    public int getDockedStackSide() throws RemoteException;

    public void setDockedTaskDividerTouchRegion(Rect var1) throws RemoteException;

    public void registerPinnedTaskListener(int var1, IPinnedTaskListener var2) throws RemoteException;

    public void requestAppKeyboardShortcuts(IResultReceiver var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:473:1:473:25")
    public void getStableInsets(int var1, Rect var2) throws RemoteException;

    public void setForwardedInsets(int var1, Insets var2) throws RemoteException;

    public void registerShortcutKey(long var1, IShortcutService var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:496:1:496:25")
    public void createInputConsumer(IBinder var1, String var2, int var3, InputChannel var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:504:1:504:25")
    public boolean destroyInputConsumer(String var1, int var2) throws RemoteException;

    public Region getCurrentImeTouchRegion() throws RemoteException;

    public void registerDisplayFoldListener(IDisplayFoldListener var1) throws RemoteException;

    public void unregisterDisplayFoldListener(IDisplayFoldListener var1) throws RemoteException;

    public void registerDisplayWindowListener(IDisplayWindowListener var1) throws RemoteException;

    public void unregisterDisplayWindowListener(IDisplayWindowListener var1) throws RemoteException;

    public void startWindowTrace() throws RemoteException;

    public void stopWindowTrace() throws RemoteException;

    public boolean isWindowTraceEnabled() throws RemoteException;

    public void dontOverrideDisplayInfo(int var1) throws RemoteException;

    public int getWindowingMode(int var1) throws RemoteException;

    public void setWindowingMode(int var1, int var2) throws RemoteException;

    public int getRemoveContentMode(int var1) throws RemoteException;

    public void setRemoveContentMode(int var1, int var2) throws RemoteException;

    public boolean shouldShowWithInsecureKeyguard(int var1) throws RemoteException;

    public void setShouldShowWithInsecureKeyguard(int var1, boolean var2) throws RemoteException;

    public boolean shouldShowSystemDecors(int var1) throws RemoteException;

    public void setShouldShowSystemDecors(int var1, boolean var2) throws RemoteException;

    public int getDisplayImePolicy(int var1) throws RemoteException;

    public void setDisplayImePolicy(int var1, int var2) throws RemoteException;

    public boolean injectInputAfterTransactionsApplied(InputEvent var1, int var2, boolean var3) throws RemoteException;

    public void syncInputTransactions(boolean var1) throws RemoteException;

    public boolean isLayerTracing() throws RemoteException;

    public void setLayerTracing(boolean var1) throws RemoteException;

    public boolean mirrorDisplay(int var1, SurfaceControl var2) throws RemoteException;

    public void setDisplayWindowInsetsController(int var1, IDisplayWindowInsetsController var2) throws RemoteException;

    public void modifyDisplayWindowInsets(int var1, InsetsState var2) throws RemoteException;

    public boolean getWindowInsets(WindowManager.LayoutParams var1, int var2, InsetsState var3) throws RemoteException;

    public void showGlobalActions() throws RemoteException;

    public void setLayerTracingFlags(int var1) throws RemoteException;

    public void requestScrollCapture(int var1, IBinder var2, int var3, IScrollCaptureResponseListener var4) throws RemoteException;

    public void holdLock(IBinder var1, int var2) throws RemoteException;

    public String[] getSupportedDisplayHashAlgorithms() throws RemoteException;

    public VerifiedDisplayHash verifyDisplayHash(DisplayHash var1) throws RemoteException;

    public void setDisplayHashThrottlingEnabled(boolean var1) throws RemoteException;

    public boolean attachWindowContextToDisplayArea(IBinder var1, int var2, int var3, Bundle var4) throws RemoteException;

    public void attachWindowContextToWindowToken(IBinder var1, IBinder var2) throws RemoteException;

    public void detachWindowContextFromWindowContainer(IBinder var1) throws RemoteException;

    public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener var1) throws RemoteException;

    public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener var1) throws RemoteException;

    public boolean isTaskSnapshotSupported() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowManager {
        public static final String DESCRIPTOR = "android.view.IWindowManager";
        static final int TRANSACTION_startViewServer = 1;
        static final int TRANSACTION_stopViewServer = 2;
        static final int TRANSACTION_isViewServerRunning = 3;
        static final int TRANSACTION_openSession = 4;
        static final int TRANSACTION_useBLAST = 5;
        static final int TRANSACTION_getInitialDisplaySize = 6;
        static final int TRANSACTION_getBaseDisplaySize = 7;
        static final int TRANSACTION_setForcedDisplaySize = 8;
        static final int TRANSACTION_clearForcedDisplaySize = 9;
        static final int TRANSACTION_getInitialDisplayDensity = 10;
        static final int TRANSACTION_getBaseDisplayDensity = 11;
        static final int TRANSACTION_setForcedDisplayDensityForUser = 12;
        static final int TRANSACTION_clearForcedDisplayDensityForUser = 13;
        static final int TRANSACTION_setForcedDisplayScalingMode = 14;
        static final int TRANSACTION_setEventDispatching = 15;
        static final int TRANSACTION_isWindowToken = 16;
        static final int TRANSACTION_addWindowToken = 17;
        static final int TRANSACTION_removeWindowToken = 18;
        static final int TRANSACTION_setDisplayWindowRotationController = 19;
        static final int TRANSACTION_addShellRoot = 20;
        static final int TRANSACTION_setShellRootAccessibilityWindow = 21;
        static final int TRANSACTION_overridePendingAppTransitionMultiThumbFuture = 22;
        static final int TRANSACTION_overridePendingAppTransitionRemote = 23;
        static final int TRANSACTION_endProlongedAnimations = 24;
        static final int TRANSACTION_startFreezingScreen = 25;
        static final int TRANSACTION_stopFreezingScreen = 26;
        static final int TRANSACTION_disableKeyguard = 27;
        static final int TRANSACTION_reenableKeyguard = 28;
        static final int TRANSACTION_exitKeyguardSecurely = 29;
        static final int TRANSACTION_isKeyguardLocked = 30;
        static final int TRANSACTION_isKeyguardSecure = 31;
        static final int TRANSACTION_dismissKeyguard = 32;
        static final int TRANSACTION_setSwitchingUser = 33;
        static final int TRANSACTION_closeSystemDialogs = 34;
        static final int TRANSACTION_getAnimationScale = 35;
        static final int TRANSACTION_getAnimationScales = 36;
        static final int TRANSACTION_setAnimationScale = 37;
        static final int TRANSACTION_setAnimationScales = 38;
        static final int TRANSACTION_getCurrentAnimatorScale = 39;
        static final int TRANSACTION_setInTouchMode = 40;
        static final int TRANSACTION_showStrictModeViolation = 41;
        static final int TRANSACTION_setStrictModeVisualIndicatorPreference = 42;
        static final int TRANSACTION_refreshScreenCaptureDisabled = 43;
        static final int TRANSACTION_updateRotation = 44;
        static final int TRANSACTION_getDefaultDisplayRotation = 45;
        static final int TRANSACTION_watchRotation = 46;
        static final int TRANSACTION_removeRotationWatcher = 47;
        static final int TRANSACTION_getPreferredOptionsPanelGravity = 48;
        static final int TRANSACTION_freezeRotation = 49;
        static final int TRANSACTION_thawRotation = 50;
        static final int TRANSACTION_isRotationFrozen = 51;
        static final int TRANSACTION_freezeDisplayRotation = 52;
        static final int TRANSACTION_thawDisplayRotation = 53;
        static final int TRANSACTION_isDisplayRotationFrozen = 54;
        static final int TRANSACTION_setFixedToUserRotation = 55;
        static final int TRANSACTION_setIgnoreOrientationRequest = 56;
        static final int TRANSACTION_screenshotWallpaper = 57;
        static final int TRANSACTION_registerWallpaperVisibilityListener = 58;
        static final int TRANSACTION_unregisterWallpaperVisibilityListener = 59;
        static final int TRANSACTION_registerSystemGestureExclusionListener = 60;
        static final int TRANSACTION_unregisterSystemGestureExclusionListener = 61;
        static final int TRANSACTION_requestAssistScreenshot = 62;
        static final int TRANSACTION_hideTransientBars = 63;
        static final int TRANSACTION_setRecentsVisibility = 64;
        static final int TRANSACTION_updateStaticPrivacyIndicatorBounds = 65;
        static final int TRANSACTION_setNavBarVirtualKeyHapticFeedbackEnabled = 66;
        static final int TRANSACTION_hasNavigationBar = 67;
        static final int TRANSACTION_getNavBarPosition = 68;
        static final int TRANSACTION_lockNow = 69;
        static final int TRANSACTION_isSafeModeEnabled = 70;
        static final int TRANSACTION_enableScreenIfNeeded = 71;
        static final int TRANSACTION_clearWindowContentFrameStats = 72;
        static final int TRANSACTION_getWindowContentFrameStats = 73;
        static final int TRANSACTION_getDockedStackSide = 74;
        static final int TRANSACTION_setDockedTaskDividerTouchRegion = 75;
        static final int TRANSACTION_registerPinnedTaskListener = 76;
        static final int TRANSACTION_requestAppKeyboardShortcuts = 77;
        static final int TRANSACTION_getStableInsets = 78;
        static final int TRANSACTION_setForwardedInsets = 79;
        static final int TRANSACTION_registerShortcutKey = 80;
        static final int TRANSACTION_createInputConsumer = 81;
        static final int TRANSACTION_destroyInputConsumer = 82;
        static final int TRANSACTION_getCurrentImeTouchRegion = 83;
        static final int TRANSACTION_registerDisplayFoldListener = 84;
        static final int TRANSACTION_unregisterDisplayFoldListener = 85;
        static final int TRANSACTION_registerDisplayWindowListener = 86;
        static final int TRANSACTION_unregisterDisplayWindowListener = 87;
        static final int TRANSACTION_startWindowTrace = 88;
        static final int TRANSACTION_stopWindowTrace = 89;
        static final int TRANSACTION_isWindowTraceEnabled = 90;
        static final int TRANSACTION_dontOverrideDisplayInfo = 91;
        static final int TRANSACTION_getWindowingMode = 92;
        static final int TRANSACTION_setWindowingMode = 93;
        static final int TRANSACTION_getRemoveContentMode = 94;
        static final int TRANSACTION_setRemoveContentMode = 95;
        static final int TRANSACTION_shouldShowWithInsecureKeyguard = 96;
        static final int TRANSACTION_setShouldShowWithInsecureKeyguard = 97;
        static final int TRANSACTION_shouldShowSystemDecors = 98;
        static final int TRANSACTION_setShouldShowSystemDecors = 99;
        static final int TRANSACTION_getDisplayImePolicy = 100;
        static final int TRANSACTION_setDisplayImePolicy = 101;
        static final int TRANSACTION_injectInputAfterTransactionsApplied = 102;
        static final int TRANSACTION_syncInputTransactions = 103;
        static final int TRANSACTION_isLayerTracing = 104;
        static final int TRANSACTION_setLayerTracing = 105;
        static final int TRANSACTION_mirrorDisplay = 106;
        static final int TRANSACTION_setDisplayWindowInsetsController = 107;
        static final int TRANSACTION_modifyDisplayWindowInsets = 108;
        static final int TRANSACTION_getWindowInsets = 109;
        static final int TRANSACTION_showGlobalActions = 110;
        static final int TRANSACTION_setLayerTracingFlags = 111;
        static final int TRANSACTION_requestScrollCapture = 112;
        static final int TRANSACTION_holdLock = 113;
        static final int TRANSACTION_getSupportedDisplayHashAlgorithms = 114;
        static final int TRANSACTION_verifyDisplayHash = 115;
        static final int TRANSACTION_setDisplayHashThrottlingEnabled = 116;
        static final int TRANSACTION_attachWindowContextToDisplayArea = 117;
        static final int TRANSACTION_attachWindowContextToWindowToken = 118;
        static final int TRANSACTION_detachWindowContextFromWindowContainer = 119;
        static final int TRANSACTION_registerCrossWindowBlurEnabledListener = 120;
        static final int TRANSACTION_unregisterCrossWindowBlurEnabledListener = 121;
        static final int TRANSACTION_isTaskSnapshotSupported = 122;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWindowManager) {
                return (IWindowManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startViewServer";
                }
                case 2: {
                    return "stopViewServer";
                }
                case 3: {
                    return "isViewServerRunning";
                }
                case 4: {
                    return "openSession";
                }
                case 5: {
                    return "useBLAST";
                }
                case 6: {
                    return "getInitialDisplaySize";
                }
                case 7: {
                    return "getBaseDisplaySize";
                }
                case 8: {
                    return "setForcedDisplaySize";
                }
                case 9: {
                    return "clearForcedDisplaySize";
                }
                case 10: {
                    return "getInitialDisplayDensity";
                }
                case 11: {
                    return "getBaseDisplayDensity";
                }
                case 12: {
                    return "setForcedDisplayDensityForUser";
                }
                case 13: {
                    return "clearForcedDisplayDensityForUser";
                }
                case 14: {
                    return "setForcedDisplayScalingMode";
                }
                case 15: {
                    return "setEventDispatching";
                }
                case 16: {
                    return "isWindowToken";
                }
                case 17: {
                    return "addWindowToken";
                }
                case 18: {
                    return "removeWindowToken";
                }
                case 19: {
                    return "setDisplayWindowRotationController";
                }
                case 20: {
                    return "addShellRoot";
                }
                case 21: {
                    return "setShellRootAccessibilityWindow";
                }
                case 22: {
                    return "overridePendingAppTransitionMultiThumbFuture";
                }
                case 23: {
                    return "overridePendingAppTransitionRemote";
                }
                case 24: {
                    return "endProlongedAnimations";
                }
                case 25: {
                    return "startFreezingScreen";
                }
                case 26: {
                    return "stopFreezingScreen";
                }
                case 27: {
                    return "disableKeyguard";
                }
                case 28: {
                    return "reenableKeyguard";
                }
                case 29: {
                    return "exitKeyguardSecurely";
                }
                case 30: {
                    return "isKeyguardLocked";
                }
                case 31: {
                    return "isKeyguardSecure";
                }
                case 32: {
                    return "dismissKeyguard";
                }
                case 33: {
                    return "setSwitchingUser";
                }
                case 34: {
                    return "closeSystemDialogs";
                }
                case 35: {
                    return "getAnimationScale";
                }
                case 36: {
                    return "getAnimationScales";
                }
                case 37: {
                    return "setAnimationScale";
                }
                case 38: {
                    return "setAnimationScales";
                }
                case 39: {
                    return "getCurrentAnimatorScale";
                }
                case 40: {
                    return "setInTouchMode";
                }
                case 41: {
                    return "showStrictModeViolation";
                }
                case 42: {
                    return "setStrictModeVisualIndicatorPreference";
                }
                case 43: {
                    return "refreshScreenCaptureDisabled";
                }
                case 44: {
                    return "updateRotation";
                }
                case 45: {
                    return "getDefaultDisplayRotation";
                }
                case 46: {
                    return "watchRotation";
                }
                case 47: {
                    return "removeRotationWatcher";
                }
                case 48: {
                    return "getPreferredOptionsPanelGravity";
                }
                case 49: {
                    return "freezeRotation";
                }
                case 50: {
                    return "thawRotation";
                }
                case 51: {
                    return "isRotationFrozen";
                }
                case 52: {
                    return "freezeDisplayRotation";
                }
                case 53: {
                    return "thawDisplayRotation";
                }
                case 54: {
                    return "isDisplayRotationFrozen";
                }
                case 55: {
                    return "setFixedToUserRotation";
                }
                case 56: {
                    return "setIgnoreOrientationRequest";
                }
                case 57: {
                    return "screenshotWallpaper";
                }
                case 58: {
                    return "registerWallpaperVisibilityListener";
                }
                case 59: {
                    return "unregisterWallpaperVisibilityListener";
                }
                case 60: {
                    return "registerSystemGestureExclusionListener";
                }
                case 61: {
                    return "unregisterSystemGestureExclusionListener";
                }
                case 62: {
                    return "requestAssistScreenshot";
                }
                case 63: {
                    return "hideTransientBars";
                }
                case 64: {
                    return "setRecentsVisibility";
                }
                case 65: {
                    return "updateStaticPrivacyIndicatorBounds";
                }
                case 66: {
                    return "setNavBarVirtualKeyHapticFeedbackEnabled";
                }
                case 67: {
                    return "hasNavigationBar";
                }
                case 68: {
                    return "getNavBarPosition";
                }
                case 69: {
                    return "lockNow";
                }
                case 70: {
                    return "isSafeModeEnabled";
                }
                case 71: {
                    return "enableScreenIfNeeded";
                }
                case 72: {
                    return "clearWindowContentFrameStats";
                }
                case 73: {
                    return "getWindowContentFrameStats";
                }
                case 74: {
                    return "getDockedStackSide";
                }
                case 75: {
                    return "setDockedTaskDividerTouchRegion";
                }
                case 76: {
                    return "registerPinnedTaskListener";
                }
                case 77: {
                    return "requestAppKeyboardShortcuts";
                }
                case 78: {
                    return "getStableInsets";
                }
                case 79: {
                    return "setForwardedInsets";
                }
                case 80: {
                    return "registerShortcutKey";
                }
                case 81: {
                    return "createInputConsumer";
                }
                case 82: {
                    return "destroyInputConsumer";
                }
                case 83: {
                    return "getCurrentImeTouchRegion";
                }
                case 84: {
                    return "registerDisplayFoldListener";
                }
                case 85: {
                    return "unregisterDisplayFoldListener";
                }
                case 86: {
                    return "registerDisplayWindowListener";
                }
                case 87: {
                    return "unregisterDisplayWindowListener";
                }
                case 88: {
                    return "startWindowTrace";
                }
                case 89: {
                    return "stopWindowTrace";
                }
                case 90: {
                    return "isWindowTraceEnabled";
                }
                case 91: {
                    return "dontOverrideDisplayInfo";
                }
                case 92: {
                    return "getWindowingMode";
                }
                case 93: {
                    return "setWindowingMode";
                }
                case 94: {
                    return "getRemoveContentMode";
                }
                case 95: {
                    return "setRemoveContentMode";
                }
                case 96: {
                    return "shouldShowWithInsecureKeyguard";
                }
                case 97: {
                    return "setShouldShowWithInsecureKeyguard";
                }
                case 98: {
                    return "shouldShowSystemDecors";
                }
                case 99: {
                    return "setShouldShowSystemDecors";
                }
                case 100: {
                    return "getDisplayImePolicy";
                }
                case 101: {
                    return "setDisplayImePolicy";
                }
                case 102: {
                    return "injectInputAfterTransactionsApplied";
                }
                case 103: {
                    return "syncInputTransactions";
                }
                case 104: {
                    return "isLayerTracing";
                }
                case 105: {
                    return "setLayerTracing";
                }
                case 106: {
                    return "mirrorDisplay";
                }
                case 107: {
                    return "setDisplayWindowInsetsController";
                }
                case 108: {
                    return "modifyDisplayWindowInsets";
                }
                case 109: {
                    return "getWindowInsets";
                }
                case 110: {
                    return "showGlobalActions";
                }
                case 111: {
                    return "setLayerTracingFlags";
                }
                case 112: {
                    return "requestScrollCapture";
                }
                case 113: {
                    return "holdLock";
                }
                case 114: {
                    return "getSupportedDisplayHashAlgorithms";
                }
                case 115: {
                    return "verifyDisplayHash";
                }
                case 116: {
                    return "setDisplayHashThrottlingEnabled";
                }
                case 117: {
                    return "attachWindowContextToDisplayArea";
                }
                case 118: {
                    return "attachWindowContextToWindowToken";
                }
                case 119: {
                    return "detachWindowContextFromWindowContainer";
                }
                case 120: {
                    return "registerCrossWindowBlurEnabledListener";
                }
                case 121: {
                    return "unregisterCrossWindowBlurEnabledListener";
                }
                case 122: {
                    return "isTaskSnapshotSupported";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.startViewServer(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.stopViewServer();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isViewServerRunning();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IWindowSessionCallback _arg0 = IWindowSessionCallback.Stub.asInterface(data.readStrongBinder());
                    IWindowSession _result = this.openSession(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.useBLAST();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Point _arg1 = new Point();
                    this.getInitialDisplaySize(_arg0, _arg1);
                    reply.writeNoException();
                    if (_arg1 != null) {
                        reply.writeInt(1);
                        _arg1.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Point _arg1 = new Point();
                    this.getBaseDisplaySize(_arg0, _arg1);
                    reply.writeNoException();
                    if (_arg1 != null) {
                        reply.writeInt(1);
                        _arg1.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.setForcedDisplaySize(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.clearForcedDisplaySize(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getInitialDisplayDensity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getBaseDisplayDensity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.setForcedDisplayDensityForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.clearForcedDisplayDensityForUser(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setForcedDisplayScalingMode(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setEventDispatching(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.isWindowToken(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    Bundle _arg3 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.addWindowToken(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    this.removeWindowToken(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    IDisplayWindowRotationController _arg0 = IDisplayWindowRotationController.Stub.asInterface(data.readStrongBinder());
                    this.setDisplayWindowRotationController(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IWindow _arg1 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    SurfaceControl _result = this.addShellRoot(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IWindow _arg2 = IWindow.Stub.asInterface(data.readStrongBinder());
                    this.setShellRootAccessibilityWindow(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    IAppTransitionAnimationSpecsFuture _arg0 = IAppTransitionAnimationSpecsFuture.Stub.asInterface(data.readStrongBinder());
                    IRemoteCallback _arg1 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg2 = 0 != data.readInt();
                    int _arg3 = data.readInt();
                    this.overridePendingAppTransitionMultiThumbFuture(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    RemoteAnimationAdapter _arg0 = 0 != data.readInt() ? RemoteAnimationAdapter.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.overridePendingAppTransitionRemote(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    this.endProlongedAnimations();
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.startFreezingScreen(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    this.stopFreezingScreen();
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.disableKeyguard(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    this.reenableKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    IOnKeyguardExitResult _arg0 = IOnKeyguardExitResult.Stub.asInterface(data.readStrongBinder());
                    this.exitKeyguardSecurely(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isKeyguardLocked();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isKeyguardSecure(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    IKeyguardDismissCallback _arg0 = IKeyguardDismissCallback.Stub.asInterface(data.readStrongBinder());
                    CharSequence _arg1 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    this.dismissKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setSwitchingUser(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.closeSystemDialogs(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    float _result = this.getAnimationScale(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    float[] _result = this.getAnimationScales();
                    reply.writeNoException();
                    reply.writeFloatArray(_result);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    this.setAnimationScale(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    float[] _arg0 = data.createFloatArray();
                    this.setAnimationScales(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    float _result = this.getCurrentAnimatorScale();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setInTouchMode(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.showStrictModeViolation(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.setStrictModeVisualIndicatorPreference(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.refreshScreenCaptureDisabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.updateRotation(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    int _result = this.getDefaultDisplayRotation();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    IRotationWatcher _arg0 = IRotationWatcher.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _result = this.watchRotation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    IRotationWatcher _arg0 = IRotationWatcher.Stub.asInterface(data.readStrongBinder());
                    this.removeRotationWatcher(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getPreferredOptionsPanelGravity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.freezeRotation(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    this.thawRotation();
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isRotationFrozen();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.freezeDisplayRotation(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.thawDisplayRotation(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isDisplayRotationFrozen(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setFixedToUserRotation(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setIgnoreOrientationRequest(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    Bitmap _result = this.screenshotWallpaper();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    IWallpaperVisibilityListener _arg0 = IWallpaperVisibilityListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    boolean _result = this.registerWallpaperVisibilityListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    IWallpaperVisibilityListener _arg0 = IWallpaperVisibilityListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.unregisterWallpaperVisibilityListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 60: {
                    data.enforceInterface(descriptor);
                    ISystemGestureExclusionListener _arg0 = ISystemGestureExclusionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.registerSystemGestureExclusionListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 61: {
                    data.enforceInterface(descriptor);
                    ISystemGestureExclusionListener _arg0 = ISystemGestureExclusionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.unregisterSystemGestureExclusionListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 62: {
                    data.enforceInterface(descriptor);
                    IAssistDataReceiver _arg0 = IAssistDataReceiver.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.requestAssistScreenshot(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 63: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.hideTransientBars(_arg0);
                    return true;
                }
                case 64: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setRecentsVisibility(_arg0);
                    return true;
                }
                case 65: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Rect[] _arg1 = data.createTypedArray(Rect.CREATOR);
                    this.updateStaticPrivacyIndicatorBounds(_arg0, _arg1);
                    return true;
                }
                case 66: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setNavBarVirtualKeyHapticFeedbackEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 67: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.hasNavigationBar(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 68: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getNavBarPosition(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 69: {
                    data.enforceInterface(descriptor);
                    Bundle _arg0 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.lockNow(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 70: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isSafeModeEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 71: {
                    data.enforceInterface(descriptor);
                    this.enableScreenIfNeeded();
                    reply.writeNoException();
                    return true;
                }
                case 72: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.clearWindowContentFrameStats(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 73: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    WindowContentFrameStats _result = this.getWindowContentFrameStats(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 74: {
                    data.enforceInterface(descriptor);
                    int _result = this.getDockedStackSide();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 75: {
                    data.enforceInterface(descriptor);
                    Rect _arg0 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    this.setDockedTaskDividerTouchRegion(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 76: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IPinnedTaskListener _arg1 = IPinnedTaskListener.Stub.asInterface(data.readStrongBinder());
                    this.registerPinnedTaskListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 77: {
                    data.enforceInterface(descriptor);
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.requestAppKeyboardShortcuts(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 78: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Rect _arg1 = new Rect();
                    this.getStableInsets(_arg0, _arg1);
                    reply.writeNoException();
                    if (_arg1 != null) {
                        reply.writeInt(1);
                        _arg1.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 79: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Insets _arg1 = 0 != data.readInt() ? Insets.CREATOR.createFromParcel(data) : null;
                    this.setForwardedInsets(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 80: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    IShortcutService _arg1 = IShortcutService.Stub.asInterface(data.readStrongBinder());
                    this.registerShortcutKey(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 81: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    InputChannel _arg3 = new InputChannel();
                    this.createInputConsumer(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_arg3 != null) {
                        reply.writeInt(1);
                        _arg3.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 82: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.destroyInputConsumer(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 83: {
                    data.enforceInterface(descriptor);
                    Region _result = this.getCurrentImeTouchRegion();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 84: {
                    data.enforceInterface(descriptor);
                    IDisplayFoldListener _arg0 = IDisplayFoldListener.Stub.asInterface(data.readStrongBinder());
                    this.registerDisplayFoldListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 85: {
                    data.enforceInterface(descriptor);
                    IDisplayFoldListener _arg0 = IDisplayFoldListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterDisplayFoldListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 86: {
                    data.enforceInterface(descriptor);
                    IDisplayWindowListener _arg0 = IDisplayWindowListener.Stub.asInterface(data.readStrongBinder());
                    this.registerDisplayWindowListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 87: {
                    data.enforceInterface(descriptor);
                    IDisplayWindowListener _arg0 = IDisplayWindowListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterDisplayWindowListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 88: {
                    data.enforceInterface(descriptor);
                    this.startWindowTrace();
                    reply.writeNoException();
                    return true;
                }
                case 89: {
                    data.enforceInterface(descriptor);
                    this.stopWindowTrace();
                    reply.writeNoException();
                    return true;
                }
                case 90: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isWindowTraceEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 91: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.dontOverrideDisplayInfo(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 92: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getWindowingMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 93: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setWindowingMode(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 94: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getRemoveContentMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 95: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setRemoveContentMode(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 96: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.shouldShowWithInsecureKeyguard(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 97: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setShouldShowWithInsecureKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 98: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.shouldShowSystemDecors(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 99: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setShouldShowSystemDecors(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 100: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getDisplayImePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 101: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setDisplayImePolicy(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 102: {
                    data.enforceInterface(descriptor);
                    InputEvent _arg0 = 0 != data.readInt() ? InputEvent.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    boolean _result = this.injectInputAfterTransactionsApplied(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 103: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.syncInputTransactions(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 104: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isLayerTracing();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 105: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setLayerTracing(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 106: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    SurfaceControl _arg1 = new SurfaceControl();
                    boolean _result = this.mirrorDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    if (_arg1 != null) {
                        reply.writeInt(1);
                        _arg1.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 107: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IDisplayWindowInsetsController _arg1 = IDisplayWindowInsetsController.Stub.asInterface(data.readStrongBinder());
                    this.setDisplayWindowInsetsController(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 108: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    InsetsState _arg1 = 0 != data.readInt() ? InsetsState.CREATOR.createFromParcel(data) : null;
                    this.modifyDisplayWindowInsets(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 109: {
                    data.enforceInterface(descriptor);
                    WindowManager.LayoutParams _arg0 = 0 != data.readInt() ? WindowManager.LayoutParams.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    InsetsState _arg2 = new InsetsState();
                    boolean _result = this.getWindowInsets(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    if (_arg2 != null) {
                        reply.writeInt(1);
                        _arg2.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 110: {
                    data.enforceInterface(descriptor);
                    this.showGlobalActions();
                    reply.writeNoException();
                    return true;
                }
                case 111: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setLayerTracingFlags(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 112: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    IScrollCaptureResponseListener _arg3 = IScrollCaptureResponseListener.Stub.asInterface(data.readStrongBinder());
                    this.requestScrollCapture(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 113: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    this.holdLock(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 114: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getSupportedDisplayHashAlgorithms();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 115: {
                    data.enforceInterface(descriptor);
                    DisplayHash _arg0 = 0 != data.readInt() ? DisplayHash.CREATOR.createFromParcel(data) : null;
                    VerifiedDisplayHash _result = this.verifyDisplayHash(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 116: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setDisplayHashThrottlingEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 117: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    Bundle _arg3 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.attachWindowContextToDisplayArea(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 118: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    this.attachWindowContextToWindowToken(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 119: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.detachWindowContextFromWindowContainer(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 120: {
                    data.enforceInterface(descriptor);
                    ICrossWindowBlurEnabledListener _arg0 = ICrossWindowBlurEnabledListener.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.registerCrossWindowBlurEnabledListener(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 121: {
                    data.enforceInterface(descriptor);
                    ICrossWindowBlurEnabledListener _arg0 = ICrossWindowBlurEnabledListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterCrossWindowBlurEnabledListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 122: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isTaskSnapshotSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IWindowManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IWindowManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IWindowManager {
            private IBinder mRemote;
            public static IWindowManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startViewServer(int port) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(port);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startViewServer(port);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopViewServer() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().stopViewServer();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isViewServerRunning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isViewServerRunning();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IWindowSession openSession(IWindowSessionCallback callback) throws RemoteException {
                IWindowSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IWindowSession iWindowSession = Stub.getDefaultImpl().openSession(callback);
                        return iWindowSession;
                    }
                    _reply.readException();
                    _result = IWindowSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean useBLAST() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().useBLAST();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getInitialDisplaySize(int displayId, Point size) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getInitialDisplaySize(displayId, size);
                        return;
                    }
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        size.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getBaseDisplaySize(int displayId, Point size) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getBaseDisplaySize(displayId, size);
                        return;
                    }
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        size.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplaySize(int displayId, int width, int height) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setForcedDisplaySize(displayId, width, height);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearForcedDisplaySize(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearForcedDisplaySize(displayId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInitialDisplayDensity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getInitialDisplayDensity(displayId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBaseDisplayDensity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getBaseDisplayDensity(displayId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplayDensityForUser(int displayId, int density, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(density);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setForcedDisplayDensityForUser(displayId, density, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearForcedDisplayDensityForUser(int displayId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearForcedDisplayDensityForUser(displayId, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplayScalingMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setForcedDisplayScalingMode(displayId, mode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEventDispatching(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setEventDispatching(enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWindowToken(IBinder binder) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isWindowToken(binder);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addWindowToken(IBinder token, int type, int displayId, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(type);
                    _data.writeInt(displayId);
                    if (options != null) {
                        _data.writeInt(1);
                        options.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addWindowToken(token, type, displayId, options);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeWindowToken(IBinder token, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeWindowToken(token, displayId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayWindowRotationController(IDisplayWindowRotationController controller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(controller != null ? controller.asBinder() : null);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDisplayWindowRotationController(controller);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceControl addShellRoot(int displayId, IWindow client, int shellRootLayer) throws RemoteException {
                SurfaceControl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    _data.writeInt(shellRootLayer);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        SurfaceControl surfaceControl = Stub.getDefaultImpl().addShellRoot(displayId, client, shellRootLayer);
                        return surfaceControl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? SurfaceControl.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShellRootAccessibilityWindow(int displayId, int shellRootLayer, IWindow target) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(shellRootLayer);
                    _data.writeStrongBinder(target != null ? target.asBinder() : null);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setShellRootAccessibilityWindow(displayId, shellRootLayer, target);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback startedCallback, boolean scaleUp, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(specsFuture != null ? specsFuture.asBinder() : null);
                    _data.writeStrongBinder(startedCallback != null ? startedCallback.asBinder() : null);
                    _data.writeInt(scaleUp ? 1 : 0);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().overridePendingAppTransitionMultiThumbFuture(specsFuture, startedCallback, scaleUp, displayId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overridePendingAppTransitionRemote(RemoteAnimationAdapter remoteAnimationAdapter, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (remoteAnimationAdapter != null) {
                        _data.writeInt(1);
                        remoteAnimationAdapter.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().overridePendingAppTransitionRemote(remoteAnimationAdapter, displayId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endProlongedAnimations() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().endProlongedAnimations();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startFreezingScreen(int exitAnim, int enterAnim) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(exitAnim);
                    _data.writeInt(enterAnim);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startFreezingScreen(exitAnim, enterAnim);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopFreezingScreen() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopFreezingScreen();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableKeyguard(IBinder token, String tag, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(tag);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().disableKeyguard(token, tag, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reenableKeyguard(IBinder token, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reenableKeyguard(token, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void exitKeyguardSecurely(IOnKeyguardExitResult callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().exitKeyguardSecurely(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isKeyguardLocked() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isKeyguardLocked();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isKeyguardSecure(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isKeyguardSecure(userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissKeyguard(IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (message != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(message, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dismissKeyguard(callback, message);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSwitchingUser(boolean switching) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(switching ? 1 : 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSwitchingUser(switching);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSystemDialogs(String reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(reason);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().closeSystemDialogs(reason);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getAnimationScale(int which) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        float f = Stub.getDefaultImpl().getAnimationScale(which);
                        return f;
                    }
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float[] getAnimationScales() throws RemoteException {
                float[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        float[] fArray = Stub.getDefaultImpl().getAnimationScales();
                        return fArray;
                    }
                    _reply.readException();
                    _result = _reply.createFloatArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnimationScale(int which, float scale) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    _data.writeFloat(scale);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAnimationScale(which, scale);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnimationScales(float[] scales) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloatArray(scales);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAnimationScales(scales);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getCurrentAnimatorScale() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        float f = Stub.getDefaultImpl().getCurrentAnimatorScale();
                        return f;
                    }
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInTouchMode(boolean showFocus) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(showFocus ? 1 : 0);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setInTouchMode(showFocus);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showStrictModeViolation(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(on ? 1 : 0);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showStrictModeViolation(on);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStrictModeVisualIndicatorPreference(String enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(enabled);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setStrictModeVisualIndicatorPreference(enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refreshScreenCaptureDisabled(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().refreshScreenCaptureDisabled(userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(alwaysSendConfiguration ? 1 : 0);
                    _data.writeInt(forceRelayout ? 1 : 0);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateRotation(alwaysSendConfiguration, forceRelayout);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultDisplayRotation() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getDefaultDisplayRotation();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int watchRotation(IRotationWatcher watcher, int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(watcher != null ? watcher.asBinder() : null);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().watchRotation(watcher, displayId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRotationWatcher(IRotationWatcher watcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(watcher != null ? watcher.asBinder() : null);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeRotationWatcher(watcher);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPreferredOptionsPanelGravity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getPreferredOptionsPanelGravity(displayId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freezeRotation(int rotation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().freezeRotation(rotation);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void thawRotation() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().thawRotation();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRotationFrozen() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isRotationFrozen();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freezeDisplayRotation(int displayId, int rotation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(rotation);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().freezeDisplayRotation(displayId, rotation);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void thawDisplayRotation(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().thawDisplayRotation(displayId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDisplayRotationFrozen(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isDisplayRotationFrozen(displayId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFixedToUserRotation(int displayId, int fixedToUserRotation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(fixedToUserRotation);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setFixedToUserRotation(displayId, fixedToUserRotation);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIgnoreOrientationRequest(int displayId, boolean ignoreOrientationRequest) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(ignoreOrientationRequest ? 1 : 0);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setIgnoreOrientationRequest(displayId, ignoreOrientationRequest);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap screenshotWallpaper() throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Bitmap bitmap = Stub.getDefaultImpl().screenshotWallpaper();
                        return bitmap;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Bitmap.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().registerWallpaperVisibilityListener(listener, displayId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterWallpaperVisibilityListener(listener, displayId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSystemGestureExclusionListener(listener, displayId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterSystemGestureExclusionListener(listener, displayId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestAssistScreenshot(IAssistDataReceiver receiver) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().requestAssistScreenshot(receiver);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideTransientBars(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(63, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideTransientBars(displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecentsVisibility(boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(visible ? 1 : 0);
                    boolean _status = this.mRemote.transact(64, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRecentsVisibility(visible);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateStaticPrivacyIndicatorBounds(int displayId, Rect[] staticBounds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedArray(staticBounds, 0);
                    boolean _status = this.mRemote.transact(65, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateStaticPrivacyIndicatorBounds(displayId, staticBounds);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setNavBarVirtualKeyHapticFeedbackEnabled(enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNavigationBar(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().hasNavigationBar(displayId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNavBarPosition(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getNavBarPosition(displayId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lockNow(Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (options != null) {
                        _data.writeInt(1);
                        options.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().lockNow(options);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSafeModeEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isSafeModeEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableScreenIfNeeded() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enableScreenIfNeeded();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean clearWindowContentFrameStats(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().clearWindowContentFrameStats(token);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WindowContentFrameStats getWindowContentFrameStats(IBinder token) throws RemoteException {
                WindowContentFrameStats _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WindowContentFrameStats windowContentFrameStats = Stub.getDefaultImpl().getWindowContentFrameStats(token);
                        return windowContentFrameStats;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WindowContentFrameStats.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDockedStackSide() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getDockedStackSide();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDockedTaskDividerTouchRegion(Rect touchableRegion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (touchableRegion != null) {
                        _data.writeInt(1);
                        touchableRegion.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDockedTaskDividerTouchRegion(touchableRegion);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPinnedTaskListener(int displayId, IPinnedTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerPinnedTaskListener(displayId, listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestAppKeyboardShortcuts(receiver, deviceId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getStableInsets(int displayId, Rect outInsets) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getStableInsets(displayId, outInsets);
                        return;
                    }
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        outInsets.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForwardedInsets(int displayId, Insets insets) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    if (insets != null) {
                        _data.writeInt(1);
                        insets.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setForwardedInsets(displayId, insets);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerShortcutKey(long shortcutCode, IShortcutService keySubscriber) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(shortcutCode);
                    _data.writeStrongBinder(keySubscriber != null ? keySubscriber.asBinder() : null);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerShortcutKey(shortcutCode, keySubscriber);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createInputConsumer(IBinder token, String name, int displayId, InputChannel inputChannel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(name);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().createInputConsumer(token, name, displayId, inputChannel);
                        return;
                    }
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        inputChannel.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean destroyInputConsumer(String name, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().destroyInputConsumer(name, displayId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Region getCurrentImeTouchRegion() throws RemoteException {
                Region _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Region region = Stub.getDefaultImpl().getCurrentImeTouchRegion();
                        return region;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Region.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerDisplayFoldListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterDisplayFoldListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerDisplayWindowListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterDisplayWindowListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWindowTrace() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startWindowTrace();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWindowTrace() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopWindowTrace();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWindowTraceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isWindowTraceEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dontOverrideDisplayInfo(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dontOverrideDisplayInfo(displayId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWindowingMode(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getWindowingMode(displayId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWindowingMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setWindowingMode(displayId, mode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRemoveContentMode(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getRemoveContentMode(displayId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRemoveContentMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRemoveContentMode(displayId, mode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldShowWithInsecureKeyguard(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().shouldShowWithInsecureKeyguard(displayId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(shouldShow ? 1 : 0);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setShouldShowWithInsecureKeyguard(displayId, shouldShow);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldShowSystemDecors(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().shouldShowSystemDecors(displayId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldShowSystemDecors(int displayId, boolean shouldShow) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(shouldShow ? 1 : 0);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setShouldShowSystemDecors(displayId, shouldShow);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisplayImePolicy(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getDisplayImePolicy(displayId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayImePolicy(int displayId, int imePolicy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(imePolicy);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDisplayImePolicy(displayId, imePolicy);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean injectInputAfterTransactionsApplied(InputEvent ev, int mode, boolean waitForAnimations) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (ev != null) {
                        _data.writeInt(1);
                        ev.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(mode);
                    _data.writeInt(waitForAnimations ? 1 : 0);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().injectInputAfterTransactionsApplied(ev, mode, waitForAnimations);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void syncInputTransactions(boolean waitForAnimations) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(waitForAnimations ? 1 : 0);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().syncInputTransactions(waitForAnimations);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLayerTracing() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isLayerTracing();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLayerTracing(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setLayerTracing(enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean mirrorDisplay(int displayId, SurfaceControl outSurfaceControl) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().mirrorDisplay(displayId, outSurfaceControl);
                        return bl;
                    }
                    _reply.readException();
                    boolean bl = _result = 0 != _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outSurfaceControl.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayWindowInsetsController(int displayId, IDisplayWindowInsetsController displayWindowInsetsController) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(displayWindowInsetsController != null ? displayWindowInsetsController.asBinder() : null);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDisplayWindowInsetsController(displayId, displayWindowInsetsController);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modifyDisplayWindowInsets(int displayId, InsetsState state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    if (state != null) {
                        _data.writeInt(1);
                        state.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().modifyDisplayWindowInsets(displayId, state);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getWindowInsets(WindowManager.LayoutParams attrs, int displayId, InsetsState outInsetsState) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attrs != null) {
                        _data.writeInt(1);
                        attrs.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().getWindowInsets(attrs, displayId, outInsetsState);
                        return bl;
                    }
                    _reply.readException();
                    boolean bl = _result = 0 != _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outInsetsState.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showGlobalActions() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showGlobalActions();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLayerTracingFlags(int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setLayerTracingFlags(flags);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestScrollCapture(int displayId, IBinder behindClient, int taskId, IScrollCaptureResponseListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(behindClient);
                    _data.writeInt(taskId);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestScrollCapture(displayId, behindClient, taskId, listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void holdLock(IBinder token, int durationMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(durationMs);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().holdLock(token, durationMs);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getSupportedDisplayHashAlgorithms() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(114, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getSupportedDisplayHashAlgorithms();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifiedDisplayHash verifyDisplayHash(DisplayHash displayHash) throws RemoteException {
                VerifiedDisplayHash _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (displayHash != null) {
                        _data.writeInt(1);
                        displayHash.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        VerifiedDisplayHash verifiedDisplayHash = Stub.getDefaultImpl().verifyDisplayHash(displayHash);
                        return verifiedDisplayHash;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? VerifiedDisplayHash.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayHashThrottlingEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDisplayHashThrottlingEnabled(enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean attachWindowContextToDisplayArea(IBinder clientToken, int type, int displayId, Bundle options) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeInt(type);
                    _data.writeInt(displayId);
                    if (options != null) {
                        _data.writeInt(1);
                        options.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(117, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().attachWindowContextToDisplayArea(clientToken, type, displayId, options);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attachWindowContextToWindowToken(IBinder clientToken, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(118, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().attachWindowContextToWindowToken(clientToken, token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void detachWindowContextFromWindowContainer(IBinder clientToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().detachWindowContextFromWindowContainer(clientToken);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().registerCrossWindowBlurEnabledListener(listener);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterCrossWindowBlurEnabledListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTaskSnapshotSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isTaskSnapshotSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IWindowManager {
        @Override
        public boolean startViewServer(int port) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopViewServer() throws RemoteException {
            return false;
        }

        @Override
        public boolean isViewServerRunning() throws RemoteException {
            return false;
        }

        @Override
        public IWindowSession openSession(IWindowSessionCallback callback) throws RemoteException {
            return null;
        }

        @Override
        public boolean useBLAST() throws RemoteException {
            return false;
        }

        @Override
        public void getInitialDisplaySize(int displayId, Point size) throws RemoteException {
        }

        @Override
        public void getBaseDisplaySize(int displayId, Point size) throws RemoteException {
        }

        @Override
        public void setForcedDisplaySize(int displayId, int width, int height) throws RemoteException {
        }

        @Override
        public void clearForcedDisplaySize(int displayId) throws RemoteException {
        }

        @Override
        public int getInitialDisplayDensity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public int getBaseDisplayDensity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setForcedDisplayDensityForUser(int displayId, int density, int userId) throws RemoteException {
        }

        @Override
        public void clearForcedDisplayDensityForUser(int displayId, int userId) throws RemoteException {
        }

        @Override
        public void setForcedDisplayScalingMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public void setEventDispatching(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isWindowToken(IBinder binder) throws RemoteException {
            return false;
        }

        @Override
        public void addWindowToken(IBinder token, int type, int displayId, Bundle options) throws RemoteException {
        }

        @Override
        public void removeWindowToken(IBinder token, int displayId) throws RemoteException {
        }

        @Override
        public void setDisplayWindowRotationController(IDisplayWindowRotationController controller) throws RemoteException {
        }

        @Override
        public SurfaceControl addShellRoot(int displayId, IWindow client, int shellRootLayer) throws RemoteException {
            return null;
        }

        @Override
        public void setShellRootAccessibilityWindow(int displayId, int shellRootLayer, IWindow target) throws RemoteException {
        }

        @Override
        public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback startedCallback, boolean scaleUp, int displayId) throws RemoteException {
        }

        @Override
        public void overridePendingAppTransitionRemote(RemoteAnimationAdapter remoteAnimationAdapter, int displayId) throws RemoteException {
        }

        @Override
        public void endProlongedAnimations() throws RemoteException {
        }

        @Override
        public void startFreezingScreen(int exitAnim, int enterAnim) throws RemoteException {
        }

        @Override
        public void stopFreezingScreen() throws RemoteException {
        }

        @Override
        public void disableKeyguard(IBinder token, String tag, int userId) throws RemoteException {
        }

        @Override
        public void reenableKeyguard(IBinder token, int userId) throws RemoteException {
        }

        @Override
        public void exitKeyguardSecurely(IOnKeyguardExitResult callback) throws RemoteException {
        }

        @Override
        public boolean isKeyguardLocked() throws RemoteException {
            return false;
        }

        @Override
        public boolean isKeyguardSecure(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void dismissKeyguard(IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
        }

        @Override
        public void setSwitchingUser(boolean switching) throws RemoteException {
        }

        @Override
        public void closeSystemDialogs(String reason) throws RemoteException {
        }

        @Override
        public float getAnimationScale(int which) throws RemoteException {
            return 0.0f;
        }

        @Override
        public float[] getAnimationScales() throws RemoteException {
            return null;
        }

        @Override
        public void setAnimationScale(int which, float scale) throws RemoteException {
        }

        @Override
        public void setAnimationScales(float[] scales) throws RemoteException {
        }

        @Override
        public float getCurrentAnimatorScale() throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setInTouchMode(boolean showFocus) throws RemoteException {
        }

        @Override
        public void showStrictModeViolation(boolean on) throws RemoteException {
        }

        @Override
        public void setStrictModeVisualIndicatorPreference(String enabled) throws RemoteException {
        }

        @Override
        public void refreshScreenCaptureDisabled(int userId) throws RemoteException {
        }

        @Override
        public void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) throws RemoteException {
        }

        @Override
        public int getDefaultDisplayRotation() throws RemoteException {
            return 0;
        }

        @Override
        public int watchRotation(IRotationWatcher watcher, int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void removeRotationWatcher(IRotationWatcher watcher) throws RemoteException {
        }

        @Override
        public int getPreferredOptionsPanelGravity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void freezeRotation(int rotation) throws RemoteException {
        }

        @Override
        public void thawRotation() throws RemoteException {
        }

        @Override
        public boolean isRotationFrozen() throws RemoteException {
            return false;
        }

        @Override
        public void freezeDisplayRotation(int displayId, int rotation) throws RemoteException {
        }

        @Override
        public void thawDisplayRotation(int displayId) throws RemoteException {
        }

        @Override
        public boolean isDisplayRotationFrozen(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setFixedToUserRotation(int displayId, int fixedToUserRotation) throws RemoteException {
        }

        @Override
        public void setIgnoreOrientationRequest(int displayId, boolean ignoreOrientationRequest) throws RemoteException {
        }

        @Override
        public Bitmap screenshotWallpaper() throws RemoteException {
            return null;
        }

        @Override
        public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
        }

        @Override
        public boolean requestAssistScreenshot(IAssistDataReceiver receiver) throws RemoteException {
            return false;
        }

        @Override
        public void hideTransientBars(int displayId) throws RemoteException {
        }

        @Override
        public void setRecentsVisibility(boolean visible) throws RemoteException {
        }

        @Override
        public void updateStaticPrivacyIndicatorBounds(int displayId, Rect[] staticBounds) throws RemoteException {
        }

        @Override
        public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean hasNavigationBar(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public int getNavBarPosition(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void lockNow(Bundle options) throws RemoteException {
        }

        @Override
        public boolean isSafeModeEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void enableScreenIfNeeded() throws RemoteException {
        }

        @Override
        public boolean clearWindowContentFrameStats(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public WindowContentFrameStats getWindowContentFrameStats(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public int getDockedStackSide() throws RemoteException {
            return 0;
        }

        @Override
        public void setDockedTaskDividerTouchRegion(Rect touchableRegion) throws RemoteException {
        }

        @Override
        public void registerPinnedTaskListener(int displayId, IPinnedTaskListener listener) throws RemoteException {
        }

        @Override
        public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
        }

        @Override
        public void getStableInsets(int displayId, Rect outInsets) throws RemoteException {
        }

        @Override
        public void setForwardedInsets(int displayId, Insets insets) throws RemoteException {
        }

        @Override
        public void registerShortcutKey(long shortcutCode, IShortcutService keySubscriber) throws RemoteException {
        }

        @Override
        public void createInputConsumer(IBinder token, String name, int displayId, InputChannel inputChannel) throws RemoteException {
        }

        @Override
        public boolean destroyInputConsumer(String name, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public Region getCurrentImeTouchRegion() throws RemoteException {
            return null;
        }

        @Override
        public void registerDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
        }

        @Override
        public void unregisterDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
        }

        @Override
        public void registerDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
        }

        @Override
        public void unregisterDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
        }

        @Override
        public void startWindowTrace() throws RemoteException {
        }

        @Override
        public void stopWindowTrace() throws RemoteException {
        }

        @Override
        public boolean isWindowTraceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void dontOverrideDisplayInfo(int displayId) throws RemoteException {
        }

        @Override
        public int getWindowingMode(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setWindowingMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public int getRemoveContentMode(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setRemoveContentMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public boolean shouldShowWithInsecureKeyguard(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) throws RemoteException {
        }

        @Override
        public boolean shouldShowSystemDecors(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setShouldShowSystemDecors(int displayId, boolean shouldShow) throws RemoteException {
        }

        @Override
        public int getDisplayImePolicy(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setDisplayImePolicy(int displayId, int imePolicy) throws RemoteException {
        }

        @Override
        public boolean injectInputAfterTransactionsApplied(InputEvent ev, int mode, boolean waitForAnimations) throws RemoteException {
            return false;
        }

        @Override
        public void syncInputTransactions(boolean waitForAnimations) throws RemoteException {
        }

        @Override
        public boolean isLayerTracing() throws RemoteException {
            return false;
        }

        @Override
        public void setLayerTracing(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean mirrorDisplay(int displayId, SurfaceControl outSurfaceControl) throws RemoteException {
            return false;
        }

        @Override
        public void setDisplayWindowInsetsController(int displayId, IDisplayWindowInsetsController displayWindowInsetsController) throws RemoteException {
        }

        @Override
        public void modifyDisplayWindowInsets(int displayId, InsetsState state) throws RemoteException {
        }

        @Override
        public boolean getWindowInsets(WindowManager.LayoutParams attrs, int displayId, InsetsState outInsetsState) throws RemoteException {
            return false;
        }

        @Override
        public void showGlobalActions() throws RemoteException {
        }

        @Override
        public void setLayerTracingFlags(int flags) throws RemoteException {
        }

        @Override
        public void requestScrollCapture(int displayId, IBinder behindClient, int taskId, IScrollCaptureResponseListener listener) throws RemoteException {
        }

        @Override
        public void holdLock(IBinder token, int durationMs) throws RemoteException {
        }

        @Override
        public String[] getSupportedDisplayHashAlgorithms() throws RemoteException {
            return null;
        }

        @Override
        public VerifiedDisplayHash verifyDisplayHash(DisplayHash displayHash) throws RemoteException {
            return null;
        }

        @Override
        public void setDisplayHashThrottlingEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public boolean attachWindowContextToDisplayArea(IBinder clientToken, int type, int displayId, Bundle options) throws RemoteException {
            return false;
        }

        @Override
        public void attachWindowContextToWindowToken(IBinder clientToken, IBinder token) throws RemoteException {
        }

        @Override
        public void detachWindowContextFromWindowContainer(IBinder clientToken) throws RemoteException {
        }

        @Override
        public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
        }

        @Override
        public boolean isTaskSnapshotSupported() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

