/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Resources;
import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import android.view.RoundedCorner;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Arrays;

public class RoundedCorners
implements Parcelable {
    public static final RoundedCorners NO_ROUNDED_CORNERS = new RoundedCorners(new RoundedCorner(0), new RoundedCorner(1), new RoundedCorner(2), new RoundedCorner(3));
    public static final int ROUNDED_CORNER_POSITION_LENGTH = 4;
    private static final Object CACHE_LOCK = new Object();
    @GuardedBy(value={"CACHE_LOCK"})
    private static int sCachedDisplayWidth;
    @GuardedBy(value={"CACHE_LOCK"})
    private static int sCachedDisplayHeight;
    @GuardedBy(value={"CACHE_LOCK"})
    private static Pair<Integer, Integer> sCachedRadii;
    @GuardedBy(value={"CACHE_LOCK"})
    private static RoundedCorners sCachedRoundedCorners;
    @VisibleForTesting
    public final RoundedCorner[] mRoundedCorners;
    public static final Parcelable.Creator<RoundedCorners> CREATOR;

    public RoundedCorners(RoundedCorner[] roundedCorners) {
        this.mRoundedCorners = roundedCorners;
    }

    public RoundedCorners(RoundedCorner topLeft, RoundedCorner topRight, RoundedCorner bottomRight, RoundedCorner bottomLeft) {
        this.mRoundedCorners = new RoundedCorner[4];
        this.mRoundedCorners[0] = topLeft;
        this.mRoundedCorners[1] = topRight;
        this.mRoundedCorners[2] = bottomRight;
        this.mRoundedCorners[3] = bottomLeft;
    }

    public RoundedCorners(RoundedCorners roundedCorners) {
        this.mRoundedCorners = new RoundedCorner[4];
        for (int i = 0; i < 4; ++i) {
            this.mRoundedCorners[i] = new RoundedCorner(roundedCorners.mRoundedCorners[i]);
        }
    }

    public static RoundedCorners fromResources(Resources res, int displayWidth, int displayHeight) {
        return RoundedCorners.fromRadii(RoundedCorners.loadRoundedCornerRadii(res), displayWidth, displayHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static RoundedCorners fromRadii(Pair<Integer, Integer> radii, int displayWidth, int displayHeight) {
        if (radii == null) {
            return null;
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (radii.equals(sCachedRadii) && sCachedDisplayWidth == displayWidth && sCachedDisplayHeight == displayHeight) {
                return sCachedRoundedCorners;
            }
        }
        RoundedCorner[] roundedCorners = new RoundedCorner[4];
        int topRadius = (Integer)radii.first > 0 ? (Integer)radii.first : 0;
        int bottomRadius = (Integer)radii.second > 0 ? (Integer)radii.second : 0;
        for (int i = 0; i < 4; ++i) {
            roundedCorners[i] = RoundedCorners.createRoundedCorner(i, i <= 1 ? topRadius : bottomRadius, displayWidth, displayHeight);
        }
        RoundedCorners result = new RoundedCorners(roundedCorners);
        Object object2 = CACHE_LOCK;
        synchronized (object2) {
            sCachedDisplayWidth = displayWidth;
            sCachedDisplayHeight = displayHeight;
            sCachedRadii = radii;
            sCachedRoundedCorners = result;
        }
        return result;
    }

    private static Pair<Integer, Integer> loadRoundedCornerRadii(Resources res) {
        int radiusDefault = res.getDimensionPixelSize(17105496);
        int radiusTop = res.getDimensionPixelSize(17105500);
        int radiusBottom = res.getDimensionPixelSize(17105498);
        if (radiusDefault == 0 && radiusTop == 0 && radiusBottom == 0) {
            return null;
        }
        Pair<Integer, Integer> radii = new Pair<Integer, Integer>(radiusTop > 0 ? radiusTop : radiusDefault, radiusBottom > 0 ? radiusBottom : radiusDefault);
        return radii;
    }

    public RoundedCorners inset(int insetLeft, int insetTop, int insetRight, int insetBottom) {
        RoundedCorner[] roundedCorners = new RoundedCorner[4];
        for (int i = 0; i < 4; ++i) {
            roundedCorners[i] = this.insetRoundedCorner(i, insetLeft, insetTop, insetRight, insetBottom);
        }
        return new RoundedCorners(roundedCorners);
    }

    private RoundedCorner insetRoundedCorner(int position, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        boolean hasRoundedCorner;
        if (this.mRoundedCorners[position].isEmpty()) {
            return new RoundedCorner(position);
        }
        int radius = this.mRoundedCorners[position].getRadius();
        Point center = this.mRoundedCorners[position].getCenter();
        switch (position) {
            case 0: {
                hasRoundedCorner = radius > insetTop && radius > insetLeft;
                break;
            }
            case 1: {
                hasRoundedCorner = radius > insetTop && radius > insetRight;
                break;
            }
            case 2: {
                hasRoundedCorner = radius > insetBottom && radius > insetRight;
                break;
            }
            case 3: {
                hasRoundedCorner = radius > insetBottom && radius > insetLeft;
                break;
            }
            default: {
                throw new IllegalArgumentException("The position is not one of the RoundedCornerPosition =" + position);
            }
        }
        return new RoundedCorner(position, radius, hasRoundedCorner ? center.x - insetLeft : 0, hasRoundedCorner ? center.y - insetTop : 0);
    }

    public RoundedCorner getRoundedCorner(int position) {
        return this.mRoundedCorners[position].isEmpty() ? null : new RoundedCorner(this.mRoundedCorners[position]);
    }

    public void setRoundedCorner(int position, RoundedCorner roundedCorner) {
        this.mRoundedCorners[position] = roundedCorner == null ? new RoundedCorner(position) : roundedCorner;
    }

    public RoundedCorner[] getAllRoundedCorners() {
        RoundedCorner[] roundedCorners = new RoundedCorner[4];
        for (int i = 0; i < 4; ++i) {
            roundedCorners[i] = new RoundedCorner(roundedCorners[i]);
        }
        return roundedCorners;
    }

    public RoundedCorners scale(float scale) {
        if (scale == 1.0f) {
            return this;
        }
        RoundedCorner[] roundedCorners = new RoundedCorner[4];
        for (int i = 0; i < 4; ++i) {
            RoundedCorner roundedCorner = this.mRoundedCorners[i];
            roundedCorners[i] = new RoundedCorner(i, (int)((float)roundedCorner.getRadius() * scale), (int)((float)roundedCorner.getCenter().x * scale), (int)((float)roundedCorner.getCenter().y * scale));
        }
        return new RoundedCorners(roundedCorners);
    }

    public RoundedCorners rotate(int rotation, int initialDisplayWidth, int initialDisplayHeight) {
        if (rotation == 0) {
            return this;
        }
        boolean isSizeFlipped = rotation == 1 || rotation == 3;
        RoundedCorner[] newCorners = new RoundedCorner[4];
        for (int i = 0; i < this.mRoundedCorners.length; ++i) {
            int newPosistion = RoundedCorners.getRotatedIndex(i, rotation);
            newCorners[newPosistion] = RoundedCorners.createRoundedCorner(newPosistion, this.mRoundedCorners[i].getRadius(), isSizeFlipped ? initialDisplayHeight : initialDisplayWidth, isSizeFlipped ? initialDisplayWidth : initialDisplayHeight);
        }
        return new RoundedCorners(newCorners);
    }

    private static RoundedCorner createRoundedCorner(int position, int radius, int displayWidth, int displayHeight) {
        switch (position) {
            case 0: {
                return new RoundedCorner(0, radius, radius > 0 ? radius : 0, radius > 0 ? radius : 0);
            }
            case 1: {
                return new RoundedCorner(1, radius, radius > 0 ? displayWidth - radius : 0, radius > 0 ? radius : 0);
            }
            case 2: {
                return new RoundedCorner(2, radius, radius > 0 ? displayWidth - radius : 0, radius > 0 ? displayHeight - radius : 0);
            }
            case 3: {
                return new RoundedCorner(3, radius, radius > 0 ? radius : 0, radius > 0 ? displayHeight - radius : 0);
            }
        }
        throw new IllegalArgumentException("The position is not one of the RoundedCornerPosition =" + position);
    }

    private static int getRotatedIndex(int position, int rotation) {
        return (position - rotation + 4) % 4;
    }

    public int hashCode() {
        int result = 0;
        for (RoundedCorner roundedCorner : this.mRoundedCorners) {
            result = result * 31 + roundedCorner.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RoundedCorners) {
            RoundedCorners r = (RoundedCorners)o;
            return Arrays.deepEquals(this.mRoundedCorners, r.mRoundedCorners);
        }
        return false;
    }

    public String toString() {
        return "RoundedCorners{" + Arrays.toString(this.mRoundedCorners) + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.equals(NO_ROUNDED_CORNERS)) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeTypedArray(this.mRoundedCorners, flags);
        }
    }

    static {
        CREATOR = new Parcelable.Creator<RoundedCorners>(){

            @Override
            public RoundedCorners createFromParcel(Parcel in) {
                int variant = in.readInt();
                if (variant == 0) {
                    return NO_ROUNDED_CORNERS;
                }
                RoundedCorner[] roundedCorners = new RoundedCorner[4];
                in.readTypedArray(roundedCorners, RoundedCorner.CREATOR);
                return new RoundedCorners(roundedCorners);
            }

            public RoundedCorners[] newArray(int size) {
                return new RoundedCorners[size];
            }
        };
    }
}

