/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.LayoutTransition;
import android.app.ActivityManager;
import android.app.ResourcesManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.BLASTBufferQueue;
import android.graphics.Canvas;
import android.graphics.FrameInfo;
import android.graphics.HardwareRenderer;
import android.graphics.HardwareRendererObserver;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.RenderNode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.hardware.display.DisplayManager;
import android.hardware.input.InputManager;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.sysprop.DisplayProperties;
import android.util.AndroidRuntimeException;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.IndentingPrintWriter;
import android.util.Log;
import android.util.LongArray;
import android.util.MergedConfiguration;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TypedValue;
import android.util.imetracing.ImeTracing;
import android.util.proto.ProtoOutputStream;
import android.view.AccessibilityEmbeddedConnection;
import android.view.AccessibilityInteractionController;
import android.view.ActionMode;
import android.view.AttachedSurfaceControl;
import android.view.Choreographer;
import android.view.ContextMenu;
import android.view.Display;
import android.view.DragEvent;
import android.view.FallbackEventHandler;
import android.view.FocusFinder;
import android.view.GestureExclusionTracker;
import android.view.HandlerActionQueue;
import android.view.IScrollCaptureResponseListener;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.ImeFocusController;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputEventAssigner;
import android.view.InputEventCompatProcessor;
import android.view.InputEventConsistencyVerifier;
import android.view.InputEventReceiver;
import android.view.InputQueue;
import android.view.InsetsController;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.MagnificationSpec;
import android.view.MotionEvent;
import android.view.NativeVectorDrawableAnimator;
import android.view.PendingInsetsController;
import android.view.PointerIcon;
import android.view.ScrollCaptureCallback;
import android.view.ScrollCaptureConnection;
import android.view.ScrollCaptureResponse;
import android.view.ScrollCaptureSearchResults;
import android.view.ScrollCaptureTarget;
import android.view.SoundEffectConstants;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceHolder;
import android.view.SurfaceSession;
import android.view.ThreadedRenderer;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewFrameInfo;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl_Delegate;
import android.view.ViewRootInsetsControllerHost;
import android.view.ViewStructure;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowCallbacks;
import android.view.WindowInsets;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeIdManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.accessibility.IAccessibilityEmbeddedConnection;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.contentcapture.ContentCaptureManager;
import android.view.contentcapture.ContentCaptureSession;
import android.view.contentcapture.MainContentCaptureSession;
import android.view.inputmethod.InputMethodManager;
import android.widget.Scroller;
import android.window.ClientWindowFrames;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.graphics.drawable.BackgroundBlurDrawable;
import com.android.internal.inputmethod.InputMethodDebug;
import com.android.internal.lang.System_Delegate;
import com.android.internal.os.IResultReceiver;
import com.android.internal.os.SomeArgs;
import com.android.internal.policy.DecorView;
import com.android.internal.policy.PhoneFallbackEventHandler;
import com.android.internal.util.Preconditions;
import com.android.internal.view.BaseSurfaceHolder;
import com.android.internal.view.RootViewSurfaceTaker;
import com.android.internal.view.SurfaceCallbackHelper;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;

public class ViewRootImpl
implements ViewParent,
View.AttachInfo.Callbacks,
ThreadedRenderer.DrawCallbacks,
AttachedSurfaceControl {
    private static final String TAG = "ViewRootImpl";
    private static final boolean DBG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final boolean DEBUG_DRAW = false;
    private static final boolean DEBUG_LAYOUT = false;
    private static final boolean DEBUG_DIALOG = false;
    private static final boolean DEBUG_INPUT_RESIZE = false;
    private static final boolean DEBUG_ORIENTATION = false;
    private static final boolean DEBUG_TRACKBALL = false;
    private static final boolean DEBUG_IMF = false;
    private static final boolean DEBUG_CONFIGURATION = false;
    private static final boolean DEBUG_FPS = false;
    private static final boolean DEBUG_INPUT_STAGES = false;
    private static final boolean DEBUG_KEEP_SCREEN_ON = false;
    private static final boolean DEBUG_CONTENT_CAPTURE = false;
    private static final boolean DEBUG_SCROLL_CAPTURE = false;
    private static final boolean DEBUG_BLAST = false;
    private static final boolean MT_RENDERER_AVAILABLE = true;
    private static final boolean ENABLE_INPUT_LATENCY_TRACKING = false;
    private static final String PROPERTY_PROFILE_RENDERING = "viewroot.profile_rendering";
    static final int MAX_TRACKBALL_DELAY = 250;
    private static final int CONTENT_CAPTURE_ENABLED_NOT_CHECKED = 0;
    private static final int CONTENT_CAPTURE_ENABLED_TRUE = 1;
    private static final int CONTENT_CAPTURE_ENABLED_FALSE = 2;
    private static final int SCROLL_CAPTURE_REQUEST_TIMEOUT_MILLIS = 2500;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    static final ThreadLocal<HandlerActionQueue> sRunQueues = new ThreadLocal();
    static final ArrayList<Runnable> sFirstDrawHandlers = new ArrayList();
    static boolean sFirstDrawComplete = false;
    private static final ArrayList<ConfigChangedCallback> sConfigCallbacks = new ArrayList();
    private ActivityConfigCallback mActivityConfigCallback;
    private boolean mForceNextConfigUpdate;
    private boolean mUseBLASTAdapter;
    private boolean mForceDisableBLAST;
    private boolean mFastScrollSoundEffectsEnabled;
    private static boolean sCompatibilityDone = false;
    private static boolean sAlwaysAssignFocus;
    @GuardedBy(value={"mWindowCallbacks"})
    final ArrayList<WindowCallbacks> mWindowCallbacks = new ArrayList();
    @UnsupportedAppUsage
    public final Context mContext;
    @UnsupportedAppUsage
    final IWindowSession mWindowSession;
    Display mDisplay;
    final DisplayManager mDisplayManager;
    final String mBasePackageName;
    final int[] mTmpLocation = new int[2];
    final TypedValue mTmpValue = new TypedValue();
    final Thread mThread;
    final WindowLeaked mLocation;
    public final WindowManager.LayoutParams mWindowAttributes = new WindowManager.LayoutParams();
    final W mWindow;
    final IBinder mLeashToken;
    final int mTargetSdkVersion;
    @UnsupportedAppUsage
    View mView;
    View mAccessibilityFocusedHost;
    AccessibilityNodeInfo mAccessibilityFocusedVirtualView;
    boolean mPointerCapture;
    int mViewVisibility;
    boolean mAppVisible = true;
    private boolean mForceDecorViewVisibility = false;
    private boolean mAppVisibilityChanged;
    int mOrigWindowType = -1;
    boolean mHadWindowFocus;
    boolean mLostWindowFocus;
    @UnsupportedAppUsage
    boolean mStopped = false;
    boolean mIsAmbientMode = false;
    boolean mPausedForTransition = false;
    boolean mLastInCompatMode = false;
    SurfaceHolder.Callback2 mSurfaceHolderCallback;
    BaseSurfaceHolder mSurfaceHolder;
    boolean mIsCreating;
    boolean mDrawingAllowed;
    final Region mTransparentRegion;
    final Region mPreviousTransparentRegion;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    int mWidth;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    int mHeight;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Rect mDirty;
    public boolean mIsAnimating;
    private boolean mUseMTRenderer;
    private boolean mDragResizing;
    private boolean mInvalidateRootRequested;
    private int mResizeMode;
    private int mCanvasOffsetX;
    private int mCanvasOffsetY;
    private boolean mActivityRelaunched;
    CompatibilityInfo.Translator mTranslator;
    @UnsupportedAppUsage
    final View.AttachInfo mAttachInfo;
    final SystemUiVisibilityInfo mCompatibleVisibilityInfo;
    int mDispatchedSystemUiVisibility;
    int mDispatchedSystemBarAppearance;
    InputQueue.Callback mInputQueueCallback;
    InputQueue mInputQueue;
    @UnsupportedAppUsage
    FallbackEventHandler mFallbackEventHandler;
    final Choreographer mChoreographer;
    protected final ViewFrameInfo mViewFrameInfo = new ViewFrameInfo();
    private final InputEventAssigner mInputEventAssigner = new InputEventAssigner();
    private boolean mIsForWebviewOverlay;
    private final Point mSurfaceSize = new Point();
    private final Point mLastSurfaceSize = new Point();
    final Rect mTempRect;
    final Rect mVisRect;
    private final Rect mTempBoundsRect = new Rect();
    @GuardedBy(value={"this"})
    boolean mWindowFocusChanged;
    @GuardedBy(value={"this"})
    boolean mUpcomingWindowFocus;
    @GuardedBy(value={"this"})
    boolean mUpcomingInTouchMode;
    public boolean mTraversalScheduled;
    int mTraversalBarrier;
    boolean mWillDrawSoon;
    boolean mIsInTraversal;
    boolean mApplyInsetsRequested;
    boolean mLayoutRequested;
    boolean mFirst;
    int mContentCaptureEnabled = 0;
    boolean mPerformContentCapture;
    boolean mReportNextDraw;
    boolean mFullRedrawNeeded;
    boolean mNewSurfaceNeeded;
    boolean mForceNextWindowRelayout;
    CountDownLatch mWindowDrawCountDown;
    boolean mIsDrawing;
    int mLastSystemUiVisibility;
    int mClientWindowLayoutFlags;
    private static final int MAX_QUEUED_INPUT_EVENT_POOL_SIZE = 10;
    private QueuedInputEvent mQueuedInputEventPool;
    private int mQueuedInputEventPoolSize;
    QueuedInputEvent mPendingInputEventHead;
    QueuedInputEvent mPendingInputEventTail;
    int mPendingInputEventCount;
    boolean mProcessInputEventsScheduled;
    boolean mUnbufferedInputDispatch;
    int mUnbufferedInputSource = 0;
    String mPendingInputEventQueueLengthCounterName = "pq";
    InputStage mFirstInputStage;
    InputStage mFirstPostImeInputStage;
    InputStage mSyntheticInputStage;
    private final UnhandledKeyManager mUnhandledKeyManager = new UnhandledKeyManager();
    boolean mWindowAttributesChanged = false;
    @UnsupportedAppUsage
    public final Surface mSurface = new Surface();
    private final SurfaceControl mSurfaceControl = new SurfaceControl();
    private BLASTBufferQueue mBlastBufferQueue;
    private final SurfaceControl.Transaction mSurfaceChangedTransaction = new SurfaceControl.Transaction();
    private SurfaceControl mBoundsLayer;
    private final SurfaceSession mSurfaceSession = new SurfaceSession();
    private final SurfaceControl.Transaction mTransaction = new SurfaceControl.Transaction();
    @UnsupportedAppUsage
    boolean mAdded;
    boolean mAddedTouchMode;
    private final ClientWindowFrames mTmpFrames = new ClientWindowFrames();
    final Rect mWinFrame;
    final Rect mPendingBackDropFrame = new Rect();
    private boolean mWillMove;
    private boolean mWillResize;
    boolean mPendingAlwaysConsumeSystemBars;
    private final InsetsState mTempInsets = new InsetsState();
    private final InsetsSourceControl[] mTempControls = new InsetsSourceControl[22];
    final ViewTreeObserver.InternalInsetsInfo mLastGivenInsets = new ViewTreeObserver.InternalInsetsInfo();
    private WindowInsets mLastWindowInsets;
    private int mTypesHiddenByFlags = 0;
    private final Configuration mLastConfigurationFromResources = new Configuration();
    private final MergedConfiguration mLastReportedMergedConfiguration = new MergedConfiguration();
    private final MergedConfiguration mPendingMergedConfiguration = new MergedConfiguration();
    boolean mScrollMayChange;
    int mSoftInputMode;
    @UnsupportedAppUsage
    WeakReference<View> mLastScrolledFocus;
    int mScrollY;
    int mCurScrollY;
    Scroller mScroller;
    static final Interpolator mResizeInterpolator;
    private ArrayList<LayoutTransition> mPendingTransitions;
    final ViewConfiguration mViewConfiguration;
    ClipDescription mDragDescription;
    View mCurrentDragView;
    volatile Object mLocalDragState;
    final PointF mDragPoint = new PointF();
    final PointF mLastTouchPoint = new PointF();
    int mLastTouchSource;
    private boolean mProfileRendering;
    private Choreographer.FrameCallback mRenderProfiler;
    private boolean mRenderProfilingEnabled;
    private long mFpsStartTime = -1L;
    private long mFpsPrevTime = -1L;
    private int mFpsNumFrames;
    private int mPointerIconType = 1;
    private PointerIcon mCustomPointerIcon = null;
    AudioManager mAudioManager;
    final AccessibilityManager mAccessibilityManager;
    AccessibilityInteractionController mAccessibilityInteractionController;
    final AccessibilityInteractionConnectionManager mAccessibilityInteractionConnectionManager = new AccessibilityInteractionConnectionManager();
    final HighContrastTextManager mHighContrastTextManager;
    SendWindowContentChangedAccessibilityEvent mSendWindowContentChangedAccessibilityEvent;
    HashSet<View> mTempHashSet;
    private final int mDensity;
    private final int mNoncompatDensity;
    private boolean mInLayout = false;
    ArrayList<View> mLayoutRequesters = new ArrayList();
    boolean mHandlingLayoutInLayoutRequest = false;
    private int mViewLayoutDirectionInitial;
    private boolean mRemoved;
    private boolean mNeedsRendererSetup;
    private final InputEventCompatProcessor mInputCompatProcessor;
    protected final InputEventConsistencyVerifier mInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
    private final InsetsController mInsetsController;
    private final ImeFocusController mImeFocusController;
    private boolean mIsSurfaceOpaque;
    private final BackgroundBlurDrawable.Aggregator mBlurRegionAggregator = new BackgroundBlurDrawable.Aggregator(this);
    private final GestureExclusionTracker mGestureExclusionTracker = new GestureExclusionTracker();
    private IAccessibilityEmbeddedConnection mAccessibilityEmbeddedConnection;
    private final SurfaceControl.Transaction mRtBLASTSyncTransaction = new SurfaceControl.Transaction();
    private boolean mNextDrawUseBlastSync = false;
    private boolean mWaitForBlastSyncComplete = false;
    private boolean mRequestedTraverseWhilePaused = false;
    private HashSet<ScrollCaptureCallback> mRootScrollCaptureCallbacks;
    private long mScrollCaptureRequestTimeout = 2500L;
    private int mSurfaceSequenceId = 0;
    private String mTag = "ViewRootImpl";
    private boolean mProfile = false;
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayChanged(int displayId) {
            int newDisplayState;
            int oldDisplayState;
            if (ViewRootImpl.this.mView != null && ViewRootImpl.this.mDisplay.getDisplayId() == displayId && (oldDisplayState = ViewRootImpl.this.mAttachInfo.mDisplayState) != (newDisplayState = ViewRootImpl.this.mDisplay.getState())) {
                ViewRootImpl.this.mAttachInfo.mDisplayState = newDisplayState;
                ViewRootImpl.this.pokeDrawLockIfNeeded();
                if (oldDisplayState != 0) {
                    int newScreenState;
                    int oldScreenState = this.toViewScreenState(oldDisplayState);
                    if (oldScreenState != (newScreenState = this.toViewScreenState(newDisplayState))) {
                        ViewRootImpl.this.mView.dispatchScreenStateChanged(newScreenState);
                    }
                    if (oldDisplayState == 1) {
                        ViewRootImpl.this.mFullRedrawNeeded = true;
                        ViewRootImpl.this.scheduleTraversals();
                    }
                }
            }
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        @Override
        public void onDisplayAdded(int displayId) {
        }

        private int toViewScreenState(int displayState) {
            return displayState == 1 ? 0 : 1;
        }
    };
    private final ArrayList<SurfaceChangedCallback> mSurfaceChangedCallbacks = new ArrayList();
    int mHardwareXOffset;
    int mHardwareYOffset;
    int mDrawsNeededToReport = 0;
    private static final int MSG_INVALIDATE = 1;
    private static final int MSG_INVALIDATE_RECT = 2;
    private static final int MSG_DIE = 3;
    private static final int MSG_RESIZED = 4;
    private static final int MSG_RESIZED_REPORT = 5;
    private static final int MSG_WINDOW_FOCUS_CHANGED = 6;
    private static final int MSG_DISPATCH_INPUT_EVENT = 7;
    private static final int MSG_DISPATCH_APP_VISIBILITY = 8;
    private static final int MSG_DISPATCH_GET_NEW_SURFACE = 9;
    private static final int MSG_DISPATCH_KEY_FROM_IME = 11;
    private static final int MSG_DISPATCH_KEY_FROM_AUTOFILL = 12;
    private static final int MSG_CHECK_FOCUS = 13;
    private static final int MSG_CLOSE_SYSTEM_DIALOGS = 14;
    private static final int MSG_DISPATCH_DRAG_EVENT = 15;
    private static final int MSG_DISPATCH_DRAG_LOCATION_EVENT = 16;
    private static final int MSG_DISPATCH_SYSTEM_UI_VISIBILITY = 17;
    private static final int MSG_UPDATE_CONFIGURATION = 18;
    private static final int MSG_PROCESS_INPUT_EVENTS = 19;
    private static final int MSG_CLEAR_ACCESSIBILITY_FOCUS_HOST = 21;
    private static final int MSG_INVALIDATE_WORLD = 22;
    private static final int MSG_WINDOW_MOVED = 23;
    private static final int MSG_SYNTHESIZE_INPUT_EVENT = 24;
    private static final int MSG_DISPATCH_WINDOW_SHOWN = 25;
    private static final int MSG_REQUEST_KEYBOARD_SHORTCUTS = 26;
    private static final int MSG_UPDATE_POINTER_ICON = 27;
    private static final int MSG_POINTER_CAPTURE_CHANGED = 28;
    private static final int MSG_DRAW_FINISHED = 29;
    private static final int MSG_INSETS_CHANGED = 30;
    private static final int MSG_INSETS_CONTROL_CHANGED = 31;
    private static final int MSG_SYSTEM_GESTURE_EXCLUSION_CHANGED = 32;
    private static final int MSG_LOCATION_IN_PARENT_DISPLAY_CHANGED = 33;
    private static final int MSG_SHOW_INSETS = 34;
    private static final int MSG_HIDE_INSETS = 35;
    private static final int MSG_REQUEST_SCROLL_CAPTURE = 36;
    final ViewRootHandler mHandler = new ViewRootHandler();
    final TraversalRunnable mTraversalRunnable = new TraversalRunnable();
    private WindowInputEventReceiver mInputEventReceiver;
    HardwareRendererObserver mHardwareRendererObserver;
    final ConsumeBatchedInputRunnable mConsumedBatchedInputRunnable = new ConsumeBatchedInputRunnable();
    boolean mConsumeBatchedInputScheduled;
    final ConsumeBatchedInputImmediatelyRunnable mConsumeBatchedInputImmediatelyRunnable = new ConsumeBatchedInputImmediatelyRunnable();
    boolean mConsumeBatchedInputImmediatelyScheduled;
    final InvalidateOnAnimationRunnable mInvalidateOnAnimationRunnable = new InvalidateOnAnimationRunnable();

    protected FrameInfo getUpdatedFrameInfo() {
        FrameInfo frameInfo = this.mChoreographer.mFrameInfo;
        this.mViewFrameInfo.populateFrameInfo(frameInfo);
        this.mViewFrameInfo.reset();
        this.mInputEventAssigner.notifyFrameProcessed();
        return frameInfo;
    }

    public ImeFocusController getImeFocusController() {
        return this.mImeFocusController;
    }

    public ViewRootImpl(Context context, Display display) {
        this(context, display, WindowManagerGlobal.getWindowSession(), false);
    }

    public ViewRootImpl(Context context, Display display, IWindowSession session) {
        this(context, display, session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewRootImpl(Context context, Display display, IWindowSession session, boolean useSfChoreographer) {
        this.mContext = context;
        this.mWindowSession = session;
        this.mDisplay = display;
        this.mBasePackageName = context.getBasePackageName();
        this.mThread = Thread.currentThread();
        this.mLocation = new WindowLeaked(null);
        this.mLocation.fillInStackTrace();
        this.mWidth = -1;
        this.mHeight = -1;
        this.mDirty = new Rect();
        this.mTempRect = new Rect();
        this.mVisRect = new Rect();
        this.mWinFrame = new Rect();
        this.mWindow = new W(this);
        this.mLeashToken = new Binder();
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        this.mViewVisibility = 8;
        this.mTransparentRegion = new Region();
        this.mPreviousTransparentRegion = new Region();
        this.mFirst = true;
        this.mPerformContentCapture = true;
        this.mAdded = false;
        this.mAttachInfo = new View.AttachInfo(this.mWindowSession, this.mWindow, display, this, this.mHandler, this, context);
        this.mCompatibleVisibilityInfo = new SystemUiVisibilityInfo();
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
        this.mAccessibilityManager.addAccessibilityStateChangeListener(this.mAccessibilityInteractionConnectionManager, this.mHandler);
        this.mHighContrastTextManager = new HighContrastTextManager();
        this.mAccessibilityManager.addHighTextContrastStateChangeListener(this.mHighContrastTextManager, this.mHandler);
        this.mViewConfiguration = ViewConfiguration.get(context);
        this.mDensity = context.getResources().getDisplayMetrics().densityDpi;
        this.mNoncompatDensity = context.getResources().getDisplayMetrics().noncompatDensityDpi;
        this.mFallbackEventHandler = new PhoneFallbackEventHandler(context);
        this.mChoreographer = useSfChoreographer ? Choreographer.getSfInstance() : Choreographer.getInstance();
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
        this.mInsetsController = new InsetsController(new ViewRootInsetsControllerHost(this));
        String processorOverrideName = context.getResources().getString(17039951);
        if (processorOverrideName.isEmpty()) {
            this.mInputCompatProcessor = new InputEventCompatProcessor(context);
        } else {
            InputEventCompatProcessor compatProcessor = null;
            try {
                Class<?> klass = Class.forName(processorOverrideName);
                compatProcessor = (InputEventCompatProcessor)klass.getConstructor(Context.class).newInstance(context);
            }
            catch (Exception e) {
                Log.e(TAG, "Unable to create the InputEventCompatProcessor. ", e);
            }
            finally {
                this.mInputCompatProcessor = compatProcessor;
            }
        }
        if (!sCompatibilityDone) {
            sAlwaysAssignFocus = this.mTargetSdkVersion < 28;
            sCompatibilityDone = true;
        }
        this.loadSystemProperties();
        this.mImeFocusController = new ImeFocusController(this);
        AudioManager audioManager = this.mContext.getSystemService(AudioManager.class);
        this.mFastScrollSoundEffectsEnabled = audioManager.areNavigationRepeatSoundEffectsEnabled();
        this.mScrollCaptureRequestTimeout = 2500L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFirstDrawHandler(Runnable callback) {
        ArrayList<Runnable> arrayList = sFirstDrawHandlers;
        synchronized (arrayList) {
            if (!sFirstDrawComplete) {
                sFirstDrawHandlers.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void addConfigCallback(ConfigChangedCallback callback) {
        ArrayList<ConfigChangedCallback> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            sConfigCallbacks.add(callback);
        }
    }

    public void setActivityConfigCallback(ActivityConfigCallback callback) {
        this.mActivityConfigCallback = callback;
    }

    public void setOnContentApplyWindowInsetsListener(Window.OnContentApplyWindowInsetsListener listener) {
        this.mAttachInfo.mContentOnApplyWindowInsetsListener = listener;
        if (!this.mFirst) {
            this.requestFitSystemWindows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowCallbacks(WindowCallbacks callback) {
        ArrayList<WindowCallbacks> arrayList = this.mWindowCallbacks;
        synchronized (arrayList) {
            this.mWindowCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowCallbacks(WindowCallbacks callback) {
        ArrayList<WindowCallbacks> arrayList = this.mWindowCallbacks;
        synchronized (arrayList) {
            this.mWindowCallbacks.remove(callback);
        }
    }

    public void reportDrawFinish() {
        if (this.mWindowDrawCountDown != null) {
            this.mWindowDrawCountDown.countDown();
        }
    }

    public void profile() {
        this.mProfile = true;
    }

    static boolean isInTouchMode_Original() {
        IWindowSession windowSession = WindowManagerGlobal.peekWindowSession();
        if (windowSession != null) {
            try {
                return windowSession.getInTouchMode();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    @LayoutlibDelegate
    static boolean isInTouchMode() {
        return ViewRootImpl_Delegate.isInTouchMode();
    }

    public void notifyChildRebuilt() {
        if (this.mView instanceof RootViewSurfaceTaker) {
            if (this.mSurfaceHolderCallback != null) {
                this.mSurfaceHolder.removeCallback(this.mSurfaceHolderCallback);
            }
            this.mSurfaceHolderCallback = ((RootViewSurfaceTaker)((Object)this.mView)).willYouTakeTheSurface();
            if (this.mSurfaceHolderCallback != null) {
                this.mSurfaceHolder = new TakenSurfaceHolder();
                this.mSurfaceHolder.setFormat(0);
                this.mSurfaceHolder.addCallback(this.mSurfaceHolderCallback);
            } else {
                this.mSurfaceHolder = null;
            }
            this.mInputQueueCallback = ((RootViewSurfaceTaker)((Object)this.mView)).willYouTakeTheInputQueue();
            if (this.mInputQueueCallback != null) {
                this.mInputQueueCallback.onInputQueueCreated(this.mInputQueue);
            }
        }
    }

    public static void computeWindowBounds(WindowManager.LayoutParams attrs, InsetsState state, Rect displayFrame, Rect outBounds) {
        int typesToFit = attrs.getFitInsetsTypes();
        int sidesToFit = attrs.getFitInsetsSides();
        ArraySet<Integer> types = InsetsState.toInternalType(typesToFit);
        Rect df = displayFrame;
        Insets insets = Insets.of(0, 0, 0, 0);
        for (int i = types.size() - 1; i >= 0; --i) {
            InsetsSource source = state.peekSource(types.valueAt(i));
            if (source == null) continue;
            insets = Insets.max(insets, source.calculateInsets(df, attrs.isFitInsetsIgnoringVisibility()));
        }
        int left = (sidesToFit & 1) != 0 ? insets.left : 0;
        int top = (sidesToFit & 2) != 0 ? insets.top : 0;
        int right = (sidesToFit & 4) != 0 ? insets.right : 0;
        int bottom = (sidesToFit & 8) != 0 ? insets.bottom : 0;
        outBounds.set(df.left + left, df.top + top, df.right - right, df.bottom - bottom);
    }

    private Configuration getConfiguration() {
        return this.mContext.getResources().getConfiguration();
    }

    public void setView(View view, WindowManager.LayoutParams attrs, View panelParentView) {
        this.setView(view, attrs, panelParentView, UserHandle.myUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setView(View view, WindowManager.LayoutParams attrs, View panelParentView, int userId) {
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            if (this.mView == null) {
                int res;
                PendingInsetsController pendingInsetsController;
                this.mView = view;
                this.mAttachInfo.mDisplayState = this.mDisplay.getState();
                this.mDisplayManager.registerDisplayListener(this.mDisplayListener, this.mHandler);
                this.mViewLayoutDirectionInitial = this.mView.getRawLayoutDirection();
                this.mFallbackEventHandler.setView(view);
                this.mWindowAttributes.copyFrom(attrs);
                if (this.mWindowAttributes.packageName == null) {
                    this.mWindowAttributes.packageName = this.mBasePackageName;
                }
                this.mWindowAttributes.privateFlags |= 0x2000000;
                attrs = this.mWindowAttributes;
                this.setTag();
                this.mClientWindowLayoutFlags = attrs.flags;
                this.setAccessibilityFocus(null, null);
                if (view instanceof RootViewSurfaceTaker) {
                    this.mSurfaceHolderCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheSurface();
                    if (this.mSurfaceHolderCallback != null) {
                        this.mSurfaceHolder = new TakenSurfaceHolder();
                        this.mSurfaceHolder.setFormat(0);
                        this.mSurfaceHolder.addCallback(this.mSurfaceHolderCallback);
                    }
                }
                if (!attrs.hasManualSurfaceInsets) {
                    attrs.setSurfaceInsets(view, false, true);
                }
                CompatibilityInfo compatibilityInfo = this.mDisplay.getDisplayAdjustments().getCompatibilityInfo();
                this.mTranslator = compatibilityInfo.getTranslator();
                if (this.mSurfaceHolder == null) {
                    boolean useMTRenderer;
                    this.enableHardwareAcceleration(attrs);
                    boolean bl = useMTRenderer = this.mAttachInfo.mThreadedRenderer != null;
                    if (this.mUseMTRenderer != useMTRenderer) {
                        this.endDragResizing();
                        this.mUseMTRenderer = useMTRenderer;
                    }
                }
                boolean restore = false;
                if (this.mTranslator != null) {
                    this.mSurface.setCompatibilityTranslator(this.mTranslator);
                    restore = true;
                    attrs.backup();
                    this.mTranslator.translateWindowLayout(attrs);
                }
                if (!compatibilityInfo.supportsScreen()) {
                    attrs.privateFlags |= 0x80;
                    this.mLastInCompatMode = true;
                }
                this.mSoftInputMode = attrs.softInputMode;
                this.mWindowAttributesChanged = true;
                this.mAttachInfo.mRootView = view;
                this.mAttachInfo.mScalingRequired = this.mTranslator != null;
                float f = this.mAttachInfo.mApplicationScale = this.mTranslator == null ? 1.0f : this.mTranslator.applicationScale;
                if (panelParentView != null) {
                    this.mAttachInfo.mPanelParentWindowToken = panelParentView.getApplicationWindowToken();
                }
                this.mAdded = true;
                this.requestLayout();
                InputChannel inputChannel = null;
                if ((this.mWindowAttributes.inputFeatures & 2) == 0) {
                    inputChannel = new InputChannel();
                }
                boolean bl = this.mForceDecorViewVisibility = (this.mWindowAttributes.privateFlags & 0x4000) != 0;
                if (this.mView instanceof RootViewSurfaceTaker && (pendingInsetsController = ((RootViewSurfaceTaker)((Object)this.mView)).providePendingInsetsController()) != null) {
                    pendingInsetsController.replayAndAttach(this.mInsetsController);
                }
                try {
                    this.mOrigWindowType = this.mWindowAttributes.type;
                    this.mAttachInfo.mRecomputeGlobalAttributes = true;
                    this.collectViewAttributes();
                    ViewRootImpl.adjustLayoutParamsForCompatibility(this.mWindowAttributes);
                    this.controlInsetsForCompatibility(this.mWindowAttributes);
                    res = this.mWindowSession.addToDisplayAsUser(this.mWindow, this.mWindowAttributes, this.getHostVisibility(), this.mDisplay.getDisplayId(), userId, this.mInsetsController.getRequestedVisibility(), inputChannel, this.mTempInsets, this.mTempControls);
                    if (this.mTranslator != null) {
                        this.mTranslator.translateInsetsStateInScreenToAppWindow(this.mTempInsets);
                        this.mTranslator.translateSourceControlsInScreenToAppWindow(this.mTempControls);
                    }
                }
                catch (RemoteException e) {
                    this.mAdded = false;
                    this.mView = null;
                    this.mAttachInfo.mRootView = null;
                    this.mFallbackEventHandler.setView(null);
                    this.unscheduleTraversals();
                    this.setAccessibilityFocus(null, null);
                    throw new RuntimeException("Adding window failed", e);
                }
                finally {
                    if (restore) {
                        attrs.restore();
                    }
                }
                this.mPendingAlwaysConsumeSystemBars = this.mAttachInfo.mAlwaysConsumeSystemBars = (res & 4) != 0;
                this.mInsetsController.onStateChanged(this.mTempInsets);
                this.mInsetsController.onControlsChanged(this.mTempControls);
                ViewRootImpl.computeWindowBounds(this.mWindowAttributes, this.mInsetsController.getState(), this.getConfiguration().windowConfiguration.getBounds(), this.mTmpFrames.frame);
                this.setFrame(this.mTmpFrames.frame);
                if (res < 0) {
                    this.mAttachInfo.mRootView = null;
                    this.mAdded = false;
                    this.mFallbackEventHandler.setView(null);
                    this.unscheduleTraversals();
                    this.setAccessibilityFocus(null, null);
                    switch (res) {
                        case -2: 
                        case -1: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + attrs.token + " is not valid; is your activity running?");
                        }
                        case -3: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + attrs.token + " is not for an application");
                        }
                        case -4: {
                            throw new WindowManager.BadTokenException("Unable to add window -- app for token " + attrs.token + " is exiting");
                        }
                        case -5: {
                            throw new WindowManager.BadTokenException("Unable to add window -- window " + this.mWindow + " has already been added");
                        }
                        case -6: {
                            return;
                        }
                        case -7: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- another window of type " + this.mWindowAttributes.type + " already exists");
                        }
                        case -8: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- permission denied for window type " + this.mWindowAttributes.type);
                        }
                        case -9: {
                            throw new WindowManager.InvalidDisplayException("Unable to add window " + this.mWindow + " -- the specified display can not be found");
                        }
                        case -10: {
                            throw new WindowManager.InvalidDisplayException("Unable to add window " + this.mWindow + " -- the specified window type " + this.mWindowAttributes.type + " is not valid");
                        }
                        case -11: {
                            throw new WindowManager.BadTokenException("Unable to add Window " + this.mWindow + " -- requested userId is not valid");
                        }
                    }
                    throw new RuntimeException("Unable to add window -- unknown error code " + res);
                }
                if ((res & 8) != 0) {
                    this.mUseBLASTAdapter = true;
                }
                if (view instanceof RootViewSurfaceTaker) {
                    this.mInputQueueCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheInputQueue();
                }
                if (inputChannel != null) {
                    if (this.mInputQueueCallback != null) {
                        this.mInputQueue = new InputQueue();
                        this.mInputQueueCallback.onInputQueueCreated(this.mInputQueue);
                    }
                    this.mInputEventReceiver = new WindowInputEventReceiver(inputChannel, Looper.myLooper());
                }
                view.assignParent(this);
                this.mAddedTouchMode = (res & 1) != 0;
                boolean bl2 = this.mAppVisible = (res & 2) != 0;
                if (this.mAccessibilityManager.isEnabled()) {
                    this.mAccessibilityInteractionConnectionManager.ensureConnection();
                }
                if (view.getImportantForAccessibility() == 0) {
                    view.setImportantForAccessibility(1);
                }
                CharSequence counterSuffix = attrs.getTitle();
                this.mSyntheticInputStage = new SyntheticInputStage();
                ViewPostImeInputStage viewPostImeStage = new ViewPostImeInputStage(this.mSyntheticInputStage);
                NativePostImeInputStage nativePostImeStage = new NativePostImeInputStage(viewPostImeStage, "aq:native-post-ime:" + counterSuffix);
                EarlyPostImeInputStage earlyPostImeStage = new EarlyPostImeInputStage(nativePostImeStage);
                ImeInputStage imeStage = new ImeInputStage(earlyPostImeStage, "aq:ime:" + counterSuffix);
                ViewPreImeInputStage viewPreImeStage = new ViewPreImeInputStage(imeStage);
                NativePreImeInputStage nativePreImeStage = new NativePreImeInputStage(viewPreImeStage, "aq:native-pre-ime:" + counterSuffix);
                this.mFirstInputStage = nativePreImeStage;
                this.mFirstPostImeInputStage = earlyPostImeStage;
                this.mPendingInputEventQueueLengthCounterName = "aq:pending:" + counterSuffix;
            }
        }
    }

    private void setTag() {
        String[] split = this.mWindowAttributes.getTitle().toString().split("\\.");
        if (split.length > 0) {
            this.mTag = "ViewRootImpl[" + split[split.length - 1] + "]";
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getWindowFlags() {
        return this.mWindowAttributes.flags;
    }

    public int getDisplayId() {
        return this.mDisplay.getDisplayId();
    }

    public CharSequence getTitle() {
        return this.mWindowAttributes.getTitle();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    void destroyHardwareResources() {
        ThreadedRenderer renderer = this.mAttachInfo.mThreadedRenderer;
        if (renderer != null) {
            if (Looper.myLooper() != this.mAttachInfo.mHandler.getLooper()) {
                this.mAttachInfo.mHandler.postAtFrontOfQueue(this::destroyHardwareResources);
                return;
            }
            renderer.destroyHardwareResources(this.mView);
            renderer.destroy();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="Use {@link android.webkit.WebView} instead")
    public void detachFunctor(long functor) {
    }

    @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="Use {@link android.webkit.WebView} instead")
    public static void invokeFunctor(long functor, boolean waitForCompletion) {
    }

    public void registerAnimatingRenderNode(RenderNode animator2) {
        if (this.mAttachInfo.mThreadedRenderer != null) {
            this.mAttachInfo.mThreadedRenderer.registerAnimatingRenderNode(animator2);
        } else {
            if (this.mAttachInfo.mPendingAnimatingRenderNodes == null) {
                this.mAttachInfo.mPendingAnimatingRenderNodes = new ArrayList<RenderNode>();
            }
            this.mAttachInfo.mPendingAnimatingRenderNodes.add(animator2);
        }
    }

    public void registerVectorDrawableAnimator(NativeVectorDrawableAnimator animator2) {
        if (this.mAttachInfo.mThreadedRenderer != null) {
            this.mAttachInfo.mThreadedRenderer.registerVectorDrawableAnimator(animator2);
        }
    }

    public void registerRtFrameCallback(HardwareRenderer.FrameDrawingCallback callback) {
        if (this.mAttachInfo.mThreadedRenderer != null) {
            this.mAttachInfo.mThreadedRenderer.registerRtFrameCallback(frame -> {
                try {
                    callback.onFrameDraw(frame);
                }
                catch (Exception e) {
                    Log.e(TAG, "Exception while executing onFrameDraw", e);
                }
            });
        }
    }

    private void addASurfaceTransactionCallback() {
        HardwareRenderer.ASurfaceTransactionCallback callback = (nativeTransactionObj, nativeSurfaceControlObj, frameNr) -> {
            if (this.mBlastBufferQueue == null) {
                return false;
            }
            this.mBlastBufferQueue.mergeWithNextTransaction(nativeTransactionObj, frameNr);
            return true;
        };
        this.mAttachInfo.mThreadedRenderer.setASurfaceTransactionCallback(callback);
    }

    private void addPrepareSurfaceControlForWebviewCallback() {
        HardwareRenderer.PrepareSurfaceControlForWebviewCallback callback = () -> {
            if (this.mIsForWebviewOverlay) {
                return;
            }
            ViewRootImpl viewRootImpl = this;
            synchronized (viewRootImpl) {
                this.mIsForWebviewOverlay = true;
            }
            this.mTransaction.setOpaque(this.mSurfaceControl, false).apply();
        };
        this.mAttachInfo.mThreadedRenderer.setPrepareSurfaceControlForWebviewCallback(callback);
    }

    @UnsupportedAppUsage
    private void enableHardwareAcceleration(WindowManager.LayoutParams attrs) {
        boolean hardwareAccelerated;
        this.mAttachInfo.mHardwareAccelerated = false;
        this.mAttachInfo.mHardwareAccelerationRequested = false;
        if (this.mTranslator != null) {
            return;
        }
        boolean bl = hardwareAccelerated = (attrs.flags & 0x1000000) != 0;
        if (hardwareAccelerated) {
            boolean forceHwAccelerated;
            boolean bl2 = forceHwAccelerated = (attrs.privateFlags & 2) != 0;
            if (ThreadedRenderer.sRendererEnabled || forceHwAccelerated) {
                if (this.mAttachInfo.mThreadedRenderer != null) {
                    this.mAttachInfo.mThreadedRenderer.destroy();
                }
                Rect insets = attrs.surfaceInsets;
                boolean hasSurfaceInsets = insets.left != 0 || insets.right != 0 || insets.top != 0 || insets.bottom != 0;
                boolean translucent = attrs.format != -1 || hasSurfaceInsets;
                this.mAttachInfo.mThreadedRenderer = ThreadedRenderer.create(this.mContext, translucent, attrs.getTitle().toString());
                this.updateColorModeIfNeeded(attrs.getColorMode());
                this.updateForceDarkMode();
                if (this.mAttachInfo.mThreadedRenderer != null) {
                    this.mAttachInfo.mHardwareAccelerationRequested = true;
                    this.mAttachInfo.mHardwareAccelerated = true;
                    if (this.mHardwareRendererObserver != null) {
                        this.mAttachInfo.mThreadedRenderer.addObserver(this.mHardwareRendererObserver);
                    }
                    if (HardwareRenderer.isWebViewOverlaysEnabled()) {
                        this.addPrepareSurfaceControlForWebviewCallback();
                        this.addASurfaceTransactionCallback();
                    }
                    this.mAttachInfo.mThreadedRenderer.setSurfaceControl(this.mSurfaceControl);
                }
            }
        }
    }

    private int getNightMode() {
        return this.getConfiguration().uiMode & 0x30;
    }

    private void updateForceDarkMode() {
        boolean useAutoDark;
        if (this.mAttachInfo.mThreadedRenderer == null) {
            return;
        }
        boolean bl = useAutoDark = this.getNightMode() == 32;
        if (useAutoDark) {
            boolean forceDarkAllowedDefault = SystemProperties.getBoolean("debug.hwui.force_dark", false);
            TypedArray a = this.mContext.obtainStyledAttributes(R.styleable.Theme);
            useAutoDark = a.getBoolean(279, true) && a.getBoolean(278, forceDarkAllowedDefault);
            a.recycle();
        }
        if (this.mAttachInfo.mThreadedRenderer.setForceDark(useAutoDark)) {
            this.invalidateWorld(this.mView);
        }
    }

    @UnsupportedAppUsage
    public View getView() {
        return this.mView;
    }

    WindowLeaked getLocation() {
        return this.mLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void setLayoutParams(WindowManager.LayoutParams attrs, boolean newView) {
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            int oldInsetLeft = this.mWindowAttributes.surfaceInsets.left;
            int oldInsetTop = this.mWindowAttributes.surfaceInsets.top;
            int oldInsetRight = this.mWindowAttributes.surfaceInsets.right;
            int oldInsetBottom = this.mWindowAttributes.surfaceInsets.bottom;
            int oldSoftInputMode = this.mWindowAttributes.softInputMode;
            boolean oldHasManualSurfaceInsets = this.mWindowAttributes.hasManualSurfaceInsets;
            this.mClientWindowLayoutFlags = attrs.flags;
            int compatibleWindowFlag = this.mWindowAttributes.privateFlags & 0x80;
            int systemUiVisibility = this.mWindowAttributes.systemUiVisibility;
            int subtreeSystemUiVisibility = this.mWindowAttributes.subtreeSystemUiVisibility;
            int appearance = this.mWindowAttributes.insetsFlags.appearance;
            int behavior = this.mWindowAttributes.insetsFlags.behavior;
            int appearanceAndBehaviorPrivateFlags = this.mWindowAttributes.privateFlags & 0xC000000;
            int changes = this.mWindowAttributes.copyFrom(attrs);
            if ((changes & 0x80000) != 0) {
                this.mAttachInfo.mRecomputeGlobalAttributes = true;
            }
            if ((changes & 1) != 0) {
                this.mAttachInfo.mNeedsUpdateLightCenter = true;
            }
            if (this.mWindowAttributes.packageName == null) {
                this.mWindowAttributes.packageName = this.mBasePackageName;
            }
            this.mWindowAttributes.systemUiVisibility = systemUiVisibility;
            this.mWindowAttributes.subtreeSystemUiVisibility = subtreeSystemUiVisibility;
            this.mWindowAttributes.insetsFlags.appearance = appearance;
            this.mWindowAttributes.insetsFlags.behavior = behavior;
            this.mWindowAttributes.privateFlags |= compatibleWindowFlag | appearanceAndBehaviorPrivateFlags | 0x2000000;
            if (this.mWindowAttributes.preservePreviousSurfaceInsets) {
                this.mWindowAttributes.surfaceInsets.set(oldInsetLeft, oldInsetTop, oldInsetRight, oldInsetBottom);
                this.mWindowAttributes.hasManualSurfaceInsets = oldHasManualSurfaceInsets;
            } else if (this.mWindowAttributes.surfaceInsets.left != oldInsetLeft || this.mWindowAttributes.surfaceInsets.top != oldInsetTop || this.mWindowAttributes.surfaceInsets.right != oldInsetRight || this.mWindowAttributes.surfaceInsets.bottom != oldInsetBottom) {
                this.mNeedsRendererSetup = true;
            }
            this.applyKeepScreenOnFlag(this.mWindowAttributes);
            if (newView) {
                this.mSoftInputMode = attrs.softInputMode;
                this.requestLayout();
            }
            if ((attrs.softInputMode & 0xF0) == 0) {
                this.mWindowAttributes.softInputMode = this.mWindowAttributes.softInputMode & 0xFFFFFF0F | oldSoftInputMode & 0xF0;
            }
            if (this.mWindowAttributes.softInputMode != oldSoftInputMode) {
                this.requestFitSystemWindows();
            }
            this.mWindowAttributesChanged = true;
            this.scheduleTraversals();
        }
    }

    void handleAppVisibility(boolean visible) {
        if (this.mAppVisible != visible) {
            this.mAppVisible = visible;
            this.mAppVisibilityChanged = true;
            this.scheduleTraversals();
            if (!this.mAppVisible) {
                WindowManagerGlobal.trimForeground();
            }
        }
    }

    void handleGetNewSurface() {
        this.mNewSurfaceNeeded = true;
        this.mFullRedrawNeeded = true;
        this.scheduleTraversals();
    }

    private void handleResized(int msg, SomeArgs args) {
        boolean displayChanged;
        if (!this.mAdded) {
            return;
        }
        ClientWindowFrames frames = (ClientWindowFrames)args.arg1;
        MergedConfiguration mergedConfiguration = (MergedConfiguration)args.arg2;
        boolean forceNextWindowRelayout = args.argi1 != 0;
        int displayId = args.argi3;
        Rect backdropFrame = frames.backdropFrame;
        boolean frameChanged = !this.mWinFrame.equals(frames.frame);
        boolean backdropFrameChanged = !this.mPendingBackDropFrame.equals(backdropFrame);
        boolean configChanged = !this.mLastReportedMergedConfiguration.equals(mergedConfiguration);
        boolean bl = displayChanged = this.mDisplay.getDisplayId() != displayId;
        if (!(msg != 4 || frameChanged || backdropFrameChanged || configChanged || displayChanged || forceNextWindowRelayout)) {
            return;
        }
        if (configChanged) {
            this.performConfigurationChange(mergedConfiguration, false, displayChanged ? displayId : -1);
        } else if (displayChanged) {
            this.onMovedToDisplay(displayId, this.mLastConfigurationFromResources);
        }
        this.setFrame(frames.frame);
        this.mTmpFrames.displayFrame.set(frames.displayFrame);
        this.mPendingBackDropFrame.set(backdropFrame);
        this.mForceNextWindowRelayout = forceNextWindowRelayout;
        boolean bl2 = this.mPendingAlwaysConsumeSystemBars = args.argi2 != 0;
        if (msg == 5 && !this.mNextDrawUseBlastSync) {
            this.reportNextDraw();
        }
        if (this.mView != null && (frameChanged || configChanged)) {
            ViewRootImpl.forceLayout(this.mView);
        }
        this.requestLayout();
    }

    public void onMovedToDisplay(int displayId, Configuration config) {
        if (this.mDisplay.getDisplayId() == displayId) {
            return;
        }
        this.updateInternalDisplay(displayId, this.mView.getResources());
        this.mImeFocusController.onMovedToDisplay();
        this.mAttachInfo.mDisplayState = this.mDisplay.getState();
        this.mView.dispatchMovedToDisplay(this.mDisplay, config);
    }

    private void updateInternalDisplay(int displayId, Resources resources) {
        Display preferredDisplay = ResourcesManager.getInstance().getAdjustedDisplay(displayId, resources);
        if (preferredDisplay == null) {
            Slog.w(TAG, "Cannot get desired display with Id: " + displayId);
            this.mDisplay = ResourcesManager.getInstance().getAdjustedDisplay(0, resources);
        } else {
            this.mDisplay = preferredDisplay;
        }
        this.mContext.updateDisplay(this.mDisplay.getDisplayId());
    }

    void pokeDrawLockIfNeeded() {
        int displayState = this.mAttachInfo.mDisplayState;
        if (this.mView != null && this.mAdded && this.mTraversalScheduled && (displayState == 3 || displayState == 4)) {
            try {
                this.mWindowSession.pokeDrawLock(this.mWindow);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void requestFitSystemWindows() {
        this.checkThread();
        this.mApplyInsetsRequested = true;
        this.scheduleTraversals();
    }

    void notifyInsetsChanged() {
        this.mApplyInsetsRequested = true;
        if (this.mWillMove || this.mWillResize) {
            return;
        }
        this.requestLayout();
        if (View.sForceLayoutWhenInsetsChanged && this.mView != null && (this.mWindowAttributes.softInputMode & 0xF0) == 16) {
            ViewRootImpl.forceLayout(this.mView);
        }
        if (!this.mIsInTraversal) {
            this.scheduleTraversals();
        }
    }

    @Override
    public void requestLayout() {
        if (!this.mHandlingLayoutInLayoutRequest) {
            this.checkThread();
            this.mLayoutRequested = true;
            this.scheduleTraversals();
        }
    }

    @Override
    public boolean isLayoutRequested() {
        return this.mLayoutRequested;
    }

    @Override
    public void onDescendantInvalidated(View child, View descendant) {
        if ((descendant.mPrivateFlags & 0x40) != 0) {
            this.mIsAnimating = true;
        }
        this.invalidate();
    }

    @UnsupportedAppUsage
    void invalidate() {
        this.mDirty.set(0, 0, this.mWidth, this.mHeight);
        if (!this.mWillDrawSoon) {
            this.scheduleTraversals();
        }
    }

    void invalidateWorld(View view) {
        view.invalidate();
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                this.invalidateWorld(parent.getChildAt(i));
            }
        }
    }

    @Override
    public void invalidateChild(View child, Rect dirty) {
        this.invalidateChildInParent(null, dirty);
    }

    @Override
    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        this.checkThread();
        if (dirty == null) {
            this.invalidate();
            return null;
        }
        if (dirty.isEmpty() && !this.mIsAnimating) {
            return null;
        }
        if (this.mCurScrollY != 0 || this.mTranslator != null) {
            this.mTempRect.set(dirty);
            dirty = this.mTempRect;
            if (this.mCurScrollY != 0) {
                dirty.offset(0, -this.mCurScrollY);
            }
            if (this.mTranslator != null) {
                this.mTranslator.translateRectInAppWindowToScreen(dirty);
            }
            if (this.mAttachInfo.mScalingRequired) {
                dirty.inset(-1, -1);
            }
        }
        this.invalidateRectOnScreen(dirty);
        return null;
    }

    private void invalidateRectOnScreen(Rect dirty) {
        Rect localDirty = this.mDirty;
        localDirty.union(dirty.left, dirty.top, dirty.right, dirty.bottom);
        float appScale = this.mAttachInfo.mApplicationScale;
        boolean intersected = localDirty.intersect(0, 0, (int)((float)this.mWidth * appScale + 0.5f), (int)((float)this.mHeight * appScale + 0.5f));
        if (!intersected) {
            localDirty.setEmpty();
        }
        if (!this.mWillDrawSoon && (intersected || this.mIsAnimating)) {
            this.scheduleTraversals();
        }
    }

    public void setIsAmbientMode(boolean ambient) {
        this.mIsAmbientMode = ambient;
    }

    void setWindowStopped(boolean stopped) {
        this.checkThread();
        if (this.mStopped != stopped) {
            this.mStopped = stopped;
            ThreadedRenderer renderer = this.mAttachInfo.mThreadedRenderer;
            if (renderer != null) {
                renderer.setStopped(this.mStopped);
            }
            if (!this.mStopped) {
                this.mNewSurfaceNeeded = true;
                this.scheduleTraversals();
            } else {
                if (renderer != null) {
                    renderer.destroyHardwareResources(this.mView);
                }
                if (this.mSurface.isValid()) {
                    if (this.mSurfaceHolder != null) {
                        this.notifyHolderSurfaceDestroyed();
                    }
                    this.notifySurfaceDestroyed();
                }
                this.destroySurface();
            }
        }
    }

    public void addSurfaceChangedCallback(SurfaceChangedCallback c) {
        this.mSurfaceChangedCallbacks.add(c);
    }

    public void removeSurfaceChangedCallback(SurfaceChangedCallback c) {
        this.mSurfaceChangedCallbacks.remove(c);
    }

    private void notifySurfaceCreated() {
        for (int i = 0; i < this.mSurfaceChangedCallbacks.size(); ++i) {
            this.mSurfaceChangedCallbacks.get(i).surfaceCreated(this.mSurfaceChangedTransaction);
        }
    }

    private void notifySurfaceReplaced() {
        for (int i = 0; i < this.mSurfaceChangedCallbacks.size(); ++i) {
            this.mSurfaceChangedCallbacks.get(i).surfaceReplaced(this.mSurfaceChangedTransaction);
        }
    }

    private void notifySurfaceDestroyed() {
        for (int i = 0; i < this.mSurfaceChangedCallbacks.size(); ++i) {
            this.mSurfaceChangedCallbacks.get(i).surfaceDestroyed();
        }
    }

    public SurfaceControl getBoundsLayer() {
        if (this.mBoundsLayer == null) {
            this.mBoundsLayer = new SurfaceControl.Builder(this.mSurfaceSession).setContainerLayer().setName("Bounds for - " + this.getTitle().toString()).setParent(this.getSurfaceControl()).setCallsite("ViewRootImpl.getBoundsLayer").build();
            this.setBoundsLayerCrop(this.mTransaction);
            this.mTransaction.show(this.mBoundsLayer).apply();
        }
        return this.mBoundsLayer;
    }

    Surface getOrCreateBLASTSurface() {
        if (!this.mSurfaceControl.isValid()) {
            return null;
        }
        Surface ret = null;
        if (this.mBlastBufferQueue == null) {
            this.mBlastBufferQueue = new BLASTBufferQueue(this.mTag, this.mSurfaceControl, this.mSurfaceSize.x, this.mSurfaceSize.y, this.mWindowAttributes.format);
            ret = this.mBlastBufferQueue.createSurface();
        } else {
            this.mBlastBufferQueue.update(this.mSurfaceControl, this.mSurfaceSize.x, this.mSurfaceSize.y, this.mWindowAttributes.format);
        }
        return ret;
    }

    private void setBoundsLayerCrop(SurfaceControl.Transaction t) {
        this.mTempBoundsRect.set(0, 0, this.mSurfaceSize.x, this.mSurfaceSize.y);
        this.mTempBoundsRect.inset(this.mWindowAttributes.surfaceInsets.left, this.mWindowAttributes.surfaceInsets.top, this.mWindowAttributes.surfaceInsets.right, this.mWindowAttributes.surfaceInsets.bottom);
        t.setWindowCrop(this.mBoundsLayer, this.mTempBoundsRect);
    }

    private boolean updateBoundsLayer(SurfaceControl.Transaction t) {
        if (this.mBoundsLayer != null) {
            this.setBoundsLayerCrop(t);
            return true;
        }
        return false;
    }

    private void prepareSurfaces() {
        SurfaceControl.Transaction t = this.mTransaction;
        SurfaceControl sc = this.getSurfaceControl();
        if (!sc.isValid()) {
            return;
        }
        if (this.updateBoundsLayer(t)) {
            this.mergeWithNextTransaction(t, this.mSurface.getNextFrameNumber());
        }
    }

    private void destroySurface() {
        if (this.mBoundsLayer != null) {
            this.mBoundsLayer.release();
            this.mBoundsLayer = null;
        }
        this.mSurface.release();
        this.mSurfaceControl.release();
        if (this.mBlastBufferQueue != null) {
            this.mBlastBufferQueue.destroy();
            this.mBlastBufferQueue = null;
        }
        if (this.mAttachInfo.mThreadedRenderer != null) {
            this.mAttachInfo.mThreadedRenderer.setSurfaceControl(null);
        }
    }

    public void setPausedForTransition(boolean paused) {
        this.mPausedForTransition = paused;
    }

    @Override
    public ViewParent getParent() {
        return null;
    }

    @Override
    public boolean getChildVisibleRect(View child, Rect r, Point offset) {
        if (child != this.mView) {
            throw new RuntimeException("child is not mine, honest!");
        }
        return r.intersect(0, 0, this.mWidth, this.mHeight);
    }

    @Override
    public void bringChildToFront(View child) {
    }

    int getHostVisibility() {
        return this.mAppVisible || this.mForceDecorViewVisibility ? this.mView.getVisibility() : 8;
    }

    public void requestTransitionStart(LayoutTransition transition2) {
        if (this.mPendingTransitions == null || !this.mPendingTransitions.contains(transition2)) {
            if (this.mPendingTransitions == null) {
                this.mPendingTransitions = new ArrayList();
            }
            this.mPendingTransitions.add(transition2);
        }
    }

    void notifyRendererOfFramePending() {
        if (this.mAttachInfo.mThreadedRenderer != null) {
            this.mAttachInfo.mThreadedRenderer.notifyFramePending();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void scheduleTraversals() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.mTraversalBarrier = this.mHandler.getLooper().getQueue().postSyncBarrier();
            this.mChoreographer.postCallback(3, this.mTraversalRunnable, null);
            this.notifyRendererOfFramePending();
            this.pokeDrawLockIfNeeded();
        }
    }

    void unscheduleTraversals() {
        if (this.mTraversalScheduled) {
            this.mTraversalScheduled = false;
            this.mHandler.getLooper().getQueue().removeSyncBarrier(this.mTraversalBarrier);
            this.mChoreographer.removeCallbacks(3, this.mTraversalRunnable, null);
        }
    }

    void doTraversal() {
        if (this.mTraversalScheduled) {
            this.mTraversalScheduled = false;
            this.mHandler.getLooper().getQueue().removeSyncBarrier(this.mTraversalBarrier);
            if (this.mProfile) {
                Debug.startMethodTracing("ViewAncestor");
            }
            this.performTraversals();
            if (this.mProfile) {
                Debug.stopMethodTracing();
                this.mProfile = false;
            }
        }
    }

    private void applyKeepScreenOnFlag(WindowManager.LayoutParams params) {
        params.flags = this.mAttachInfo.mKeepScreenOn ? (params.flags |= 0x80) : params.flags & 0xFFFFFF7F | this.mClientWindowLayoutFlags & 0x80;
    }

    private boolean collectViewAttributes() {
        if (this.mAttachInfo.mRecomputeGlobalAttributes) {
            this.mAttachInfo.mRecomputeGlobalAttributes = false;
            boolean oldScreenOn = this.mAttachInfo.mKeepScreenOn;
            this.mAttachInfo.mKeepScreenOn = false;
            this.mAttachInfo.mSystemUiVisibility = 0;
            this.mAttachInfo.mHasSystemUiListeners = false;
            this.mView.dispatchCollectViewAttributes(this.mAttachInfo, 0);
            this.mAttachInfo.mSystemUiVisibility &= ~this.mAttachInfo.mDisabledSystemUiVisibility;
            WindowManager.LayoutParams params = this.mWindowAttributes;
            this.mAttachInfo.mSystemUiVisibility |= this.getImpliedSystemUiVisibility(params);
            this.mCompatibleVisibilityInfo.globalVisibility = this.mCompatibleVisibilityInfo.globalVisibility & 0xFFFFFFFE | this.mAttachInfo.mSystemUiVisibility & 1;
            this.dispatchDispatchSystemUiVisibilityChanged(this.mCompatibleVisibilityInfo);
            if (this.mAttachInfo.mKeepScreenOn != oldScreenOn || this.mAttachInfo.mSystemUiVisibility != params.subtreeSystemUiVisibility || this.mAttachInfo.mHasSystemUiListeners != params.hasSystemUiListeners) {
                this.applyKeepScreenOnFlag(params);
                params.subtreeSystemUiVisibility = this.mAttachInfo.mSystemUiVisibility;
                params.hasSystemUiListeners = this.mAttachInfo.mHasSystemUiListeners;
                this.mView.dispatchWindowSystemUiVisiblityChanged(this.mAttachInfo.mSystemUiVisibility);
                return true;
            }
        }
        return false;
    }

    private int getImpliedSystemUiVisibility(WindowManager.LayoutParams params) {
        int vis = 0;
        if ((params.flags & 0x4000000) != 0) {
            vis |= 0x500;
        }
        if ((params.flags & 0x8000000) != 0) {
            vis |= 0x300;
        }
        return vis;
    }

    void updateCompatSysUiVisibility(int type, boolean visible, boolean hasControl) {
        boolean wasVisible;
        if (type != 0 && type != 1) {
            return;
        }
        SystemUiVisibilityInfo info = this.mCompatibleVisibilityInfo;
        int systemUiFlag = type == 0 ? 4 : 2;
        boolean bl = wasVisible = (info.globalVisibility & systemUiFlag) == 0;
        if (visible) {
            info.globalVisibility &= ~systemUiFlag;
            if (!wasVisible && hasControl) {
                info.localChanges |= systemUiFlag;
            }
        } else {
            info.globalVisibility |= systemUiFlag;
            info.localChanges &= ~systemUiFlag;
        }
        this.dispatchDispatchSystemUiVisibilityChanged(info);
    }

    private void clearLowProfileModeIfNeeded(int showTypes, boolean fromIme) {
        SystemUiVisibilityInfo info = this.mCompatibleVisibilityInfo;
        if ((showTypes & WindowInsets.Type.systemBars()) != 0 && !fromIme && (info.globalVisibility & 1) != 0) {
            info.globalVisibility &= 0xFFFFFFFE;
            info.localChanges |= 1;
            this.dispatchDispatchSystemUiVisibilityChanged(info);
        }
    }

    private void dispatchDispatchSystemUiVisibilityChanged(SystemUiVisibilityInfo args) {
        if (this.mDispatchedSystemUiVisibility != args.globalVisibility) {
            this.mHandler.removeMessages(17);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(17, args));
        }
    }

    private void handleDispatchSystemUiVisibilityChanged(SystemUiVisibilityInfo args) {
        int visibility;
        if (this.mView == null) {
            return;
        }
        if (args.localChanges != 0) {
            this.mView.updateLocalSystemUiVisibility(args.localValue, args.localChanges);
            args.localChanges = 0;
        }
        if (this.mDispatchedSystemUiVisibility != (visibility = args.globalVisibility & 7)) {
            this.mDispatchedSystemUiVisibility = visibility;
            this.mView.dispatchSystemUiVisibilityChanged(visibility);
        }
    }

    @VisibleForTesting
    public static void adjustLayoutParamsForCompatibility(WindowManager.LayoutParams inOutParams) {
        int sysUiVis = inOutParams.systemUiVisibility | inOutParams.subtreeSystemUiVisibility;
        int flags = inOutParams.flags;
        int type = inOutParams.type;
        int adjust = inOutParams.softInputMode & 0xF0;
        if ((inOutParams.privateFlags & 0x4000000) == 0) {
            inOutParams.insetsFlags.appearance = 0;
            if ((sysUiVis & 1) != 0) {
                inOutParams.insetsFlags.appearance |= 4;
            }
            if ((sysUiVis & 0x2000) != 0) {
                inOutParams.insetsFlags.appearance |= 8;
            }
            if ((sysUiVis & 0x10) != 0) {
                inOutParams.insetsFlags.appearance |= 0x10;
            }
        }
        if ((inOutParams.privateFlags & 0x8000000) == 0) {
            inOutParams.insetsFlags.behavior = (sysUiVis & 0x1000) != 0 || (flags & 0x400) != 0 ? 2 : 1;
        }
        inOutParams.privateFlags &= 0xBFFFFFFF;
        if ((inOutParams.privateFlags & 0x10000000) != 0) {
            return;
        }
        int types = inOutParams.getFitInsetsTypes();
        boolean ignoreVis = inOutParams.isFitInsetsIgnoringVisibility();
        if ((sysUiVis & 0x400) != 0 || (flags & 0x100) != 0 || (flags & 0x4000000) != 0) {
            types &= ~WindowInsets.Type.statusBars();
        }
        if ((sysUiVis & 0x200) != 0 || (flags & 0x8000000) != 0) {
            types &= ~WindowInsets.Type.systemBars();
        }
        if (type == 2005 || type == 2003) {
            ignoreVis = true;
        } else if ((types & WindowInsets.Type.systemBars()) == WindowInsets.Type.systemBars()) {
            if (adjust == 16) {
                types |= WindowInsets.Type.ime();
            } else {
                inOutParams.privateFlags |= 0x40000000;
            }
        }
        inOutParams.setFitInsetsTypes(types);
        inOutParams.setFitInsetsIgnoringVisibility(ignoreVis);
        inOutParams.privateFlags &= 0xEFFFFFFF;
    }

    private void controlInsetsForCompatibility(WindowManager.LayoutParams params) {
        int sysUiVis = params.systemUiVisibility | params.subtreeSystemUiVisibility;
        int flags = params.flags;
        boolean matchParent = params.width == -1 && params.height == -1;
        boolean nonAttachedAppWindow = params.type >= 1 && params.type <= 99;
        boolean statusWasHiddenByFlags = (this.mTypesHiddenByFlags & WindowInsets.Type.statusBars()) != 0;
        boolean statusIsHiddenByFlags = (sysUiVis & 4) != 0 || (flags & 0x400) != 0 && matchParent && nonAttachedAppWindow;
        boolean navWasHiddenByFlags = (this.mTypesHiddenByFlags & WindowInsets.Type.navigationBars()) != 0;
        boolean navIsHiddenByFlags = (sysUiVis & 2) != 0;
        int typesToHide = 0;
        int typesToShow = 0;
        if (statusIsHiddenByFlags && !statusWasHiddenByFlags) {
            typesToHide |= WindowInsets.Type.statusBars();
        } else if (!statusIsHiddenByFlags && statusWasHiddenByFlags) {
            typesToShow |= WindowInsets.Type.statusBars();
        }
        if (navIsHiddenByFlags && !navWasHiddenByFlags) {
            typesToHide |= WindowInsets.Type.navigationBars();
        } else if (!navIsHiddenByFlags && navWasHiddenByFlags) {
            typesToShow |= WindowInsets.Type.navigationBars();
        }
        if (typesToHide != 0) {
            this.getInsetsController().hide(typesToHide);
        }
        if (typesToShow != 0) {
            this.getInsetsController().show(typesToShow);
        }
        this.mTypesHiddenByFlags |= typesToHide;
        this.mTypesHiddenByFlags &= ~typesToShow;
    }

    private boolean measureHierarchy(View host, WindowManager.LayoutParams lp, Resources res, int desiredWindowWidth, int desiredWindowHeight) {
        int childHeightMeasureSpec;
        int childWidthMeasureSpec;
        boolean windowSizeMayChange = false;
        boolean goodMeasure = false;
        if (lp.width == -2) {
            DisplayMetrics packageMetrics = res.getDisplayMetrics();
            res.getValue(17105092, this.mTmpValue, true);
            int baseSize = 0;
            if (this.mTmpValue.type == 5) {
                baseSize = (int)this.mTmpValue.getDimension(packageMetrics);
            }
            if (baseSize != 0 && desiredWindowWidth > baseSize) {
                childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(baseSize, lp.width);
                childHeightMeasureSpec = ViewRootImpl.getRootMeasureSpec(desiredWindowHeight, lp.height);
                this.performMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
                if ((host.getMeasuredWidthAndState() & 0x1000000) == 0) {
                    goodMeasure = true;
                } else {
                    baseSize = (baseSize + desiredWindowWidth) / 2;
                    childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(baseSize, lp.width);
                    this.performMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
                    if ((host.getMeasuredWidthAndState() & 0x1000000) == 0) {
                        goodMeasure = true;
                    }
                }
            }
        }
        if (!goodMeasure) {
            childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(desiredWindowWidth, lp.width);
            childHeightMeasureSpec = ViewRootImpl.getRootMeasureSpec(desiredWindowHeight, lp.height);
            this.performMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
            if (this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight()) {
                windowSizeMayChange = true;
            }
        }
        return windowSizeMayChange;
    }

    void transformMatrixToGlobal(Matrix m) {
        m.preTranslate(this.mAttachInfo.mWindowLeft, this.mAttachInfo.mWindowTop);
    }

    void transformMatrixToLocal(Matrix m) {
        m.postTranslate(-this.mAttachInfo.mWindowLeft, -this.mAttachInfo.mWindowTop);
    }

    WindowInsets getWindowInsets(boolean forceConstruct) {
        if (this.mLastWindowInsets == null || forceConstruct) {
            Configuration config = this.getConfiguration();
            this.mLastWindowInsets = this.mInsetsController.calculateInsets(config.isScreenRound(), this.mAttachInfo.mAlwaysConsumeSystemBars, this.mWindowAttributes.type, config.windowConfiguration.getWindowingMode(), this.mWindowAttributes.softInputMode, this.mWindowAttributes.flags, this.mWindowAttributes.systemUiVisibility | this.mWindowAttributes.subtreeSystemUiVisibility);
            this.mAttachInfo.mContentInsets.set(this.mLastWindowInsets.getSystemWindowInsets().toRect());
            this.mAttachInfo.mStableInsets.set(this.mLastWindowInsets.getStableInsets().toRect());
            this.mAttachInfo.mVisibleInsets.set(this.mInsetsController.calculateVisibleInsets(this.mWindowAttributes.softInputMode));
        }
        return this.mLastWindowInsets;
    }

    public void dispatchApplyInsets(View host) {
        Trace.traceBegin(8L, "dispatchApplyInsets");
        this.mApplyInsetsRequested = false;
        WindowInsets insets = this.getWindowInsets(true);
        if (!this.shouldDispatchCutout()) {
            insets = insets.consumeDisplayCutout();
        }
        host.dispatchApplyWindowInsets(insets);
        this.mAttachInfo.delayNotifyContentCaptureInsetsEvent(insets.getInsets(WindowInsets.Type.all()));
        Trace.traceEnd(8L);
    }

    private boolean updateCaptionInsets() {
        if (!(this.mView instanceof DecorView)) {
            return false;
        }
        int captionInsetsHeight = ((DecorView)this.mView).getCaptionInsetsHeight();
        Rect captionFrame = new Rect();
        if (captionInsetsHeight != 0) {
            captionFrame.set(this.mWinFrame.left, this.mWinFrame.top, this.mWinFrame.right, this.mWinFrame.top + captionInsetsHeight);
        }
        if (this.mAttachInfo.mCaptionInsets.equals(captionFrame)) {
            return false;
        }
        this.mAttachInfo.mCaptionInsets.set(captionFrame);
        return true;
    }

    private boolean shouldDispatchCutout() {
        return this.mWindowAttributes.layoutInDisplayCutoutMode == 3 || this.mWindowAttributes.layoutInDisplayCutoutMode == 1;
    }

    @VisibleForTesting
    public InsetsController getInsetsController() {
        return this.mInsetsController;
    }

    private static boolean shouldUseDisplaySize(WindowManager.LayoutParams lp) {
        return lp.type == 2041 || lp.type == 2011 || lp.type == 2020;
    }

    int dipToPx(int dip) {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        return (int)(displayMetrics.density * (float)dip + 0.5f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void performTraversals() {
        host = this.mView;
        if (host == null || !this.mAdded) {
            return;
        }
        if (this.mWaitForBlastSyncComplete) {
            this.mRequestedTraverseWhilePaused = true;
            return;
        }
        this.mIsInTraversal = true;
        this.mWillDrawSoon = true;
        windowSizeMayChange = false;
        lp = this.mWindowAttributes;
        viewVisibility = this.getHostVisibility();
        viewVisibilityChanged = this.mFirst == false && (this.mViewVisibility != viewVisibility || this.mNewSurfaceNeeded != false || this.mAppVisibilityChanged != false);
        this.mAppVisibilityChanged = false;
        viewUserVisibilityChanged = this.mFirst == false && this.mViewVisibility == 0 != (viewVisibility == 0);
        params = null;
        compatibilityInfo = this.mDisplay.getDisplayAdjustments().getCompatibilityInfo();
        if (compatibilityInfo.supportsScreen() == this.mLastInCompatMode) {
            params = lp;
            this.mFullRedrawNeeded = true;
            this.mLayoutRequested = true;
            if (this.mLastInCompatMode) {
                params.privateFlags &= -129;
                this.mLastInCompatMode = false;
            } else {
                params.privateFlags |= 128;
                this.mLastInCompatMode = true;
            }
        }
        frame = this.mWinFrame;
        if (this.mFirst) {
            this.mFullRedrawNeeded = true;
            this.mLayoutRequested = true;
            config = this.getConfiguration();
            if (ViewRootImpl.shouldUseDisplaySize(lp)) {
                size = new Point();
                this.mDisplay.getRealSize(size);
                desiredWindowWidth = size.x;
                desiredWindowHeight = size.y;
            } else if (lp.width == -2 || lp.height == -2) {
                desiredWindowWidth = this.dipToPx(config.screenWidthDp);
                desiredWindowHeight = this.dipToPx(config.screenHeightDp);
            } else {
                desiredWindowWidth = frame.width();
                desiredWindowHeight = frame.height();
            }
            this.mAttachInfo.mUse32BitDrawingCache = true;
            this.mAttachInfo.mWindowVisibility = viewVisibility;
            this.mAttachInfo.mRecomputeGlobalAttributes = false;
            this.mLastConfigurationFromResources.setTo(config);
            this.mLastSystemUiVisibility = this.mAttachInfo.mSystemUiVisibility;
            if (this.mViewLayoutDirectionInitial == 2) {
                host.setLayoutDirection(config.getLayoutDirection());
            }
            host.dispatchAttachedToWindow(this.mAttachInfo, 0);
            this.mAttachInfo.mTreeObserver.dispatchOnWindowAttachedChange(true);
            this.dispatchApplyInsets(host);
        } else {
            desiredWindowWidth = frame.width();
            desiredWindowHeight = frame.height();
            if (desiredWindowWidth != this.mWidth || desiredWindowHeight != this.mHeight) {
                this.mFullRedrawNeeded = true;
                this.mLayoutRequested = true;
                windowSizeMayChange = true;
            }
        }
        if (viewVisibilityChanged) {
            this.mAttachInfo.mWindowVisibility = viewVisibility;
            host.dispatchWindowVisibilityChanged(viewVisibility);
            if (viewUserVisibilityChanged) {
                host.dispatchVisibilityAggregated(viewVisibility == 0);
            }
            if (viewVisibility != 0 || this.mNewSurfaceNeeded) {
                this.endDragResizing();
                this.destroyHardwareResources();
            }
        }
        if (this.mAttachInfo.mWindowVisibility != 0) {
            host.clearAccessibilityFocus();
        }
        ViewRootImpl.getRunQueue().executeActions(this.mAttachInfo.mHandler);
        v0 = layoutRequested = this.mLayoutRequested != false && (this.mStopped == false || this.mReportNextDraw != false);
        if (layoutRequested) {
            res = this.mView.getContext().getResources();
            if (this.mFirst) {
                this.mAttachInfo.mInTouchMode = this.mAddedTouchMode == false;
                this.ensureTouchModeLocally(this.mAddedTouchMode);
            } else if (lp.width == -2 || lp.height == -2) {
                windowSizeMayChange = true;
                if (ViewRootImpl.shouldUseDisplaySize(lp)) {
                    size = new Point();
                    this.mDisplay.getRealSize(size);
                    desiredWindowWidth = size.x;
                    desiredWindowHeight = size.y;
                } else {
                    config = res.getConfiguration();
                    desiredWindowWidth = this.dipToPx(config.screenWidthDp);
                    desiredWindowHeight = this.dipToPx(config.screenHeightDp);
                }
            }
            windowSizeMayChange |= this.measureHierarchy(host, lp, res, desiredWindowWidth, desiredWindowHeight);
        }
        if (this.collectViewAttributes()) {
            params = lp;
        }
        if (this.mAttachInfo.mForceReportNewAttributes) {
            this.mAttachInfo.mForceReportNewAttributes = false;
            params = lp;
        }
        if (this.mFirst || this.mAttachInfo.mViewVisibilityChanged) {
            this.mAttachInfo.mViewVisibilityChanged = false;
            resizeMode = this.mSoftInputMode & 240;
            if (resizeMode == 0) {
                N = this.mAttachInfo.mScrollContainers.size();
                for (i = 0; i < N; ++i) {
                    if (!this.mAttachInfo.mScrollContainers.get(i).isShown()) continue;
                    resizeMode = 16;
                }
                if (resizeMode == 0) {
                    resizeMode = 32;
                }
                if ((lp.softInputMode & 240) != resizeMode) {
                    lp.softInputMode = lp.softInputMode & -241 | resizeMode;
                    params = lp;
                }
            }
        }
        if (this.mApplyInsetsRequested && !this.mWillMove && !this.mWillResize) {
            this.dispatchApplyInsets(host);
            if (this.mLayoutRequested) {
                windowSizeMayChange |= this.measureHierarchy(host, lp, this.mView.getContext().getResources(), desiredWindowWidth, desiredWindowHeight);
            }
        }
        if (layoutRequested) {
            this.mLayoutRequested = false;
        }
        windowShouldResize = layoutRequested != false && windowSizeMayChange != false && (this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight() || lp.width == -2 && frame.width() < desiredWindowWidth && frame.width() != this.mWidth || lp.height == -2 && frame.height() < desiredWindowHeight && frame.height() != this.mHeight);
        windowShouldResize |= this.mDragResizing != false && this.mResizeMode == 0;
        windowShouldResize |= this.mActivityRelaunched;
        computesInternalInsets = this.mAttachInfo.mTreeObserver.hasComputeInternalInsetsListeners() != false || this.mAttachInfo.mHasNonEmptyGivenInternalInsets != false;
        insetsPending = false;
        relayoutResult = 0;
        updatedConfiguration = false;
        surfaceGenerationId = this.mSurface.getGenerationId();
        isViewVisible = viewVisibility == 0;
        windowRelayoutWasForced = this.mForceNextWindowRelayout;
        surfaceSizeChanged = false;
        surfaceCreated = false;
        surfaceDestroyed = false;
        surfaceReplaced = false;
        windowAttributesChanged = this.mWindowAttributesChanged;
        if (windowAttributesChanged) {
            this.mWindowAttributesChanged = false;
            params = lp;
        }
        if (params != null) {
            if ((host.mPrivateFlags & 512) != 0 && !PixelFormat.formatHasAlpha(params.format)) {
                params.format = -3;
            }
            ViewRootImpl.adjustLayoutParamsForCompatibility(params);
            this.controlInsetsForCompatibility(params);
            if (this.mDispatchedSystemBarAppearance != params.insetsFlags.appearance) {
                this.mDispatchedSystemBarAppearance = params.insetsFlags.appearance;
                this.mView.onSystemBarAppearanceChanged(this.mDispatchedSystemBarAppearance);
            }
        }
        wasReportNextDraw = this.mReportNextDraw;
        if (this.mFirst || windowShouldResize || viewVisibilityChanged || params != null || this.mForceNextWindowRelayout) {
            this.mForceNextWindowRelayout = false;
            insetsPending = computesInternalInsets;
            if (this.mSurfaceHolder != null) {
                this.mSurfaceHolder.mSurfaceLock.lock();
                this.mDrawingAllowed = true;
            }
            hwInitialized = false;
            dispatchApplyInsets = false;
            hadSurface = this.mSurface.isValid();
            try {
                if (this.mAttachInfo.mThreadedRenderer != null && this.mAttachInfo.mThreadedRenderer.pause()) {
                    this.mDirty.set(0, 0, this.mWidth, this.mHeight);
                }
                if (this.mFirst || viewVisibilityChanged) {
                    this.mViewFrameInfo.flags |= 1L;
                }
                freeformResizing = ((relayoutResult = this.relayoutWindow(params, viewVisibility, insetsPending)) & 16) != 0;
                dockedResizing = (relayoutResult & 8) != 0;
                v1 = dragResizing = freeformResizing != false || dockedResizing != false ? 1 : 0;
                if ((relayoutResult & 128) != 0) {
                    this.reportNextDraw();
                    if (this.isHardwareEnabled()) {
                        this.mNextDrawUseBlastSync = true;
                    }
                }
                v2 = surfaceControlChanged = (relayoutResult & 4) == 4 ? 1 : 0;
                if (this.mSurfaceControl.isValid()) {
                    this.updateOpacity(this.mWindowAttributes, (boolean)dragResizing, (boolean)surfaceControlChanged);
                }
                if (!this.mPendingMergedConfiguration.equals(this.mLastReportedMergedConfiguration)) {
                    this.performConfigurationChange(new MergedConfiguration(this.mPendingMergedConfiguration), this.mFirst == false, -1);
                    updatedConfiguration = true;
                }
                surfaceSizeChanged = false;
                if (!this.mLastSurfaceSize.equals(this.mSurfaceSize)) {
                    surfaceSizeChanged = true;
                    this.mLastSurfaceSize.set(this.mSurfaceSize.x, this.mSurfaceSize.y);
                }
                alwaysConsumeSystemBarsChanged = this.mPendingAlwaysConsumeSystemBars != this.mAttachInfo.mAlwaysConsumeSystemBars;
                this.updateColorModeIfNeeded(lp.getColorMode());
                surfaceCreated = hadSurface == false && this.mSurface.isValid() != false;
                surfaceDestroyed = hadSurface != false && this.mSurface.isValid() == false;
                v3 = surfaceReplaced = (surfaceGenerationId != this.mSurface.getGenerationId() || surfaceControlChanged != 0) && this.mSurface.isValid() != false;
                if (surfaceReplaced) {
                    ++this.mSurfaceSequenceId;
                }
                if (alwaysConsumeSystemBarsChanged) {
                    this.mAttachInfo.mAlwaysConsumeSystemBars = this.mPendingAlwaysConsumeSystemBars;
                    dispatchApplyInsets = true;
                }
                if (this.updateCaptionInsets()) {
                    dispatchApplyInsets = true;
                }
                if (dispatchApplyInsets || this.mLastSystemUiVisibility != this.mAttachInfo.mSystemUiVisibility || this.mApplyInsetsRequested) {
                    this.mLastSystemUiVisibility = this.mAttachInfo.mSystemUiVisibility;
                    this.dispatchApplyInsets(host);
                    dispatchApplyInsets = true;
                }
                if (surfaceCreated) {
                    this.mFullRedrawNeeded = true;
                    this.mPreviousTransparentRegion.setEmpty();
                    if (this.mAttachInfo.mThreadedRenderer != null) {
                        try {
                            hwInitialized = this.mAttachInfo.mThreadedRenderer.initialize(this.mSurface);
                            if (!hwInitialized || (host.mPrivateFlags & 512) != 0) ** GOTO lbl225
                            this.mAttachInfo.mThreadedRenderer.allocateBuffers();
                        }
                        catch (Surface.OutOfResourcesException e) {
                            this.handleOutOfResourcesException(e);
                            return;
                        }
                    }
                } else if (surfaceDestroyed) {
                    if (this.mLastScrolledFocus != null) {
                        this.mLastScrolledFocus.clear();
                    }
                    this.mCurScrollY = 0;
                    this.mScrollY = 0;
                    if (this.mView instanceof RootViewSurfaceTaker) {
                        ((RootViewSurfaceTaker)this.mView).onRootViewScrollYChanged(this.mCurScrollY);
                    }
                    if (this.mScroller != null) {
                        this.mScroller.abortAnimation();
                    }
                    if (this.isHardwareEnabled()) {
                        this.mAttachInfo.mThreadedRenderer.destroy();
                    }
                } else if ((surfaceReplaced || surfaceSizeChanged || windowRelayoutWasForced) && this.mSurfaceHolder == null && this.mAttachInfo.mThreadedRenderer != null && this.mSurface.isValid()) {
                    this.mFullRedrawNeeded = true;
                    try {
                        this.mAttachInfo.mThreadedRenderer.updateSurface(this.mSurface);
                    }
                    catch (Surface.OutOfResourcesException e) {
                        this.handleOutOfResourcesException(e);
                        return;
                    }
                }
lbl225:
                // 7 sources

                if (this.mDragResizing != dragResizing) {
                    if (dragResizing != 0) {
                        this.mResizeMode = freeformResizing != false ? 0 : 1;
                        backdropSizeMatchesFrame = this.mWinFrame.width() == this.mPendingBackDropFrame.width() && this.mWinFrame.height() == this.mPendingBackDropFrame.height();
                        this.startDragResizing(this.mPendingBackDropFrame, backdropSizeMatchesFrame == false, this.mAttachInfo.mContentInsets, this.mAttachInfo.mStableInsets, this.mResizeMode);
                    } else {
                        this.endDragResizing();
                    }
                }
                if (!this.mUseMTRenderer) {
                    if (dragResizing != 0) {
                        this.mCanvasOffsetX = this.mWinFrame.left;
                        this.mCanvasOffsetY = this.mWinFrame.top;
                    } else {
                        this.mCanvasOffsetY = 0;
                        this.mCanvasOffsetX = 0;
                    }
                }
            }
            catch (RemoteException freeformResizing) {
                // empty catch block
            }
            this.mAttachInfo.mWindowLeft = frame.left;
            this.mAttachInfo.mWindowTop = frame.top;
            if (this.mWidth != frame.width() || this.mHeight != frame.height()) {
                this.mWidth = frame.width();
                this.mHeight = frame.height();
            }
            if (this.mSurfaceHolder != null) {
                if (this.mSurface.isValid()) {
                    this.mSurfaceHolder.mSurface = this.mSurface;
                }
                this.mSurfaceHolder.setSurfaceFrameSize(this.mWidth, this.mHeight);
                this.mSurfaceHolder.mSurfaceLock.unlock();
                if (surfaceCreated) {
                    this.mSurfaceHolder.ungetCallbacks();
                    this.mIsCreating = true;
                    callbacks = this.mSurfaceHolder.getCallbacks();
                    if (callbacks != null) {
                        for (SurfaceHolder.Callback c : callbacks) {
                            c.surfaceCreated(this.mSurfaceHolder);
                        }
                    }
                }
                if ((surfaceCreated || surfaceReplaced || surfaceSizeChanged || windowAttributesChanged) && this.mSurface.isValid()) {
                    callbacks = this.mSurfaceHolder.getCallbacks();
                    if (callbacks != null) {
                        for (SurfaceHolder.Callback c : callbacks) {
                            c.surfaceChanged(this.mSurfaceHolder, lp.format, this.mWidth, this.mHeight);
                        }
                    }
                    this.mIsCreating = false;
                }
                if (surfaceDestroyed) {
                    this.notifyHolderSurfaceDestroyed();
                    this.mSurfaceHolder.mSurfaceLock.lock();
                    try {
                        this.mSurfaceHolder.mSurface = new Surface();
                    }
                    finally {
                        this.mSurfaceHolder.mSurfaceLock.unlock();
                    }
                }
            }
            if ((threadedRenderer = this.mAttachInfo.mThreadedRenderer) != null && threadedRenderer.isEnabled() && (hwInitialized || this.mWidth != threadedRenderer.getWidth() || this.mHeight != threadedRenderer.getHeight() || this.mNeedsRendererSetup)) {
                threadedRenderer.setup(this.mWidth, this.mHeight, this.mAttachInfo, this.mWindowAttributes.surfaceInsets);
                this.mNeedsRendererSetup = false;
            }
            if ((!this.mStopped || wasReportNextDraw) && ((focusChangedDueToTouchMode = this.ensureTouchModeLocally((relayoutResult & 1) != 0)) || this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight() || dispatchApplyInsets || updatedConfiguration)) {
                childWidthMeasureSpec = ViewRootImpl.getRootMeasureSpec(this.mWidth, lp.width);
                childHeightMeasureSpec = ViewRootImpl.getRootMeasureSpec(this.mHeight, lp.height);
                this.performMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
                width = host.getMeasuredWidth();
                height = host.getMeasuredHeight();
                measureAgain = false;
                if (lp.horizontalWeight > 0.0f) {
                    width += (int)((float)(this.mWidth - width) * lp.horizontalWeight);
                    childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
                    measureAgain = true;
                }
                if (lp.verticalWeight > 0.0f) {
                    height += (int)((float)(this.mHeight - height) * lp.verticalWeight);
                    childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
                    measureAgain = true;
                }
                if (measureAgain) {
                    this.performMeasure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
                layoutRequested = true;
            }
        } else {
            this.maybeHandleWindowMove(frame);
        }
        if (surfaceSizeChanged || surfaceReplaced || surfaceCreated || windowAttributesChanged) {
            this.prepareSurfaces();
        }
        didLayout = layoutRequested != false && (this.mStopped == false || wasReportNextDraw != false);
        v4 = triggerGlobalLayoutListener = didLayout != false || this.mAttachInfo.mRecomputeGlobalAttributes != false;
        if (didLayout) {
            this.performLayout(lp, this.mWidth, this.mHeight);
            if ((host.mPrivateFlags & 512) != 0) {
                host.getLocationInWindow(this.mTmpLocation);
                this.mTransparentRegion.set(this.mTmpLocation[0], this.mTmpLocation[1], this.mTmpLocation[0] + host.mRight - host.mLeft, this.mTmpLocation[1] + host.mBottom - host.mTop);
                host.gatherTransparentRegion(this.mTransparentRegion);
                if (this.mTranslator != null) {
                    this.mTranslator.translateRegionInWindowToScreen(this.mTransparentRegion);
                }
                if (!this.mTransparentRegion.equals(this.mPreviousTransparentRegion)) {
                    this.mPreviousTransparentRegion.set(this.mTransparentRegion);
                    this.mFullRedrawNeeded = true;
                    sc = this.getSurfaceControl();
                    if (sc.isValid()) {
                        this.mTransaction.setTransparentRegionHint(sc, this.mTransparentRegion).apply();
                    }
                }
            }
        }
        if (surfaceCreated) {
            this.notifySurfaceCreated();
        } else if (surfaceReplaced) {
            this.notifySurfaceReplaced();
        } else if (surfaceDestroyed) {
            this.notifySurfaceDestroyed();
        }
        if (triggerGlobalLayoutListener) {
            this.mAttachInfo.mRecomputeGlobalAttributes = false;
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalLayout();
        }
        if (computesInternalInsets) {
            insets = this.mAttachInfo.mGivenInternalInsets;
            insets.reset();
            this.mAttachInfo.mTreeObserver.dispatchOnComputeInternalInsets(insets);
            v5 = this.mAttachInfo.mHasNonEmptyGivenInternalInsets = insets.isEmpty() == false;
            if (insetsPending || !this.mLastGivenInsets.equals(insets)) {
                this.mLastGivenInsets.set(insets);
                if (this.mTranslator != null) {
                    contentInsets = this.mTranslator.getTranslatedContentInsets(insets.contentInsets);
                    visibleInsets = this.mTranslator.getTranslatedVisibleInsets(insets.visibleInsets);
                    touchableRegion = this.mTranslator.getTranslatedTouchableArea(insets.touchableRegion);
                } else {
                    contentInsets = insets.contentInsets;
                    visibleInsets = insets.visibleInsets;
                    touchableRegion = insets.touchableRegion;
                }
                try {
                    this.mWindowSession.setInsets(this.mWindow, insets.mTouchableInsets, contentInsets, visibleInsets, touchableRegion);
                }
                catch (RemoteException childHeightMeasureSpec) {
                    // empty catch block
                }
            }
        }
        if (this.mFirst) {
            if (ViewRootImpl.sAlwaysAssignFocus || !ViewRootImpl.isInTouchMode()) {
                if (this.mView != null && !this.mView.hasFocus()) {
                    this.mView.restoreDefaultFocus();
                }
            } else {
                focused = this.mView.findFocus();
                if (focused instanceof ViewGroup && ((ViewGroup)focused).getDescendantFocusability() == 262144) {
                    focused.restoreDefaultFocus();
                }
            }
        }
        changedVisibility = (viewVisibilityChanged != false || this.mFirst != false) && isViewVisible != false;
        hasWindowFocus = this.mAttachInfo.mHasWindowFocus != false && isViewVisible != false;
        v6 = regainedFocus = hasWindowFocus != false && this.mLostWindowFocus != false;
        if (regainedFocus) {
            this.mLostWindowFocus = false;
        } else if (!hasWindowFocus && this.mHadWindowFocus) {
            this.mLostWindowFocus = true;
        }
        if (changedVisibility || regainedFocus) {
            v7 = isToast = this.mWindowAttributes.type == 2005;
            if (!isToast) {
                host.sendAccessibilityEvent(32);
            }
        }
        this.mFirst = false;
        this.mWillDrawSoon = false;
        this.mNewSurfaceNeeded = false;
        this.mActivityRelaunched = false;
        this.mViewVisibility = viewVisibility;
        this.mHadWindowFocus = hasWindowFocus;
        this.mImeFocusController.onTraversal(hasWindowFocus, this.mWindowAttributes);
        if ((relayoutResult & 2) != 0) {
            this.reportNextDraw();
        }
        v8 = cancelDraw = this.mAttachInfo.mTreeObserver.dispatchOnPreDraw() != false || isViewVisible == false;
        if (!cancelDraw) {
            if (this.mPendingTransitions != null && this.mPendingTransitions.size() > 0) {
                for (i = 0; i < this.mPendingTransitions.size(); ++i) {
                    this.mPendingTransitions.get(i).startChangingAnimations();
                }
                this.mPendingTransitions.clear();
            }
            this.performDraw();
        } else if (isViewVisible) {
            this.scheduleTraversals();
        } else {
            if (this.mPendingTransitions != null && this.mPendingTransitions.size() > 0) {
                for (i = 0; i < this.mPendingTransitions.size(); ++i) {
                    this.mPendingTransitions.get(i).endChangingAnimations();
                }
                this.mPendingTransitions.clear();
            }
            if (!wasReportNextDraw && this.mReportNextDraw) {
                this.mReportNextDraw = false;
                this.pendingDrawFinished();
            }
        }
        if (this.mAttachInfo.mContentCaptureEvents != null) {
            this.notifyContentCatpureEvents();
        }
        this.mIsInTraversal = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyContentCatpureEvents() {
        Trace.traceBegin(8L, "notifyContentCaptureEvents");
        try {
            MainContentCaptureSession mainSession = this.mAttachInfo.mContentCaptureManager.getMainContentCaptureSession();
            for (int i = 0; i < this.mAttachInfo.mContentCaptureEvents.size(); ++i) {
                int sessionId = this.mAttachInfo.mContentCaptureEvents.keyAt(i);
                mainSession.notifyViewTreeEvent(sessionId, true);
                ArrayList<Object> events = this.mAttachInfo.mContentCaptureEvents.valueAt(i);
                for (int j = 0; j < events.size(); ++j) {
                    Object event = events.get(j);
                    if (event instanceof AutofillId) {
                        mainSession.notifyViewDisappeared(sessionId, (AutofillId)event);
                        continue;
                    }
                    if (event instanceof View) {
                        View view = (View)event;
                        ContentCaptureSession session = view.getContentCaptureSession();
                        if (session == null) {
                            Log.w(this.mTag, "no content capture session on view: " + view);
                            continue;
                        }
                        int actualId = session.getId();
                        if (actualId != sessionId) {
                            Log.w(this.mTag, "content capture session mismatch for view (" + view + "): was " + sessionId + " before, it's " + actualId + " now");
                            continue;
                        }
                        ViewStructure structure = session.newViewStructure(view);
                        view.onProvideContentCaptureStructure(structure, 0);
                        session.notifyViewAppeared(structure);
                        continue;
                    }
                    if (event instanceof Insets) {
                        mainSession.notifyViewInsetsChanged(sessionId, (Insets)event);
                        continue;
                    }
                    Log.w(this.mTag, "invalid content capture event: " + event);
                }
                mainSession.notifyViewTreeEvent(sessionId, false);
            }
            this.mAttachInfo.mContentCaptureEvents = null;
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    private void notifyHolderSurfaceDestroyed() {
        this.mSurfaceHolder.ungetCallbacks();
        SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
        if (callbacks != null) {
            for (SurfaceHolder.Callback c : callbacks) {
                c.surfaceDestroyed(this.mSurfaceHolder);
            }
        }
    }

    private void maybeHandleWindowMove(Rect frame) {
        boolean windowMoved;
        boolean bl = windowMoved = this.mAttachInfo.mWindowLeft != frame.left || this.mAttachInfo.mWindowTop != frame.top;
        if (windowMoved) {
            this.mAttachInfo.mWindowLeft = frame.left;
            this.mAttachInfo.mWindowTop = frame.top;
        }
        if (windowMoved || this.mAttachInfo.mNeedsUpdateLightCenter) {
            if (this.mAttachInfo.mThreadedRenderer != null) {
                this.mAttachInfo.mThreadedRenderer.setLightCenter(this.mAttachInfo);
            }
            this.mAttachInfo.mNeedsUpdateLightCenter = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWindowFocusChanged() {
        boolean inTouchMode;
        boolean hasWindowFocus;
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            if (!this.mWindowFocusChanged) {
                return;
            }
            this.mWindowFocusChanged = false;
            hasWindowFocus = this.mUpcomingWindowFocus;
            inTouchMode = this.mUpcomingInTouchMode;
        }
        if (hasWindowFocus) {
            this.mInsetsController.onWindowFocusGained(this.getFocusedViewOrNull() != null);
        } else {
            this.mInsetsController.onWindowFocusLost();
        }
        if (this.mAdded) {
            this.profileRendering(hasWindowFocus);
            if (hasWindowFocus) {
                this.ensureTouchModeLocally(inTouchMode);
                if (this.mAttachInfo.mThreadedRenderer != null && this.mSurface.isValid()) {
                    this.mFullRedrawNeeded = true;
                    try {
                        Rect surfaceInsets = this.mWindowAttributes.surfaceInsets;
                        this.mAttachInfo.mThreadedRenderer.initializeIfNeeded(this.mWidth, this.mHeight, this.mAttachInfo, this.mSurface, surfaceInsets);
                    }
                    catch (Surface.OutOfResourcesException e) {
                        Log.e(this.mTag, "OutOfResourcesException locking surface", e);
                        try {
                            if (!this.mWindowSession.outOfMemory(this.mWindow)) {
                                Slog.w(this.mTag, "No processes killed for memory; killing self");
                                Process.killProcess(Process.myPid());
                            }
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(6), 500L);
                        return;
                    }
                }
            }
            this.mAttachInfo.mHasWindowFocus = hasWindowFocus;
            this.mImeFocusController.updateImeFocusable(this.mWindowAttributes, true);
            this.mImeFocusController.onPreWindowFocus(hasWindowFocus, this.mWindowAttributes);
            if (this.mView != null) {
                this.mAttachInfo.mKeyDispatchState.reset();
                this.mView.dispatchWindowFocusChanged(hasWindowFocus);
                this.mAttachInfo.mTreeObserver.dispatchOnWindowFocusChange(hasWindowFocus);
                if (this.mAttachInfo.mTooltipHost != null) {
                    this.mAttachInfo.mTooltipHost.hideTooltip();
                }
            }
            this.mImeFocusController.onPostWindowFocus(this.getFocusedViewOrNull(), hasWindowFocus, this.mWindowAttributes);
            if (hasWindowFocus) {
                this.mWindowAttributes.softInputMode &= 0xFFFFFEFF;
                ((WindowManager.LayoutParams)this.mView.getLayoutParams()).softInputMode &= 0xFFFFFEFF;
                this.fireAccessibilityFocusEventIfHasFocusedNode();
            } else if (this.mPointerCapture) {
                this.handlePointerCaptureChanged(false);
            }
        }
        this.mFirstInputStage.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.handleContentCaptureFlush();
        }
    }

    private void fireAccessibilityFocusEventIfHasFocusedNode() {
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return;
        }
        View focusedView = this.mView.findFocus();
        if (focusedView == null) {
            return;
        }
        AccessibilityNodeProvider provider = focusedView.getAccessibilityNodeProvider();
        if (provider == null) {
            focusedView.sendAccessibilityEvent(8);
        } else {
            AccessibilityNodeInfo focusedNode = this.findFocusedVirtualNode(provider);
            if (focusedNode != null) {
                int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(focusedNode.getSourceNodeId());
                AccessibilityEvent event = AccessibilityEvent.obtain(8);
                event.setSource(focusedView, virtualId);
                event.setPackageName(focusedNode.getPackageName());
                event.setChecked(focusedNode.isChecked());
                event.setContentDescription(focusedNode.getContentDescription());
                event.setPassword(focusedNode.isPassword());
                event.getText().add(focusedNode.getText());
                event.setEnabled(focusedNode.isEnabled());
                focusedView.getParent().requestSendAccessibilityEvent(focusedView, event);
                focusedNode.recycle();
            }
        }
    }

    private AccessibilityNodeInfo findFocusedVirtualNode(AccessibilityNodeProvider provider) {
        AccessibilityNodeInfo focusedNode = provider.findFocus(1);
        if (focusedNode != null) {
            return focusedNode;
        }
        if (!this.mContext.isAutofillCompatibilityEnabled()) {
            return null;
        }
        AccessibilityNodeInfo current = provider.createAccessibilityNodeInfo(-1);
        if (current.isFocused()) {
            return current;
        }
        LinkedList<AccessibilityNodeInfo> fringe = new LinkedList<AccessibilityNodeInfo>();
        fringe.offer(current);
        while (!fringe.isEmpty()) {
            current = (AccessibilityNodeInfo)fringe.poll();
            LongArray childNodeIds = current.getChildNodeIds();
            if (childNodeIds == null || childNodeIds.size() <= 0) continue;
            int childCount = childNodeIds.size();
            for (int i = 0; i < childCount; ++i) {
                int virtualId = AccessibilityNodeInfo.getVirtualDescendantId(childNodeIds.get(i));
                AccessibilityNodeInfo child = provider.createAccessibilityNodeInfo(virtualId);
                if (child == null) continue;
                if (child.isFocused()) {
                    return child;
                }
                fringe.offer(child);
            }
            current.recycle();
        }
        return null;
    }

    private void handleOutOfResourcesException(Surface.OutOfResourcesException e) {
        Log.e(this.mTag, "OutOfResourcesException initializing HW surface", e);
        try {
            if (!this.mWindowSession.outOfMemory(this.mWindow) && Process.myUid() != 1000) {
                Slog.w(this.mTag, "No processes killed for memory; killing self");
                Process.killProcess(Process.myPid());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mLayoutRequested = true;
    }

    private void performMeasure(int childWidthMeasureSpec, int childHeightMeasureSpec) {
        if (this.mView == null) {
            return;
        }
        Trace.traceBegin(8L, "measure");
        try {
            this.mView.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    boolean isInLayout() {
        return this.mInLayout;
    }

    boolean requestLayoutDuringLayout(View view) {
        if (view.mParent == null || view.mAttachInfo == null) {
            return true;
        }
        if (!this.mLayoutRequesters.contains(view)) {
            this.mLayoutRequesters.add(view);
        }
        return !this.mHandlingLayoutInLayoutRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLayout(WindowManager.LayoutParams lp, int desiredWindowWidth, int desiredWindowHeight) {
        this.mScrollMayChange = true;
        this.mInLayout = true;
        View host = this.mView;
        if (host == null) {
            return;
        }
        Trace.traceBegin(8L, "layout");
        try {
            ArrayList<View> validLayoutRequesters;
            host.layout(0, 0, host.getMeasuredWidth(), host.getMeasuredHeight());
            this.mInLayout = false;
            int numViewsRequestingLayout = this.mLayoutRequesters.size();
            if (numViewsRequestingLayout > 0 && (validLayoutRequesters = this.getValidLayoutRequesters(this.mLayoutRequesters, false)) != null) {
                this.mHandlingLayoutInLayoutRequest = true;
                int numValidRequests = validLayoutRequesters.size();
                for (int i = 0; i < numValidRequests; ++i) {
                    View view = validLayoutRequesters.get(i);
                    Log.w("View", "requestLayout() improperly called by " + view + " during layout: running second layout pass");
                    view.requestLayout();
                }
                this.measureHierarchy(host, lp, this.mView.getContext().getResources(), desiredWindowWidth, desiredWindowHeight);
                this.mInLayout = true;
                host.layout(0, 0, host.getMeasuredWidth(), host.getMeasuredHeight());
                this.mHandlingLayoutInLayoutRequest = false;
                validLayoutRequesters = this.getValidLayoutRequesters(this.mLayoutRequesters, true);
                if (validLayoutRequesters != null) {
                    final ArrayList<View> finalRequesters = validLayoutRequesters;
                    ViewRootImpl.getRunQueue().post(new Runnable(){

                        @Override
                        public void run() {
                            int numValidRequests = finalRequesters.size();
                            for (int i = 0; i < numValidRequests; ++i) {
                                View view = (View)finalRequesters.get(i);
                                Log.w("View", "requestLayout() improperly called by " + view + " during second layout pass: posting in next frame");
                                view.requestLayout();
                            }
                        }
                    });
                }
            }
        }
        finally {
            Trace.traceEnd(8L);
        }
        this.mInLayout = false;
    }

    private ArrayList<View> getValidLayoutRequesters(ArrayList<View> layoutRequesters, boolean secondLayoutRequests) {
        View view;
        int i;
        int numViewsRequestingLayout = layoutRequesters.size();
        ArrayList<View> validLayoutRequesters = null;
        for (i = 0; i < numViewsRequestingLayout; ++i) {
            view = layoutRequesters.get(i);
            if (view == null || view.mAttachInfo == null || view.mParent == null || !secondLayoutRequests && (view.mPrivateFlags & 0x1000) != 4096) continue;
            boolean gone = false;
            View parent = view;
            while (parent != null) {
                if ((parent.mViewFlags & 0xC) == 8) {
                    gone = true;
                    break;
                }
                if (parent.mParent instanceof View) {
                    parent = (View)((Object)parent.mParent);
                    continue;
                }
                parent = null;
            }
            if (gone) continue;
            if (validLayoutRequesters == null) {
                validLayoutRequesters = new ArrayList<View>();
            }
            validLayoutRequesters.add(view);
        }
        if (!secondLayoutRequests) {
            for (i = 0; i < numViewsRequestingLayout; ++i) {
                view = layoutRequesters.get(i);
                while (view != null && (view.mPrivateFlags & 0x1000) != 0) {
                    view.mPrivateFlags &= 0xFFFFEFFF;
                    if (view.mParent instanceof View) {
                        view = (View)((Object)view.mParent);
                        continue;
                    }
                    view = null;
                }
            }
        }
        layoutRequesters.clear();
        return validLayoutRequesters;
    }

    @Override
    public void requestTransparentRegion(View child) {
        this.checkThread();
        if (this.mView != child) {
            return;
        }
        if ((this.mView.mPrivateFlags & 0x200) == 0) {
            this.mView.mPrivateFlags |= 0x200;
            this.mWindowAttributesChanged = true;
        }
        this.requestLayout();
    }

    public static int getRootMeasureSpec(int windowSize, int rootDimension) {
        int measureSpec;
        switch (rootDimension) {
            case -1: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(windowSize, 0x40000000);
                break;
            }
            case -2: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(windowSize, Integer.MIN_VALUE);
                break;
            }
            default: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(rootDimension, 0x40000000);
            }
        }
        return measureSpec;
    }

    @Override
    public void onPreDraw(RecordingCanvas canvas) {
        if (this.mCurScrollY != 0 && this.mHardwareYOffset != 0 && this.mAttachInfo.mThreadedRenderer.isOpaque()) {
            canvas.drawColor(-16777216);
        }
        canvas.translate(-this.mHardwareXOffset, -this.mHardwareYOffset);
    }

    @Override
    public void onPostDraw(RecordingCanvas canvas) {
        this.drawAccessibilityFocusedDrawableIfNeeded(canvas);
        if (this.mUseMTRenderer) {
            for (int i = this.mWindowCallbacks.size() - 1; i >= 0; --i) {
                this.mWindowCallbacks.get(i).onPostDraw(canvas);
            }
        }
    }

    void outputDisplayList(View view) {
        view.mRenderNode.output();
    }

    private void profileRendering(boolean enabled) {
        if (this.mProfileRendering) {
            this.mRenderProfilingEnabled = enabled;
            if (this.mRenderProfiler != null) {
                this.mChoreographer.removeFrameCallback(this.mRenderProfiler);
            }
            if (this.mRenderProfilingEnabled) {
                if (this.mRenderProfiler == null) {
                    this.mRenderProfiler = new Choreographer.FrameCallback(){

                        @Override
                        public void doFrame(long frameTimeNanos) {
                            ViewRootImpl.this.mDirty.set(0, 0, ViewRootImpl.this.mWidth, ViewRootImpl.this.mHeight);
                            ViewRootImpl.this.scheduleTraversals();
                            if (ViewRootImpl.this.mRenderProfilingEnabled) {
                                ViewRootImpl.this.mChoreographer.postFrameCallback(ViewRootImpl.this.mRenderProfiler);
                            }
                        }
                    };
                }
                this.mChoreographer.postFrameCallback(this.mRenderProfiler);
            } else {
                this.mRenderProfiler = null;
            }
        }
    }

    private void trackFPS() {
        long nowTime = System_Delegate.currentTimeMillis();
        if (this.mFpsStartTime < 0L) {
            this.mFpsStartTime = this.mFpsPrevTime = nowTime;
            this.mFpsNumFrames = 0;
        } else {
            ++this.mFpsNumFrames;
            String thisHash = Integer.toHexString(System.identityHashCode(this));
            long frameTime = nowTime - this.mFpsPrevTime;
            long totalTime = nowTime - this.mFpsStartTime;
            Log.v(this.mTag, "0x" + thisHash + "\tFrame time:\t" + frameTime);
            this.mFpsPrevTime = nowTime;
            if (totalTime > 1000L) {
                float fps = (float)this.mFpsNumFrames * 1000.0f / (float)totalTime;
                Log.v(this.mTag, "0x" + thisHash + "\tFPS:\t" + fps);
                this.mFpsStartTime = nowTime;
                this.mFpsNumFrames = 0;
            }
        }
    }

    void drawPending() {
        ++this.mDrawsNeededToReport;
    }

    void pendingDrawFinished() {
        if (this.mDrawsNeededToReport == 0) {
            throw new RuntimeException("Unbalanced drawPending/pendingDrawFinished calls");
        }
        --this.mDrawsNeededToReport;
        if (this.mDrawsNeededToReport == 0) {
            this.reportDrawFinished();
        }
    }

    private void postDrawFinished() {
        this.mHandler.sendEmptyMessage(29);
    }

    private void reportDrawFinished() {
        try {
            this.mDrawsNeededToReport = 0;
            this.mWindowSession.finishDrawing(this.mWindow, this.mSurfaceChangedTransaction);
        }
        catch (RemoteException e) {
            Log.e(this.mTag, "Unable to report draw finished", e);
            this.mSurfaceChangedTransaction.apply();
        }
        finally {
            this.mSurfaceChangedTransaction.clear();
        }
    }

    private HardwareRenderer.FrameCompleteCallback createFrameCompleteCallback(Handler handler, boolean reportNextDraw, ArrayList<Runnable> commitCallbacks) {
        return frameNr -> handler.postAtFrontOfQueue(() -> {
            if (this.mNextDrawUseBlastSync) {
                this.mSurfaceChangedTransaction.merge(this.mRtBLASTSyncTransaction);
            }
            if (reportNextDraw) {
                this.pendingDrawFinished();
            }
            if (commitCallbacks != null) {
                for (int i = 0; i < commitCallbacks.size(); ++i) {
                    ((Runnable)commitCallbacks.get(i)).run();
                }
            }
        });
    }

    public boolean isHardwareEnabled() {
        return this.mAttachInfo.mThreadedRenderer != null && this.mAttachInfo.mThreadedRenderer.isEnabled();
    }

    private boolean addFrameCompleteCallbackIfNeeded() {
        boolean needFrameCompleteCallback;
        if (!this.isHardwareEnabled()) {
            return false;
        }
        ArrayList<Runnable> commitCallbacks = this.mAttachInfo.mTreeObserver.captureFrameCommitCallbacks();
        boolean bl = needFrameCompleteCallback = this.mNextDrawUseBlastSync || this.mReportNextDraw || commitCallbacks != null && commitCallbacks.size() > 0;
        if (needFrameCompleteCallback) {
            this.mAttachInfo.mThreadedRenderer.setFrameCompleteCallback(this.createFrameCompleteCallback(this.mAttachInfo.mHandler, this.mReportNextDraw, commitCallbacks));
            return true;
        }
        return false;
    }

    private void addFrameCallbackIfNeeded() {
        boolean needsCallbackForBlur;
        boolean nextDrawUseBlastSync = this.mNextDrawUseBlastSync;
        boolean reportNextDraw = this.mReportNextDraw;
        boolean hasBlurUpdates = this.mBlurRegionAggregator.hasUpdates();
        boolean bl = needsCallbackForBlur = hasBlurUpdates || this.mBlurRegionAggregator.hasRegions();
        if (!(nextDrawUseBlastSync || reportNextDraw || needsCallbackForBlur)) {
            return;
        }
        this.mWaitForBlastSyncComplete = nextDrawUseBlastSync;
        BackgroundBlurDrawable.BlurRegion[] blurRegionsForFrame = needsCallbackForBlur ? this.mBlurRegionAggregator.getBlurRegionsCopyForRT() : null;
        HardwareRenderer.FrameDrawingCallback frameDrawingCallback = frame -> {
            if (needsCallbackForBlur) {
                this.mBlurRegionAggregator.dispatchBlurTransactionIfNeeded(frame, blurRegionsForFrame, hasBlurUpdates);
            }
            if (this.mBlastBufferQueue == null) {
                return;
            }
            if (nextDrawUseBlastSync) {
                this.mBlastBufferQueue.setNextTransaction(this.mRtBLASTSyncTransaction);
                this.mBlastBufferQueue.setTransactionCompleteCallback(frame, frameNumber -> this.mHandler.postAtFrontOfQueue(() -> {
                    this.mNextDrawUseBlastSync = false;
                    this.mWaitForBlastSyncComplete = false;
                    if (this.mRequestedTraverseWhilePaused) {
                        this.mRequestedTraverseWhilePaused = false;
                        this.scheduleTraversals();
                    }
                }));
            } else if (reportNextDraw) {
                this.mBlastBufferQueue.flushShadowQueue();
            }
        };
        this.registerRtFrameCallback(frameDrawingCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDraw() {
        if (this.mAttachInfo.mDisplayState == 1 && !this.mReportNextDraw) {
            return;
        }
        if (this.mView == null) {
            return;
        }
        boolean fullRedrawNeeded = this.mFullRedrawNeeded || this.mReportNextDraw || this.mNextDrawUseBlastSync;
        this.mFullRedrawNeeded = false;
        this.mIsDrawing = true;
        Trace.traceBegin(8L, "draw");
        boolean usingAsyncReport = this.addFrameCompleteCallbackIfNeeded();
        this.addFrameCallbackIfNeeded();
        try {
            boolean canUseAsync = this.draw(fullRedrawNeeded);
            if (usingAsyncReport && !canUseAsync) {
                this.mAttachInfo.mThreadedRenderer.setFrameCompleteCallback(null);
                usingAsyncReport = false;
            }
        }
        finally {
            this.mIsDrawing = false;
            Trace.traceEnd(8L);
        }
        if (this.mAttachInfo.mPendingAnimatingRenderNodes != null) {
            int count = this.mAttachInfo.mPendingAnimatingRenderNodes.size();
            for (int i = 0; i < count; ++i) {
                this.mAttachInfo.mPendingAnimatingRenderNodes.get(i).endAllAnimators();
            }
            this.mAttachInfo.mPendingAnimatingRenderNodes.clear();
        }
        if (this.mReportNextDraw) {
            this.mReportNextDraw = false;
            if (this.mWindowDrawCountDown != null) {
                try {
                    this.mWindowDrawCountDown.await();
                }
                catch (InterruptedException e) {
                    Log.e(this.mTag, "Window redraw count down interrupted!");
                }
                this.mWindowDrawCountDown = null;
            }
            if (this.mAttachInfo.mThreadedRenderer != null) {
                this.mAttachInfo.mThreadedRenderer.setStopped(this.mStopped);
            }
            if (this.mSurfaceHolder != null && this.mSurface.isValid()) {
                SurfaceCallbackHelper sch = new SurfaceCallbackHelper(this::postDrawFinished);
                SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                sch.dispatchSurfaceRedrawNeededAsync(this.mSurfaceHolder, callbacks);
            } else if (!usingAsyncReport) {
                if (this.mAttachInfo.mThreadedRenderer != null) {
                    this.mAttachInfo.mThreadedRenderer.fence();
                }
                this.pendingDrawFinished();
            }
        }
        if (this.mPerformContentCapture) {
            this.performContentCaptureInitialReport();
        }
    }

    private boolean isContentCaptureEnabled() {
        switch (this.mContentCaptureEnabled) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 0: {
                boolean reallyEnabled = this.isContentCaptureReallyEnabled();
                this.mContentCaptureEnabled = reallyEnabled ? 1 : 2;
                return reallyEnabled;
            }
        }
        Log.w(TAG, "isContentCaptureEnabled(): invalid state " + this.mContentCaptureEnabled);
        return false;
    }

    private boolean isContentCaptureReallyEnabled() {
        if (this.mContext.getContentCaptureOptions() == null) {
            return false;
        }
        ContentCaptureManager ccm = this.mAttachInfo.getContentCaptureManager(this.mContext);
        return ccm != null && ccm.isContentCaptureEnabled();
    }

    private void performContentCaptureInitialReport() {
        this.mPerformContentCapture = false;
        View rootView = this.mView;
        if (Trace.isTagEnabled(8L)) {
            Trace.traceBegin(8L, "dispatchContentCapture() for " + this.getClass().getSimpleName());
        }
        try {
            if (!this.isContentCaptureEnabled()) {
                return;
            }
            rootView.dispatchInitialProvideContentCaptureStructure();
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    private void handleContentCaptureFlush() {
        if (Trace.isTagEnabled(8L)) {
            Trace.traceBegin(8L, "flushContentCapture for " + this.getClass().getSimpleName());
        }
        try {
            if (!this.isContentCaptureEnabled()) {
                return;
            }
            ContentCaptureManager ccm = this.mAttachInfo.mContentCaptureManager;
            if (ccm == null) {
                Log.w(TAG, "No ContentCapture on AttachInfo");
                return;
            }
            ccm.flush(2);
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean draw(boolean fullRedrawNeeded) {
        Rect surfaceInsets;
        boolean animating;
        int curScrollY;
        Surface surface = this.mSurface;
        if (!surface.isValid()) {
            return false;
        }
        if (!sFirstDrawComplete) {
            ArrayList<Runnable> arrayList = sFirstDrawHandlers;
            synchronized (arrayList) {
                sFirstDrawComplete = true;
                int count = sFirstDrawHandlers.size();
                for (int i = 0; i < count; ++i) {
                    this.mHandler.post(sFirstDrawHandlers.get(i));
                }
            }
        }
        this.scrollToRectOrFocus(null, false);
        if (this.mAttachInfo.mViewScrollChanged) {
            this.mAttachInfo.mViewScrollChanged = false;
            this.mAttachInfo.mTreeObserver.dispatchOnScrollChanged();
        }
        if (this.mCurScrollY != (curScrollY = (animating = this.mScroller != null && this.mScroller.computeScrollOffset()) ? this.mScroller.getCurrY() : this.mScrollY)) {
            this.mCurScrollY = curScrollY;
            fullRedrawNeeded = true;
            if (this.mView instanceof RootViewSurfaceTaker) {
                ((RootViewSurfaceTaker)((Object)this.mView)).onRootViewScrollYChanged(this.mCurScrollY);
            }
        }
        float appScale = this.mAttachInfo.mApplicationScale;
        boolean scalingRequired = this.mAttachInfo.mScalingRequired;
        Rect dirty = this.mDirty;
        if (this.mSurfaceHolder != null) {
            dirty.setEmpty();
            if (animating && this.mScroller != null) {
                this.mScroller.abortAnimation();
            }
            return false;
        }
        if (fullRedrawNeeded) {
            dirty.set(0, 0, (int)((float)this.mWidth * appScale + 0.5f), (int)((float)this.mHeight * appScale + 0.5f));
        }
        this.mAttachInfo.mTreeObserver.dispatchOnDraw();
        int xOffset = -this.mCanvasOffsetX;
        int yOffset = -this.mCanvasOffsetY + curScrollY;
        WindowManager.LayoutParams params = this.mWindowAttributes;
        Rect rect = surfaceInsets = params != null ? params.surfaceInsets : null;
        if (surfaceInsets != null) {
            xOffset -= surfaceInsets.left;
            yOffset -= surfaceInsets.top;
            dirty.offset(surfaceInsets.left, surfaceInsets.top);
        }
        boolean accessibilityFocusDirty = false;
        Drawable drawable2 = this.mAttachInfo.mAccessibilityFocusDrawable;
        if (drawable2 != null) {
            Rect bounds = this.mAttachInfo.mTmpInvalRect;
            boolean hasFocus = this.getAccessibilityFocusedRect(bounds);
            if (!hasFocus) {
                bounds.setEmpty();
            }
            if (!bounds.equals(drawable2.getBounds())) {
                accessibilityFocusDirty = true;
            }
        }
        this.mAttachInfo.mDrawingTime = this.mChoreographer.getFrameTimeNanos() / 1000000L;
        boolean useAsyncReport = false;
        if (!dirty.isEmpty() || this.mIsAnimating || accessibilityFocusDirty || this.mNextDrawUseBlastSync) {
            if (this.isHardwareEnabled()) {
                boolean invalidateRoot = accessibilityFocusDirty || this.mInvalidateRootRequested;
                this.mInvalidateRootRequested = false;
                this.mIsAnimating = false;
                if (this.mHardwareYOffset != yOffset || this.mHardwareXOffset != xOffset) {
                    this.mHardwareYOffset = yOffset;
                    this.mHardwareXOffset = xOffset;
                    invalidateRoot = true;
                }
                if (invalidateRoot) {
                    this.mAttachInfo.mThreadedRenderer.invalidateRoot();
                }
                dirty.setEmpty();
                boolean updated = this.updateContentDrawBounds();
                if (this.mReportNextDraw) {
                    this.mAttachInfo.mThreadedRenderer.setStopped(false);
                }
                if (updated) {
                    this.requestDrawWindow();
                }
                useAsyncReport = true;
                this.mAttachInfo.mThreadedRenderer.draw(this.mView, this.mAttachInfo, this);
            } else {
                if (this.mAttachInfo.mThreadedRenderer != null && !this.mAttachInfo.mThreadedRenderer.isEnabled() && this.mAttachInfo.mThreadedRenderer.isRequested() && this.mSurface.isValid()) {
                    try {
                        this.mAttachInfo.mThreadedRenderer.initializeIfNeeded(this.mWidth, this.mHeight, this.mAttachInfo, this.mSurface, surfaceInsets);
                    }
                    catch (Surface.OutOfResourcesException e) {
                        this.handleOutOfResourcesException(e);
                        return false;
                    }
                    this.mFullRedrawNeeded = true;
                    this.scheduleTraversals();
                    return false;
                }
                if (!this.drawSoftware(surface, this.mAttachInfo, xOffset, yOffset, scalingRequired, dirty, surfaceInsets)) {
                    return false;
                }
            }
        }
        if (animating) {
            this.mFullRedrawNeeded = true;
            this.scheduleTraversals();
        }
        return useAsyncReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drawSoftware(Surface surface, View.AttachInfo attachInfo, int xoff, int yoff, boolean scalingRequired, Rect dirty, Rect surfaceInsets) {
        Canvas canvas;
        int dirtyXOffset = xoff;
        int dirtyYOffset = yoff;
        if (surfaceInsets != null) {
            dirtyXOffset += surfaceInsets.left;
            dirtyYOffset += surfaceInsets.top;
        }
        try {
            dirty.offset(-dirtyXOffset, -dirtyYOffset);
            int left = dirty.left;
            int top = dirty.top;
            int right = dirty.right;
            int bottom = dirty.bottom;
            canvas = this.mSurface.lockCanvas(dirty);
            canvas.setDensity(this.mDensity);
        }
        catch (Surface.OutOfResourcesException e) {
            this.handleOutOfResourcesException(e);
            boolean bl = false;
            return bl;
        }
        catch (IllegalArgumentException e) {
            Log.e(this.mTag, "Could not lock surface", e);
            this.mLayoutRequested = true;
            boolean bl = false;
            return bl;
        }
        finally {
            dirty.offset(dirtyXOffset, dirtyYOffset);
        }
        try {
            if (!canvas.isOpaque() || yoff != 0 || xoff != 0) {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            }
            dirty.setEmpty();
            this.mIsAnimating = false;
            this.mView.mPrivateFlags |= 0x20;
            canvas.translate(-xoff, -yoff);
            if (this.mTranslator != null) {
                this.mTranslator.translateCanvas(canvas);
            }
            canvas.setScreenDensity(scalingRequired ? this.mNoncompatDensity : 0);
            this.mView.draw(canvas);
            this.drawAccessibilityFocusedDrawableIfNeeded(canvas);
        }
        finally {
            try {
                surface.unlockCanvasAndPost(canvas);
            }
            catch (IllegalArgumentException e) {
                Log.e(this.mTag, "Could not unlock surface", e);
                this.mLayoutRequested = true;
                return false;
            }
        }
        return true;
    }

    private void drawAccessibilityFocusedDrawableIfNeeded(Canvas canvas) {
        Rect bounds = this.mAttachInfo.mTmpInvalRect;
        if (this.getAccessibilityFocusedRect(bounds)) {
            Drawable drawable2 = this.getAccessibilityFocusedDrawable();
            if (drawable2 != null) {
                drawable2.setBounds(bounds);
                drawable2.draw(canvas);
            }
        } else if (this.mAttachInfo.mAccessibilityFocusDrawable != null) {
            this.mAttachInfo.mAccessibilityFocusDrawable.setBounds(0, 0, 0, 0);
        }
    }

    private boolean getAccessibilityFocusedRect(Rect bounds) {
        AccessibilityManager manager = AccessibilityManager.getInstance(this.mView.mContext);
        if (!manager.isEnabled() || !manager.isTouchExplorationEnabled()) {
            return false;
        }
        View host = this.mAccessibilityFocusedHost;
        if (host == null || host.mAttachInfo == null) {
            return false;
        }
        AccessibilityNodeProvider provider = host.getAccessibilityNodeProvider();
        if (provider == null) {
            host.getBoundsOnScreen(bounds, true);
        } else if (this.mAccessibilityFocusedVirtualView != null) {
            this.mAccessibilityFocusedVirtualView.getBoundsInScreen(bounds);
        } else {
            return false;
        }
        View.AttachInfo attachInfo = this.mAttachInfo;
        bounds.offset(0, attachInfo.mViewRootImpl.mScrollY);
        bounds.offset(-attachInfo.mWindowLeft, -attachInfo.mWindowTop);
        if (!bounds.intersect(0, 0, attachInfo.mViewRootImpl.mWidth, attachInfo.mViewRootImpl.mHeight)) {
            bounds.setEmpty();
        }
        return !bounds.isEmpty();
    }

    private Drawable getAccessibilityFocusedDrawable() {
        if (this.mAttachInfo.mAccessibilityFocusDrawable == null) {
            TypedValue value = new TypedValue();
            boolean resolved = this.mView.mContext.getTheme().resolveAttribute(17956871, value, true);
            if (resolved) {
                this.mAttachInfo.mAccessibilityFocusDrawable = this.mView.mContext.getDrawable(value.resourceId);
            }
        }
        if (this.mAttachInfo.mAccessibilityFocusDrawable instanceof GradientDrawable) {
            GradientDrawable drawable2 = (GradientDrawable)this.mAttachInfo.mAccessibilityFocusDrawable;
            drawable2.setStroke(this.mAccessibilityManager.getAccessibilityFocusStrokeWidth(), this.mAccessibilityManager.getAccessibilityFocusColor());
        }
        return this.mAttachInfo.mAccessibilityFocusDrawable;
    }

    void updateSystemGestureExclusionRectsForView(View view) {
        this.mGestureExclusionTracker.updateRectsForView(view);
        this.mHandler.sendEmptyMessage(32);
    }

    void systemGestureExclusionChanged() {
        List<Rect> rectsForWindowManager = this.mGestureExclusionTracker.computeChangedRects();
        if (rectsForWindowManager != null && this.mView != null) {
            try {
                this.mWindowSession.reportSystemGestureExclusionChanged(this.mWindow, rectsForWindowManager);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mAttachInfo.mTreeObserver.dispatchOnSystemGestureExclusionRectsChanged(rectsForWindowManager);
        }
    }

    void updateLocationInParentDisplay(int x, int y) {
        if (this.mAttachInfo != null && !this.mAttachInfo.mLocationInParentDisplay.equals(x, y)) {
            this.mAttachInfo.mLocationInParentDisplay.set(x, y);
        }
    }

    public void setRootSystemGestureExclusionRects(List<Rect> rects) {
        this.mGestureExclusionTracker.setRootSystemGestureExclusionRects(rects);
        this.mHandler.sendEmptyMessage(32);
    }

    public List<Rect> getRootSystemGestureExclusionRects() {
        return this.mGestureExclusionTracker.getRootSystemGestureExclusionRects();
    }

    public void requestInvalidateRootRenderNode() {
        this.mInvalidateRootRequested = true;
    }

    boolean scrollToRectOrFocus(Rect rectangle, boolean immediate) {
        Rect ci = this.mAttachInfo.mContentInsets;
        Rect vi = this.mAttachInfo.mVisibleInsets;
        int scrollY = 0;
        boolean handled = false;
        if (vi.left > ci.left || vi.top > ci.top || vi.right > ci.right || vi.bottom > ci.bottom) {
            View lastScrolledFocus;
            scrollY = this.mScrollY;
            View focus = this.mView.findFocus();
            if (focus == null) {
                return false;
            }
            View view = lastScrolledFocus = this.mLastScrolledFocus != null ? (View)this.mLastScrolledFocus.get() : null;
            if (focus != lastScrolledFocus) {
                rectangle = null;
            }
            if (focus != lastScrolledFocus || this.mScrollMayChange || rectangle != null) {
                this.mLastScrolledFocus = new WeakReference<View>(focus);
                this.mScrollMayChange = false;
                if (focus.getGlobalVisibleRect(this.mVisRect, null)) {
                    if (rectangle == null) {
                        focus.getFocusedRect(this.mTempRect);
                        if (this.mView instanceof ViewGroup) {
                            ((ViewGroup)this.mView).offsetDescendantRectToMyCoords(focus, this.mTempRect);
                        }
                    } else {
                        this.mTempRect.set(rectangle);
                    }
                    if (this.mTempRect.intersect(this.mVisRect)) {
                        if (this.mTempRect.height() <= this.mView.getHeight() - vi.top - vi.bottom) {
                            scrollY = this.mTempRect.top < vi.top ? this.mTempRect.top - vi.top : (this.mTempRect.bottom > this.mView.getHeight() - vi.bottom ? this.mTempRect.bottom - (this.mView.getHeight() - vi.bottom) : 0);
                        }
                        handled = true;
                    }
                }
            }
        }
        if (scrollY != this.mScrollY) {
            if (!immediate) {
                if (this.mScroller == null) {
                    this.mScroller = new Scroller(this.mView.getContext());
                }
                this.mScroller.startScroll(0, this.mScrollY, 0, scrollY - this.mScrollY);
            } else if (this.mScroller != null) {
                this.mScroller.abortAnimation();
            }
            this.mScrollY = scrollY;
        }
        return handled;
    }

    @UnsupportedAppUsage
    public View getAccessibilityFocusedHost() {
        return this.mAccessibilityFocusedHost;
    }

    @UnsupportedAppUsage
    public AccessibilityNodeInfo getAccessibilityFocusedVirtualView() {
        return this.mAccessibilityFocusedVirtualView;
    }

    void setAccessibilityFocus(View view, AccessibilityNodeInfo node) {
        if (this.mAccessibilityFocusedVirtualView != null) {
            AccessibilityNodeInfo focusNode = this.mAccessibilityFocusedVirtualView;
            View focusHost = this.mAccessibilityFocusedHost;
            this.mAccessibilityFocusedHost = null;
            this.mAccessibilityFocusedVirtualView = null;
            focusHost.clearAccessibilityFocusNoCallbacks(64);
            AccessibilityNodeProvider provider = focusHost.getAccessibilityNodeProvider();
            if (provider != null) {
                focusNode.getBoundsInParent(this.mTempRect);
                focusHost.invalidate(this.mTempRect);
                int virtualNodeId = AccessibilityNodeInfo.getVirtualDescendantId(focusNode.getSourceNodeId());
                provider.performAction(virtualNodeId, 128, null);
            }
            focusNode.recycle();
        }
        if (this.mAccessibilityFocusedHost != null && this.mAccessibilityFocusedHost != view) {
            this.mAccessibilityFocusedHost.clearAccessibilityFocusNoCallbacks(64);
        }
        this.mAccessibilityFocusedHost = view;
        this.mAccessibilityFocusedVirtualView = node;
        if (this.mAttachInfo.mThreadedRenderer != null) {
            this.mAttachInfo.mThreadedRenderer.invalidateRoot();
        }
    }

    boolean hasPointerCapture() {
        return this.mPointerCapture;
    }

    void requestPointerCapture(boolean enabled) {
        if (this.mPointerCapture == enabled) {
            return;
        }
        IBinder inputToken = this.getInputToken();
        if (inputToken == null) {
            Log.e(this.mTag, "No input channel to request Pointer Capture.");
            return;
        }
        InputManager.getInstance().requestPointerCapture(inputToken, enabled);
    }

    private void handlePointerCaptureChanged(boolean hasCapture) {
        if (this.mPointerCapture == hasCapture) {
            return;
        }
        this.mPointerCapture = hasCapture;
        if (this.mView != null) {
            this.mView.dispatchPointerCaptureChanged(hasCapture);
        }
    }

    private void updateColorModeIfNeeded(int colorMode) {
        if (this.mAttachInfo.mThreadedRenderer == null) {
            return;
        }
        if (!this.getConfiguration().isScreenWideColorGamut()) {
            colorMode = 0;
        }
        this.mAttachInfo.mThreadedRenderer.setColorMode(colorMode);
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        this.checkThread();
        this.scheduleTraversals();
    }

    @Override
    public void clearChildFocus(View child) {
        this.checkThread();
        this.scheduleTraversals();
    }

    @Override
    public ViewParent getParentForAccessibility() {
        return null;
    }

    @Override
    public void focusableViewAvailable(View v) {
        this.checkThread();
        if (this.mView != null) {
            if (!this.mView.hasFocus()) {
                if (sAlwaysAssignFocus || !this.mAttachInfo.mInTouchMode) {
                    v.requestFocus();
                }
            } else {
                ViewGroup group;
                View focused = this.mView.findFocus();
                if (focused instanceof ViewGroup && (group = (ViewGroup)focused).getDescendantFocusability() == 262144 && ViewRootImpl.isViewDescendantOf(v, focused)) {
                    v.requestFocus();
                }
            }
        }
    }

    @Override
    public void recomputeViewAttributes(View child) {
        this.checkThread();
        if (this.mView == child) {
            this.mAttachInfo.mRecomputeGlobalAttributes = true;
            if (!this.mWillDrawSoon) {
                this.scheduleTraversals();
            }
        }
    }

    void dispatchDetachedFromWindow() {
        this.mInsetsController.onWindowFocusLost();
        this.mFirstInputStage.onDetachedFromWindow();
        if (this.mView != null && this.mView.mAttachInfo != null) {
            this.mAttachInfo.mTreeObserver.dispatchOnWindowAttachedChange(false);
            this.mView.dispatchDetachedFromWindow();
        }
        this.mAccessibilityInteractionConnectionManager.ensureNoConnection();
        this.mAccessibilityManager.removeAccessibilityStateChangeListener(this.mAccessibilityInteractionConnectionManager);
        this.mAccessibilityManager.removeHighTextContrastStateChangeListener(this.mHighContrastTextManager);
        this.removeSendWindowContentChangedCallback();
        this.destroyHardwareRenderer();
        this.setAccessibilityFocus(null, null);
        this.mInsetsController.cancelExistingAnimations();
        this.mView.assignParent(null);
        this.mView = null;
        this.mAttachInfo.mRootView = null;
        this.destroySurface();
        if (this.mInputQueueCallback != null && this.mInputQueue != null) {
            this.mInputQueueCallback.onInputQueueDestroyed(this.mInputQueue);
            this.mInputQueue.dispose();
            this.mInputQueueCallback = null;
            this.mInputQueue = null;
        }
        try {
            this.mWindowSession.remove(this.mWindow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mInputEventReceiver != null) {
            this.mInputEventReceiver.dispose();
            this.mInputEventReceiver = null;
        }
        this.mDisplayManager.unregisterDisplayListener(this.mDisplayListener);
        this.unscheduleTraversals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performConfigurationChange(MergedConfiguration mergedConfiguration, boolean force, int newDisplayId) {
        if (mergedConfiguration == null) {
            throw new IllegalArgumentException("No merged config provided.");
        }
        Configuration globalConfig = mergedConfiguration.getGlobalConfiguration();
        Configuration overrideConfig = mergedConfiguration.getOverrideConfiguration();
        CompatibilityInfo ci = this.mDisplay.getDisplayAdjustments().getCompatibilityInfo();
        if (!ci.equals(CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO)) {
            globalConfig = new Configuration(globalConfig);
            ci.applyToConfiguration(this.mNoncompatDensity, globalConfig);
        }
        ArrayList<ConfigChangedCallback> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            for (int i = sConfigCallbacks.size() - 1; i >= 0; --i) {
                sConfigCallbacks.get(i).onConfigurationChanged(globalConfig);
            }
        }
        this.mLastReportedMergedConfiguration.setConfiguration(globalConfig, overrideConfig);
        this.mForceNextConfigUpdate = force;
        if (this.mActivityConfigCallback != null) {
            this.mActivityConfigCallback.onConfigurationChanged(overrideConfig, newDisplayId);
        } else {
            this.updateConfiguration(newDisplayId);
        }
        this.mForceNextConfigUpdate = false;
    }

    public void updateConfiguration(int newDisplayId) {
        if (this.mView == null) {
            return;
        }
        Resources localResources = this.mView.getResources();
        Configuration config = localResources.getConfiguration();
        if (newDisplayId != -1) {
            this.onMovedToDisplay(newDisplayId, config);
        }
        if (this.mForceNextConfigUpdate || this.mLastConfigurationFromResources.diff(config) != 0) {
            this.updateInternalDisplay(this.mDisplay.getDisplayId(), localResources);
            int lastLayoutDirection = this.mLastConfigurationFromResources.getLayoutDirection();
            int currentLayoutDirection = config.getLayoutDirection();
            this.mLastConfigurationFromResources.setTo(config);
            if (lastLayoutDirection != currentLayoutDirection && this.mViewLayoutDirectionInitial == 2) {
                this.mView.setLayoutDirection(currentLayoutDirection);
            }
            this.mView.dispatchConfigurationChanged(config);
            this.mForceNextWindowRelayout = true;
            this.requestLayout();
        }
        this.updateForceDarkMode();
    }

    public static boolean isViewDescendantOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && ViewRootImpl.isViewDescendantOf((View)((Object)theParent), parent);
    }

    private static void forceLayout(View view) {
        view.forceLayout();
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewRootImpl.forceLayout(group.getChildAt(i));
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    boolean ensureTouchMode(boolean inTouchMode) {
        if (this.mAttachInfo.mInTouchMode == inTouchMode) {
            return false;
        }
        try {
            this.mWindowSession.setInTouchMode(inTouchMode);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return this.ensureTouchModeLocally(inTouchMode);
    }

    private boolean ensureTouchModeLocally(boolean inTouchMode) {
        if (this.mAttachInfo.mInTouchMode == inTouchMode) {
            return false;
        }
        this.mAttachInfo.mInTouchMode = inTouchMode;
        this.mAttachInfo.mTreeObserver.dispatchOnTouchModeChanged(inTouchMode);
        return inTouchMode ? this.enterTouchMode() : this.leaveTouchMode();
    }

    private boolean enterTouchMode() {
        View focused;
        if (this.mView != null && this.mView.hasFocus() && (focused = this.mView.findFocus()) != null && !focused.isFocusableInTouchMode()) {
            ViewGroup ancestorToTakeFocus = ViewRootImpl.findAncestorToTakeFocusInTouchMode(focused);
            if (ancestorToTakeFocus != null) {
                return ancestorToTakeFocus.requestFocus();
            }
            focused.clearFocusInternal(null, true, false);
            return true;
        }
        return false;
    }

    private static ViewGroup findAncestorToTakeFocusInTouchMode(View focused) {
        ViewParent parent = focused.getParent();
        while (parent instanceof ViewGroup) {
            ViewGroup vgParent = (ViewGroup)parent;
            if (vgParent.getDescendantFocusability() == 262144 && vgParent.isFocusableInTouchMode()) {
                return vgParent;
            }
            if (vgParent.isRootNamespace()) {
                return null;
            }
            parent = vgParent.getParent();
        }
        return null;
    }

    private boolean leaveTouchMode() {
        if (this.mView != null) {
            if (this.mView.hasFocus()) {
                View focusedView = this.mView.findFocus();
                if (!(focusedView instanceof ViewGroup)) {
                    return false;
                }
                if (((ViewGroup)focusedView).getDescendantFocusability() != 262144) {
                    return false;
                }
            }
            return this.mView.restoreDefaultFocus();
        }
        return false;
    }

    private void resetPointerIcon(MotionEvent event) {
        this.mPointerIconType = 1;
        this.updatePointerIcon(event);
    }

    private boolean updatePointerIcon(MotionEvent event) {
        int pointerType;
        boolean pointerIndex = false;
        float x = event.getX(0);
        float y = event.getY(0);
        if (this.mView == null) {
            Slog.d(this.mTag, "updatePointerIcon called after view was removed");
            return false;
        }
        if (x < 0.0f || x >= (float)this.mView.getWidth() || y < 0.0f || y >= (float)this.mView.getHeight()) {
            Slog.d(this.mTag, "updatePointerIcon called with position out of bounds");
            return false;
        }
        PointerIcon pointerIcon = this.mView.onResolvePointerIcon(event, 0);
        int n = pointerType = pointerIcon != null ? pointerIcon.getType() : 1000;
        if (this.mPointerIconType != pointerType) {
            this.mPointerIconType = pointerType;
            this.mCustomPointerIcon = null;
            if (this.mPointerIconType != -1) {
                InputManager.getInstance().setPointerIconType(pointerType);
                return true;
            }
        }
        if (this.mPointerIconType == -1 && !pointerIcon.equals(this.mCustomPointerIcon)) {
            this.mCustomPointerIcon = pointerIcon;
            InputManager.getInstance().setCustomPointerIcon(this.mCustomPointerIcon);
        }
        return true;
    }

    private void maybeUpdateTooltip(MotionEvent event) {
        if (event.getPointerCount() != 1) {
            return;
        }
        int action = event.getActionMasked();
        if (action != 9 && action != 7 && action != 10) {
            return;
        }
        AccessibilityManager manager = AccessibilityManager.getInstance(this.mContext);
        if (manager.isEnabled() && manager.isTouchExplorationEnabled()) {
            return;
        }
        if (this.mView == null) {
            Slog.d(this.mTag, "maybeUpdateTooltip called after view was removed");
            return;
        }
        this.mView.dispatchTooltipHoverEvent(event);
    }

    private View getFocusedViewOrNull() {
        return this.mView != null ? this.mView.findFocus() : null;
    }

    private static boolean isNavigationKey(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 61: 
            case 62: 
            case 66: 
            case 92: 
            case 93: 
            case 122: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    private static boolean isTypingKey(KeyEvent keyEvent) {
        return keyEvent.getUnicodeChar() > 0;
    }

    private boolean checkForLeavingTouchModeAndConsume(KeyEvent event) {
        if (!this.mAttachInfo.mInTouchMode) {
            return false;
        }
        int action = event.getAction();
        if (action != 0 && action != 2) {
            return false;
        }
        if ((event.getFlags() & 4) != 0) {
            return false;
        }
        if (ViewRootImpl.isNavigationKey(event)) {
            return this.ensureTouchMode(false);
        }
        if (ViewRootImpl.isTypingKey(event)) {
            this.ensureTouchMode(false);
            return false;
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void setLocalDragState(Object obj) {
        this.mLocalDragState = obj;
    }

    private void handleDragEvent(DragEvent event) {
        if (this.mView != null && this.mAdded) {
            int what = event.mAction;
            if (what == 1) {
                this.mCurrentDragView = null;
                this.mDragDescription = event.mClipDescription;
            } else {
                if (what == 4) {
                    this.mDragDescription = null;
                }
                event.mClipDescription = this.mDragDescription;
            }
            if (what == 6) {
                if (View.sCascadedDragDrop) {
                    this.mView.dispatchDragEnterExitInPreN(event);
                }
                this.setDragFocus(null, event);
            } else {
                if (what == 2 || what == 3) {
                    this.mDragPoint.set(event.mX, event.mY);
                    if (this.mTranslator != null) {
                        this.mTranslator.translatePointInScreenToAppWindow(this.mDragPoint);
                    }
                    if (this.mCurScrollY != 0) {
                        this.mDragPoint.offset(0.0f, this.mCurScrollY);
                    }
                    event.mX = this.mDragPoint.x;
                    event.mY = this.mDragPoint.y;
                }
                View prevDragView = this.mCurrentDragView;
                if (what == 3 && event.mClipData != null) {
                    event.mClipData.prepareToEnterProcess(this.mView.getContext().getAttributionSource());
                }
                boolean result = this.mView.dispatchDragEvent(event);
                if (what == 2 && !event.mEventHandlerWasCalled) {
                    this.setDragFocus(null, event);
                }
                if (prevDragView != this.mCurrentDragView) {
                    try {
                        if (prevDragView != null) {
                            this.mWindowSession.dragRecipientExited(this.mWindow);
                        }
                        if (this.mCurrentDragView != null) {
                            this.mWindowSession.dragRecipientEntered(this.mWindow);
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(this.mTag, "Unable to note drag target change");
                    }
                }
                if (what == 3) {
                    try {
                        Log.i(this.mTag, "Reporting drop result: " + result);
                        this.mWindowSession.reportDropResult(this.mWindow, result);
                    }
                    catch (RemoteException e) {
                        Log.e(this.mTag, "Unable to report drop result");
                    }
                }
                if (what == 4) {
                    this.mCurrentDragView = null;
                    this.setLocalDragState(null);
                    this.mAttachInfo.mDragToken = null;
                    if (this.mAttachInfo.mDragSurface != null) {
                        this.mAttachInfo.mDragSurface.release();
                        this.mAttachInfo.mDragSurface = null;
                    }
                }
            }
        }
        event.recycle();
    }

    public void onWindowTitleChanged() {
        this.mAttachInfo.mForceReportNewAttributes = true;
    }

    public void handleDispatchWindowShown() {
        this.mAttachInfo.mTreeObserver.dispatchOnWindowShown();
    }

    public void handleRequestKeyboardShortcuts(IResultReceiver receiver, int deviceId) {
        Bundle data = new Bundle();
        ArrayList<KeyboardShortcutGroup> list = new ArrayList<KeyboardShortcutGroup>();
        if (this.mView != null) {
            this.mView.requestKeyboardShortcuts(list, deviceId);
        }
        data.putParcelableArrayList("shortcuts_array", list);
        try {
            receiver.send(0, data);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @UnsupportedAppUsage
    public void getLastTouchPoint(Point outLocation) {
        outLocation.x = (int)this.mLastTouchPoint.x;
        outLocation.y = (int)this.mLastTouchPoint.y;
    }

    public int getLastTouchSource() {
        return this.mLastTouchSource;
    }

    public void setDragFocus(View newDragTarget, DragEvent event) {
        if (this.mCurrentDragView != newDragTarget && !View.sCascadedDragDrop) {
            float tx = event.mX;
            float ty = event.mY;
            int action = event.mAction;
            ClipData td = event.mClipData;
            event.mX = 0.0f;
            event.mY = 0.0f;
            event.mClipData = null;
            if (this.mCurrentDragView != null) {
                event.mAction = 6;
                this.mCurrentDragView.callDragEventHandler(event);
            }
            if (newDragTarget != null) {
                event.mAction = 5;
                newDragTarget.callDragEventHandler(event);
            }
            event.mAction = action;
            event.mX = tx;
            event.mY = ty;
            event.mClipData = td;
        }
        this.mCurrentDragView = newDragTarget;
    }

    private AudioManager getAudioManager() {
        if (this.mView == null) {
            throw new IllegalStateException("getAudioManager called when there is no mView");
        }
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mView.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    private AutofillManager getAutofillManager() {
        ViewGroup decorView;
        if (this.mView instanceof ViewGroup && (decorView = (ViewGroup)this.mView).getChildCount() > 0) {
            return decorView.getChildAt(0).getContext().getSystemService(AutofillManager.class);
        }
        return null;
    }

    private boolean isAutofillUiShowing() {
        AutofillManager afm = this.getAutofillManager();
        if (afm == null) {
            return false;
        }
        return afm.isAutofillUiShowing();
    }

    public AccessibilityInteractionController getAccessibilityInteractionController() {
        if (this.mView == null) {
            throw new IllegalStateException("getAccessibilityInteractionController called when there is no mView");
        }
        if (this.mAccessibilityInteractionController == null) {
            this.mAccessibilityInteractionController = new AccessibilityInteractionController(this);
        }
        return this.mAccessibilityInteractionController;
    }

    private int relayoutWindow(WindowManager.LayoutParams params, int viewVisibility, boolean insetsPending) throws RemoteException {
        float appScale = this.mAttachInfo.mApplicationScale;
        boolean restore = false;
        if (params != null && this.mTranslator != null) {
            restore = true;
            params.backup();
            this.mTranslator.translateWindowLayout(params);
        }
        if (params != null && this.mOrigWindowType != params.type && this.mTargetSdkVersion < 14) {
            Slog.w(this.mTag, "Window type can not be changed after the window is added; ignoring change of " + this.mView);
            params.type = this.mOrigWindowType;
        }
        long frameNumber = -1L;
        if (this.mSurface.isValid()) {
            frameNumber = this.mSurface.getNextFrameNumber();
        }
        int relayoutResult = this.mWindowSession.relayout(this.mWindow, params, (int)((float)this.mView.getMeasuredWidth() * appScale + 0.5f), (int)((float)this.mView.getMeasuredHeight() * appScale + 0.5f), viewVisibility, insetsPending ? 1 : 0, frameNumber, this.mTmpFrames, this.mPendingMergedConfiguration, this.mSurfaceControl, this.mTempInsets, this.mTempControls, this.mSurfaceSize);
        this.mPendingBackDropFrame.set(this.mTmpFrames.backdropFrame);
        if (this.mSurfaceControl.isValid()) {
            if (!this.useBLAST()) {
                this.mSurface.copyFrom(this.mSurfaceControl);
            } else {
                Surface blastSurface = this.getOrCreateBLASTSurface();
                if (blastSurface != null) {
                    this.mSurface.transferFrom(blastSurface);
                }
            }
            if (this.mAttachInfo.mThreadedRenderer != null) {
                if (HardwareRenderer.isWebViewOverlaysEnabled()) {
                    this.addPrepareSurfaceControlForWebviewCallback();
                    this.addASurfaceTransactionCallback();
                }
                this.mAttachInfo.mThreadedRenderer.setSurfaceControl(this.mSurfaceControl);
            }
        } else {
            this.destroySurface();
        }
        boolean bl = this.mPendingAlwaysConsumeSystemBars = (relayoutResult & 0x40) != 0;
        if (restore) {
            params.restore();
        }
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWindow(this.mTmpFrames.frame);
            this.mTranslator.translateInsetsStateInScreenToAppWindow(this.mTempInsets);
            this.mTranslator.translateSourceControlsInScreenToAppWindow(this.mTempControls);
        }
        this.setFrame(this.mTmpFrames.frame);
        this.mWillMove = false;
        this.mWillResize = false;
        this.mInsetsController.onStateChanged(this.mTempInsets);
        this.mInsetsController.onControlsChanged(this.mTempControls);
        return relayoutResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOpacity(WindowManager.LayoutParams params, boolean dragResizing, boolean forceUpdate) {
        boolean opaque = false;
        if (!PixelFormat.formatHasAlpha(params.format) && params.surfaceInsets.left == 0 && params.surfaceInsets.top == 0 && params.surfaceInsets.right == 0 && params.surfaceInsets.bottom == 0 && !dragResizing) {
            opaque = true;
        }
        if (!forceUpdate && this.mIsSurfaceOpaque == opaque) {
            return;
        }
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            if (this.mIsForWebviewOverlay) {
                this.mIsSurfaceOpaque = false;
                return;
            }
            this.mTransaction.setOpaque(this.mSurfaceControl, opaque).apply();
        }
        this.mIsSurfaceOpaque = opaque;
    }

    private void setFrame(Rect frame) {
        this.mWinFrame.set(frame);
        this.mInsetsController.onFrameChanged(frame);
    }

    void getDisplayFrame(Rect outFrame) {
        outFrame.set(this.mTmpFrames.displayFrame);
    }

    void getWindowVisibleDisplayFrame(Rect outFrame) {
        outFrame.set(this.mTmpFrames.displayFrame);
        Rect insets = this.mAttachInfo.mVisibleInsets;
        outFrame.left += insets.left;
        outFrame.top += insets.top;
        outFrame.right -= insets.right;
        outFrame.bottom -= insets.bottom;
    }

    @Override
    public void playSoundEffect(int effectId) {
        this.checkThread();
        try {
            AudioManager audioManager = this.getAudioManager();
            if (this.mFastScrollSoundEffectsEnabled && SoundEffectConstants.isNavigationRepeat(effectId)) {
                audioManager.playSoundEffect(SoundEffectConstants.nextNavigationRepeatSoundEffectId());
                return;
            }
            switch (effectId) {
                case 0: {
                    audioManager.playSoundEffect(0);
                    return;
                }
                case 4: 
                case 8: {
                    audioManager.playSoundEffect(2);
                    return;
                }
                case 1: 
                case 5: {
                    audioManager.playSoundEffect(3);
                    return;
                }
                case 3: 
                case 7: {
                    audioManager.playSoundEffect(4);
                    return;
                }
                case 2: 
                case 6: {
                    audioManager.playSoundEffect(1);
                    return;
                }
            }
            throw new IllegalArgumentException("unknown effect id " + effectId + " not defined in " + SoundEffectConstants.class.getCanonicalName());
        }
        catch (IllegalStateException e) {
            Log.e(this.mTag, "FATAL EXCEPTION when attempting to play sound effect: " + e);
            e.printStackTrace();
            return;
        }
    }

    @Override
    public boolean performHapticFeedback(int effectId, boolean always) {
        try {
            return this.mWindowSession.performHapticFeedback(effectId, always);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public View focusSearch(View focused, int direction) {
        this.checkThread();
        if (!(this.mView instanceof ViewGroup)) {
            return null;
        }
        return FocusFinder.getInstance().findNextFocus((ViewGroup)this.mView, focused, direction);
    }

    @Override
    public View keyboardNavigationClusterSearch(View currentCluster, int direction) {
        this.checkThread();
        return FocusFinder.getInstance().findNextKeyboardNavigationCluster(this.mView, currentCluster, direction);
    }

    public void debug() {
        this.mView.debug();
    }

    @GuardedBy(value={"this"})
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, Objects.toString(this.mView));
        proto.write(1120986464258L, this.mDisplay.getDisplayId());
        proto.write(1133871366147L, this.mAppVisible);
        proto.write(0x10500000005L, this.mHeight);
        proto.write(1120986464260L, this.mWidth);
        proto.write(1133871366150L, this.mIsAnimating);
        this.mVisRect.dumpDebug(proto, 1146756268039L);
        proto.write(0x10800000008L, this.mIsDrawing);
        proto.write(1133871366153L, this.mAdded);
        this.mWinFrame.dumpDebug(proto, 1146756268042L);
        proto.write(1138166333452L, Objects.toString(this.mLastWindowInsets));
        proto.write(1138166333453L, InputMethodDebug.softInputModeToString(this.mSoftInputMode));
        proto.write(1120986464270L, this.mScrollY);
        proto.write(1120986464271L, this.mCurScrollY);
        proto.write(0x10800000010L, this.mRemoved);
        this.mWindowAttributes.dumpDebug(proto, 0x10B00000011L);
        proto.end(token);
        this.mInsetsController.dumpDebug(proto, 1146756268036L);
        this.mImeFocusController.dumpDebug(proto, 1146756268039L);
    }

    public void dump(String prefix, PrintWriter writer) {
        String innerPrefix = prefix + "  ";
        writer.println(prefix + "ViewRoot:");
        writer.println(innerPrefix + "mAdded=" + this.mAdded);
        writer.println(innerPrefix + "mRemoved=" + this.mRemoved);
        writer.println(innerPrefix + "mStopped=" + this.mStopped);
        writer.println(innerPrefix + "mPausedForTransition=" + this.mPausedForTransition);
        writer.println(innerPrefix + "mConsumeBatchedInputScheduled=" + this.mConsumeBatchedInputScheduled);
        writer.println(innerPrefix + "mConsumeBatchedInputImmediatelyScheduled=" + this.mConsumeBatchedInputImmediatelyScheduled);
        writer.println(innerPrefix + "mPendingInputEventCount=" + this.mPendingInputEventCount);
        writer.println(innerPrefix + "mProcessInputEventsScheduled=" + this.mProcessInputEventsScheduled);
        writer.println(innerPrefix + "mTraversalScheduled=" + this.mTraversalScheduled);
        if (this.mTraversalScheduled) {
            writer.println(innerPrefix + " (barrier=" + this.mTraversalBarrier + ")");
        }
        writer.println(innerPrefix + "mIsAmbientMode=" + this.mIsAmbientMode);
        writer.println(innerPrefix + "mUnbufferedInputSource=" + Integer.toHexString(this.mUnbufferedInputSource));
        if (this.mAttachInfo != null) {
            writer.print(innerPrefix + "mAttachInfo= ");
            this.mAttachInfo.dump(innerPrefix, writer);
        } else {
            writer.println(innerPrefix + "mAttachInfo=<null>");
        }
        this.mFirstInputStage.dump(innerPrefix, writer);
        if (this.mInputEventReceiver != null) {
            this.mInputEventReceiver.dump(innerPrefix, writer);
        }
        this.mChoreographer.dump(prefix, writer);
        this.mInsetsController.dump(prefix, writer);
        writer.println(prefix + "View Hierarchy:");
        this.dumpViewHierarchy(innerPrefix, writer, this.mView);
    }

    private void dumpViewHierarchy(String prefix, PrintWriter writer, View view) {
        writer.print(prefix);
        if (view == null) {
            writer.println("null");
            return;
        }
        writer.println(view.toString());
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup grp = (ViewGroup)view;
        int N = grp.getChildCount();
        if (N <= 0) {
            return;
        }
        prefix = prefix + "  ";
        for (int i = 0; i < N; ++i) {
            this.dumpViewHierarchy(prefix, writer, grp.getChildAt(i));
        }
    }

    GfxInfo getGfxInfo() {
        GfxInfo info = new GfxInfo();
        if (this.mView != null) {
            ViewRootImpl.appendGfxInfo(this.mView, info);
        }
        return info;
    }

    private static void computeRenderNodeUsage(RenderNode node, GfxInfo info) {
        if (node == null) {
            return;
        }
        info.renderNodeMemoryUsage += node.computeApproximateMemoryUsage();
        info.renderNodeMemoryAllocated += node.computeApproximateMemoryAllocated();
    }

    private static void appendGfxInfo(View view, GfxInfo info) {
        ++info.viewCount;
        ViewRootImpl.computeRenderNodeUsage(view.mRenderNode, info);
        ViewRootImpl.computeRenderNodeUsage(view.mBackgroundRenderNode, info);
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewRootImpl.appendGfxInfo(group.getChildAt(i), info);
            }
        }
    }

    boolean die(boolean immediate) {
        if (immediate && !this.mIsInTraversal) {
            this.doDie();
            return false;
        }
        if (!this.mIsDrawing) {
            this.destroyHardwareRenderer();
        } else {
            Log.e(this.mTag, "Attempting to destroy the window while drawing!\n  window=" + this + ", title=" + this.mWindowAttributes.getTitle());
        }
        this.mHandler.sendEmptyMessage(3);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDie() {
        this.checkThread();
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            if (this.mRemoved) {
                return;
            }
            this.mRemoved = true;
            if (this.mAdded) {
                this.dispatchDetachedFromWindow();
            }
            if (this.mAdded && !this.mFirst) {
                this.destroyHardwareRenderer();
                if (this.mView != null) {
                    boolean viewVisibilityChanged;
                    int viewVisibility = this.mView.getVisibility();
                    boolean bl = viewVisibilityChanged = this.mViewVisibility != viewVisibility;
                    if (this.mWindowAttributesChanged || viewVisibilityChanged) {
                        try {
                            if ((this.relayoutWindow(this.mWindowAttributes, viewVisibility, false) & 2) != 0) {
                                this.mWindowSession.finishDrawing(this.mWindow, null);
                            }
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    this.destroySurface();
                }
            }
            this.mInsetsController.onControlsChanged(null);
            this.mAdded = false;
        }
        WindowManagerGlobal.getInstance().doRemoveView(this);
    }

    public void requestUpdateConfiguration(Configuration config) {
        Message msg = this.mHandler.obtainMessage(18, config);
        this.mHandler.sendMessage(msg);
    }

    public void loadSystemProperties() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                boolean layout2;
                ViewRootImpl.this.mProfileRendering = SystemProperties.getBoolean(ViewRootImpl.PROPERTY_PROFILE_RENDERING, false);
                ViewRootImpl.this.profileRendering(ViewRootImpl.this.mAttachInfo.mHasWindowFocus);
                if (ViewRootImpl.this.mAttachInfo.mThreadedRenderer != null && ViewRootImpl.this.mAttachInfo.mThreadedRenderer.loadSystemProperties()) {
                    ViewRootImpl.this.invalidate();
                }
                if ((layout2 = DisplayProperties.debug_layout().orElse(false).booleanValue()) != ViewRootImpl.this.mAttachInfo.mDebugLayout) {
                    ViewRootImpl.this.mAttachInfo.mDebugLayout = layout2;
                    if (!ViewRootImpl.this.mHandler.hasMessages(22)) {
                        ViewRootImpl.this.mHandler.sendEmptyMessageDelayed(22, 200L);
                    }
                }
            }
        });
    }

    private void destroyHardwareRenderer() {
        ThreadedRenderer hardwareRenderer = this.mAttachInfo.mThreadedRenderer;
        if (hardwareRenderer != null) {
            if (this.mHardwareRendererObserver != null) {
                hardwareRenderer.removeObserver(this.mHardwareRendererObserver);
            }
            if (this.mView != null) {
                hardwareRenderer.destroyHardwareResources(this.mView);
            }
            hardwareRenderer.destroy();
            hardwareRenderer.setRequested(false);
            this.mAttachInfo.mThreadedRenderer = null;
            this.mAttachInfo.mHardwareAccelerated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void dispatchResized(ClientWindowFrames frames, boolean reportDraw, MergedConfiguration mergedConfiguration, boolean forceLayout, boolean alwaysConsumeSystemBars, int displayId) {
        Rect frame = frames.frame;
        Rect backDropFrame = frames.backdropFrame;
        if (this.mDragResizing && this.mUseMTRenderer) {
            boolean fullscreen = frame.equals(backDropFrame);
            ArrayList<WindowCallbacks> arrayList = this.mWindowCallbacks;
            synchronized (arrayList) {
                for (int i = this.mWindowCallbacks.size() - 1; i >= 0; --i) {
                    this.mWindowCallbacks.get(i).onWindowSizeIsChanging(backDropFrame, fullscreen, this.mAttachInfo.mVisibleInsets, this.mAttachInfo.mStableInsets);
                }
            }
        }
        Message msg = this.mHandler.obtainMessage(reportDraw ? 5 : 4);
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWindow(frame);
        }
        SomeArgs args = SomeArgs.obtain();
        boolean sameProcessCall = Binder.getCallingPid() == Process.myPid();
        args.arg1 = sameProcessCall ? new ClientWindowFrames(frames) : frames;
        args.arg2 = sameProcessCall && mergedConfiguration != null ? new MergedConfiguration(mergedConfiguration) : mergedConfiguration;
        args.argi1 = forceLayout ? 1 : 0;
        args.argi2 = alwaysConsumeSystemBars ? 1 : 0;
        args.argi3 = displayId;
        msg.obj = args;
        this.mHandler.sendMessage(msg);
    }

    private void dispatchInsetsChanged(InsetsState insetsState, boolean willMove, boolean willResize) {
        if (Binder.getCallingPid() == Process.myPid()) {
            insetsState = new InsetsState(insetsState, true);
        }
        if (this.mTranslator != null) {
            this.mTranslator.translateInsetsStateInScreenToAppWindow(insetsState);
        }
        if (insetsState != null && insetsState.getSource(19).isVisible()) {
            ImeTracing.getInstance().triggerClientDump("ViewRootImpl#dispatchInsetsChanged", this.getInsetsController().getHost().getInputMethodManager(), null);
        }
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = insetsState;
        args.argi1 = willMove ? 1 : 0;
        args.argi2 = willResize ? 1 : 0;
        this.mHandler.obtainMessage(30, args).sendToTarget();
    }

    private void dispatchInsetsControlChanged(InsetsState insetsState, InsetsSourceControl[] activeControls, boolean willMove, boolean willResize) {
        if (Binder.getCallingPid() == Process.myPid()) {
            insetsState = new InsetsState(insetsState, true);
            if (activeControls != null) {
                for (int i = activeControls.length - 1; i >= 0; --i) {
                    activeControls[i] = new InsetsSourceControl(activeControls[i]);
                }
            }
        }
        if (this.mTranslator != null) {
            this.mTranslator.translateInsetsStateInScreenToAppWindow(insetsState);
            this.mTranslator.translateSourceControlsInScreenToAppWindow(activeControls);
        }
        if (insetsState != null && insetsState.getSource(19).isVisible()) {
            ImeTracing.getInstance().triggerClientDump("ViewRootImpl#dispatchInsetsControlChanged", this.getInsetsController().getHost().getInputMethodManager(), null);
        }
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = insetsState;
        args.arg2 = activeControls;
        args.argi1 = willMove ? 1 : 0;
        args.argi2 = willResize ? 1 : 0;
        this.mHandler.obtainMessage(31, args).sendToTarget();
    }

    private void showInsets(int types, boolean fromIme) {
        this.mHandler.obtainMessage(34, types, fromIme ? 1 : 0).sendToTarget();
    }

    private void hideInsets(int types, boolean fromIme) {
        this.mHandler.obtainMessage(35, types, fromIme ? 1 : 0).sendToTarget();
    }

    public void dispatchMoved(int newX, int newY) {
        if (this.mTranslator != null) {
            PointF point = new PointF(newX, newY);
            this.mTranslator.translatePointInScreenToAppWindow(point);
            newX = (int)((double)point.x + 0.5);
            newY = (int)((double)point.y + 0.5);
        }
        Message msg = this.mHandler.obtainMessage(23, newX, newY);
        this.mHandler.sendMessage(msg);
    }

    private QueuedInputEvent obtainQueuedInputEvent(InputEvent event, InputEventReceiver receiver, int flags) {
        QueuedInputEvent q = this.mQueuedInputEventPool;
        if (q != null) {
            --this.mQueuedInputEventPoolSize;
            this.mQueuedInputEventPool = q.mNext;
            q.mNext = null;
        } else {
            q = new QueuedInputEvent();
        }
        q.mEvent = event;
        q.mReceiver = receiver;
        q.mFlags = flags;
        return q;
    }

    private void recycleQueuedInputEvent(QueuedInputEvent q) {
        q.mEvent = null;
        q.mReceiver = null;
        if (this.mQueuedInputEventPoolSize < 10) {
            ++this.mQueuedInputEventPoolSize;
            q.mNext = this.mQueuedInputEventPool;
            this.mQueuedInputEventPool = q;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void enqueueInputEvent(InputEvent event) {
        this.enqueueInputEvent(event, null, 0, false);
    }

    @UnsupportedAppUsage
    void enqueueInputEvent(InputEvent event, InputEventReceiver receiver, int flags, boolean processImmediately) {
        KeyEvent ke;
        QueuedInputEvent q = this.obtainQueuedInputEvent(event, receiver, flags);
        if (event instanceof MotionEvent) {
            MotionEvent me = (MotionEvent)event;
            if (me.getAction() == 3) {
                EventLog.writeEvent(62002, "Motion - Cancel", this.getTitle());
            }
        } else if (event instanceof KeyEvent && (ke = (KeyEvent)event).isCanceled()) {
            EventLog.writeEvent(62002, "Key - Cancel", this.getTitle());
        }
        QueuedInputEvent last = this.mPendingInputEventTail;
        if (last == null) {
            this.mPendingInputEventHead = q;
            this.mPendingInputEventTail = q;
        } else {
            last.mNext = q;
            this.mPendingInputEventTail = q;
        }
        ++this.mPendingInputEventCount;
        Trace.traceCounter(4L, this.mPendingInputEventQueueLengthCounterName, this.mPendingInputEventCount);
        if (processImmediately) {
            this.doProcessInputEvents();
        } else {
            this.scheduleProcessInputEvents();
        }
    }

    private void scheduleProcessInputEvents() {
        if (!this.mProcessInputEventsScheduled) {
            this.mProcessInputEventsScheduled = true;
            Message msg = this.mHandler.obtainMessage(19);
            msg.setAsynchronous(true);
            this.mHandler.sendMessage(msg);
        }
    }

    void doProcessInputEvents() {
        while (this.mPendingInputEventHead != null) {
            QueuedInputEvent q = this.mPendingInputEventHead;
            this.mPendingInputEventHead = q.mNext;
            if (this.mPendingInputEventHead == null) {
                this.mPendingInputEventTail = null;
            }
            q.mNext = null;
            --this.mPendingInputEventCount;
            Trace.traceCounter(4L, this.mPendingInputEventQueueLengthCounterName, this.mPendingInputEventCount);
            this.mViewFrameInfo.setInputEvent(this.mInputEventAssigner.processEvent(q.mEvent));
            this.deliverInputEvent(q);
        }
        if (this.mProcessInputEventsScheduled) {
            this.mProcessInputEventsScheduled = false;
            this.mHandler.removeMessages(19);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverInputEvent(QueuedInputEvent q) {
        Trace.asyncTraceBegin(8L, "deliverInputEvent", q.mEvent.getId());
        if (Trace.isTagEnabled(8L)) {
            Trace.traceBegin(8L, "deliverInputEvent src=0x" + Integer.toHexString(q.mEvent.getSource()) + " eventTimeNano=" + q.mEvent.getEventTimeNano() + " id=0x" + Integer.toHexString(q.mEvent.getId()));
        }
        try {
            InputStage stage;
            if (this.mInputEventConsistencyVerifier != null) {
                Trace.traceBegin(8L, "verifyEventConsistency");
                try {
                    this.mInputEventConsistencyVerifier.onInputEvent(q.mEvent, 0);
                }
                finally {
                    Trace.traceEnd(8L);
                }
            }
            if (q.shouldSendToSynthesizer()) {
                stage = this.mSyntheticInputStage;
            } else {
                InputStage inputStage = stage = q.shouldSkipIme() ? this.mFirstPostImeInputStage : this.mFirstInputStage;
            }
            if (q.mEvent instanceof KeyEvent) {
                Trace.traceBegin(8L, "preDispatchToUnhandledKeyManager");
                try {
                    this.mUnhandledKeyManager.preDispatch((KeyEvent)q.mEvent);
                }
                finally {
                    Trace.traceEnd(8L);
                }
            }
            if (stage != null) {
                this.handleWindowFocusChanged();
                stage.deliver(q);
            } else {
                this.finishInputEvent(q);
            }
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInputEvent(QueuedInputEvent q) {
        Trace.asyncTraceEnd(8L, "deliverInputEvent", q.mEvent.getId());
        if (q.mReceiver != null) {
            boolean modified;
            boolean handled = (q.mFlags & 8) != 0;
            boolean bl = modified = (q.mFlags & 0x40) != 0;
            if (modified) {
                InputEvent processedEvent;
                Trace.traceBegin(8L, "processInputEventBeforeFinish");
                try {
                    processedEvent = this.mInputCompatProcessor.processInputEventBeforeFinish(q.mEvent);
                }
                finally {
                    Trace.traceEnd(8L);
                }
                if (processedEvent != null) {
                    q.mReceiver.finishInputEvent(processedEvent, handled);
                }
            } else {
                q.mReceiver.finishInputEvent(q.mEvent, handled);
            }
        } else {
            q.mEvent.recycleIfNeededAfterDispatch();
        }
        this.recycleQueuedInputEvent(q);
    }

    static boolean isTerminalInputEvent(InputEvent event) {
        if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            return keyEvent.getAction() == 1;
        }
        MotionEvent motionEvent = (MotionEvent)event;
        int action = motionEvent.getAction();
        return action == 1 || action == 3 || action == 10;
    }

    void scheduleConsumeBatchedInput() {
        if (!this.mConsumeBatchedInputScheduled && !this.mConsumeBatchedInputImmediatelyScheduled) {
            this.mConsumeBatchedInputScheduled = true;
            this.mChoreographer.postCallback(0, this.mConsumedBatchedInputRunnable, null);
        }
    }

    void unscheduleConsumeBatchedInput() {
        if (this.mConsumeBatchedInputScheduled) {
            this.mConsumeBatchedInputScheduled = false;
            this.mChoreographer.removeCallbacks(0, this.mConsumedBatchedInputRunnable, null);
        }
    }

    void scheduleConsumeBatchedInputImmediately() {
        if (!this.mConsumeBatchedInputImmediatelyScheduled) {
            this.unscheduleConsumeBatchedInput();
            this.mConsumeBatchedInputImmediatelyScheduled = true;
            this.mHandler.post(this.mConsumeBatchedInputImmediatelyRunnable);
        }
    }

    boolean doConsumeBatchedInput(long frameTimeNanos) {
        boolean consumedBatches = this.mInputEventReceiver != null ? this.mInputEventReceiver.consumeBatchedInputEvents(frameTimeNanos) : false;
        this.doProcessInputEvents();
        return consumedBatches;
    }

    public void dispatchInvalidateDelayed(View view, long delayMilliseconds) {
        Message msg = this.mHandler.obtainMessage(1, view);
        this.mHandler.sendMessageDelayed(msg, delayMilliseconds);
    }

    public void dispatchInvalidateRectDelayed(View.AttachInfo.InvalidateInfo info, long delayMilliseconds) {
        Message msg = this.mHandler.obtainMessage(2, info);
        this.mHandler.sendMessageDelayed(msg, delayMilliseconds);
    }

    public void dispatchInvalidateOnAnimation(View view) {
        this.mInvalidateOnAnimationRunnable.addView(view);
    }

    public void dispatchInvalidateRectOnAnimation(View.AttachInfo.InvalidateInfo info) {
        this.mInvalidateOnAnimationRunnable.addViewRect(info);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void cancelInvalidate(View view) {
        this.mHandler.removeMessages(1, view);
        this.mHandler.removeMessages(2, view);
        this.mInvalidateOnAnimationRunnable.removeView(view);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void dispatchInputEvent(InputEvent event) {
        this.dispatchInputEvent(event, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void dispatchInputEvent(InputEvent event, InputEventReceiver receiver) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = event;
        args.arg2 = receiver;
        Message msg = this.mHandler.obtainMessage(7, args);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
    }

    public void synthesizeInputEvent(InputEvent event) {
        Message msg = this.mHandler.obtainMessage(24, event);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
    }

    @UnsupportedAppUsage
    public void dispatchKeyFromIme(KeyEvent event) {
        Message msg = this.mHandler.obtainMessage(11, event);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
    }

    public void dispatchKeyFromAutofill(KeyEvent event) {
        Message msg = this.mHandler.obtainMessage(12, event);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
    }

    @UnsupportedAppUsage
    public void dispatchUnhandledInputEvent(InputEvent event) {
        if (event instanceof MotionEvent) {
            event = MotionEvent.obtain((MotionEvent)event);
        }
        this.synthesizeInputEvent(event);
    }

    public void dispatchAppVisibility(boolean visible) {
        Message msg = this.mHandler.obtainMessage(8);
        msg.arg1 = visible ? 1 : 0;
        this.mHandler.sendMessage(msg);
    }

    public void dispatchGetNewSurface() {
        Message msg = this.mHandler.obtainMessage(9);
        this.mHandler.sendMessage(msg);
    }

    public void dispatchLocationInParentDisplayChanged(Point offset) {
        Message msg = this.mHandler.obtainMessage(33, offset.x, offset.y);
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowFocusChanged(boolean hasFocus, boolean inTouchMode) {
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            this.mWindowFocusChanged = true;
            this.mUpcomingWindowFocus = hasFocus;
            this.mUpcomingInTouchMode = inTouchMode;
        }
        Message msg = Message.obtain();
        msg.what = 6;
        this.mHandler.sendMessage(msg);
    }

    public void dispatchWindowShown() {
        this.mHandler.sendEmptyMessage(25);
    }

    public void dispatchCloseSystemDialogs(String reason) {
        Message msg = Message.obtain();
        msg.what = 14;
        msg.obj = reason;
        this.mHandler.sendMessage(msg);
    }

    public void dispatchDragEvent(DragEvent event) {
        int what;
        if (event.getAction() == 2) {
            what = 16;
            this.mHandler.removeMessages(what);
        } else {
            what = 15;
        }
        Message msg = this.mHandler.obtainMessage(what, event);
        this.mHandler.sendMessage(msg);
    }

    public void updatePointerIcon(float x, float y) {
        int what = 27;
        this.mHandler.removeMessages(27);
        long now = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain(0L, now, 7, x, y, 0);
        Message msg = this.mHandler.obtainMessage(27, event);
        this.mHandler.sendMessage(msg);
    }

    public void dispatchCheckFocus() {
        if (!this.mHandler.hasMessages(13)) {
            this.mHandler.sendEmptyMessage(13);
        }
    }

    public void dispatchRequestKeyboardShortcuts(IResultReceiver receiver, int deviceId) {
        this.mHandler.obtainMessage(26, deviceId, 0, receiver).sendToTarget();
    }

    private void dispatchPointerCaptureChanged(boolean on) {
        int what = 28;
        this.mHandler.removeMessages(28);
        Message msg = this.mHandler.obtainMessage(28);
        msg.arg1 = on ? 1 : 0;
        this.mHandler.sendMessage(msg);
    }

    private void postSendWindowContentChangedCallback(View source, int changeType) {
        if (this.mSendWindowContentChangedAccessibilityEvent == null) {
            this.mSendWindowContentChangedAccessibilityEvent = new SendWindowContentChangedAccessibilityEvent();
        }
        this.mSendWindowContentChangedAccessibilityEvent.runOrPost(source, changeType);
    }

    private void removeSendWindowContentChangedCallback() {
        if (this.mSendWindowContentChangedAccessibilityEvent != null) {
            this.mHandler.removeCallbacks(this.mSendWindowContentChangedAccessibilityEvent);
        }
    }

    @Override
    public boolean showContextMenuForChild(View originalView) {
        return false;
    }

    @Override
    public boolean showContextMenuForChild(View originalView, float x, float y) {
        return false;
    }

    @Override
    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback) {
        return null;
    }

    @Override
    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback, int type) {
        return null;
    }

    @Override
    public void createContextMenu(ContextMenu menu2) {
    }

    @Override
    public void childDrawableStateChanged(View child) {
    }

    @Override
    public boolean requestSendAccessibilityEvent(View child, AccessibilityEvent event) {
        if (this.mView == null || this.mStopped || this.mPausedForTransition) {
            return false;
        }
        if (event.getEventType() != 2048 && this.mSendWindowContentChangedAccessibilityEvent != null && this.mSendWindowContentChangedAccessibilityEvent.mSource != null) {
            this.mSendWindowContentChangedAccessibilityEvent.removeCallbacksAndRun();
        }
        int eventType = event.getEventType();
        View source = this.getSourceForAccessibilityEvent(event);
        switch (eventType) {
            case 32768: {
                AccessibilityNodeProvider provider;
                if (source == null || (provider = source.getAccessibilityNodeProvider()) == null) break;
                int virtualNodeId = AccessibilityNodeInfo.getVirtualDescendantId(event.getSourceNodeId());
                AccessibilityNodeInfo node = provider.createAccessibilityNodeInfo(virtualNodeId);
                this.setAccessibilityFocus(source, node);
                break;
            }
            case 65536: {
                if (source == null || source.getAccessibilityNodeProvider() == null) break;
                this.setAccessibilityFocus(null, null);
                break;
            }
            case 2048: {
                this.handleWindowContentChangedEvent(event);
            }
        }
        this.mAccessibilityManager.sendAccessibilityEvent(event);
        return true;
    }

    private View getSourceForAccessibilityEvent(AccessibilityEvent event) {
        long sourceNodeId = event.getSourceNodeId();
        int accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(sourceNodeId);
        return AccessibilityNodeIdManager.getInstance().findView(accessibilityViewId);
    }

    private void handleWindowContentChangedEvent(AccessibilityEvent event) {
        View focusedHost = this.mAccessibilityFocusedHost;
        if (focusedHost == null || this.mAccessibilityFocusedVirtualView == null) {
            return;
        }
        AccessibilityNodeProvider provider = focusedHost.getAccessibilityNodeProvider();
        if (provider == null) {
            this.mAccessibilityFocusedHost = null;
            this.mAccessibilityFocusedVirtualView = null;
            focusedHost.clearAccessibilityFocusNoCallbacks(0);
            return;
        }
        int changes = event.getContentChangeTypes();
        if ((changes & 1) == 0 && changes != 0) {
            return;
        }
        long eventSourceNodeId = event.getSourceNodeId();
        int changedViewId = AccessibilityNodeInfo.getAccessibilityViewId(eventSourceNodeId);
        boolean hostInSubtree = false;
        View root = this.mAccessibilityFocusedHost;
        while (root != null && !hostInSubtree) {
            if (changedViewId == root.getAccessibilityViewId()) {
                hostInSubtree = true;
                continue;
            }
            ViewParent parent = root.getParent();
            if (parent instanceof View) {
                root = (View)((Object)parent);
                continue;
            }
            root = null;
        }
        if (!hostInSubtree) {
            return;
        }
        long focusedSourceNodeId = this.mAccessibilityFocusedVirtualView.getSourceNodeId();
        int focusedChildId = AccessibilityNodeInfo.getVirtualDescendantId(focusedSourceNodeId);
        Rect oldBounds = this.mTempRect;
        this.mAccessibilityFocusedVirtualView.getBoundsInScreen(oldBounds);
        this.mAccessibilityFocusedVirtualView = provider.createAccessibilityNodeInfo(focusedChildId);
        if (this.mAccessibilityFocusedVirtualView == null) {
            this.mAccessibilityFocusedHost = null;
            focusedHost.clearAccessibilityFocusNoCallbacks(0);
            provider.performAction(focusedChildId, AccessibilityNodeInfo.AccessibilityAction.ACTION_CLEAR_ACCESSIBILITY_FOCUS.getId(), null);
            this.invalidateRectOnScreen(oldBounds);
        } else {
            Rect newBounds = this.mAccessibilityFocusedVirtualView.getBoundsInScreen();
            if (!oldBounds.equals(newBounds)) {
                oldBounds.union(newBounds);
                this.invalidateRectOnScreen(oldBounds);
            }
        }
    }

    @Override
    public void notifySubtreeAccessibilityStateChanged(View child, View source, int changeType) {
        this.postSendWindowContentChangedCallback(Preconditions.checkNotNull(source), changeType);
    }

    @Override
    public boolean canResolveLayoutDirection() {
        return true;
    }

    @Override
    public boolean isLayoutDirectionResolved() {
        return true;
    }

    @Override
    public int getLayoutDirection() {
        return 0;
    }

    @Override
    public boolean canResolveTextDirection() {
        return true;
    }

    @Override
    public boolean isTextDirectionResolved() {
        return true;
    }

    @Override
    public int getTextDirection() {
        return 1;
    }

    @Override
    public boolean canResolveTextAlignment() {
        return true;
    }

    @Override
    public boolean isTextAlignmentResolved() {
        return true;
    }

    @Override
    public int getTextAlignment() {
        return 1;
    }

    private View getCommonPredecessor(View first, View second) {
        if (this.mTempHashSet == null) {
            this.mTempHashSet = new HashSet();
        }
        HashSet<View> seen = this.mTempHashSet;
        seen.clear();
        View firstCurrent = first;
        while (firstCurrent != null) {
            seen.add(firstCurrent);
            ViewParent firstCurrentParent = firstCurrent.mParent;
            if (firstCurrentParent instanceof View) {
                firstCurrent = (View)((Object)firstCurrentParent);
                continue;
            }
            firstCurrent = null;
        }
        View secondCurrent = second;
        while (secondCurrent != null) {
            if (seen.contains(secondCurrent)) {
                seen.clear();
                return secondCurrent;
            }
            ViewParent secondCurrentParent = secondCurrent.mParent;
            if (secondCurrentParent instanceof View) {
                secondCurrent = (View)((Object)secondCurrentParent);
                continue;
            }
            secondCurrent = null;
        }
        seen.clear();
        return null;
    }

    void checkThread() {
        if (this.mThread != Thread.currentThread()) {
            throw new CalledFromWrongThreadException("Only the original thread that created a view hierarchy can touch its views.");
        }
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        if (rectangle == null) {
            return this.scrollToRectOrFocus(null, immediate);
        }
        rectangle.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        boolean scrolled = this.scrollToRectOrFocus(rectangle, immediate);
        this.mTempRect.set(rectangle);
        this.mTempRect.offset(0, -this.mCurScrollY);
        this.mTempRect.offset(this.mAttachInfo.mWindowLeft, this.mAttachInfo.mWindowTop);
        try {
            this.mWindowSession.onRectangleOnScreenRequested(this.mWindow, this.mTempRect);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return scrolled;
    }

    @Override
    public void childHasTransientStateChanged(View child, boolean hasTransientState) {
    }

    @Override
    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return false;
    }

    @Override
    public void onStopNestedScroll(View target) {
    }

    @Override
    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
    }

    @Override
    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
    }

    @Override
    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
    }

    @Override
    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    @Override
    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return false;
    }

    @Override
    public boolean onNestedPrePerformAccessibilityAction(View target, int action, Bundle args) {
        return false;
    }

    public void addScrollCaptureCallback(ScrollCaptureCallback callback) {
        if (this.mRootScrollCaptureCallbacks == null) {
            this.mRootScrollCaptureCallbacks = new HashSet();
        }
        this.mRootScrollCaptureCallbacks.add(callback);
    }

    public void removeScrollCaptureCallback(ScrollCaptureCallback callback) {
        if (this.mRootScrollCaptureCallbacks != null) {
            this.mRootScrollCaptureCallbacks.remove(callback);
            if (this.mRootScrollCaptureCallbacks.isEmpty()) {
                this.mRootScrollCaptureCallbacks = null;
            }
        }
    }

    public void dispatchScrollCaptureRequest(IScrollCaptureResponseListener listener) {
        this.mHandler.obtainMessage(36, listener).sendToTarget();
    }

    private void collectRootScrollCaptureTargets(ScrollCaptureSearchResults results) {
        if (this.mRootScrollCaptureCallbacks == null) {
            return;
        }
        for (ScrollCaptureCallback cb : this.mRootScrollCaptureCallbacks) {
            Point offset = new Point(this.mView.getLeft(), this.mView.getTop());
            Rect rect = new Rect(0, 0, this.mView.getWidth(), this.mView.getHeight());
            results.addTarget(new ScrollCaptureTarget(this.mView, rect, offset, cb));
        }
    }

    public void setScrollCaptureRequestTimeout(int timeMillis) {
        this.mScrollCaptureRequestTimeout = timeMillis;
    }

    public long getScrollCaptureRequestTimeout() {
        return this.mScrollCaptureRequestTimeout;
    }

    public void handleScrollCaptureRequest(IScrollCaptureResponseListener listener) {
        ScrollCaptureSearchResults results = new ScrollCaptureSearchResults(this.mContext.getMainExecutor());
        this.collectRootScrollCaptureTargets(results);
        View rootView = this.getView();
        if (rootView != null) {
            Point point = new Point();
            Rect rect = new Rect(0, 0, rootView.getWidth(), rootView.getHeight());
            this.getChildVisibleRect(rootView, rect, point);
            rootView.dispatchScrollCaptureSearch(rect, point, results::addTarget);
        }
        Runnable onComplete = () -> this.dispatchScrollCaptureSearchResponse(listener, results);
        results.setOnCompleteListener(onComplete);
        if (!results.isComplete()) {
            this.mHandler.postDelayed(results::finish, this.getScrollCaptureRequestTimeout());
        }
    }

    private void dispatchScrollCaptureSearchResponse(IScrollCaptureResponseListener listener, ScrollCaptureSearchResults results) {
        ScrollCaptureTarget selectedTarget = results.getTopResult();
        ScrollCaptureResponse.Builder response = new ScrollCaptureResponse.Builder();
        response.setWindowTitle(this.getTitle().toString());
        StringWriter writer = new StringWriter();
        IndentingPrintWriter pw = new IndentingPrintWriter(writer);
        results.dump(pw);
        pw.flush();
        response.addMessage(writer.toString());
        if (selectedTarget == null) {
            response.setDescription("No scrollable targets found in window");
            try {
                listener.onScrollCaptureResponse(response.build());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to send scroll capture search result", e);
            }
            return;
        }
        response.setDescription("Connected");
        Rect boundsInWindow = new Rect();
        View containingView = selectedTarget.getContainingView();
        containingView.getLocationInWindow(this.mAttachInfo.mTmpLocation);
        boundsInWindow.set(selectedTarget.getScrollBounds());
        boundsInWindow.offset(this.mAttachInfo.mTmpLocation[0], this.mAttachInfo.mTmpLocation[1]);
        response.setBoundsInWindow(boundsInWindow);
        Rect boundsOnScreen = new Rect();
        this.mView.getLocationOnScreen(this.mAttachInfo.mTmpLocation);
        boundsOnScreen.set(0, 0, this.mView.getWidth(), this.mView.getHeight());
        boundsOnScreen.offset(this.mAttachInfo.mTmpLocation[0], this.mAttachInfo.mTmpLocation[1]);
        response.setWindowBounds(boundsOnScreen);
        ScrollCaptureConnection connection = new ScrollCaptureConnection(this.mView.getContext().getMainExecutor(), selectedTarget);
        response.setConnection(connection);
        try {
            listener.onScrollCaptureResponse(response.build());
        }
        catch (RemoteException e) {
            connection.close();
        }
    }

    private void reportNextDraw() {
        if (!this.mReportNextDraw) {
            this.drawPending();
        }
        this.mReportNextDraw = true;
    }

    public void setReportNextDraw() {
        this.reportNextDraw();
        this.invalidate();
    }

    void changeCanvasOpacity(boolean opaque) {
        Log.d(this.mTag, "changeCanvasOpacity: opaque=" + opaque);
        opaque &= (this.mView.mPrivateFlags & 0x200) == 0;
        if (this.mAttachInfo.mThreadedRenderer != null) {
            this.mAttachInfo.mThreadedRenderer.setOpaque(opaque);
        }
    }

    public boolean dispatchUnhandledKeyEvent(KeyEvent event) {
        return this.mUnhandledKeyManager.dispatch(this.mView, event);
    }

    static HandlerActionQueue getRunQueue() {
        HandlerActionQueue rq = sRunQueues.get();
        if (rq != null) {
            return rq;
        }
        rq = new HandlerActionQueue();
        sRunQueues.set(rq);
        return rq;
    }

    private void startDragResizing(Rect initialBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets, int resizeMode) {
        if (!this.mDragResizing) {
            this.mDragResizing = true;
            if (this.mUseMTRenderer) {
                for (int i = this.mWindowCallbacks.size() - 1; i >= 0; --i) {
                    this.mWindowCallbacks.get(i).onWindowDragResizeStart(initialBounds, fullscreen, systemInsets, stableInsets, resizeMode);
                }
            }
            this.mFullRedrawNeeded = true;
        }
    }

    private void endDragResizing() {
        if (this.mDragResizing) {
            this.mDragResizing = false;
            if (this.mUseMTRenderer) {
                for (int i = this.mWindowCallbacks.size() - 1; i >= 0; --i) {
                    this.mWindowCallbacks.get(i).onWindowDragResizeEnd();
                }
            }
            this.mFullRedrawNeeded = true;
        }
    }

    private boolean updateContentDrawBounds() {
        boolean updated = false;
        if (this.mUseMTRenderer) {
            for (int i = this.mWindowCallbacks.size() - 1; i >= 0; --i) {
                updated |= this.mWindowCallbacks.get(i).onContentDrawn(this.mWindowAttributes.surfaceInsets.left, this.mWindowAttributes.surfaceInsets.top, this.mWidth, this.mHeight);
            }
        }
        return updated | (this.mDragResizing && this.mReportNextDraw);
    }

    private void requestDrawWindow() {
        if (!this.mUseMTRenderer) {
            return;
        }
        this.mWindowDrawCountDown = new CountDownLatch(this.mWindowCallbacks.size());
        for (int i = this.mWindowCallbacks.size() - 1; i >= 0; --i) {
            this.mWindowCallbacks.get(i).onRequestDraw(this.mReportNextDraw);
        }
    }

    public void reportActivityRelaunched() {
        this.mActivityRelaunched = true;
    }

    public SurfaceControl getSurfaceControl() {
        return this.mSurfaceControl;
    }

    public IBinder getInputToken() {
        if (this.mInputEventReceiver == null) {
            return null;
        }
        return this.mInputEventReceiver.getToken();
    }

    public IBinder getWindowToken() {
        return this.mAttachInfo.mWindowToken;
    }

    public IAccessibilityEmbeddedConnection getAccessibilityEmbeddedConnection() {
        if (this.mAccessibilityEmbeddedConnection == null) {
            this.mAccessibilityEmbeddedConnection = new AccessibilityEmbeddedConnection(this);
        }
        return this.mAccessibilityEmbeddedConnection;
    }

    public void dispatchBlurRegions(float[][] regionCopy, long frameNumber) {
        SurfaceControl surfaceControl = this.getSurfaceControl();
        if (!surfaceControl.isValid()) {
            return;
        }
        SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
        transaction.setBlurRegions(surfaceControl, regionCopy);
        if (this.useBLAST() && this.mBlastBufferQueue != null) {
            this.mBlastBufferQueue.mergeWithNextTransaction(transaction, frameNumber);
        }
    }

    public BackgroundBlurDrawable createBackgroundBlurDrawable() {
        return this.mBlurRegionAggregator.createBackgroundBlurDrawable(this.mContext);
    }

    @Override
    public void onDescendantUnbufferedRequested() {
        this.mUnbufferedInputSource = this.mView.mUnbufferedInputSource;
    }

    void forceDisableBLAST() {
        this.mForceDisableBLAST = true;
    }

    boolean useBLAST() {
        return this.mUseBLASTAdapter && !this.mForceDisableBLAST;
    }

    int getSurfaceSequenceId() {
        return this.mSurfaceSequenceId;
    }

    public void mergeWithNextTransaction(SurfaceControl.Transaction t, long frameNumber) {
        if (this.mBlastBufferQueue != null) {
            this.mBlastBufferQueue.mergeWithNextTransaction(t, frameNumber);
        } else {
            t.apply();
        }
    }

    @Override
    public SurfaceControl.Transaction buildReparentTransaction(SurfaceControl child) {
        if (this.mSurfaceControl.isValid()) {
            return new SurfaceControl.Transaction().reparent(child, this.mSurfaceControl);
        }
        return null;
    }

    @Override
    public boolean applyTransactionOnDraw(SurfaceControl.Transaction t) {
        this.registerRtFrameCallback(frame -> this.mergeWithNextTransaction(t, frame));
        return true;
    }

    int getSurfaceTransformHint() {
        return this.mSurfaceControl.getTransformHint();
    }

    static {
        mResizeInterpolator = new AccelerateDecelerateInterpolator();
    }

    private static class UnhandledKeyManager {
        private boolean mDispatched = true;
        private final SparseArray<WeakReference<View>> mCapturedKeys = new SparseArray();
        private WeakReference<View> mCurrentReceiver = null;

        private UnhandledKeyManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean dispatch(View root, KeyEvent event) {
            View consumer;
            if (this.mDispatched) {
                return false;
            }
            try {
                Trace.traceBegin(8L, "UnhandledKeyEvent dispatch");
                this.mDispatched = true;
                consumer = root.dispatchUnhandledKeyEvent(event);
                if (event.getAction() == 0) {
                    int keycode = event.getKeyCode();
                    if (consumer != null && !KeyEvent.isModifierKey(keycode)) {
                        this.mCapturedKeys.put(keycode, new WeakReference<View>(consumer));
                    }
                }
            }
            finally {
                Trace.traceEnd(8L);
            }
            return consumer != null;
        }

        void preDispatch(KeyEvent event) {
            int idx;
            this.mCurrentReceiver = null;
            if (event.getAction() == 1 && (idx = this.mCapturedKeys.indexOfKey(event.getKeyCode())) >= 0) {
                this.mCurrentReceiver = this.mCapturedKeys.valueAt(idx);
                this.mCapturedKeys.removeAt(idx);
            }
        }

        boolean preViewDispatch(KeyEvent event) {
            this.mDispatched = false;
            if (this.mCurrentReceiver == null) {
                this.mCurrentReceiver = this.mCapturedKeys.get(event.getKeyCode());
            }
            if (this.mCurrentReceiver != null) {
                View target = (View)this.mCurrentReceiver.get();
                if (event.getAction() == 1) {
                    this.mCurrentReceiver = null;
                }
                if (target != null && target.isAttachedToWindow()) {
                    target.onUnhandledKeyEvent(event);
                }
                return true;
            }
            return false;
        }
    }

    private class SendWindowContentChangedAccessibilityEvent
    implements Runnable {
        private int mChangeTypes = 0;
        public View mSource;
        public long mLastEventTimeMillis;
        public StackTraceElement[] mOrigin;

        private SendWindowContentChangedAccessibilityEvent() {
        }

        @Override
        public void run() {
            View source = this.mSource;
            this.mSource = null;
            if (source == null) {
                Log.e(ViewRootImpl.TAG, "Accessibility content change has no source");
                return;
            }
            if (AccessibilityManager.getInstance(ViewRootImpl.this.mContext).isEnabled()) {
                this.mLastEventTimeMillis = SystemClock.uptimeMillis();
                AccessibilityEvent event = AccessibilityEvent.obtain();
                event.setEventType(2048);
                event.setContentChangeTypes(this.mChangeTypes);
                source.sendAccessibilityEventUnchecked(event);
            } else {
                this.mLastEventTimeMillis = 0L;
            }
            source.resetSubtreeAccessibilityStateChanged();
            this.mChangeTypes = 0;
        }

        public void runOrPost(View source, int changeType) {
            long minEventIntevalMillis;
            if (ViewRootImpl.this.mHandler.getLooper() != Looper.myLooper()) {
                CalledFromWrongThreadException e = new CalledFromWrongThreadException("Only the original thread that created a view hierarchy can touch its views.");
                Log.e(ViewRootImpl.TAG, "Accessibility content change on non-UI thread. Future Android versions will throw an exception.", e);
                ViewRootImpl.this.mHandler.removeCallbacks(this);
                if (this.mSource != null) {
                    this.run();
                }
            }
            if (this.mSource != null) {
                View predecessor = ViewRootImpl.this.getCommonPredecessor(this.mSource, source);
                if (predecessor != null) {
                    predecessor = predecessor.getSelfOrParentImportantForA11y();
                }
                this.mSource = predecessor != null ? predecessor : source;
                this.mChangeTypes |= changeType;
                return;
            }
            this.mSource = source;
            this.mChangeTypes = changeType;
            long timeSinceLastMillis = SystemClock.uptimeMillis() - this.mLastEventTimeMillis;
            if (timeSinceLastMillis >= (minEventIntevalMillis = ViewConfiguration.getSendRecurringAccessibilityEventsInterval())) {
                this.removeCallbacksAndRun();
            } else {
                ViewRootImpl.this.mHandler.postDelayed(this, minEventIntevalMillis - timeSinceLastMillis);
            }
        }

        public void removeCallbacksAndRun() {
            ViewRootImpl.this.mHandler.removeCallbacks(this);
            this.run();
        }
    }

    static class AccessibilityInteractionConnection
    extends IAccessibilityInteractionConnection.Stub {
        private final WeakReference<ViewRootImpl> mViewRootImpl;

        AccessibilityInteractionConnection(ViewRootImpl viewRootImpl) {
            this.mViewRootImpl = new WeakReference<ViewRootImpl>(viewRootImpl);
        }

        @Override
        public void findAccessibilityNodeInfoByAccessibilityId(long accessibilityNodeId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec, Bundle args) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfoByAccessibilityIdClientThread(accessibilityNodeId, interactiveRegion, interactionId, callback, flags, interrogatingPid, interrogatingTid, spec, args);
            } else {
                try {
                    callback.setFindAccessibilityNodeInfosResult(null, interactionId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void performAccessibilityAction(long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().performAccessibilityActionClientThread(accessibilityNodeId, action, arguments, interactionId, callback, flags, interrogatingPid, interrogatingTid);
            } else {
                try {
                    callback.setPerformAccessibilityActionResult(false, interactionId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void findAccessibilityNodeInfosByViewId(long accessibilityNodeId, String viewId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfosByViewIdClientThread(accessibilityNodeId, viewId, interactiveRegion, interactionId, callback, flags, interrogatingPid, interrogatingTid, spec);
            } else {
                try {
                    callback.setFindAccessibilityNodeInfoResult(null, interactionId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void findAccessibilityNodeInfosByText(long accessibilityNodeId, String text, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfosByTextClientThread(accessibilityNodeId, text, interactiveRegion, interactionId, callback, flags, interrogatingPid, interrogatingTid, spec);
            } else {
                try {
                    callback.setFindAccessibilityNodeInfosResult(null, interactionId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void findFocus(long accessibilityNodeId, int focusType, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findFocusClientThread(accessibilityNodeId, focusType, interactiveRegion, interactionId, callback, flags, interrogatingPid, interrogatingTid, spec);
            } else {
                try {
                    callback.setFindAccessibilityNodeInfoResult(null, interactionId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void focusSearch(long accessibilityNodeId, int direction, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().focusSearchClientThread(accessibilityNodeId, direction, interactiveRegion, interactionId, callback, flags, interrogatingPid, interrogatingTid, spec);
            } else {
                try {
                    callback.setFindAccessibilityNodeInfoResult(null, interactionId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void clearAccessibilityFocus() {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().clearAccessibilityFocusClientThread();
            }
        }

        @Override
        public void notifyOutsideTouch() {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().notifyOutsideTouchClientThread();
            }
        }
    }

    class HighContrastTextManager
    implements AccessibilityManager.HighTextContrastChangeListener {
        HighContrastTextManager() {
            ThreadedRenderer.setHighContrastText(ViewRootImpl.this.mAccessibilityManager.isHighTextContrastEnabled());
        }

        @Override
        public void onHighTextContrastStateChanged(boolean enabled) {
            ThreadedRenderer.setHighContrastText(enabled);
            ViewRootImpl.this.destroyHardwareResources();
            ViewRootImpl.this.invalidate();
        }
    }

    class AccessibilityInteractionConnectionManager
    implements AccessibilityManager.AccessibilityStateChangeListener {
        AccessibilityInteractionConnectionManager() {
        }

        @Override
        public void onAccessibilityStateChanged(boolean enabled) {
            if (enabled) {
                this.ensureConnection();
                if (ViewRootImpl.this.mAttachInfo.mHasWindowFocus && ViewRootImpl.this.mView != null) {
                    ViewRootImpl.this.mView.sendAccessibilityEvent(32);
                    View focusedView = ViewRootImpl.this.mView.findFocus();
                    if (focusedView != null && focusedView != ViewRootImpl.this.mView) {
                        focusedView.sendAccessibilityEvent(8);
                    }
                }
                if (ViewRootImpl.this.mAttachInfo.mLeashedParentToken != null) {
                    ViewRootImpl.this.mAccessibilityManager.associateEmbeddedHierarchy(ViewRootImpl.this.mAttachInfo.mLeashedParentToken, ViewRootImpl.this.mLeashToken);
                }
            } else {
                this.ensureNoConnection();
                ViewRootImpl.this.mHandler.obtainMessage(21).sendToTarget();
            }
        }

        public void ensureConnection() {
            boolean registered;
            boolean bl = registered = ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId != -1;
            if (!registered) {
                ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId = ViewRootImpl.this.mAccessibilityManager.addAccessibilityInteractionConnection(ViewRootImpl.this.mWindow, ViewRootImpl.this.mLeashToken, ViewRootImpl.this.mContext.getPackageName(), new AccessibilityInteractionConnection(ViewRootImpl.this));
            }
        }

        public void ensureNoConnection() {
            boolean registered;
            boolean bl = registered = ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId != -1;
            if (registered) {
                ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId = -1;
                ViewRootImpl.this.mAccessibilityManager.removeAccessibilityInteractionConnection(ViewRootImpl.this.mWindow);
            }
        }
    }

    public static class CalledFromWrongThreadException
    extends AndroidRuntimeException {
        @UnsupportedAppUsage
        public CalledFromWrongThreadException(String msg) {
            super(msg);
        }
    }

    static class W
    extends IWindow.Stub {
        private final WeakReference<ViewRootImpl> mViewAncestor;
        private final IWindowSession mWindowSession;

        W(ViewRootImpl viewAncestor) {
            this.mViewAncestor = new WeakReference<ViewRootImpl>(viewAncestor);
            this.mWindowSession = viewAncestor.mWindowSession;
        }

        @Override
        public void resized(ClientWindowFrames frames, boolean reportDraw, MergedConfiguration mergedConfiguration, boolean forceLayout, boolean alwaysConsumeSystemBars, int displayId) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchResized(frames, reportDraw, mergedConfiguration, forceLayout, alwaysConsumeSystemBars, displayId);
            }
        }

        @Override
        public void locationInParentDisplayChanged(Point offset) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchLocationInParentDisplayChanged(offset);
            }
        }

        @Override
        public void insetsChanged(InsetsState insetsState, boolean willMove, boolean willResize) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchInsetsChanged(insetsState, willMove, willResize);
            }
        }

        @Override
        public void insetsControlChanged(InsetsState insetsState, InsetsSourceControl[] activeControls, boolean willMove, boolean willResize) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchInsetsControlChanged(insetsState, activeControls, willMove, willResize);
            }
        }

        @Override
        public void showInsets(int types, boolean fromIme) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (fromIme) {
                ImeTracing.getInstance().triggerClientDump("ViewRootImpl.W#showInsets", viewAncestor.getInsetsController().getHost().getInputMethodManager(), null);
            }
            if (viewAncestor != null) {
                viewAncestor.showInsets(types, fromIme);
            }
        }

        @Override
        public void hideInsets(int types, boolean fromIme) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (fromIme) {
                ImeTracing.getInstance().triggerClientDump("ViewRootImpl.W#hideInsets", viewAncestor.getInsetsController().getHost().getInputMethodManager(), null);
            }
            if (viewAncestor != null) {
                viewAncestor.hideInsets(types, fromIme);
            }
        }

        @Override
        public void moved(int newX, int newY) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchMoved(newX, newY);
            }
        }

        @Override
        public void dispatchAppVisibility(boolean visible) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchAppVisibility(visible);
            }
        }

        @Override
        public void dispatchGetNewSurface() {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchGetNewSurface();
            }
        }

        @Override
        public void windowFocusChanged(boolean hasFocus, boolean inTouchMode) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.windowFocusChanged(hasFocus, inTouchMode);
            }
        }

        private static int checkCallingPermission(String permission2) {
            try {
                return ActivityManager.getService().checkPermission(permission2, Binder.getCallingPid(), Binder.getCallingUid());
            }
            catch (RemoteException e) {
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeCommand(String command, String parameters, ParcelFileDescriptor out) {
            View view;
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null && (view = viewAncestor.mView) != null) {
                if (W.checkCallingPermission("android.permission.DUMP") != 0) {
                    throw new SecurityException("Insufficient permissions to invoke executeCommand() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                }
                ParcelFileDescriptor.AutoCloseOutputStream clientStream = null;
                try {
                    clientStream = new ParcelFileDescriptor.AutoCloseOutputStream(out);
                    ViewDebug.dispatchCommand(view, command, parameters, clientStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (clientStream != null) {
                        try {
                            ((OutputStream)clientStream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        @Override
        public void closeSystemDialogs(String reason) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchCloseSystemDialogs(reason);
            }
        }

        @Override
        public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, float zoom, boolean sync) {
            if (sync) {
                try {
                    this.mWindowSession.wallpaperOffsetsComplete(this.asBinder());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) {
            if (sync) {
                try {
                    this.mWindowSession.wallpaperCommandComplete(this.asBinder(), null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void dispatchDragEvent(DragEvent event) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchDragEvent(event);
            }
        }

        @Override
        public void updatePointerIcon(float x, float y) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.updatePointerIcon(x, y);
            }
        }

        @Override
        public void dispatchWindowShown() {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchWindowShown();
            }
        }

        @Override
        public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchRequestKeyboardShortcuts(receiver, deviceId);
            }
        }

        @Override
        public void requestScrollCapture(IScrollCaptureResponseListener listener) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchScrollCaptureRequest(listener);
            }
        }
    }

    class TakenSurfaceHolder
    extends BaseSurfaceHolder {
        TakenSurfaceHolder() {
        }

        @Override
        public boolean onAllowLockCanvas() {
            return ViewRootImpl.this.mDrawingAllowed;
        }

        @Override
        public void onRelayoutContainer() {
        }

        @Override
        public void setFormat(int format) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceFormat(format);
        }

        @Override
        public void setType(int type) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceType(type);
        }

        @Override
        public void onUpdateSurface() {
            throw new IllegalStateException("Shouldn't be here");
        }

        @Override
        public boolean isCreating() {
            return ViewRootImpl.this.mIsCreating;
        }

        @Override
        public void setFixedSize(int width, int height) {
            throw new UnsupportedOperationException("Currently only support sizing from layout");
        }

        @Override
        public void setKeepScreenOn(boolean screenOn) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceKeepScreenOn(screenOn);
        }
    }

    class InvalidateOnAnimationRunnable
    implements Runnable {
        private boolean mPosted;
        private final ArrayList<View> mViews = new ArrayList();
        private final ArrayList<View.AttachInfo.InvalidateInfo> mViewRects = new ArrayList();
        private View[] mTempViews;
        private View.AttachInfo.InvalidateInfo[] mTempViewRects;

        InvalidateOnAnimationRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addView(View view) {
            InvalidateOnAnimationRunnable invalidateOnAnimationRunnable = this;
            synchronized (invalidateOnAnimationRunnable) {
                this.mViews.add(view);
                this.postIfNeededLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addViewRect(View.AttachInfo.InvalidateInfo info) {
            InvalidateOnAnimationRunnable invalidateOnAnimationRunnable = this;
            synchronized (invalidateOnAnimationRunnable) {
                this.mViewRects.add(info);
                this.postIfNeededLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeView(View view) {
            InvalidateOnAnimationRunnable invalidateOnAnimationRunnable = this;
            synchronized (invalidateOnAnimationRunnable) {
                this.mViews.remove(view);
                int i = this.mViewRects.size();
                while (i-- > 0) {
                    View.AttachInfo.InvalidateInfo info = this.mViewRects.get(i);
                    if (info.target != view) continue;
                    this.mViewRects.remove(i);
                    info.recycle();
                }
                if (this.mPosted && this.mViews.isEmpty() && this.mViewRects.isEmpty()) {
                    ViewRootImpl.this.mChoreographer.removeCallbacks(1, this, null);
                    this.mPosted = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i;
            int viewRectCount;
            int viewCount;
            InvalidateOnAnimationRunnable invalidateOnAnimationRunnable = this;
            synchronized (invalidateOnAnimationRunnable) {
                this.mPosted = false;
                viewCount = this.mViews.size();
                if (viewCount != 0) {
                    this.mTempViews = this.mViews.toArray(this.mTempViews != null ? this.mTempViews : new View[viewCount]);
                    this.mViews.clear();
                }
                if ((viewRectCount = this.mViewRects.size()) != 0) {
                    this.mTempViewRects = this.mViewRects.toArray(this.mTempViewRects != null ? this.mTempViewRects : new View.AttachInfo.InvalidateInfo[viewRectCount]);
                    this.mViewRects.clear();
                }
            }
            for (i = 0; i < viewCount; ++i) {
                this.mTempViews[i].invalidate();
                this.mTempViews[i] = null;
            }
            for (i = 0; i < viewRectCount; ++i) {
                View.AttachInfo.InvalidateInfo info = this.mTempViewRects[i];
                info.target.invalidate(info.left, info.top, info.right, info.bottom);
                info.recycle();
            }
        }

        private void postIfNeededLocked() {
            if (!this.mPosted) {
                ViewRootImpl.this.mChoreographer.postCallback(1, this, null);
                this.mPosted = true;
            }
        }
    }

    class ConsumeBatchedInputImmediatelyRunnable
    implements Runnable {
        ConsumeBatchedInputImmediatelyRunnable() {
        }

        @Override
        public void run() {
            ViewRootImpl.this.mConsumeBatchedInputImmediatelyScheduled = false;
            ViewRootImpl.this.doConsumeBatchedInput(-1L);
        }
    }

    class ConsumeBatchedInputRunnable
    implements Runnable {
        ConsumeBatchedInputRunnable() {
        }

        @Override
        public void run() {
            ViewRootImpl.this.mConsumeBatchedInputScheduled = false;
            if (ViewRootImpl.this.doConsumeBatchedInput(ViewRootImpl.this.mChoreographer.getFrameTimeNanos())) {
                ViewRootImpl.this.scheduleConsumeBatchedInput();
            }
        }
    }

    class InputMetricsListener
    implements HardwareRendererObserver.OnFrameMetricsAvailableListener {
        public long[] data = new long[22];

        InputMetricsListener() {
        }

        @Override
        public void onFrameMetricsAvailable(int dropCountSinceLastInvocation) {
            int inputEventId = (int)this.data[4];
            if (inputEventId == 0) {
                return;
            }
            long presentTime = this.data[21];
            if (presentTime <= 0L) {
                return;
            }
            long gpuCompletedTime = this.data[19];
            if (ViewRootImpl.this.mInputEventReceiver == null) {
                return;
            }
            if (gpuCompletedTime >= presentTime) {
                double discrepancyMs = (double)(gpuCompletedTime - presentTime) * 1.0E-6;
                long vsyncId = this.data[1];
                Log.w(ViewRootImpl.TAG, "Not reporting timeline because gpuCompletedTime is " + discrepancyMs + "ms ahead of presentTime. FRAME_TIMELINE_VSYNC_ID=" + vsyncId + ", INPUT_EVENT_ID=" + inputEventId);
                return;
            }
            ViewRootImpl.this.mInputEventReceiver.reportTimeline(inputEventId, gpuCompletedTime, presentTime);
        }
    }

    class WindowInputEventReceiver
    extends InputEventReceiver {
        public WindowInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        @Override
        public void onInputEvent(InputEvent event) {
            List<InputEvent> processedEvents;
            Trace.traceBegin(8L, "processInputEventForCompatibility");
            try {
                processedEvents = ViewRootImpl.this.mInputCompatProcessor.processInputEventForCompatibility(event);
            }
            finally {
                Trace.traceEnd(8L);
            }
            if (processedEvents != null) {
                if (processedEvents.isEmpty()) {
                    this.finishInputEvent(event, true);
                } else {
                    for (int i = 0; i < processedEvents.size(); ++i) {
                        ViewRootImpl.this.enqueueInputEvent(processedEvents.get(i), this, 64, true);
                    }
                }
            } else {
                ViewRootImpl.this.enqueueInputEvent(event, this, 0, true);
            }
        }

        @Override
        public void onBatchedInputEventPending(int source) {
            boolean unbuffered;
            boolean bl = unbuffered = ViewRootImpl.this.mUnbufferedInputDispatch || (source & ViewRootImpl.this.mUnbufferedInputSource) != 0;
            if (unbuffered) {
                if (ViewRootImpl.this.mConsumeBatchedInputScheduled) {
                    ViewRootImpl.this.unscheduleConsumeBatchedInput();
                }
                this.consumeBatchedInputEvents(-1L);
                return;
            }
            ViewRootImpl.this.scheduleConsumeBatchedInput();
        }

        @Override
        public void onFocusEvent(boolean hasFocus, boolean inTouchMode) {
            ViewRootImpl.this.windowFocusChanged(hasFocus, inTouchMode);
        }

        @Override
        public void onPointerCaptureEvent(boolean pointerCaptureEnabled) {
            ViewRootImpl.this.dispatchPointerCaptureChanged(pointerCaptureEnabled);
        }

        @Override
        public void onDragEvent(boolean isExiting, float x, float y) {
            DragEvent event = DragEvent.obtain(isExiting ? 6 : 2, x, y, 0.0f, 0.0f, null, null, null, null, null, false);
            ViewRootImpl.this.dispatchDragEvent(event);
        }

        @Override
        public void dispose() {
            ViewRootImpl.this.unscheduleConsumeBatchedInput();
            super.dispose();
        }
    }

    class TraversalRunnable
    implements Runnable {
        TraversalRunnable() {
        }

        @Override
        public void run() {
            ViewRootImpl.this.doTraversal();
        }
    }

    private static class QueuedInputEvent {
        public static final int FLAG_DELIVER_POST_IME = 1;
        public static final int FLAG_DEFERRED = 2;
        public static final int FLAG_FINISHED = 4;
        public static final int FLAG_FINISHED_HANDLED = 8;
        public static final int FLAG_RESYNTHESIZED = 16;
        public static final int FLAG_UNHANDLED = 32;
        public static final int FLAG_MODIFIED_FOR_COMPATIBILITY = 64;
        public QueuedInputEvent mNext;
        public InputEvent mEvent;
        public InputEventReceiver mReceiver;
        public int mFlags;

        private QueuedInputEvent() {
        }

        public boolean shouldSkipIme() {
            if ((this.mFlags & 1) != 0) {
                return true;
            }
            return this.mEvent instanceof MotionEvent && (this.mEvent.isFromSource(2) || this.mEvent.isFromSource(0x400000));
        }

        public boolean shouldSendToSynthesizer() {
            return (this.mFlags & 0x20) != 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("QueuedInputEvent{flags=");
            boolean hasPrevious = false;
            hasPrevious = this.flagToString("DELIVER_POST_IME", 1, hasPrevious, sb);
            hasPrevious = this.flagToString("DEFERRED", 2, hasPrevious, sb);
            hasPrevious = this.flagToString("FINISHED", 4, hasPrevious, sb);
            hasPrevious = this.flagToString("FINISHED_HANDLED", 8, hasPrevious, sb);
            hasPrevious = this.flagToString("RESYNTHESIZED", 16, hasPrevious, sb);
            if (!(hasPrevious = this.flagToString("UNHANDLED", 32, hasPrevious, sb))) {
                sb.append("0");
            }
            sb.append(", hasNextQueuedEvent=" + (this.mEvent != null ? "true" : "false"));
            sb.append(", hasInputEventReceiver=" + (this.mReceiver != null ? "true" : "false"));
            sb.append(", mEvent=" + this.mEvent + "}");
            return sb.toString();
        }

        private boolean flagToString(String name, int flag, boolean hasPrevious, StringBuilder sb) {
            if ((this.mFlags & flag) != 0) {
                if (hasPrevious) {
                    sb.append("|");
                }
                sb.append(name);
                return true;
            }
            return hasPrevious;
        }
    }

    static class GfxInfo {
        public int viewCount;
        public long renderNodeMemoryUsage;
        public long renderNodeMemoryAllocated;

        GfxInfo() {
        }

        void add(GfxInfo other) {
            this.viewCount += other.viewCount;
            this.renderNodeMemoryUsage += other.renderNodeMemoryUsage;
            this.renderNodeMemoryAllocated += other.renderNodeMemoryAllocated;
        }
    }

    class SyntheticKeyboardHandler {
        SyntheticKeyboardHandler() {
        }

        public void process(KeyEvent event) {
            int metaState;
            int keyCode;
            if ((event.getFlags() & 0x400) != 0) {
                return;
            }
            KeyCharacterMap kcm = event.getKeyCharacterMap();
            KeyCharacterMap.FallbackAction fallbackAction = kcm.getFallbackAction(keyCode = event.getKeyCode(), metaState = event.getMetaState());
            if (fallbackAction != null) {
                int flags = event.getFlags() | 0x400;
                KeyEvent fallbackEvent = KeyEvent.obtain(event.getDownTime(), event.getEventTime(), event.getAction(), fallbackAction.keyCode, event.getRepeatCount(), fallbackAction.metaState, event.getDeviceId(), event.getScanCode(), flags, event.getSource(), null);
                fallbackAction.recycle();
                ViewRootImpl.this.enqueueInputEvent(fallbackEvent);
            }
        }
    }

    class SyntheticTouchNavigationHandler
    extends Handler {
        private static final String LOCAL_TAG = "SyntheticTouchNavigationHandler";
        private static final boolean LOCAL_DEBUG = false;
        private static final float DEFAULT_WIDTH_MILLIMETERS = 48.0f;
        private static final float DEFAULT_HEIGHT_MILLIMETERS = 48.0f;
        private static final int TICK_DISTANCE_MILLIMETERS = 12;
        private static final float MIN_FLING_VELOCITY_TICKS_PER_SECOND = 6.0f;
        private static final float MAX_FLING_VELOCITY_TICKS_PER_SECOND = 20.0f;
        private static final float FLING_TICK_DECAY = 0.8f;
        private int mCurrentDeviceId;
        private int mCurrentSource;
        private boolean mCurrentDeviceSupported;
        private float mConfigTickDistance;
        private float mConfigMinFlingVelocity;
        private float mConfigMaxFlingVelocity;
        private VelocityTracker mVelocityTracker;
        private int mActivePointerId;
        private float mStartX;
        private float mStartY;
        private float mLastX;
        private float mLastY;
        private float mAccumulatedX;
        private float mAccumulatedY;
        private boolean mConsumedMovement;
        private long mPendingKeyDownTime;
        private int mPendingKeyCode;
        private int mPendingKeyRepeatCount;
        private int mPendingKeyMetaState;
        private boolean mFlinging;
        private float mFlingVelocity;
        private final Runnable mFlingRunnable;

        public SyntheticTouchNavigationHandler() {
            super(true);
            this.mCurrentDeviceId = -1;
            this.mActivePointerId = -1;
            this.mPendingKeyCode = 0;
            this.mFlingRunnable = new Runnable(){

                @Override
                public void run() {
                    long time = SystemClock.uptimeMillis();
                    SyntheticTouchNavigationHandler.this.sendKeyDownOrRepeat(time, SyntheticTouchNavigationHandler.this.mPendingKeyCode, SyntheticTouchNavigationHandler.this.mPendingKeyMetaState);
                    SyntheticTouchNavigationHandler.this.mFlingVelocity *= 0.8f;
                    if (!SyntheticTouchNavigationHandler.this.postFling(time)) {
                        SyntheticTouchNavigationHandler.this.mFlinging = false;
                        SyntheticTouchNavigationHandler.this.finishKeys(time);
                    }
                }
            };
        }

        public void process(MotionEvent event) {
            long time = event.getEventTime();
            int deviceId = event.getDeviceId();
            int source = event.getSource();
            if (this.mCurrentDeviceId != deviceId || this.mCurrentSource != source) {
                this.finishKeys(time);
                this.finishTracking(time);
                this.mCurrentDeviceId = deviceId;
                this.mCurrentSource = source;
                this.mCurrentDeviceSupported = false;
                InputDevice device = event.getDevice();
                if (device != null) {
                    InputDevice.MotionRange xRange = device.getMotionRange(0);
                    InputDevice.MotionRange yRange = device.getMotionRange(1);
                    if (xRange != null && yRange != null) {
                        float yRes;
                        this.mCurrentDeviceSupported = true;
                        float xRes = xRange.getResolution();
                        if (xRes <= 0.0f) {
                            xRes = xRange.getRange() / 48.0f;
                        }
                        if ((yRes = yRange.getResolution()) <= 0.0f) {
                            yRes = yRange.getRange() / 48.0f;
                        }
                        float nominalRes = (xRes + yRes) * 0.5f;
                        this.mConfigTickDistance = 12.0f * nominalRes;
                        this.mConfigMinFlingVelocity = 6.0f * this.mConfigTickDistance;
                        this.mConfigMaxFlingVelocity = 20.0f * this.mConfigTickDistance;
                    }
                }
            }
            if (!this.mCurrentDeviceSupported) {
                return;
            }
            int action = event.getActionMasked();
            switch (action) {
                case 0: {
                    boolean caughtFling = this.mFlinging;
                    this.finishKeys(time);
                    this.finishTracking(time);
                    this.mActivePointerId = event.getPointerId(0);
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(event);
                    this.mStartX = event.getX();
                    this.mStartY = event.getY();
                    this.mLastX = this.mStartX;
                    this.mLastY = this.mStartY;
                    this.mAccumulatedX = 0.0f;
                    this.mAccumulatedY = 0.0f;
                    this.mConsumedMovement = caughtFling;
                    break;
                }
                case 1: 
                case 2: {
                    if (this.mActivePointerId < 0) break;
                    int index = event.findPointerIndex(this.mActivePointerId);
                    if (index < 0) {
                        this.finishKeys(time);
                        this.finishTracking(time);
                        break;
                    }
                    this.mVelocityTracker.addMovement(event);
                    float x = event.getX(index);
                    float y = event.getY(index);
                    this.mAccumulatedX += x - this.mLastX;
                    this.mAccumulatedY += y - this.mLastY;
                    this.mLastX = x;
                    this.mLastY = y;
                    int metaState = event.getMetaState();
                    this.consumeAccumulatedMovement(time, metaState);
                    if (action != 1) break;
                    if (this.mConsumedMovement && this.mPendingKeyCode != 0) {
                        this.mVelocityTracker.computeCurrentVelocity(1000, this.mConfigMaxFlingVelocity);
                        float vx = this.mVelocityTracker.getXVelocity(this.mActivePointerId);
                        float vy = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                        if (!this.startFling(time, vx, vy)) {
                            this.finishKeys(time);
                        }
                    }
                    this.finishTracking(time);
                    break;
                }
                case 3: {
                    this.finishKeys(time);
                    this.finishTracking(time);
                }
            }
        }

        public void cancel(MotionEvent event) {
            if (this.mCurrentDeviceId == event.getDeviceId() && this.mCurrentSource == event.getSource()) {
                long time = event.getEventTime();
                this.finishKeys(time);
                this.finishTracking(time);
            }
        }

        private void finishKeys(long time) {
            this.cancelFling();
            this.sendKeyUp(time);
        }

        private void finishTracking(long time) {
            if (this.mActivePointerId >= 0) {
                this.mActivePointerId = -1;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }

        private void consumeAccumulatedMovement(long time, int metaState) {
            float absY;
            float absX = Math.abs(this.mAccumulatedX);
            if (absX >= (absY = Math.abs(this.mAccumulatedY))) {
                if (absX >= this.mConfigTickDistance) {
                    this.mAccumulatedX = this.consumeAccumulatedMovement(time, metaState, this.mAccumulatedX, 21, 22);
                    this.mAccumulatedY = 0.0f;
                    this.mConsumedMovement = true;
                }
            } else if (absY >= this.mConfigTickDistance) {
                this.mAccumulatedY = this.consumeAccumulatedMovement(time, metaState, this.mAccumulatedY, 19, 20);
                this.mAccumulatedX = 0.0f;
                this.mConsumedMovement = true;
            }
        }

        private float consumeAccumulatedMovement(long time, int metaState, float accumulator, int negativeKeyCode, int positiveKeyCode) {
            while (accumulator <= -this.mConfigTickDistance) {
                this.sendKeyDownOrRepeat(time, negativeKeyCode, metaState);
                accumulator += this.mConfigTickDistance;
            }
            while (accumulator >= this.mConfigTickDistance) {
                this.sendKeyDownOrRepeat(time, positiveKeyCode, metaState);
                accumulator -= this.mConfigTickDistance;
            }
            return accumulator;
        }

        private void sendKeyDownOrRepeat(long time, int keyCode, int metaState) {
            if (this.mPendingKeyCode != keyCode) {
                this.sendKeyUp(time);
                this.mPendingKeyDownTime = time;
                this.mPendingKeyCode = keyCode;
                this.mPendingKeyRepeatCount = 0;
            } else {
                ++this.mPendingKeyRepeatCount;
            }
            this.mPendingKeyMetaState = metaState;
            ViewRootImpl.this.enqueueInputEvent(new KeyEvent(this.mPendingKeyDownTime, time, 0, this.mPendingKeyCode, this.mPendingKeyRepeatCount, this.mPendingKeyMetaState, this.mCurrentDeviceId, 1024, this.mCurrentSource));
        }

        private void sendKeyUp(long time) {
            if (this.mPendingKeyCode != 0) {
                ViewRootImpl.this.enqueueInputEvent(new KeyEvent(this.mPendingKeyDownTime, time, 1, this.mPendingKeyCode, 0, this.mPendingKeyMetaState, this.mCurrentDeviceId, 0, 1024, this.mCurrentSource));
                this.mPendingKeyCode = 0;
            }
        }

        private boolean startFling(long time, float vx, float vy) {
            switch (this.mPendingKeyCode) {
                case 21: {
                    if (-vx >= this.mConfigMinFlingVelocity && Math.abs(vy) < this.mConfigMinFlingVelocity) {
                        this.mFlingVelocity = -vx;
                        break;
                    }
                    return false;
                }
                case 22: {
                    if (vx >= this.mConfigMinFlingVelocity && Math.abs(vy) < this.mConfigMinFlingVelocity) {
                        this.mFlingVelocity = vx;
                        break;
                    }
                    return false;
                }
                case 19: {
                    if (-vy >= this.mConfigMinFlingVelocity && Math.abs(vx) < this.mConfigMinFlingVelocity) {
                        this.mFlingVelocity = -vy;
                        break;
                    }
                    return false;
                }
                case 20: {
                    if (vy >= this.mConfigMinFlingVelocity && Math.abs(vx) < this.mConfigMinFlingVelocity) {
                        this.mFlingVelocity = vy;
                        break;
                    }
                    return false;
                }
            }
            this.mFlinging = this.postFling(time);
            return this.mFlinging;
        }

        private boolean postFling(long time) {
            if (this.mFlingVelocity >= this.mConfigMinFlingVelocity) {
                long delay = (long)(this.mConfigTickDistance / this.mFlingVelocity * 1000.0f);
                this.postAtTime(this.mFlingRunnable, time + delay);
                return true;
            }
            return false;
        }

        private void cancelFling() {
            if (this.mFlinging) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlinging = false;
            }
        }
    }

    class SyntheticJoystickHandler
    extends Handler {
        private static final int MSG_ENQUEUE_X_AXIS_KEY_REPEAT = 1;
        private static final int MSG_ENQUEUE_Y_AXIS_KEY_REPEAT = 2;
        private final JoystickAxesState mJoystickAxesState;
        private final SparseArray<KeyEvent> mDeviceKeyEvents;

        public SyntheticJoystickHandler() {
            super(true);
            this.mJoystickAxesState = new JoystickAxesState();
            this.mDeviceKeyEvents = new SparseArray();
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: {
                    if (!ViewRootImpl.this.mAttachInfo.mHasWindowFocus) break;
                    KeyEvent oldEvent = (KeyEvent)msg.obj;
                    KeyEvent e = KeyEvent.changeTimeRepeat(oldEvent, SystemClock.uptimeMillis(), oldEvent.getRepeatCount() + 1);
                    ViewRootImpl.this.enqueueInputEvent(e);
                    Message m = this.obtainMessage(msg.what, e);
                    m.setAsynchronous(true);
                    this.sendMessageDelayed(m, ViewConfiguration.getKeyRepeatDelay());
                }
            }
        }

        public void process(MotionEvent event) {
            switch (event.getActionMasked()) {
                case 3: {
                    this.cancel();
                    break;
                }
                case 2: {
                    this.update(event);
                    break;
                }
                default: {
                    Log.w(ViewRootImpl.this.mTag, "Unexpected action: " + event.getActionMasked());
                }
            }
        }

        private void cancel() {
            this.removeMessages(1);
            this.removeMessages(2);
            for (int i = 0; i < this.mDeviceKeyEvents.size(); ++i) {
                KeyEvent keyEvent = this.mDeviceKeyEvents.valueAt(i);
                if (keyEvent == null) continue;
                ViewRootImpl.this.enqueueInputEvent(KeyEvent.changeTimeRepeat(keyEvent, SystemClock.uptimeMillis(), 0));
            }
            this.mDeviceKeyEvents.clear();
            this.mJoystickAxesState.resetState();
        }

        private void update(MotionEvent event) {
            int historySize = event.getHistorySize();
            for (int h = 0; h < historySize; ++h) {
                long time = event.getHistoricalEventTime(h);
                this.mJoystickAxesState.updateStateForAxis(event, time, 0, event.getHistoricalAxisValue(0, 0, h));
                this.mJoystickAxesState.updateStateForAxis(event, time, 1, event.getHistoricalAxisValue(1, 0, h));
                this.mJoystickAxesState.updateStateForAxis(event, time, 15, event.getHistoricalAxisValue(15, 0, h));
                this.mJoystickAxesState.updateStateForAxis(event, time, 16, event.getHistoricalAxisValue(16, 0, h));
            }
            long time = event.getEventTime();
            this.mJoystickAxesState.updateStateForAxis(event, time, 0, event.getAxisValue(0));
            this.mJoystickAxesState.updateStateForAxis(event, time, 1, event.getAxisValue(1));
            this.mJoystickAxesState.updateStateForAxis(event, time, 15, event.getAxisValue(15));
            this.mJoystickAxesState.updateStateForAxis(event, time, 16, event.getAxisValue(16));
        }

        class JoystickAxesState {
            private static final int STATE_UP_OR_LEFT = -1;
            private static final int STATE_NEUTRAL = 0;
            private static final int STATE_DOWN_OR_RIGHT = 1;
            final int[] mAxisStatesHat = new int[]{0, 0};
            final int[] mAxisStatesStick = new int[]{0, 0};

            JoystickAxesState() {
            }

            void resetState() {
                this.mAxisStatesHat[0] = 0;
                this.mAxisStatesHat[1] = 0;
                this.mAxisStatesStick[0] = 0;
                this.mAxisStatesStick[1] = 0;
            }

            void updateStateForAxis(MotionEvent event, long time, int axis, float value) {
                int keyCode;
                int repeatMessage;
                int axisStateIndex;
                if (this.isXAxis(axis)) {
                    axisStateIndex = 0;
                    repeatMessage = 1;
                } else if (this.isYAxis(axis)) {
                    axisStateIndex = 1;
                    repeatMessage = 2;
                } else {
                    Log.e(ViewRootImpl.this.mTag, "Unexpected axis " + axis + " in updateStateForAxis!");
                    return;
                }
                int newState = this.joystickAxisValueToState(value);
                int currentState = axis == 0 || axis == 1 ? this.mAxisStatesStick[axisStateIndex] : this.mAxisStatesHat[axisStateIndex];
                if (currentState == newState) {
                    return;
                }
                int metaState = event.getMetaState();
                int deviceId = event.getDeviceId();
                int source = event.getSource();
                if (currentState == 1 || currentState == -1) {
                    keyCode = this.joystickAxisAndStateToKeycode(axis, currentState);
                    if (keyCode != 0) {
                        ViewRootImpl.this.enqueueInputEvent(new KeyEvent(time, time, 1, keyCode, 0, metaState, deviceId, 0, 1024, source));
                        SyntheticJoystickHandler.this.mDeviceKeyEvents.put(deviceId, null);
                    }
                    SyntheticJoystickHandler.this.removeMessages(repeatMessage);
                }
                if ((newState == 1 || newState == -1) && (keyCode = this.joystickAxisAndStateToKeycode(axis, newState)) != 0) {
                    KeyEvent keyEvent = new KeyEvent(time, time, 0, keyCode, 0, metaState, deviceId, 0, 1024, source);
                    ViewRootImpl.this.enqueueInputEvent(keyEvent);
                    Message m = SyntheticJoystickHandler.this.obtainMessage(repeatMessage, keyEvent);
                    m.setAsynchronous(true);
                    SyntheticJoystickHandler.this.sendMessageDelayed(m, ViewConfiguration.getKeyRepeatTimeout());
                    SyntheticJoystickHandler.this.mDeviceKeyEvents.put(deviceId, new KeyEvent(time, time, 1, keyCode, 0, metaState, deviceId, 0, 1056, source));
                }
                if (axis == 0 || axis == 1) {
                    this.mAxisStatesStick[axisStateIndex] = newState;
                } else {
                    this.mAxisStatesHat[axisStateIndex] = newState;
                }
            }

            private boolean isXAxis(int axis) {
                return axis == 0 || axis == 15;
            }

            private boolean isYAxis(int axis) {
                return axis == 1 || axis == 16;
            }

            private int joystickAxisAndStateToKeycode(int axis, int state) {
                if (this.isXAxis(axis) && state == -1) {
                    return 21;
                }
                if (this.isXAxis(axis) && state == 1) {
                    return 22;
                }
                if (this.isYAxis(axis) && state == -1) {
                    return 19;
                }
                if (this.isYAxis(axis) && state == 1) {
                    return 20;
                }
                Log.e(ViewRootImpl.this.mTag, "Unknown axis " + axis + " or direction " + state);
                return 0;
            }

            private int joystickAxisValueToState(float value) {
                if (value >= 0.5f) {
                    return 1;
                }
                if (value <= -0.5f) {
                    return -1;
                }
                return 0;
            }
        }
    }

    static class TrackballAxis {
        static final float MAX_ACCELERATION = 20.0f;
        static final long FAST_MOVE_TIME = 150L;
        static final float ACCEL_MOVE_SCALING_FACTOR = 0.025f;
        static final float FIRST_MOVEMENT_THRESHOLD = 0.5f;
        static final float SECOND_CUMULATIVE_MOVEMENT_THRESHOLD = 2.0f;
        static final float SUBSEQUENT_INCREMENTAL_MOVEMENT_THRESHOLD = 1.0f;
        float position;
        float acceleration = 1.0f;
        long lastMoveTime = 0L;
        int step;
        int dir;
        int nonAccelMovement;

        TrackballAxis() {
        }

        void reset(int _step) {
            this.position = 0.0f;
            this.acceleration = 1.0f;
            this.lastMoveTime = 0L;
            this.step = _step;
            this.dir = 0;
        }

        float collect(float off, long time, String axis) {
            long normTime;
            if (off > 0.0f) {
                normTime = (long)(off * 150.0f);
                if (this.dir < 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = 1;
            } else if (off < 0.0f) {
                normTime = (long)(-off * 150.0f);
                if (this.dir > 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = -1;
            } else {
                normTime = 0L;
            }
            if (normTime > 0L) {
                long delta = time - this.lastMoveTime;
                this.lastMoveTime = time;
                float acc = this.acceleration;
                if (delta < normTime) {
                    float scale = (float)(normTime - delta) * 0.025f;
                    if (scale > 1.0f) {
                        acc *= scale;
                    }
                    this.acceleration = acc < 20.0f ? acc : 20.0f;
                } else {
                    float scale = (float)(delta - normTime) * 0.025f;
                    if (scale > 1.0f) {
                        acc /= scale;
                    }
                    this.acceleration = acc > 1.0f ? acc : 1.0f;
                }
            }
            this.position += off;
            return Math.abs(this.position);
        }

        int generate() {
            int movement = 0;
            this.nonAccelMovement = 0;
            block4: while (true) {
                int dir = this.position >= 0.0f ? 1 : -1;
                switch (this.step) {
                    case 0: {
                        if (Math.abs(this.position) < 0.5f) {
                            return movement;
                        }
                        movement += dir;
                        this.nonAccelMovement += dir;
                        this.step = 1;
                        continue block4;
                    }
                    case 1: {
                        if (Math.abs(this.position) < 2.0f) {
                            return movement;
                        }
                        movement += dir;
                        this.nonAccelMovement += dir;
                        this.position -= 2.0f * (float)dir;
                        this.step = 2;
                        continue block4;
                    }
                }
                if (Math.abs(this.position) < 1.0f) {
                    return movement;
                }
                movement += dir;
                this.position -= (float)dir * 1.0f;
                float acc = this.acceleration;
                this.acceleration = (acc *= 1.1f) < 20.0f ? acc : this.acceleration;
            }
        }
    }

    class SyntheticTrackballHandler {
        private final TrackballAxis mX = new TrackballAxis();
        private final TrackballAxis mY = new TrackballAxis();
        private long mLastTime;

        SyntheticTrackballHandler() {
        }

        public void process(MotionEvent event) {
            long curTime = SystemClock.uptimeMillis();
            if (this.mLastTime + 250L < curTime) {
                this.mX.reset(0);
                this.mY.reset(0);
                this.mLastTime = curTime;
            }
            int action = event.getAction();
            int metaState = event.getMetaState();
            switch (action) {
                case 0: {
                    this.mX.reset(2);
                    this.mY.reset(2);
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(curTime, curTime, 0, 23, 0, metaState, -1, 0, 1024, 257));
                    break;
                }
                case 1: {
                    this.mX.reset(2);
                    this.mY.reset(2);
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(curTime, curTime, 1, 23, 0, metaState, -1, 0, 1024, 257));
                }
            }
            float xOff = this.mX.collect(event.getX(), event.getEventTime(), "X");
            float yOff = this.mY.collect(event.getY(), event.getEventTime(), "Y");
            int keycode = 0;
            int movement = 0;
            float accel = 1.0f;
            if (xOff > yOff) {
                movement = this.mX.generate();
                if (movement != 0) {
                    keycode = movement > 0 ? 22 : 21;
                    accel = this.mX.acceleration;
                    this.mY.reset(2);
                }
            } else if (yOff > 0.0f && (movement = this.mY.generate()) != 0) {
                keycode = movement > 0 ? 20 : 19;
                accel = this.mY.acceleration;
                this.mX.reset(2);
            }
            if (keycode != 0) {
                int accelMovement;
                if (movement < 0) {
                    movement = -movement;
                }
                if ((accelMovement = (int)((float)movement * accel)) > movement) {
                    int repeatCount = accelMovement - --movement;
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(curTime, curTime, 2, keycode, repeatCount, metaState, -1, 0, 1024, 257));
                }
                while (movement > 0) {
                    --movement;
                    curTime = SystemClock.uptimeMillis();
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(curTime, curTime, 0, keycode, 0, metaState, -1, 0, 1024, 257));
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(curTime, curTime, 1, keycode, 0, metaState, -1, 0, 1024, 257));
                }
                this.mLastTime = curTime;
            }
        }

        public void cancel() {
            this.mLastTime = Integer.MIN_VALUE;
            if (ViewRootImpl.this.mView != null && ViewRootImpl.this.mAdded) {
                ViewRootImpl.this.ensureTouchMode(false);
            }
        }
    }

    class SyntheticInputStage
    extends InputStage {
        private final SyntheticTrackballHandler mTrackball;
        private final SyntheticJoystickHandler mJoystick;
        private final SyntheticTouchNavigationHandler mTouchNavigation;
        private final SyntheticKeyboardHandler mKeyboard;

        public SyntheticInputStage() {
            super(null);
            this.mTrackball = new SyntheticTrackballHandler();
            this.mJoystick = new SyntheticJoystickHandler();
            this.mTouchNavigation = new SyntheticTouchNavigationHandler();
            this.mKeyboard = new SyntheticKeyboardHandler();
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            q.mFlags |= 0x10;
            if (q.mEvent instanceof MotionEvent) {
                MotionEvent event = (MotionEvent)q.mEvent;
                int source = event.getSource();
                if ((source & 4) != 0) {
                    this.mTrackball.process(event);
                    return 1;
                }
                if ((source & 0x10) != 0) {
                    this.mJoystick.process(event);
                    return 1;
                }
                if ((source & 0x200000) == 0x200000) {
                    this.mTouchNavigation.process(event);
                    return 1;
                }
            } else if ((q.mFlags & 0x20) != 0) {
                this.mKeyboard.process((KeyEvent)q.mEvent);
                return 1;
            }
            return 0;
        }

        @Override
        protected void onDeliverToNext(QueuedInputEvent q) {
            if ((q.mFlags & 0x10) == 0 && q.mEvent instanceof MotionEvent) {
                MotionEvent event = (MotionEvent)q.mEvent;
                int source = event.getSource();
                if ((source & 4) != 0) {
                    this.mTrackball.cancel();
                } else if ((source & 0x10) != 0) {
                    this.mJoystick.cancel();
                } else if ((source & 0x200000) == 0x200000) {
                    this.mTouchNavigation.cancel(event);
                }
            }
            super.onDeliverToNext(q);
        }

        @Override
        protected void onWindowFocusChanged(boolean hasWindowFocus) {
            if (!hasWindowFocus) {
                this.mJoystick.cancel();
            }
        }

        @Override
        protected void onDetachedFromWindow() {
            this.mJoystick.cancel();
        }
    }

    class ViewPostImeInputStage
    extends InputStage {
        public ViewPostImeInputStage(InputStage next) {
            super(next);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            if (q.mEvent instanceof KeyEvent) {
                return this.processKeyEvent(q);
            }
            int source = q.mEvent.getSource();
            if ((source & 2) != 0) {
                return this.processPointerEvent(q);
            }
            if ((source & 4) != 0) {
                return this.processTrackballEvent(q);
            }
            return this.processGenericMotionEvent(q);
        }

        @Override
        protected void onDeliverToNext(QueuedInputEvent q) {
            if (ViewRootImpl.this.mUnbufferedInputDispatch && q.mEvent instanceof MotionEvent && ((MotionEvent)q.mEvent).isTouchEvent() && ViewRootImpl.isTerminalInputEvent(q.mEvent)) {
                ViewRootImpl.this.mUnbufferedInputDispatch = false;
                ViewRootImpl.this.scheduleConsumeBatchedInput();
            }
            super.onDeliverToNext(q);
        }

        private boolean performFocusNavigation(KeyEvent event) {
            int direction = 0;
            switch (event.getKeyCode()) {
                case 21: {
                    if (!event.hasNoModifiers()) break;
                    direction = 17;
                    break;
                }
                case 22: {
                    if (!event.hasNoModifiers()) break;
                    direction = 66;
                    break;
                }
                case 19: {
                    if (!event.hasNoModifiers()) break;
                    direction = 33;
                    break;
                }
                case 20: {
                    if (!event.hasNoModifiers()) break;
                    direction = 130;
                    break;
                }
                case 61: {
                    if (event.hasNoModifiers()) {
                        direction = 2;
                        break;
                    }
                    if (!event.hasModifiers(1)) break;
                    direction = 1;
                }
            }
            if (direction != 0) {
                View focused = ViewRootImpl.this.mView.findFocus();
                if (focused != null) {
                    View v = focused.focusSearch(direction);
                    if (v != null && v != focused) {
                        focused.getFocusedRect(ViewRootImpl.this.mTempRect);
                        if (ViewRootImpl.this.mView instanceof ViewGroup) {
                            ((ViewGroup)ViewRootImpl.this.mView).offsetDescendantRectToMyCoords(focused, ViewRootImpl.this.mTempRect);
                            ((ViewGroup)ViewRootImpl.this.mView).offsetRectIntoDescendantCoords(v, ViewRootImpl.this.mTempRect);
                        }
                        if (v.requestFocus(direction, ViewRootImpl.this.mTempRect)) {
                            boolean isFastScrolling = event.getRepeatCount() > 0;
                            ViewRootImpl.this.playSoundEffect(SoundEffectConstants.getConstantForFocusDirection(direction, isFastScrolling));
                            return true;
                        }
                    }
                    if (ViewRootImpl.this.mView.dispatchUnhandledMove(focused, direction)) {
                        return true;
                    }
                } else if (ViewRootImpl.this.mView.restoreDefaultFocus()) {
                    return true;
                }
            }
            return false;
        }

        private boolean performKeyboardGroupNavigation(int direction) {
            View focused = ViewRootImpl.this.mView.findFocus();
            if (focused == null && ViewRootImpl.this.mView.restoreDefaultFocus()) {
                return true;
            }
            View cluster = focused == null ? ViewRootImpl.this.keyboardNavigationClusterSearch(null, direction) : focused.keyboardNavigationClusterSearch(null, direction);
            int realDirection = direction;
            if (direction == 2 || direction == 1) {
                realDirection = 130;
            }
            if (cluster != null && cluster.isRootNamespace()) {
                if (cluster.restoreFocusNotInCluster()) {
                    ViewRootImpl.this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
                    return true;
                }
                cluster = ViewRootImpl.this.keyboardNavigationClusterSearch(null, direction);
            }
            if (cluster != null && cluster.restoreFocusInCluster(realDirection)) {
                ViewRootImpl.this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
                return true;
            }
            return false;
        }

        private int processKeyEvent(QueuedInputEvent q) {
            KeyEvent event = (KeyEvent)q.mEvent;
            if (ViewRootImpl.this.mUnhandledKeyManager.preViewDispatch(event)) {
                return 1;
            }
            if (ViewRootImpl.this.mView.dispatchKeyEvent(event)) {
                return 1;
            }
            if (this.shouldDropInputEvent(q)) {
                return 2;
            }
            if (ViewRootImpl.this.mUnhandledKeyManager.dispatch(ViewRootImpl.this.mView, event)) {
                return 1;
            }
            int groupNavigationDirection = 0;
            if (event.getAction() == 0 && event.getKeyCode() == 61) {
                if (KeyEvent.metaStateHasModifiers(event.getMetaState(), 65536)) {
                    groupNavigationDirection = 2;
                } else if (KeyEvent.metaStateHasModifiers(event.getMetaState(), 65537)) {
                    groupNavigationDirection = 1;
                }
            }
            if (event.getAction() == 0 && !KeyEvent.metaStateHasNoModifiers(event.getMetaState()) && event.getRepeatCount() == 0 && !KeyEvent.isModifierKey(event.getKeyCode()) && groupNavigationDirection == 0) {
                if (ViewRootImpl.this.mView.dispatchKeyShortcutEvent(event)) {
                    return 1;
                }
                if (this.shouldDropInputEvent(q)) {
                    return 2;
                }
            }
            if (ViewRootImpl.this.mFallbackEventHandler.dispatchKeyEvent(event)) {
                return 1;
            }
            if (this.shouldDropInputEvent(q)) {
                return 2;
            }
            if (event.getAction() == 0 && (groupNavigationDirection != 0 ? this.performKeyboardGroupNavigation(groupNavigationDirection) : this.performFocusNavigation(event))) {
                return 1;
            }
            return 0;
        }

        private int processPointerEvent(QueuedInputEvent q) {
            MotionEvent event = (MotionEvent)q.mEvent;
            ViewRootImpl.this.mAttachInfo.mUnbufferedDispatchRequested = false;
            ViewRootImpl.this.mAttachInfo.mHandlingPointerEvent = true;
            boolean handled = ViewRootImpl.this.mView.dispatchPointerEvent(event);
            this.maybeUpdatePointerIcon(event);
            ViewRootImpl.this.maybeUpdateTooltip(event);
            ViewRootImpl.this.mAttachInfo.mHandlingPointerEvent = false;
            if (ViewRootImpl.this.mAttachInfo.mUnbufferedDispatchRequested && !ViewRootImpl.this.mUnbufferedInputDispatch) {
                ViewRootImpl.this.mUnbufferedInputDispatch = true;
                if (ViewRootImpl.this.mConsumeBatchedInputScheduled) {
                    ViewRootImpl.this.scheduleConsumeBatchedInputImmediately();
                }
            }
            return handled ? 1 : 0;
        }

        private void maybeUpdatePointerIcon(MotionEvent event) {
            if (event.getPointerCount() == 1 && event.isFromSource(8194)) {
                if (event.getActionMasked() == 9 || event.getActionMasked() == 10) {
                    ViewRootImpl.this.mPointerIconType = 1;
                }
                if (event.getActionMasked() != 10 && !ViewRootImpl.this.updatePointerIcon(event) && event.getActionMasked() == 7) {
                    ViewRootImpl.this.mPointerIconType = 1;
                }
            }
        }

        private int processTrackballEvent(QueuedInputEvent q) {
            MotionEvent event = (MotionEvent)q.mEvent;
            if (event.isFromSource(131076) && (!ViewRootImpl.this.hasPointerCapture() || ViewRootImpl.this.mView.dispatchCapturedPointerEvent(event))) {
                return 1;
            }
            if (ViewRootImpl.this.mView.dispatchTrackballEvent(event)) {
                return 1;
            }
            return 0;
        }

        private int processGenericMotionEvent(QueuedInputEvent q) {
            MotionEvent event = (MotionEvent)q.mEvent;
            if (event.isFromSource(0x100008) && ViewRootImpl.this.hasPointerCapture() && ViewRootImpl.this.mView.dispatchCapturedPointerEvent(event)) {
                return 1;
            }
            if (ViewRootImpl.this.mView.dispatchGenericMotionEvent(event)) {
                return 1;
            }
            return 0;
        }
    }

    class NativePostImeInputStage
    extends AsyncInputStage
    implements InputQueue.FinishedInputEventCallback {
        public NativePostImeInputStage(InputStage next, String traceCounter) {
            super(next, traceCounter);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            if (ViewRootImpl.this.mInputQueue != null) {
                ViewRootImpl.this.mInputQueue.sendInputEvent(q.mEvent, q, false, this);
                return 3;
            }
            return 0;
        }

        @Override
        public void onFinishedInputEvent(Object token, boolean handled) {
            QueuedInputEvent q = (QueuedInputEvent)token;
            if (handled) {
                this.finish(q, true);
                return;
            }
            this.forward(q);
        }
    }

    class EarlyPostImeInputStage
    extends InputStage {
        public EarlyPostImeInputStage(InputStage next) {
            super(next);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            if (q.mEvent instanceof KeyEvent) {
                return this.processKeyEvent(q);
            }
            if (q.mEvent instanceof MotionEvent) {
                return this.processMotionEvent(q);
            }
            return 0;
        }

        private int processKeyEvent(QueuedInputEvent q) {
            KeyEvent event = (KeyEvent)q.mEvent;
            if (ViewRootImpl.this.mAttachInfo.mTooltipHost != null) {
                ViewRootImpl.this.mAttachInfo.mTooltipHost.handleTooltipKey(event);
            }
            if (ViewRootImpl.this.checkForLeavingTouchModeAndConsume(event)) {
                return 1;
            }
            ViewRootImpl.this.mFallbackEventHandler.preDispatchKeyEvent(event);
            return 0;
        }

        private int processMotionEvent(QueuedInputEvent q) {
            MotionEvent event = (MotionEvent)q.mEvent;
            if (event.isFromSource(2)) {
                return this.processPointerEvent(q);
            }
            int action = event.getActionMasked();
            if ((action == 0 || action == 8) && event.isFromSource(8)) {
                ViewRootImpl.this.ensureTouchMode(false);
            }
            return 0;
        }

        private int processPointerEvent(QueuedInputEvent q) {
            AutofillManager afm;
            int action;
            MotionEvent event = (MotionEvent)q.mEvent;
            if (ViewRootImpl.this.mTranslator != null) {
                ViewRootImpl.this.mTranslator.translateEventInScreenToAppWindow(event);
            }
            if ((action = event.getAction()) == 0 || action == 8) {
                ViewRootImpl.this.ensureTouchMode(true);
            }
            if (action == 0 && (afm = ViewRootImpl.this.getAutofillManager()) != null) {
                afm.requestHideFillUi();
            }
            if (action == 0 && ViewRootImpl.this.mAttachInfo.mTooltipHost != null) {
                ViewRootImpl.this.mAttachInfo.mTooltipHost.hideTooltip();
            }
            if (ViewRootImpl.this.mCurScrollY != 0) {
                event.offsetLocation(0.0f, ViewRootImpl.this.mCurScrollY);
            }
            if (event.isTouchEvent()) {
                ViewRootImpl.this.mLastTouchPoint.x = event.getRawX();
                ViewRootImpl.this.mLastTouchPoint.y = event.getRawY();
                ViewRootImpl.this.mLastTouchSource = event.getSource();
            }
            return 0;
        }
    }

    class ImeInputStage
    extends AsyncInputStage
    implements InputMethodManager.FinishedInputEventCallback {
        public ImeInputStage(InputStage next, String traceCounter) {
            super(next, traceCounter);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            int result = ViewRootImpl.this.mImeFocusController.onProcessImeInputStage(q, q.mEvent, ViewRootImpl.this.mWindowAttributes, this);
            switch (result) {
                case -1: {
                    return 3;
                }
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            throw new IllegalStateException("Unexpected result=" + result);
        }

        @Override
        public void onFinishedInputEvent(Object token, boolean handled) {
            QueuedInputEvent q = (QueuedInputEvent)token;
            if (handled) {
                this.finish(q, true);
                return;
            }
            this.forward(q);
        }
    }

    class ViewPreImeInputStage
    extends InputStage {
        public ViewPreImeInputStage(InputStage next) {
            super(next);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            if (q.mEvent instanceof KeyEvent) {
                return this.processKeyEvent(q);
            }
            return 0;
        }

        private int processKeyEvent(QueuedInputEvent q) {
            KeyEvent event = (KeyEvent)q.mEvent;
            if (ViewRootImpl.this.mView.dispatchKeyEventPreIme(event)) {
                return 1;
            }
            return 0;
        }
    }

    class NativePreImeInputStage
    extends AsyncInputStage
    implements InputQueue.FinishedInputEventCallback {
        public NativePreImeInputStage(InputStage next, String traceCounter) {
            super(next, traceCounter);
        }

        @Override
        protected int onProcess(QueuedInputEvent q) {
            if (ViewRootImpl.this.mInputQueue != null && q.mEvent instanceof KeyEvent) {
                ViewRootImpl.this.mInputQueue.sendInputEvent(q.mEvent, q, true, this);
                return 3;
            }
            return 0;
        }

        @Override
        public void onFinishedInputEvent(Object token, boolean handled) {
            QueuedInputEvent q = (QueuedInputEvent)token;
            if (handled) {
                this.finish(q, true);
                return;
            }
            this.forward(q);
        }
    }

    abstract class AsyncInputStage
    extends InputStage {
        private final String mTraceCounter;
        private QueuedInputEvent mQueueHead;
        private QueuedInputEvent mQueueTail;
        private int mQueueLength;
        protected static final int DEFER = 3;

        public AsyncInputStage(InputStage next, String traceCounter) {
            super(next);
            this.mTraceCounter = traceCounter;
        }

        protected void defer(QueuedInputEvent q) {
            q.mFlags |= 2;
            this.enqueue(q);
        }

        @Override
        protected void forward(QueuedInputEvent q) {
            q.mFlags &= 0xFFFFFFFD;
            QueuedInputEvent curr = this.mQueueHead;
            if (curr == null) {
                super.forward(q);
                return;
            }
            int deviceId = q.mEvent.getDeviceId();
            QueuedInputEvent prev = null;
            boolean blocked = false;
            while (curr != null && curr != q) {
                if (!blocked && deviceId == curr.mEvent.getDeviceId()) {
                    blocked = true;
                }
                prev = curr;
                curr = curr.mNext;
            }
            if (blocked) {
                if (curr == null) {
                    this.enqueue(q);
                }
                return;
            }
            if (curr != null) {
                curr = curr.mNext;
                this.dequeue(q, prev);
            }
            super.forward(q);
            while (curr != null) {
                if (deviceId == curr.mEvent.getDeviceId()) {
                    if ((curr.mFlags & 2) != 0) break;
                    QueuedInputEvent next = curr.mNext;
                    this.dequeue(curr, prev);
                    super.forward(curr);
                    curr = next;
                    continue;
                }
                prev = curr;
                curr = curr.mNext;
            }
        }

        @Override
        protected void apply(QueuedInputEvent q, int result) {
            if (result == 3) {
                this.defer(q);
            } else {
                super.apply(q, result);
            }
        }

        private void enqueue(QueuedInputEvent q) {
            if (this.mQueueTail == null) {
                this.mQueueHead = q;
                this.mQueueTail = q;
            } else {
                this.mQueueTail.mNext = q;
                this.mQueueTail = q;
            }
            ++this.mQueueLength;
            Trace.traceCounter(4L, this.mTraceCounter, this.mQueueLength);
        }

        private void dequeue(QueuedInputEvent q, QueuedInputEvent prev) {
            if (prev == null) {
                this.mQueueHead = q.mNext;
            } else {
                prev.mNext = q.mNext;
            }
            if (this.mQueueTail == q) {
                this.mQueueTail = prev;
            }
            q.mNext = null;
            --this.mQueueLength;
            Trace.traceCounter(4L, this.mTraceCounter, this.mQueueLength);
        }

        @Override
        void dump(String prefix, PrintWriter writer) {
            writer.print(prefix);
            writer.print(this.getClass().getName());
            writer.print(": mQueueLength=");
            writer.println(this.mQueueLength);
            super.dump(prefix, writer);
        }
    }

    abstract class InputStage {
        private final InputStage mNext;
        protected static final int FORWARD = 0;
        protected static final int FINISH_HANDLED = 1;
        protected static final int FINISH_NOT_HANDLED = 2;
        private String mTracePrefix;

        public InputStage(InputStage next) {
            this.mNext = next;
        }

        public void deliver(QueuedInputEvent q) {
            if ((q.mFlags & 4) != 0) {
                this.forward(q);
            } else if (this.shouldDropInputEvent(q)) {
                this.finish(q, false);
            } else {
                int result;
                this.traceEvent(q, 8L);
                try {
                    result = this.onProcess(q);
                }
                finally {
                    Trace.traceEnd(8L);
                }
                this.apply(q, result);
            }
        }

        protected void finish(QueuedInputEvent q, boolean handled) {
            q.mFlags |= 4;
            if (handled) {
                q.mFlags |= 8;
            }
            this.forward(q);
        }

        protected void forward(QueuedInputEvent q) {
            this.onDeliverToNext(q);
        }

        protected void apply(QueuedInputEvent q, int result) {
            if (result == 0) {
                this.forward(q);
            } else if (result == 1) {
                this.finish(q, true);
            } else if (result == 2) {
                this.finish(q, false);
            } else {
                throw new IllegalArgumentException("Invalid result: " + result);
            }
        }

        protected int onProcess(QueuedInputEvent q) {
            return 0;
        }

        protected void onDeliverToNext(QueuedInputEvent q) {
            if (this.mNext != null) {
                this.mNext.deliver(q);
            } else {
                ViewRootImpl.this.finishInputEvent(q);
            }
        }

        protected void onWindowFocusChanged(boolean hasWindowFocus) {
            if (this.mNext != null) {
                this.mNext.onWindowFocusChanged(hasWindowFocus);
            }
        }

        protected void onDetachedFromWindow() {
            if (this.mNext != null) {
                this.mNext.onDetachedFromWindow();
            }
        }

        protected boolean shouldDropInputEvent(QueuedInputEvent q) {
            String reason;
            if (ViewRootImpl.this.mView == null || !ViewRootImpl.this.mAdded) {
                Slog.w(ViewRootImpl.this.mTag, "Dropping event due to root view being removed: " + q.mEvent);
                return true;
            }
            if (!(ViewRootImpl.this.mAttachInfo.mHasWindowFocus || q.mEvent.isFromSource(2) || ViewRootImpl.this.isAutofillUiShowing())) {
                reason = "no window focus";
            } else if (ViewRootImpl.this.mStopped) {
                reason = "window is stopped";
            } else if (ViewRootImpl.this.mIsAmbientMode && !q.mEvent.isFromSource(1)) {
                reason = "non-button event in ambient mode";
            } else if (ViewRootImpl.this.mPausedForTransition && !this.isBack(q.mEvent)) {
                reason = "paused for transition";
            } else {
                return false;
            }
            if (ViewRootImpl.isTerminalInputEvent(q.mEvent)) {
                q.mEvent.cancel();
                Slog.w(ViewRootImpl.this.mTag, "Cancelling event (" + reason + "):" + q.mEvent);
                return false;
            }
            Slog.w(ViewRootImpl.this.mTag, "Dropping event (" + reason + "):" + q.mEvent);
            return true;
        }

        void dump(String prefix, PrintWriter writer) {
            if (this.mNext != null) {
                this.mNext.dump(prefix, writer);
            }
        }

        private boolean isBack(InputEvent event) {
            if (event instanceof KeyEvent) {
                return ((KeyEvent)event).getKeyCode() == 4;
            }
            return false;
        }

        private void traceEvent(QueuedInputEvent q, long traceTag) {
            if (!Trace.isTagEnabled(traceTag)) {
                return;
            }
            if (this.mTracePrefix == null) {
                this.mTracePrefix = this.getClass().getSimpleName();
            }
            Trace.traceBegin(traceTag, this.mTracePrefix + " id=0x" + Integer.toHexString(q.mEvent.getId()));
        }
    }

    class ViewRootHandler
    extends Handler {
        ViewRootHandler() {
        }

        @Override
        public String getMessageName(Message message) {
            switch (message.what) {
                case 1: {
                    return "MSG_INVALIDATE";
                }
                case 2: {
                    return "MSG_INVALIDATE_RECT";
                }
                case 3: {
                    return "MSG_DIE";
                }
                case 4: {
                    return "MSG_RESIZED";
                }
                case 5: {
                    return "MSG_RESIZED_REPORT";
                }
                case 6: {
                    return "MSG_WINDOW_FOCUS_CHANGED";
                }
                case 7: {
                    return "MSG_DISPATCH_INPUT_EVENT";
                }
                case 8: {
                    return "MSG_DISPATCH_APP_VISIBILITY";
                }
                case 9: {
                    return "MSG_DISPATCH_GET_NEW_SURFACE";
                }
                case 11: {
                    return "MSG_DISPATCH_KEY_FROM_IME";
                }
                case 12: {
                    return "MSG_DISPATCH_KEY_FROM_AUTOFILL";
                }
                case 13: {
                    return "MSG_CHECK_FOCUS";
                }
                case 14: {
                    return "MSG_CLOSE_SYSTEM_DIALOGS";
                }
                case 15: {
                    return "MSG_DISPATCH_DRAG_EVENT";
                }
                case 16: {
                    return "MSG_DISPATCH_DRAG_LOCATION_EVENT";
                }
                case 17: {
                    return "MSG_DISPATCH_SYSTEM_UI_VISIBILITY";
                }
                case 18: {
                    return "MSG_UPDATE_CONFIGURATION";
                }
                case 19: {
                    return "MSG_PROCESS_INPUT_EVENTS";
                }
                case 21: {
                    return "MSG_CLEAR_ACCESSIBILITY_FOCUS_HOST";
                }
                case 23: {
                    return "MSG_WINDOW_MOVED";
                }
                case 24: {
                    return "MSG_SYNTHESIZE_INPUT_EVENT";
                }
                case 25: {
                    return "MSG_DISPATCH_WINDOW_SHOWN";
                }
                case 27: {
                    return "MSG_UPDATE_POINTER_ICON";
                }
                case 28: {
                    return "MSG_POINTER_CAPTURE_CHANGED";
                }
                case 29: {
                    return "MSG_DRAW_FINISHED";
                }
                case 30: {
                    return "MSG_INSETS_CHANGED";
                }
                case 31: {
                    return "MSG_INSETS_CONTROL_CHANGED";
                }
                case 32: {
                    return "MSG_SYSTEM_GESTURE_EXCLUSION_CHANGED";
                }
                case 33: {
                    return "MSG_LOCATION_IN_PARENT_DISPLAY_CHANGED";
                }
                case 34: {
                    return "MSG_SHOW_INSETS";
                }
                case 35: {
                    return "MSG_HIDE_INSETS";
                }
            }
            return super.getMessageName(message);
        }

        @Override
        public boolean sendMessageAtTime(Message msg, long uptimeMillis) {
            if (msg.what == 26 && msg.obj == null) {
                throw new NullPointerException("Attempted to call MSG_REQUEST_KEYBOARD_SHORTCUTS with null receiver:");
            }
            return super.sendMessageAtTime(msg, uptimeMillis);
        }

        @Override
        public void handleMessage(Message msg) {
            if (Trace.isTagEnabled(8L)) {
                Trace.traceBegin(8L, this.getMessageName(msg));
            }
            try {
                this.handleMessageImpl(msg);
            }
            finally {
                Trace.traceEnd(8L);
            }
        }

        private void handleMessageImpl(Message msg) {
            switch (msg.what) {
                case 1: {
                    ((View)msg.obj).invalidate();
                    break;
                }
                case 2: {
                    View.AttachInfo.InvalidateInfo info = (View.AttachInfo.InvalidateInfo)msg.obj;
                    info.target.invalidate(info.left, info.top, info.right, info.bottom);
                    info.recycle();
                    break;
                }
                case 19: {
                    ViewRootImpl.this.mProcessInputEventsScheduled = false;
                    ViewRootImpl.this.doProcessInputEvents();
                    break;
                }
                case 8: {
                    ViewRootImpl.this.handleAppVisibility(msg.arg1 != 0);
                    break;
                }
                case 9: {
                    ViewRootImpl.this.handleGetNewSurface();
                    break;
                }
                case 4: 
                case 5: {
                    ViewRootImpl.this.mWillMove = false;
                    ViewRootImpl.this.mWillResize = false;
                    SomeArgs args = (SomeArgs)msg.obj;
                    ViewRootImpl.this.handleResized(msg.what, args);
                    args.recycle();
                    break;
                }
                case 30: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    ViewRootImpl.this.mWillMove = args.argi1 == 1;
                    ViewRootImpl.this.mWillResize = args.argi2 == 1;
                    ViewRootImpl.this.mInsetsController.onStateChanged((InsetsState)args.arg1);
                    args.recycle();
                    break;
                }
                case 31: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    ViewRootImpl.this.mWillMove = args.argi1 == 1;
                    ViewRootImpl.this.mWillResize = args.argi2 == 1;
                    ViewRootImpl.this.mInsetsController.onStateChanged((InsetsState)args.arg1);
                    InsetsSourceControl[] controls = (InsetsSourceControl[])args.arg2;
                    if (ViewRootImpl.this.mAdded) {
                        ViewRootImpl.this.mInsetsController.onControlsChanged(controls);
                    } else if (controls != null) {
                        for (InsetsSourceControl control : controls) {
                            if (control == null) continue;
                            control.release(SurfaceControl::release);
                        }
                    }
                    args.recycle();
                    break;
                }
                case 34: {
                    if (ViewRootImpl.this.mView == null) {
                        Log.e(ViewRootImpl.TAG, String.format("Calling showInsets(%d,%b) on window that no longer has views.", msg.arg1, msg.arg2 == 1));
                    }
                    ViewRootImpl.this.clearLowProfileModeIfNeeded(msg.arg1, msg.arg2 == 1);
                    ViewRootImpl.this.mInsetsController.show(msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 35: {
                    ViewRootImpl.this.mInsetsController.hide(msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 23: {
                    ViewRootImpl.this.mWillMove = false;
                    if (!ViewRootImpl.this.mAdded) break;
                    int w = ViewRootImpl.this.mWinFrame.width();
                    int h = ViewRootImpl.this.mWinFrame.height();
                    int l = msg.arg1;
                    int t = msg.arg2;
                    ((ViewRootImpl)ViewRootImpl.this).mTmpFrames.frame.left = l;
                    ((ViewRootImpl)ViewRootImpl.this).mTmpFrames.frame.right = l + w;
                    ((ViewRootImpl)ViewRootImpl.this).mTmpFrames.frame.top = t;
                    ((ViewRootImpl)ViewRootImpl.this).mTmpFrames.frame.bottom = t + h;
                    ViewRootImpl.this.setFrame(((ViewRootImpl)ViewRootImpl.this).mTmpFrames.frame);
                    ViewRootImpl.this.mPendingBackDropFrame.set(ViewRootImpl.this.mWinFrame);
                    ViewRootImpl.this.maybeHandleWindowMove(ViewRootImpl.this.mWinFrame);
                    break;
                }
                case 6: {
                    ViewRootImpl.this.handleWindowFocusChanged();
                    break;
                }
                case 3: {
                    ViewRootImpl.this.doDie();
                    break;
                }
                case 7: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    InputEvent event = (InputEvent)args.arg1;
                    InputEventReceiver receiver = (InputEventReceiver)args.arg2;
                    ViewRootImpl.this.enqueueInputEvent(event, receiver, 0, true);
                    args.recycle();
                    break;
                }
                case 24: {
                    InputEvent event = (InputEvent)msg.obj;
                    ViewRootImpl.this.enqueueInputEvent(event, null, 32, true);
                    break;
                }
                case 11: {
                    KeyEvent event = (KeyEvent)msg.obj;
                    if ((event.getFlags() & 8) != 0) {
                        event = KeyEvent.changeFlags(event, event.getFlags() & 0xFFFFFFF7);
                    }
                    ViewRootImpl.this.enqueueInputEvent(event, null, 1, true);
                    break;
                }
                case 12: {
                    KeyEvent event = (KeyEvent)msg.obj;
                    ViewRootImpl.this.enqueueInputEvent(event, null, 0, true);
                    break;
                }
                case 13: {
                    ViewRootImpl.this.getImeFocusController().checkFocus(false, true);
                    break;
                }
                case 14: {
                    if (ViewRootImpl.this.mView == null) break;
                    ViewRootImpl.this.mView.onCloseSystemDialogs((String)msg.obj);
                    break;
                }
                case 15: 
                case 16: {
                    DragEvent event = (DragEvent)msg.obj;
                    event.mLocalState = ViewRootImpl.this.mLocalDragState;
                    ViewRootImpl.this.handleDragEvent(event);
                    break;
                }
                case 17: {
                    ViewRootImpl.this.handleDispatchSystemUiVisibilityChanged((SystemUiVisibilityInfo)msg.obj);
                    break;
                }
                case 18: {
                    Configuration config = (Configuration)msg.obj;
                    if (config.isOtherSeqNewer(ViewRootImpl.this.mLastReportedMergedConfiguration.getMergedConfiguration())) {
                        config = ViewRootImpl.this.mLastReportedMergedConfiguration.getGlobalConfiguration();
                    }
                    ViewRootImpl.this.mPendingMergedConfiguration.setConfiguration(config, ViewRootImpl.this.mLastReportedMergedConfiguration.getOverrideConfiguration());
                    ViewRootImpl.this.performConfigurationChange(new MergedConfiguration(ViewRootImpl.this.mPendingMergedConfiguration), false, -1);
                    break;
                }
                case 21: {
                    ViewRootImpl.this.setAccessibilityFocus(null, null);
                    break;
                }
                case 22: {
                    if (ViewRootImpl.this.mView == null) break;
                    ViewRootImpl.this.invalidateWorld(ViewRootImpl.this.mView);
                    break;
                }
                case 25: {
                    ViewRootImpl.this.handleDispatchWindowShown();
                    break;
                }
                case 26: {
                    IResultReceiver receiver = (IResultReceiver)msg.obj;
                    int deviceId = msg.arg1;
                    ViewRootImpl.this.handleRequestKeyboardShortcuts(receiver, deviceId);
                    break;
                }
                case 27: {
                    MotionEvent event = (MotionEvent)msg.obj;
                    ViewRootImpl.this.resetPointerIcon(event);
                    break;
                }
                case 28: {
                    boolean hasCapture = msg.arg1 != 0;
                    ViewRootImpl.this.handlePointerCaptureChanged(hasCapture);
                    break;
                }
                case 29: {
                    ViewRootImpl.this.pendingDrawFinished();
                    break;
                }
                case 32: {
                    ViewRootImpl.this.systemGestureExclusionChanged();
                    break;
                }
                case 33: {
                    ViewRootImpl.this.updateLocationInParentDisplay(msg.arg1, msg.arg2);
                    break;
                }
                case 36: {
                    ViewRootImpl.this.handleScrollCaptureRequest((IScrollCaptureResponseListener)msg.obj);
                }
            }
        }
    }

    public static interface SurfaceChangedCallback {
        public void surfaceCreated(SurfaceControl.Transaction var1);

        public void surfaceReplaced(SurfaceControl.Transaction var1);

        public void surfaceDestroyed();
    }

    static class SystemUiVisibilityInfo {
        int globalVisibility;
        int localValue;
        int localChanges;

        SystemUiVisibilityInfo() {
        }
    }

    public static interface ActivityConfigCallback {
        public void onConfigurationChanged(Configuration var1, int var2);
    }

    public static interface ConfigChangedCallback {
        public void onConfigurationChanged(Configuration var1);
    }
}

