/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Insets;
import android.graphics.Rect;
import android.view.DisplayCutout;
import android.view.PrivacyIndicatorBounds;
import android.view.RoundedCorner;
import android.view.RoundedCorners;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public class WindowInsets {
    private final Insets[] mTypeInsetsMap;
    private final Insets[] mTypeMaxInsetsMap;
    private final boolean[] mTypeVisibilityMap;
    private Rect mTempRect;
    private final boolean mIsRound;
    private final DisplayCutout mDisplayCutout;
    private final RoundedCorners mRoundedCorners;
    private final PrivacyIndicatorBounds mPrivacyIndicatorBounds;
    private final boolean mAlwaysConsumeSystemBars;
    private final boolean mSystemWindowInsetsConsumed;
    private final boolean mStableInsetsConsumed;
    private final boolean mDisplayCutoutConsumed;
    private final int mCompatInsetsTypes;
    private final boolean mCompatIgnoreVisibility;
    public static final WindowInsets CONSUMED = new WindowInsets(null, null, false, false, null);

    @Deprecated
    public WindowInsets(Rect systemWindowInsetsRect, Rect stableInsetsRect, boolean isRound, boolean alwaysConsumeSystemBars, DisplayCutout displayCutout) {
        this(WindowInsets.createCompatTypeMap(systemWindowInsetsRect), WindowInsets.createCompatTypeMap(stableInsetsRect), WindowInsets.createCompatVisibilityMap(WindowInsets.createCompatTypeMap(systemWindowInsetsRect)), isRound, alwaysConsumeSystemBars, displayCutout, null, null, Type.systemBars(), false);
    }

    public WindowInsets(Insets[] typeInsetsMap, Insets[] typeMaxInsetsMap, boolean[] typeVisibilityMap, boolean isRound, boolean alwaysConsumeSystemBars, DisplayCutout displayCutout, RoundedCorners roundedCorners, PrivacyIndicatorBounds privacyIndicatorBounds, int compatInsetsTypes, boolean compatIgnoreVisibility) {
        this.mSystemWindowInsetsConsumed = typeInsetsMap == null;
        this.mTypeInsetsMap = this.mSystemWindowInsetsConsumed ? new Insets[9] : (Insets[])typeInsetsMap.clone();
        this.mStableInsetsConsumed = typeMaxInsetsMap == null;
        this.mTypeMaxInsetsMap = this.mStableInsetsConsumed ? new Insets[9] : (Insets[])typeMaxInsetsMap.clone();
        this.mTypeVisibilityMap = typeVisibilityMap;
        this.mIsRound = isRound;
        this.mAlwaysConsumeSystemBars = alwaysConsumeSystemBars;
        this.mCompatInsetsTypes = compatInsetsTypes;
        this.mCompatIgnoreVisibility = compatIgnoreVisibility;
        this.mDisplayCutoutConsumed = displayCutout == null;
        this.mDisplayCutout = this.mDisplayCutoutConsumed || displayCutout.isEmpty() ? null : displayCutout;
        this.mRoundedCorners = roundedCorners;
        this.mPrivacyIndicatorBounds = privacyIndicatorBounds;
    }

    public WindowInsets(WindowInsets src) {
        this(src.mSystemWindowInsetsConsumed ? null : src.mTypeInsetsMap, src.mStableInsetsConsumed ? null : src.mTypeMaxInsetsMap, src.mTypeVisibilityMap, src.mIsRound, src.mAlwaysConsumeSystemBars, WindowInsets.displayCutoutCopyConstructorArgument(src), src.mRoundedCorners, src.mPrivacyIndicatorBounds, src.mCompatInsetsTypes, src.mCompatIgnoreVisibility);
    }

    private static DisplayCutout displayCutoutCopyConstructorArgument(WindowInsets w) {
        if (w.mDisplayCutoutConsumed) {
            return null;
        }
        if (w.mDisplayCutout == null) {
            return DisplayCutout.NO_CUTOUT;
        }
        return w.mDisplayCutout;
    }

    static Insets getInsets(Insets[] typeInsetsMap, int typeMask) {
        Insets result = null;
        for (int i = 1; i <= 256; i <<= 1) {
            Insets insets;
            if ((typeMask & i) == 0 || (insets = typeInsetsMap[Type.indexOf(i)]) == null) continue;
            result = result == null ? insets : Insets.max(result, insets);
        }
        return result == null ? Insets.NONE : result;
    }

    private static void setInsets(Insets[] typeInsetsMap, int typeMask, Insets insets) {
        for (int i = 1; i <= 256; i <<= 1) {
            if ((typeMask & i) == 0) continue;
            typeInsetsMap[Type.indexOf((int)i)] = insets;
        }
    }

    @UnsupportedAppUsage
    public WindowInsets(Rect systemWindowInsets) {
        this(WindowInsets.createCompatTypeMap(systemWindowInsets), null, new boolean[9], false, false, null, null, null, Type.systemBars(), false);
    }

    private static Insets[] createCompatTypeMap(Rect insets) {
        if (insets == null) {
            return null;
        }
        Insets[] typeInsetsMap = new Insets[9];
        WindowInsets.assignCompatInsets(typeInsetsMap, insets);
        return typeInsetsMap;
    }

    @VisibleForTesting
    public static void assignCompatInsets(Insets[] typeInsetsMap, Rect insets) {
        typeInsetsMap[Type.indexOf((int)1)] = Insets.of(0, insets.top, 0, 0);
        typeInsetsMap[Type.indexOf((int)2)] = Insets.of(insets.left, 0, insets.right, insets.bottom);
    }

    private static boolean[] createCompatVisibilityMap(Insets[] typeInsetsMap) {
        boolean[] typeVisibilityMap = new boolean[9];
        if (typeInsetsMap == null) {
            return typeVisibilityMap;
        }
        for (int i = 1; i <= 256; i <<= 1) {
            int index = Type.indexOf(i);
            if (Insets.NONE.equals(typeInsetsMap[index])) continue;
            typeVisibilityMap[index] = true;
        }
        return typeVisibilityMap;
    }

    @Deprecated
    public Rect getSystemWindowInsetsAsRect() {
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        Insets insets = this.getSystemWindowInsets();
        this.mTempRect.set(insets.left, insets.top, insets.right, insets.bottom);
        return this.mTempRect;
    }

    @Deprecated
    public Insets getSystemWindowInsets() {
        Insets result;
        Insets insets = result = this.mCompatIgnoreVisibility ? this.getInsetsIgnoringVisibility(this.mCompatInsetsTypes & ~Type.ime()) : this.getInsets(this.mCompatInsetsTypes);
        if ((this.mCompatInsetsTypes & Type.ime()) != 0 && this.mCompatIgnoreVisibility) {
            result = Insets.max(result, this.getInsets(Type.ime()));
        }
        return result;
    }

    public Insets getInsets(int typeMask) {
        return WindowInsets.getInsets(this.mTypeInsetsMap, typeMask);
    }

    public Insets getInsetsIgnoringVisibility(int typeMask) {
        if ((typeMask & 8) != 0) {
            throw new IllegalArgumentException("Unable to query the maximum insets for IME");
        }
        return WindowInsets.getInsets(this.mTypeMaxInsetsMap, typeMask);
    }

    public boolean isVisible(int typeMask) {
        for (int i = 1; i <= 256; i <<= 1) {
            if ((typeMask & i) == 0 || this.mTypeVisibilityMap[Type.indexOf(i)]) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public int getSystemWindowInsetLeft() {
        return this.getSystemWindowInsets().left;
    }

    @Deprecated
    public int getSystemWindowInsetTop() {
        return this.getSystemWindowInsets().top;
    }

    @Deprecated
    public int getSystemWindowInsetRight() {
        return this.getSystemWindowInsets().right;
    }

    @Deprecated
    public int getSystemWindowInsetBottom() {
        return this.getSystemWindowInsets().bottom;
    }

    @Deprecated
    public boolean hasSystemWindowInsets() {
        return !this.getSystemWindowInsets().equals(Insets.NONE);
    }

    public boolean hasInsets() {
        return !WindowInsets.getInsets(this.mTypeInsetsMap, Type.all()).equals(Insets.NONE) || !WindowInsets.getInsets(this.mTypeMaxInsetsMap, Type.all()).equals(Insets.NONE) || this.mDisplayCutout != null || this.mRoundedCorners != null;
    }

    public DisplayCutout getDisplayCutout() {
        return this.mDisplayCutout;
    }

    public RoundedCorner getRoundedCorner(int position) {
        return this.mRoundedCorners == null ? null : this.mRoundedCorners.getRoundedCorner(position);
    }

    public Rect getPrivacyIndicatorBounds() {
        return this.mPrivacyIndicatorBounds == null ? null : this.mPrivacyIndicatorBounds.getStaticPrivacyIndicatorBounds();
    }

    @Deprecated
    public WindowInsets consumeDisplayCutout() {
        return new WindowInsets(this.mSystemWindowInsetsConsumed ? null : this.mTypeInsetsMap, this.mStableInsetsConsumed ? null : this.mTypeMaxInsetsMap, this.mTypeVisibilityMap, this.mIsRound, this.mAlwaysConsumeSystemBars, null, this.mRoundedCorners, this.mPrivacyIndicatorBounds, this.mCompatInsetsTypes, this.mCompatIgnoreVisibility);
    }

    public boolean isConsumed() {
        return this.mSystemWindowInsetsConsumed && this.mStableInsetsConsumed && this.mDisplayCutoutConsumed;
    }

    public boolean isRound() {
        return this.mIsRound;
    }

    @Deprecated
    public WindowInsets consumeSystemWindowInsets() {
        return new WindowInsets(null, null, this.mTypeVisibilityMap, this.mIsRound, this.mAlwaysConsumeSystemBars, WindowInsets.displayCutoutCopyConstructorArgument(this), this.mRoundedCorners, this.mPrivacyIndicatorBounds, this.mCompatInsetsTypes, this.mCompatIgnoreVisibility);
    }

    @Deprecated
    public WindowInsets replaceSystemWindowInsets(int left, int top, int right, int bottom) {
        if (this.mSystemWindowInsetsConsumed) {
            return this;
        }
        return new Builder(this).setSystemWindowInsets(Insets.of(left, top, right, bottom)).build();
    }

    @Deprecated
    public WindowInsets replaceSystemWindowInsets(Rect systemWindowInsets) {
        return this.replaceSystemWindowInsets(systemWindowInsets.left, systemWindowInsets.top, systemWindowInsets.right, systemWindowInsets.bottom);
    }

    @Deprecated
    public Insets getStableInsets() {
        return WindowInsets.getInsets(this.mTypeMaxInsetsMap, this.mCompatInsetsTypes);
    }

    @Deprecated
    public int getStableInsetTop() {
        return this.getStableInsets().top;
    }

    @Deprecated
    public int getStableInsetLeft() {
        return this.getStableInsets().left;
    }

    @Deprecated
    public int getStableInsetRight() {
        return this.getStableInsets().right;
    }

    @Deprecated
    public int getStableInsetBottom() {
        return this.getStableInsets().bottom;
    }

    @Deprecated
    public boolean hasStableInsets() {
        return !this.getStableInsets().equals(Insets.NONE);
    }

    @Deprecated
    public Insets getSystemGestureInsets() {
        return WindowInsets.getInsets(this.mTypeInsetsMap, 16);
    }

    @Deprecated
    public Insets getMandatorySystemGestureInsets() {
        return WindowInsets.getInsets(this.mTypeInsetsMap, 32);
    }

    @Deprecated
    public Insets getTappableElementInsets() {
        return WindowInsets.getInsets(this.mTypeInsetsMap, 64);
    }

    @Deprecated
    public WindowInsets consumeStableInsets() {
        return this;
    }

    public boolean shouldAlwaysConsumeSystemBars() {
        return this.mAlwaysConsumeSystemBars;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("WindowInsets{\n    ");
        for (int i = 0; i < 9; ++i) {
            Insets insets = this.mTypeInsetsMap[i];
            Insets maxInsets = this.mTypeMaxInsetsMap[i];
            boolean visible = this.mTypeVisibilityMap[i];
            if (Insets.NONE.equals(insets) && Insets.NONE.equals(maxInsets) && !visible) continue;
            result.append(Type.toString(1 << i)).append("=").append(insets).append(" max=").append(maxInsets).append(" vis=").append(visible).append("\n    ");
        }
        result.append(this.mDisplayCutout != null ? "cutout=" + this.mDisplayCutout : "");
        result.append("\n    ");
        result.append(this.mRoundedCorners != null ? "roundedCorners=" + this.mRoundedCorners : "");
        result.append("\n    ");
        result.append(this.mPrivacyIndicatorBounds != null ? "privacyIndicatorBounds=" + this.mPrivacyIndicatorBounds : "");
        result.append("\n    ");
        result.append(this.isRound() ? "round" : "");
        result.append("}");
        return result.toString();
    }

    @Deprecated
    public WindowInsets inset(Rect r) {
        return this.inset(r.left, r.top, r.right, r.bottom);
    }

    public WindowInsets inset(Insets insets) {
        Objects.requireNonNull(insets);
        return this.inset(insets.left, insets.top, insets.right, insets.bottom);
    }

    public WindowInsets inset(int left, int top, int right, int bottom) {
        Preconditions.checkArgumentNonnegative(left);
        Preconditions.checkArgumentNonnegative(top);
        Preconditions.checkArgumentNonnegative(right);
        Preconditions.checkArgumentNonnegative(bottom);
        return this.insetUnchecked(left, top, right, bottom);
    }

    public WindowInsets insetUnchecked(int left, int top, int right, int bottom) {
        return new WindowInsets(this.mSystemWindowInsetsConsumed ? null : WindowInsets.insetInsets(this.mTypeInsetsMap, left, top, right, bottom), this.mStableInsetsConsumed ? null : WindowInsets.insetInsets(this.mTypeMaxInsetsMap, left, top, right, bottom), this.mTypeVisibilityMap, this.mIsRound, this.mAlwaysConsumeSystemBars, this.mDisplayCutoutConsumed ? null : (this.mDisplayCutout == null ? DisplayCutout.NO_CUTOUT : this.mDisplayCutout.inset(left, top, right, bottom)), this.mRoundedCorners == null ? RoundedCorners.NO_ROUNDED_CORNERS : this.mRoundedCorners.inset(left, top, right, bottom), this.mPrivacyIndicatorBounds == null ? null : this.mPrivacyIndicatorBounds.inset(left, top, right, bottom), this.mCompatInsetsTypes, this.mCompatIgnoreVisibility);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof WindowInsets)) {
            return false;
        }
        WindowInsets that = (WindowInsets)o;
        return this.mIsRound == that.mIsRound && this.mAlwaysConsumeSystemBars == that.mAlwaysConsumeSystemBars && this.mSystemWindowInsetsConsumed == that.mSystemWindowInsetsConsumed && this.mStableInsetsConsumed == that.mStableInsetsConsumed && this.mDisplayCutoutConsumed == that.mDisplayCutoutConsumed && Arrays.equals(this.mTypeInsetsMap, that.mTypeInsetsMap) && Arrays.equals(this.mTypeMaxInsetsMap, that.mTypeMaxInsetsMap) && Arrays.equals(this.mTypeVisibilityMap, that.mTypeVisibilityMap) && Objects.equals(this.mDisplayCutout, that.mDisplayCutout) && Objects.equals(this.mRoundedCorners, that.mRoundedCorners) && Objects.equals(this.mPrivacyIndicatorBounds, that.mPrivacyIndicatorBounds);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.mTypeInsetsMap), Arrays.hashCode(this.mTypeMaxInsetsMap), Arrays.hashCode(this.mTypeVisibilityMap), this.mIsRound, this.mDisplayCutout, this.mRoundedCorners, this.mAlwaysConsumeSystemBars, this.mSystemWindowInsetsConsumed, this.mStableInsetsConsumed, this.mDisplayCutoutConsumed, this.mPrivacyIndicatorBounds);
    }

    private static Insets[] insetInsets(Insets[] typeInsetsMap, int left, int top, int right, int bottom) {
        boolean cloned = false;
        for (int i = 0; i < 9; ++i) {
            Insets insetInsets;
            Insets insets = typeInsetsMap[i];
            if (insets == null || (insetInsets = WindowInsets.insetInsets(insets, left, top, right, bottom)) == insets) continue;
            if (!cloned) {
                typeInsetsMap = (Insets[])typeInsetsMap.clone();
                cloned = true;
            }
            typeInsetsMap[i] = insetInsets;
        }
        return typeInsetsMap;
    }

    static Insets insetInsets(Insets insets, int left, int top, int right, int bottom) {
        int newLeft = Math.max(0, insets.left - left);
        int newTop = Math.max(0, insets.top - top);
        int newRight = Math.max(0, insets.right - right);
        int newBottom = Math.max(0, insets.bottom - bottom);
        if (newLeft == left && newTop == top && newRight == right && newBottom == bottom) {
            return insets;
        }
        return Insets.of(newLeft, newTop, newRight, newBottom);
    }

    boolean isSystemWindowInsetsConsumed() {
        return this.mSystemWindowInsetsConsumed;
    }

    public static class Side {
        public static final int LEFT = 1;
        public static final int TOP = 2;
        public static final int RIGHT = 4;
        public static final int BOTTOM = 8;

        private Side() {
        }

        public static int all() {
            return 15;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InsetsSide {
        }
    }

    public static class Type {
        static final int FIRST = 1;
        static final int STATUS_BARS = 1;
        static final int NAVIGATION_BARS = 2;
        static final int CAPTION_BAR = 4;
        static final int IME = 8;
        static final int SYSTEM_GESTURES = 16;
        static final int MANDATORY_SYSTEM_GESTURES = 32;
        static final int TAPPABLE_ELEMENT = 64;
        static final int DISPLAY_CUTOUT = 128;
        static final int LAST = 256;
        static final int SIZE = 9;
        static final int WINDOW_DECOR = 256;

        static int indexOf(int type) {
            switch (type) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 8: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 32: {
                    return 5;
                }
                case 64: {
                    return 6;
                }
                case 128: {
                    return 7;
                }
                case 256: {
                    return 8;
                }
            }
            throw new IllegalArgumentException("type needs to be >= FIRST and <= LAST, type=" + type);
        }

        static String toString(int types) {
            StringBuilder result = new StringBuilder();
            if ((types & 1) != 0) {
                result.append("statusBars |");
            }
            if ((types & 2) != 0) {
                result.append("navigationBars |");
            }
            if ((types & 4) != 0) {
                result.append("captionBar |");
            }
            if ((types & 8) != 0) {
                result.append("ime |");
            }
            if ((types & 0x10) != 0) {
                result.append("systemGestures |");
            }
            if ((types & 0x20) != 0) {
                result.append("mandatorySystemGestures |");
            }
            if ((types & 0x40) != 0) {
                result.append("tappableElement |");
            }
            if ((types & 0x80) != 0) {
                result.append("displayCutout |");
            }
            if ((types & 0x100) != 0) {
                result.append("windowDecor |");
            }
            if (result.length() > 0) {
                result.delete(result.length() - 2, result.length());
            }
            return result.toString();
        }

        private Type() {
        }

        public static int statusBars() {
            return 1;
        }

        public static int navigationBars() {
            return 2;
        }

        public static int captionBar() {
            return 4;
        }

        public static int ime() {
            return 8;
        }

        public static int systemGestures() {
            return 16;
        }

        public static int mandatorySystemGestures() {
            return 32;
        }

        public static int tappableElement() {
            return 64;
        }

        public static int displayCutout() {
            return 128;
        }

        public static int systemBars() {
            return 7;
        }

        public static int all() {
            return -1;
        }

        public static boolean isVisibleInsetsType(int type, int softInputModeFlags) {
            int softInputMode = softInputModeFlags & 0xF0;
            return (type & Type.systemBars()) != 0 || softInputMode != 48 && (type & Type.ime()) != 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InsetsType {
        }
    }

    public static class Builder {
        private final Insets[] mTypeInsetsMap;
        private final Insets[] mTypeMaxInsetsMap;
        private final boolean[] mTypeVisibilityMap;
        private boolean mSystemInsetsConsumed = true;
        private boolean mStableInsetsConsumed = true;
        private DisplayCutout mDisplayCutout;
        private RoundedCorners mRoundedCorners = RoundedCorners.NO_ROUNDED_CORNERS;
        private boolean mIsRound;
        private boolean mAlwaysConsumeSystemBars;
        private PrivacyIndicatorBounds mPrivacyIndicatorBounds = new PrivacyIndicatorBounds();

        public Builder() {
            this.mTypeInsetsMap = new Insets[9];
            this.mTypeMaxInsetsMap = new Insets[9];
            this.mTypeVisibilityMap = new boolean[9];
        }

        public Builder(WindowInsets insets) {
            this.mTypeInsetsMap = (Insets[])insets.mTypeInsetsMap.clone();
            this.mTypeMaxInsetsMap = (Insets[])insets.mTypeMaxInsetsMap.clone();
            this.mTypeVisibilityMap = (boolean[])insets.mTypeVisibilityMap.clone();
            this.mSystemInsetsConsumed = insets.mSystemWindowInsetsConsumed;
            this.mStableInsetsConsumed = insets.mStableInsetsConsumed;
            this.mDisplayCutout = WindowInsets.displayCutoutCopyConstructorArgument(insets);
            this.mRoundedCorners = insets.mRoundedCorners;
            this.mIsRound = insets.mIsRound;
            this.mAlwaysConsumeSystemBars = insets.mAlwaysConsumeSystemBars;
            this.mPrivacyIndicatorBounds = insets.mPrivacyIndicatorBounds;
        }

        @Deprecated
        public Builder setSystemWindowInsets(Insets systemWindowInsets) {
            Preconditions.checkNotNull(systemWindowInsets);
            WindowInsets.assignCompatInsets(this.mTypeInsetsMap, systemWindowInsets.toRect());
            this.mSystemInsetsConsumed = false;
            return this;
        }

        @Deprecated
        public Builder setSystemGestureInsets(Insets insets) {
            WindowInsets.setInsets(this.mTypeInsetsMap, 16, insets);
            return this;
        }

        @Deprecated
        public Builder setMandatorySystemGestureInsets(Insets insets) {
            WindowInsets.setInsets(this.mTypeInsetsMap, 32, insets);
            return this;
        }

        @Deprecated
        public Builder setTappableElementInsets(Insets insets) {
            WindowInsets.setInsets(this.mTypeInsetsMap, 64, insets);
            return this;
        }

        public Builder setInsets(int typeMask, Insets insets) {
            Preconditions.checkNotNull(insets);
            WindowInsets.setInsets(this.mTypeInsetsMap, typeMask, insets);
            this.mSystemInsetsConsumed = false;
            return this;
        }

        public Builder setInsetsIgnoringVisibility(int typeMask, Insets insets) throws IllegalArgumentException {
            if (typeMask == 8) {
                throw new IllegalArgumentException("Maximum inset not available for IME");
            }
            Preconditions.checkNotNull(insets);
            WindowInsets.setInsets(this.mTypeMaxInsetsMap, typeMask, insets);
            this.mStableInsetsConsumed = false;
            return this;
        }

        public Builder setVisible(int typeMask, boolean visible) {
            for (int i = 1; i <= 256; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                this.mTypeVisibilityMap[Type.indexOf((int)i)] = visible;
            }
            return this;
        }

        @Deprecated
        public Builder setStableInsets(Insets stableInsets) {
            Preconditions.checkNotNull(stableInsets);
            WindowInsets.assignCompatInsets(this.mTypeMaxInsetsMap, stableInsets.toRect());
            this.mStableInsetsConsumed = false;
            return this;
        }

        public Builder setDisplayCutout(DisplayCutout displayCutout) {
            DisplayCutout displayCutout2 = this.mDisplayCutout = displayCutout != null ? displayCutout : DisplayCutout.NO_CUTOUT;
            if (!this.mDisplayCutout.isEmpty()) {
                Insets safeInsets = Insets.of(this.mDisplayCutout.getSafeInsets());
                int index = Type.indexOf(128);
                this.mTypeInsetsMap[index] = safeInsets;
                this.mTypeMaxInsetsMap[index] = safeInsets;
                this.mTypeVisibilityMap[index] = true;
            }
            return this;
        }

        public Builder setRoundedCorners(RoundedCorners roundedCorners) {
            this.mRoundedCorners = roundedCorners != null ? roundedCorners : RoundedCorners.NO_ROUNDED_CORNERS;
            return this;
        }

        public Builder setRoundedCorner(int position, RoundedCorner roundedCorner) {
            this.mRoundedCorners.setRoundedCorner(position, roundedCorner);
            return this;
        }

        public Builder setPrivacyIndicatorBounds(PrivacyIndicatorBounds bounds) {
            this.mPrivacyIndicatorBounds = bounds;
            return this;
        }

        public Builder setPrivacyIndicatorBounds(Rect bounds) {
            Rect[] boundsArr = new Rect[]{bounds, bounds, bounds, bounds};
            this.mPrivacyIndicatorBounds = new PrivacyIndicatorBounds(boundsArr, 0);
            return this;
        }

        public Builder setRound(boolean round) {
            this.mIsRound = round;
            return this;
        }

        public Builder setAlwaysConsumeSystemBars(boolean alwaysConsumeSystemBars) {
            this.mAlwaysConsumeSystemBars = alwaysConsumeSystemBars;
            return this;
        }

        public WindowInsets build() {
            return new WindowInsets(this.mSystemInsetsConsumed ? null : this.mTypeInsetsMap, this.mStableInsetsConsumed ? null : this.mTypeMaxInsetsMap, this.mTypeVisibilityMap, this.mIsRound, this.mAlwaysConsumeSystemBars, this.mDisplayCutout, this.mRoundedCorners, this.mPrivacyIndicatorBounds, Type.systemBars(), false);
        }
    }
}

