/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class AutofillValue
implements Parcelable {
    private static final String TAG = "AutofillValue";
    private final int mType;
    private final Object mValue;
    public static final Parcelable.Creator<AutofillValue> CREATOR = new Parcelable.Creator<AutofillValue>(){

        @Override
        public AutofillValue createFromParcel(Parcel source) {
            return new AutofillValue(source);
        }

        public AutofillValue[] newArray(int size) {
            return new AutofillValue[size];
        }
    };

    private AutofillValue(int type, Object value) {
        this.mType = type;
        this.mValue = value;
    }

    public CharSequence getTextValue() {
        Preconditions.checkState(this.isText(), "value must be a text value, not type=%d", this.mType);
        return (CharSequence)this.mValue;
    }

    public boolean isText() {
        return this.mType == 1;
    }

    public boolean getToggleValue() {
        Preconditions.checkState(this.isToggle(), "value must be a toggle value, not type=%d", this.mType);
        return (Boolean)this.mValue;
    }

    public boolean isToggle() {
        return this.mType == 2;
    }

    public int getListValue() {
        Preconditions.checkState(this.isList(), "value must be a list value, not type=%d", this.mType);
        return (Integer)this.mValue;
    }

    public boolean isList() {
        return this.mType == 3;
    }

    public long getDateValue() {
        Preconditions.checkState(this.isDate(), "value must be a date value, not type=%d", this.mType);
        return (Long)this.mValue;
    }

    public boolean isDate() {
        return this.mType == 4;
    }

    public boolean isEmpty() {
        return this.isText() && ((CharSequence)this.mValue).length() == 0;
    }

    public int hashCode() {
        return this.mType + this.mValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutofillValue other = (AutofillValue)obj;
        if (this.mType != other.mType) {
            return false;
        }
        if (this.isText()) {
            return this.mValue.toString().equals(other.mValue.toString());
        }
        return Objects.equals(this.mValue, other.mValue);
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        StringBuilder string2 = new StringBuilder().append("[type=").append(this.mType).append(", value=");
        if (this.isText()) {
            Helper.appendRedacted(string2, (CharSequence)this.mValue);
        } else {
            string2.append(this.mValue);
        }
        return string2.append(']').toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mType);
        switch (this.mType) {
            case 1: {
                parcel.writeCharSequence((CharSequence)this.mValue);
                break;
            }
            case 2: {
                parcel.writeInt((Boolean)this.mValue != false ? 1 : 0);
                break;
            }
            case 3: {
                parcel.writeInt((Integer)this.mValue);
                break;
            }
            case 4: {
                parcel.writeLong((Long)this.mValue);
            }
        }
    }

    private AutofillValue(Parcel parcel) {
        this.mType = parcel.readInt();
        switch (this.mType) {
            case 1: {
                this.mValue = parcel.readCharSequence();
                break;
            }
            case 2: {
                int rawValue = parcel.readInt();
                this.mValue = rawValue != 0;
                break;
            }
            case 3: {
                this.mValue = parcel.readInt();
                break;
            }
            case 4: {
                this.mValue = parcel.readLong();
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + this.mType + " not valid");
            }
        }
    }

    public static AutofillValue forText(CharSequence value) {
        if (Helper.sVerbose && !Looper.getMainLooper().isCurrentThread()) {
            Log.v(TAG, "forText() not called on main thread: " + Thread.currentThread());
        }
        return value == null ? null : new AutofillValue(1, TextUtils.trimNoCopySpans(value));
    }

    public static AutofillValue forToggle(boolean value) {
        return new AutofillValue(2, value);
    }

    public static AutofillValue forList(int value) {
        return new AutofillValue(3, value);
    }

    public static AutofillValue forDate(long value) {
        return new AutofillValue(4, value);
    }
}

