/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.SystemApi;
import android.app.assist.AssistStructure;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewStructure;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import com.android.internal.util.Preconditions;

@SystemApi
public class ViewNode
extends AssistStructure.ViewNode {
    private static final String TAG = ViewNode.class.getSimpleName();
    private static final long FLAGS_HAS_TEXT = 1L;
    private static final long FLAGS_HAS_COMPLEX_TEXT = 2L;
    private static final long FLAGS_VISIBILITY_MASK = 12L;
    private static final long FLAGS_HAS_CLASSNAME = 16L;
    private static final long FLAGS_HAS_AUTOFILL_ID = 32L;
    private static final long FLAGS_HAS_AUTOFILL_PARENT_ID = 64L;
    private static final long FLAGS_HAS_ID = 128L;
    private static final long FLAGS_HAS_LARGE_COORDS = 256L;
    private static final long FLAGS_HAS_SCROLL = 512L;
    private static final long FLAGS_ASSIST_BLOCKED = 1024L;
    private static final long FLAGS_DISABLED = 2048L;
    private static final long FLAGS_CLICKABLE = 4096L;
    private static final long FLAGS_LONG_CLICKABLE = 8192L;
    private static final long FLAGS_CONTEXT_CLICKABLE = 16384L;
    private static final long FLAGS_FOCUSABLE = 32768L;
    private static final long FLAGS_FOCUSED = 65536L;
    private static final long FLAGS_ACCESSIBILITY_FOCUSED = 131072L;
    private static final long FLAGS_CHECKABLE = 262144L;
    private static final long FLAGS_CHECKED = 524288L;
    private static final long FLAGS_SELECTED = 0x100000L;
    private static final long FLAGS_ACTIVATED = 0x200000L;
    private static final long FLAGS_OPAQUE = 0x400000L;
    private static final long FLAGS_HAS_CONTENT_DESCRIPTION = 0x800000L;
    private static final long FLAGS_HAS_EXTRAS = 0x1000000L;
    private static final long FLAGS_HAS_LOCALE_LIST = 0x2000000L;
    private static final long FLAGS_HAS_INPUT_TYPE = 0x4000000L;
    private static final long FLAGS_HAS_MIN_TEXT_EMS = 0x8000000L;
    private static final long FLAGS_HAS_MAX_TEXT_EMS = 0x10000000L;
    private static final long FLAGS_HAS_MAX_TEXT_LENGTH = 0x20000000L;
    private static final long FLAGS_HAS_TEXT_ID_ENTRY = 0x40000000L;
    private static final long FLAGS_HAS_AUTOFILL_TYPE = 0x80000000L;
    private static final long FLAGS_HAS_AUTOFILL_VALUE = 0x100000000L;
    private static final long FLAGS_HAS_AUTOFILL_HINTS = 0x200000000L;
    private static final long FLAGS_HAS_AUTOFILL_OPTIONS = 0x400000000L;
    private static final long FLAGS_HAS_HINT_ID_ENTRY = 0x800000000L;
    private static final long FLAGS_HAS_MIME_TYPES = 0x1000000000L;
    private long mFlags;
    private AutofillId mParentAutofillId;
    private AutofillId mAutofillId;
    private ViewNodeText mText;
    private String mClassName;
    private int mId = -1;
    private String mIdPackage;
    private String mIdType;
    private String mIdEntry;
    private int mX;
    private int mY;
    private int mScrollX;
    private int mScrollY;
    private int mWidth;
    private int mHeight;
    private CharSequence mContentDescription;
    private Bundle mExtras;
    private LocaleList mLocaleList;
    private int mInputType;
    private int mMinEms = -1;
    private int mMaxEms = -1;
    private int mMaxLength = -1;
    private String mTextIdEntry;
    private String mHintIdEntry;
    private int mAutofillType = 0;
    private String[] mAutofillHints;
    private AutofillValue mAutofillValue;
    private CharSequence[] mAutofillOptions;
    private String[] mReceiveContentMimeTypes;

    public ViewNode() {
    }

    private ViewNode(long nodeFlags, Parcel parcel) {
        this.mFlags = nodeFlags;
        if ((nodeFlags & 0x20L) != 0L) {
            this.mAutofillId = (AutofillId)parcel.readParcelable(null);
        }
        if ((nodeFlags & 0x40L) != 0L) {
            this.mParentAutofillId = (AutofillId)parcel.readParcelable(null);
        }
        if ((nodeFlags & 1L) != 0L) {
            this.mText = new ViewNodeText(parcel, (nodeFlags & 2L) == 0L);
        }
        if ((nodeFlags & 0x10L) != 0L) {
            this.mClassName = parcel.readString();
        }
        if ((nodeFlags & 0x80L) != 0L) {
            this.mId = parcel.readInt();
            if (this.mId != -1) {
                this.mIdEntry = parcel.readString();
                if (this.mIdEntry != null) {
                    this.mIdType = parcel.readString();
                    this.mIdPackage = parcel.readString();
                }
            }
        }
        if ((nodeFlags & 0x100L) != 0L) {
            this.mX = parcel.readInt();
            this.mY = parcel.readInt();
            this.mWidth = parcel.readInt();
            this.mHeight = parcel.readInt();
        } else {
            int val = parcel.readInt();
            this.mX = val & Short.MAX_VALUE;
            this.mY = val >> 16 & Short.MAX_VALUE;
            val = parcel.readInt();
            this.mWidth = val & Short.MAX_VALUE;
            this.mHeight = val >> 16 & Short.MAX_VALUE;
        }
        if ((nodeFlags & 0x200L) != 0L) {
            this.mScrollX = parcel.readInt();
            this.mScrollY = parcel.readInt();
        }
        if ((nodeFlags & 0x800000L) != 0L) {
            this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        }
        if ((nodeFlags & 0x1000000L) != 0L) {
            this.mExtras = parcel.readBundle();
        }
        if ((nodeFlags & 0x2000000L) != 0L) {
            this.mLocaleList = (LocaleList)parcel.readParcelable(null);
        }
        if ((nodeFlags & 0x1000000000L) != 0L) {
            this.mReceiveContentMimeTypes = parcel.readStringArray();
        }
        if ((nodeFlags & 0x4000000L) != 0L) {
            this.mInputType = parcel.readInt();
        }
        if ((nodeFlags & 0x8000000L) != 0L) {
            this.mMinEms = parcel.readInt();
        }
        if ((nodeFlags & 0x10000000L) != 0L) {
            this.mMaxEms = parcel.readInt();
        }
        if ((nodeFlags & 0x20000000L) != 0L) {
            this.mMaxLength = parcel.readInt();
        }
        if ((nodeFlags & 0x40000000L) != 0L) {
            this.mTextIdEntry = parcel.readString();
        }
        if ((nodeFlags & 0x80000000L) != 0L) {
            this.mAutofillType = parcel.readInt();
        }
        if ((nodeFlags & 0x200000000L) != 0L) {
            this.mAutofillHints = parcel.readStringArray();
        }
        if ((nodeFlags & 0x100000000L) != 0L) {
            this.mAutofillValue = (AutofillValue)parcel.readParcelable(null);
        }
        if ((nodeFlags & 0x400000000L) != 0L) {
            this.mAutofillOptions = parcel.readCharSequenceArray();
        }
        if ((nodeFlags & 0x800000000L) != 0L) {
            this.mHintIdEntry = parcel.readString();
        }
    }

    public AutofillId getParentAutofillId() {
        return this.mParentAutofillId;
    }

    @Override
    public AutofillId getAutofillId() {
        return this.mAutofillId;
    }

    @Override
    public CharSequence getText() {
        return this.mText != null ? this.mText.mText : null;
    }

    @Override
    public String getClassName() {
        return this.mClassName;
    }

    @Override
    public int getId() {
        return this.mId;
    }

    @Override
    public String getIdPackage() {
        return this.mIdPackage;
    }

    @Override
    public String getIdType() {
        return this.mIdType;
    }

    @Override
    public String getIdEntry() {
        return this.mIdEntry;
    }

    @Override
    public int getLeft() {
        return this.mX;
    }

    @Override
    public int getTop() {
        return this.mY;
    }

    @Override
    public int getScrollX() {
        return this.mScrollX;
    }

    @Override
    public int getScrollY() {
        return this.mScrollY;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public boolean isAssistBlocked() {
        return (this.mFlags & 0x400L) != 0L;
    }

    @Override
    public boolean isEnabled() {
        return (this.mFlags & 0x800L) == 0L;
    }

    @Override
    public boolean isClickable() {
        return (this.mFlags & 0x1000L) != 0L;
    }

    @Override
    public boolean isLongClickable() {
        return (this.mFlags & 0x2000L) != 0L;
    }

    @Override
    public boolean isContextClickable() {
        return (this.mFlags & 0x4000L) != 0L;
    }

    @Override
    public boolean isFocusable() {
        return (this.mFlags & 0x8000L) != 0L;
    }

    @Override
    public boolean isFocused() {
        return (this.mFlags & 0x10000L) != 0L;
    }

    @Override
    public boolean isAccessibilityFocused() {
        return (this.mFlags & 0x20000L) != 0L;
    }

    @Override
    public boolean isCheckable() {
        return (this.mFlags & 0x40000L) != 0L;
    }

    @Override
    public boolean isChecked() {
        return (this.mFlags & 0x80000L) != 0L;
    }

    @Override
    public boolean isSelected() {
        return (this.mFlags & 0x100000L) != 0L;
    }

    @Override
    public boolean isActivated() {
        return (this.mFlags & 0x200000L) != 0L;
    }

    @Override
    public boolean isOpaque() {
        return (this.mFlags & 0x400000L) != 0L;
    }

    @Override
    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String getHint() {
        return this.mText != null ? this.mText.mHint : null;
    }

    @Override
    public String getHintIdEntry() {
        return this.mHintIdEntry;
    }

    @Override
    public int getTextSelectionStart() {
        return this.mText != null ? this.mText.mTextSelectionStart : -1;
    }

    @Override
    public int getTextSelectionEnd() {
        return this.mText != null ? this.mText.mTextSelectionEnd : -1;
    }

    @Override
    public int getTextColor() {
        return this.mText != null ? this.mText.mTextColor : 1;
    }

    @Override
    public int getTextBackgroundColor() {
        return this.mText != null ? this.mText.mTextBackgroundColor : 1;
    }

    @Override
    public float getTextSize() {
        return this.mText != null ? this.mText.mTextSize : 0.0f;
    }

    @Override
    public int getTextStyle() {
        return this.mText != null ? this.mText.mTextStyle : 0;
    }

    @Override
    public int[] getTextLineCharOffsets() {
        return this.mText != null ? this.mText.mLineCharOffsets : null;
    }

    @Override
    public int[] getTextLineBaselines() {
        return this.mText != null ? this.mText.mLineBaselines : null;
    }

    @Override
    public int getVisibility() {
        return (int)(this.mFlags & 0xCL);
    }

    @Override
    public int getInputType() {
        return this.mInputType;
    }

    @Override
    public int getMinTextEms() {
        return this.mMinEms;
    }

    @Override
    public int getMaxTextEms() {
        return this.mMaxEms;
    }

    @Override
    public int getMaxTextLength() {
        return this.mMaxLength;
    }

    @Override
    public String getTextIdEntry() {
        return this.mTextIdEntry;
    }

    @Override
    public int getAutofillType() {
        return this.mAutofillType;
    }

    @Override
    public String[] getAutofillHints() {
        return this.mAutofillHints;
    }

    @Override
    public AutofillValue getAutofillValue() {
        return this.mAutofillValue;
    }

    @Override
    public CharSequence[] getAutofillOptions() {
        return this.mAutofillOptions;
    }

    @Override
    public String[] getReceiveContentMimeTypes() {
        return this.mReceiveContentMimeTypes;
    }

    @Override
    public LocaleList getLocaleList() {
        return this.mLocaleList;
    }

    private void writeSelfToParcel(Parcel parcel, int parcelFlags) {
        long nodeFlags = this.mFlags;
        if (this.mAutofillId != null) {
            nodeFlags |= 0x20L;
        }
        if (this.mParentAutofillId != null) {
            nodeFlags |= 0x40L;
        }
        if (this.mText != null) {
            nodeFlags |= 1L;
            if (!this.mText.isSimple()) {
                nodeFlags |= 2L;
            }
        }
        if (this.mClassName != null) {
            nodeFlags |= 0x10L;
        }
        if (this.mId != -1) {
            nodeFlags |= 0x80L;
        }
        if ((this.mX & Short.MIN_VALUE) != 0 || (this.mY & Short.MIN_VALUE) != 0 || (this.mWidth & Short.MIN_VALUE) != 0 | (this.mHeight & Short.MIN_VALUE) != 0) {
            nodeFlags |= 0x100L;
        }
        if (this.mScrollX != 0 || this.mScrollY != 0) {
            nodeFlags |= 0x200L;
        }
        if (this.mContentDescription != null) {
            nodeFlags |= 0x800000L;
        }
        if (this.mExtras != null) {
            nodeFlags |= 0x1000000L;
        }
        if (this.mLocaleList != null) {
            nodeFlags |= 0x2000000L;
        }
        if (this.mReceiveContentMimeTypes != null) {
            nodeFlags |= 0x1000000000L;
        }
        if (this.mInputType != 0) {
            nodeFlags |= 0x4000000L;
        }
        if (this.mMinEms > -1) {
            nodeFlags |= 0x8000000L;
        }
        if (this.mMaxEms > -1) {
            nodeFlags |= 0x10000000L;
        }
        if (this.mMaxLength > -1) {
            nodeFlags |= 0x20000000L;
        }
        if (this.mTextIdEntry != null) {
            nodeFlags |= 0x40000000L;
        }
        if (this.mAutofillValue != null) {
            nodeFlags |= 0x100000000L;
        }
        if (this.mAutofillType != 0) {
            nodeFlags |= 0x80000000L;
        }
        if (this.mAutofillHints != null) {
            nodeFlags |= 0x200000000L;
        }
        if (this.mAutofillOptions != null) {
            nodeFlags |= 0x400000000L;
        }
        if (this.mHintIdEntry != null) {
            nodeFlags |= 0x800000000L;
        }
        parcel.writeLong(nodeFlags);
        if ((nodeFlags & 0x20L) != 0L) {
            parcel.writeParcelable(this.mAutofillId, parcelFlags);
        }
        if ((nodeFlags & 0x40L) != 0L) {
            parcel.writeParcelable(this.mParentAutofillId, parcelFlags);
        }
        if ((nodeFlags & 1L) != 0L) {
            this.mText.writeToParcel(parcel, (nodeFlags & 2L) == 0L);
        }
        if ((nodeFlags & 0x10L) != 0L) {
            parcel.writeString(this.mClassName);
        }
        if ((nodeFlags & 0x80L) != 0L) {
            parcel.writeInt(this.mId);
            if (this.mId != -1) {
                parcel.writeString(this.mIdEntry);
                if (this.mIdEntry != null) {
                    parcel.writeString(this.mIdType);
                    parcel.writeString(this.mIdPackage);
                }
            }
        }
        if ((nodeFlags & 0x100L) != 0L) {
            parcel.writeInt(this.mX);
            parcel.writeInt(this.mY);
            parcel.writeInt(this.mWidth);
            parcel.writeInt(this.mHeight);
        } else {
            parcel.writeInt(this.mY << 16 | this.mX);
            parcel.writeInt(this.mHeight << 16 | this.mWidth);
        }
        if ((nodeFlags & 0x200L) != 0L) {
            parcel.writeInt(this.mScrollX);
            parcel.writeInt(this.mScrollY);
        }
        if ((nodeFlags & 0x800000L) != 0L) {
            TextUtils.writeToParcel(this.mContentDescription, parcel, 0);
        }
        if ((nodeFlags & 0x1000000L) != 0L) {
            parcel.writeBundle(this.mExtras);
        }
        if ((nodeFlags & 0x2000000L) != 0L) {
            parcel.writeParcelable(this.mLocaleList, 0);
        }
        if ((nodeFlags & 0x1000000000L) != 0L) {
            parcel.writeStringArray(this.mReceiveContentMimeTypes);
        }
        if ((nodeFlags & 0x4000000L) != 0L) {
            parcel.writeInt(this.mInputType);
        }
        if ((nodeFlags & 0x8000000L) != 0L) {
            parcel.writeInt(this.mMinEms);
        }
        if ((nodeFlags & 0x10000000L) != 0L) {
            parcel.writeInt(this.mMaxEms);
        }
        if ((nodeFlags & 0x20000000L) != 0L) {
            parcel.writeInt(this.mMaxLength);
        }
        if ((nodeFlags & 0x40000000L) != 0L) {
            parcel.writeString(this.mTextIdEntry);
        }
        if ((nodeFlags & 0x80000000L) != 0L) {
            parcel.writeInt(this.mAutofillType);
        }
        if ((nodeFlags & 0x200000000L) != 0L) {
            parcel.writeStringArray(this.mAutofillHints);
        }
        if ((nodeFlags & 0x100000000L) != 0L) {
            parcel.writeParcelable(this.mAutofillValue, 0);
        }
        if ((nodeFlags & 0x400000000L) != 0L) {
            parcel.writeCharSequenceArray(this.mAutofillOptions);
        }
        if ((nodeFlags & 0x800000000L) != 0L) {
            parcel.writeString(this.mHintIdEntry);
        }
    }

    public static void writeToParcel(Parcel parcel, ViewNode node, int flags) {
        if (node == null) {
            parcel.writeLong(0L);
        } else {
            node.writeSelfToParcel(parcel, flags);
        }
    }

    public static ViewNode readFromParcel(Parcel parcel) {
        long nodeFlags = parcel.readLong();
        return nodeFlags == 0L ? null : new ViewNode(nodeFlags, parcel);
    }

    static /* synthetic */ String[] access$2002(ViewNode x0, String[] x1) {
        x0.mReceiveContentMimeTypes = x1;
        return x1;
    }

    static /* synthetic */ String[] access$2102(ViewNode x0, String[] x1) {
        x0.mAutofillHints = x1;
        return x1;
    }

    static /* synthetic */ CharSequence[] access$2302(ViewNode x0, CharSequence[] x1) {
        x0.mAutofillOptions = x1;
        return x1;
    }

    static class ViewNodeText {
        CharSequence mText;
        float mTextSize;
        int mTextStyle;
        int mTextColor = 1;
        int mTextBackgroundColor = 1;
        int mTextSelectionStart;
        int mTextSelectionEnd;
        int[] mLineCharOffsets;
        int[] mLineBaselines;
        String mHint;

        ViewNodeText() {
        }

        boolean isSimple() {
            return this.mTextBackgroundColor == 1 && this.mTextSelectionStart == 0 && this.mTextSelectionEnd == 0 && this.mLineCharOffsets == null && this.mLineBaselines == null && this.mHint == null;
        }

        ViewNodeText(Parcel in, boolean simple) {
            this.mText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.mTextSize = in.readFloat();
            this.mTextStyle = in.readInt();
            this.mTextColor = in.readInt();
            if (!simple) {
                this.mTextBackgroundColor = in.readInt();
                this.mTextSelectionStart = in.readInt();
                this.mTextSelectionEnd = in.readInt();
                this.mLineCharOffsets = in.createIntArray();
                this.mLineBaselines = in.createIntArray();
                this.mHint = in.readString();
            }
        }

        void writeToParcel(Parcel out, boolean simple) {
            TextUtils.writeToParcel(this.mText, out, 0);
            out.writeFloat(this.mTextSize);
            out.writeInt(this.mTextStyle);
            out.writeInt(this.mTextColor);
            if (!simple) {
                out.writeInt(this.mTextBackgroundColor);
                out.writeInt(this.mTextSelectionStart);
                out.writeInt(this.mTextSelectionEnd);
                out.writeIntArray(this.mLineCharOffsets);
                out.writeIntArray(this.mLineBaselines);
                out.writeString(this.mHint);
            }
        }
    }

    public static class ViewStructureImpl
    extends ViewStructure {
        final ViewNode mNode = new ViewNode();

        public ViewStructureImpl(View view) {
            this.mNode.mAutofillId = Preconditions.checkNotNull(view).getAutofillId();
            ViewParent parent = view.getParent();
            if (parent instanceof View) {
                this.mNode.mParentAutofillId = ((View)((Object)parent)).getAutofillId();
            }
        }

        public ViewStructureImpl(AutofillId parentId, long virtualId, int sessionId) {
            this.mNode.mParentAutofillId = Preconditions.checkNotNull(parentId);
            this.mNode.mAutofillId = new AutofillId(parentId, virtualId, sessionId);
        }

        public ViewNode getNode() {
            return this.mNode;
        }

        @Override
        public void setId(int id2, String packageName, String typeName, String entryName) {
            this.mNode.mId = id2;
            this.mNode.mIdPackage = packageName;
            this.mNode.mIdType = typeName;
            this.mNode.mIdEntry = entryName;
        }

        @Override
        public void setDimens(int left, int top, int scrollX, int scrollY, int width, int height) {
            this.mNode.mX = left;
            this.mNode.mY = top;
            this.mNode.mScrollX = scrollX;
            this.mNode.mScrollY = scrollY;
            this.mNode.mWidth = width;
            this.mNode.mHeight = height;
        }

        @Override
        public void setTransformation(Matrix matrix) {
            Log.w(TAG, "setTransformation() is not supported");
        }

        @Override
        public void setElevation(float elevation) {
            Log.w(TAG, "setElevation() is not supported");
        }

        @Override
        public void setAlpha(float alpha) {
            Log.w(TAG, "setAlpha() is not supported");
        }

        @Override
        public void setVisibility(int visibility) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFFFFFF3L | (long)visibility & 0xCL;
        }

        @Override
        public void setAssistBlocked(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFFFFBFFL | (state ? 1024L : 0L);
        }

        @Override
        public void setEnabled(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFFFF7FFL | (state ? 0L : 2048L);
        }

        @Override
        public void setClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFFFEFFFL | (state ? 4096L : 0L);
        }

        @Override
        public void setLongClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFFFDFFFL | (state ? 8192L : 0L);
        }

        @Override
        public void setContextClickable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFFFBFFFL | (state ? 16384L : 0L);
        }

        @Override
        public void setFocusable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFFF7FFFL | (state ? 32768L : 0L);
        }

        @Override
        public void setFocused(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFFEFFFFL | (state ? 65536L : 0L);
        }

        @Override
        public void setAccessibilityFocused(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFFDFFFFL | (state ? 131072L : 0L);
        }

        @Override
        public void setCheckable(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFFBFFFFL | (state ? 262144L : 0L);
        }

        @Override
        public void setChecked(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFF7FFFFL | (state ? 524288L : 0L);
        }

        @Override
        public void setSelected(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFEFFFFFL | (state ? 0x100000L : 0L);
        }

        @Override
        public void setActivated(boolean state) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFDFFFFFL | (state ? 0x200000L : 0L);
        }

        @Override
        public void setOpaque(boolean opaque) {
            this.mNode.mFlags = this.mNode.mFlags & 0xFFFFFFFFFFBFFFFFL | (opaque ? 0x400000L : 0L);
        }

        @Override
        public void setClassName(String className) {
            this.mNode.mClassName = className;
        }

        @Override
        public void setContentDescription(CharSequence contentDescription) {
            this.mNode.mContentDescription = contentDescription;
        }

        @Override
        public void setText(CharSequence text) {
            ViewNodeText t = this.getNodeText();
            t.mText = TextUtils.trimNoCopySpans(text);
            t.mTextSelectionEnd = -1;
            t.mTextSelectionStart = -1;
        }

        @Override
        public void setText(CharSequence text, int selectionStart, int selectionEnd) {
            ViewNodeText t = this.getNodeText();
            t.mText = TextUtils.trimNoCopySpans(text);
            t.mTextSelectionStart = selectionStart;
            t.mTextSelectionEnd = selectionEnd;
        }

        @Override
        public void setTextStyle(float size, int fgColor, int bgColor, int style2) {
            ViewNodeText t = this.getNodeText();
            t.mTextColor = fgColor;
            t.mTextBackgroundColor = bgColor;
            t.mTextSize = size;
            t.mTextStyle = style2;
        }

        @Override
        public void setTextLines(int[] charOffsets, int[] baselines) {
            ViewNodeText t = this.getNodeText();
            t.mLineCharOffsets = charOffsets;
            t.mLineBaselines = baselines;
        }

        @Override
        public void setTextIdEntry(String entryName) {
            this.mNode.mTextIdEntry = Preconditions.checkNotNull(entryName);
        }

        @Override
        public void setHint(CharSequence hint) {
            this.getNodeText().mHint = hint != null ? hint.toString() : null;
        }

        @Override
        public void setHintIdEntry(String entryName) {
            this.mNode.mHintIdEntry = Preconditions.checkNotNull(entryName);
        }

        @Override
        public CharSequence getText() {
            return this.mNode.getText();
        }

        @Override
        public int getTextSelectionStart() {
            return this.mNode.getTextSelectionStart();
        }

        @Override
        public int getTextSelectionEnd() {
            return this.mNode.getTextSelectionEnd();
        }

        @Override
        public CharSequence getHint() {
            return this.mNode.getHint();
        }

        @Override
        public Bundle getExtras() {
            if (this.mNode.mExtras != null) {
                return this.mNode.mExtras;
            }
            this.mNode.mExtras = new Bundle();
            return this.mNode.mExtras;
        }

        @Override
        public boolean hasExtras() {
            return this.mNode.mExtras != null;
        }

        @Override
        public void setChildCount(int num) {
            Log.w(TAG, "setChildCount() is not supported");
        }

        @Override
        public int addChildCount(int num) {
            Log.w(TAG, "addChildCount() is not supported");
            return 0;
        }

        @Override
        public int getChildCount() {
            Log.w(TAG, "getChildCount() is not supported");
            return 0;
        }

        @Override
        public ViewStructure newChild(int index) {
            Log.w(TAG, "newChild() is not supported");
            return null;
        }

        @Override
        public ViewStructure asyncNewChild(int index) {
            Log.w(TAG, "asyncNewChild() is not supported");
            return null;
        }

        @Override
        public AutofillId getAutofillId() {
            return this.mNode.mAutofillId;
        }

        @Override
        public void setAutofillId(AutofillId id2) {
            this.mNode.mAutofillId = Preconditions.checkNotNull(id2);
        }

        @Override
        public void setAutofillId(AutofillId parentId, int virtualId) {
            this.mNode.mParentAutofillId = Preconditions.checkNotNull(parentId);
            this.mNode.mAutofillId = new AutofillId(parentId, virtualId);
        }

        @Override
        public void setAutofillType(int type) {
            this.mNode.mAutofillType = type;
        }

        @Override
        public void setReceiveContentMimeTypes(String[] mimeTypes) {
            ViewNode.access$2002(this.mNode, mimeTypes);
        }

        @Override
        public void setAutofillHints(String[] hints) {
            ViewNode.access$2102(this.mNode, hints);
        }

        @Override
        public void setAutofillValue(AutofillValue value) {
            this.mNode.mAutofillValue = value;
        }

        @Override
        public void setAutofillOptions(CharSequence[] options) {
            ViewNode.access$2302(this.mNode, options);
        }

        @Override
        public void setInputType(int inputType) {
            this.mNode.mInputType = inputType;
        }

        @Override
        public void setMinTextEms(int minEms) {
            this.mNode.mMinEms = minEms;
        }

        @Override
        public void setMaxTextEms(int maxEms) {
            this.mNode.mMaxEms = maxEms;
        }

        @Override
        public void setMaxTextLength(int maxLength) {
            this.mNode.mMaxLength = maxLength;
        }

        @Override
        public void setDataIsSensitive(boolean sensitive) {
            Log.w(TAG, "setDataIsSensitive() is not supported");
        }

        @Override
        public void asyncCommit() {
            Log.w(TAG, "asyncCommit() is not supported");
        }

        @Override
        public Rect getTempRect() {
            Log.w(TAG, "getTempRect() is not supported");
            return null;
        }

        @Override
        public void setWebDomain(String domain) {
            Log.w(TAG, "setWebDomain() is not supported");
        }

        @Override
        public void setLocaleList(LocaleList localeList) {
            this.mNode.mLocaleList = localeList;
        }

        @Override
        public ViewStructure.HtmlInfo.Builder newHtmlInfoBuilder(String tagName) {
            Log.w(TAG, "newHtmlInfoBuilder() is not supported");
            return null;
        }

        @Override
        public void setHtmlInfo(ViewStructure.HtmlInfo htmlInfo) {
            Log.w(TAG, "setHtmlInfo() is not supported");
        }

        private ViewNodeText getNodeText() {
            if (this.mNode.mText != null) {
                return this.mNode.mText;
            }
            this.mNode.mText = new ViewNodeText();
            return this.mNode.mText;
        }
    }
}

