/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.os.Bundle;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.view.inputmethod.InputContentInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class InputConnectionInspector {
    private static final Map<Class, Integer> sMissingMethodsMap = Collections.synchronizedMap(new WeakHashMap());

    public static int getMissingMethodFlags(InputConnection ic) {
        if (ic == null) {
            return 0;
        }
        if (ic instanceof BaseInputConnection) {
            return 0;
        }
        if (ic instanceof InputConnectionWrapper) {
            return ((InputConnectionWrapper)ic).getMissingMethodFlags();
        }
        return InputConnectionInspector.getMissingMethodFlagsInternal(ic.getClass());
    }

    public static int getMissingMethodFlagsInternal(Class clazz) {
        Integer cachedFlags = sMissingMethodsMap.get(clazz);
        if (cachedFlags != null) {
            return cachedFlags;
        }
        int flags = 0;
        if (!InputConnectionInspector.hasGetSelectedText(clazz)) {
            flags |= 1;
        }
        if (!InputConnectionInspector.hasSetComposingRegion(clazz)) {
            flags |= 2;
        }
        if (!InputConnectionInspector.hasCommitCorrection(clazz)) {
            flags |= 4;
        }
        if (!InputConnectionInspector.hasRequestCursorUpdate(clazz)) {
            flags |= 8;
        }
        if (!InputConnectionInspector.hasDeleteSurroundingTextInCodePoints(clazz)) {
            flags |= 0x10;
        }
        if (!InputConnectionInspector.hasGetHandler(clazz)) {
            flags |= 0x20;
        }
        if (!InputConnectionInspector.hasCloseConnection(clazz)) {
            flags |= 0x40;
        }
        if (!InputConnectionInspector.hasCommitContent(clazz)) {
            flags |= 0x80;
        }
        if (!InputConnectionInspector.hasGetSurroundingText(clazz)) {
            flags |= 0x100;
        }
        sMissingMethodsMap.put(clazz, flags);
        return flags;
    }

    private static boolean hasGetSelectedText(Class clazz) {
        try {
            Method method = clazz.getMethod("getSelectedText", Integer.TYPE);
            return !Modifier.isAbstract(method.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean hasSetComposingRegion(Class clazz) {
        try {
            Method method = clazz.getMethod("setComposingRegion", Integer.TYPE, Integer.TYPE);
            return !Modifier.isAbstract(method.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean hasCommitCorrection(Class clazz) {
        try {
            Method method = clazz.getMethod("commitCorrection", CorrectionInfo.class);
            return !Modifier.isAbstract(method.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean hasRequestCursorUpdate(Class clazz) {
        try {
            Method method = clazz.getMethod("requestCursorUpdates", Integer.TYPE);
            return !Modifier.isAbstract(method.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean hasDeleteSurroundingTextInCodePoints(Class clazz) {
        try {
            Method method = clazz.getMethod("deleteSurroundingTextInCodePoints", Integer.TYPE, Integer.TYPE);
            return !Modifier.isAbstract(method.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean hasGetHandler(Class clazz) {
        try {
            Method method = clazz.getMethod("getHandler", new Class[0]);
            return !Modifier.isAbstract(method.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean hasCloseConnection(Class clazz) {
        try {
            Method method = clazz.getMethod("closeConnection", new Class[0]);
            return !Modifier.isAbstract(method.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean hasCommitContent(Class clazz) {
        try {
            Method method = clazz.getMethod("commitContent", InputContentInfo.class, Integer.TYPE, Bundle.class);
            return !Modifier.isAbstract(method.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean hasGetSurroundingText(Class clazz) {
        try {
            Method method = clazz.getMethod("getSurroundingText", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return !Modifier.isAbstract(method.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static String getMissingMethodFlagsAsString(int flags) {
        StringBuilder sb = new StringBuilder();
        boolean isEmpty = true;
        if ((flags & 1) != 0) {
            sb.append("getSelectedText(int)");
            isEmpty = false;
        }
        if ((flags & 2) != 0) {
            if (!isEmpty) {
                sb.append(",");
            }
            sb.append("setComposingRegion(int, int)");
            isEmpty = false;
        }
        if ((flags & 4) != 0) {
            if (!isEmpty) {
                sb.append(",");
            }
            sb.append("commitCorrection(CorrectionInfo)");
            isEmpty = false;
        }
        if ((flags & 8) != 0) {
            if (!isEmpty) {
                sb.append(",");
            }
            sb.append("requestCursorUpdate(int)");
            isEmpty = false;
        }
        if ((flags & 0x10) != 0) {
            if (!isEmpty) {
                sb.append(",");
            }
            sb.append("deleteSurroundingTextInCodePoints(int, int)");
            isEmpty = false;
        }
        if ((flags & 0x20) != 0) {
            if (!isEmpty) {
                sb.append(",");
            }
            sb.append("getHandler()");
        }
        if ((flags & 0x40) != 0) {
            if (!isEmpty) {
                sb.append(",");
            }
            sb.append("closeConnection()");
        }
        if ((flags & 0x80) != 0) {
            if (!isEmpty) {
                sb.append(",");
            }
            sb.append("commitContent(InputContentInfo, Bundle)");
        }
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MissingMethodFlags {
        public static final int GET_SELECTED_TEXT = 1;
        public static final int SET_COMPOSING_REGION = 2;
        public static final int COMMIT_CORRECTION = 4;
        public static final int REQUEST_CURSOR_UPDATES = 8;
        public static final int DELETE_SURROUNDING_TEXT_IN_CODE_POINTS = 16;
        public static final int GET_HANDLER = 32;
        public static final int CLOSE_CONNECTION = 64;
        public static final int COMMIT_CONTENT = 128;
        public static final int GET_SURROUNDING_TEXT = 256;
    }
}

