/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class SurroundingText
implements Parcelable {
    private final CharSequence mText;
    private final int mSelectionStart;
    private final int mSelectionEnd;
    private final int mOffset;
    public static final Parcelable.Creator<SurroundingText> CREATOR = new Parcelable.Creator<SurroundingText>(){

        @Override
        public SurroundingText createFromParcel(Parcel in) {
            CharSequence text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            int selectionHead = in.readInt();
            int selectionEnd = in.readInt();
            int offset = in.readInt();
            return new SurroundingText(text == null ? "" : text, selectionHead, selectionEnd, offset);
        }

        public SurroundingText[] newArray(int size) {
            return new SurroundingText[size];
        }
    };

    public SurroundingText(CharSequence text, int selectionStart, int selectionEnd, int offset) {
        this.mText = SurroundingText.copyWithParcelableSpans(text);
        this.mSelectionStart = selectionStart;
        this.mSelectionEnd = selectionEnd;
        this.mOffset = offset;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public int getSelectionStart() {
        return this.mSelectionStart;
    }

    public int getSelectionEnd() {
        return this.mSelectionEnd;
    }

    public int getOffset() {
        return this.mOffset;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        TextUtils.writeToParcel(this.mText, out, flags);
        out.writeInt(this.mSelectionStart);
        out.writeInt(this.mSelectionEnd);
        out.writeInt(this.mOffset);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static CharSequence copyWithParcelableSpans(CharSequence source) {
        if (source == null) {
            return null;
        }
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            TextUtils.writeToParcel(source, parcel, 0);
            parcel.setDataPosition(0);
            CharSequence charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            return charSequence;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
            }
        }
    }
}

