/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.Objects;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class SystemTextClassifierMetadata
implements Parcelable {
    private final String mCallingPackageName;
    private final int mUserId;
    private final boolean mUseDefaultTextClassifier;
    public static final Parcelable.Creator<SystemTextClassifierMetadata> CREATOR = new Parcelable.Creator<SystemTextClassifierMetadata>(){

        @Override
        public SystemTextClassifierMetadata createFromParcel(Parcel in) {
            return SystemTextClassifierMetadata.readFromParcel(in);
        }

        public SystemTextClassifierMetadata[] newArray(int size) {
            return new SystemTextClassifierMetadata[size];
        }
    };

    public SystemTextClassifierMetadata(String packageName, int userId, boolean useDefaultTextClassifier) {
        Objects.requireNonNull(packageName);
        this.mCallingPackageName = packageName;
        this.mUserId = userId;
        this.mUseDefaultTextClassifier = useDefaultTextClassifier;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public String getCallingPackageName() {
        return this.mCallingPackageName;
    }

    public boolean useDefaultTextClassifier() {
        return this.mUseDefaultTextClassifier;
    }

    public String toString() {
        return String.format(Locale.US, "SystemTextClassifierMetadata {callingPackageName=%s, userId=%d, useDefaultTextClassifier=%b}", this.mCallingPackageName, this.mUserId, this.mUseDefaultTextClassifier);
    }

    private static SystemTextClassifierMetadata readFromParcel(Parcel in) {
        String packageName = in.readString();
        int userId = in.readInt();
        boolean useDefaultTextClassifier = in.readBoolean();
        return new SystemTextClassifierMetadata(packageName, userId, useDefaultTextClassifier);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mCallingPackageName);
        dest.writeInt(this.mUserId);
        dest.writeBoolean(this.mUseDefaultTextClassifier);
    }
}

