/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.translation.TranslationSpec;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.BitUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TranslationContext
implements Parcelable {
    public static final int FLAG_LOW_LATENCY = 1;
    public static final int FLAG_TRANSLITERATION = 2;
    public static final int FLAG_DEFINITIONS = 4;
    private final TranslationSpec mSourceSpec;
    private final TranslationSpec mTargetSpec;
    private final int mTranslationFlags;
    public static final Parcelable.Creator<TranslationContext> CREATOR = new Parcelable.Creator<TranslationContext>(){

        public TranslationContext[] newArray(int size) {
            return new TranslationContext[size];
        }

        @Override
        public TranslationContext createFromParcel(Parcel in) {
            return new TranslationContext(in);
        }
    };

    private static int defaultTranslationFlags() {
        return 0;
    }

    public static String translationFlagToString(int value) {
        return BitUtils.flagsToString(value, TranslationContext::singleTranslationFlagToString);
    }

    static String singleTranslationFlagToString(int value) {
        switch (value) {
            case 1: {
                return "FLAG_LOW_LATENCY";
            }
            case 2: {
                return "FLAG_TRANSLITERATION";
            }
            case 4: {
                return "FLAG_DEFINITIONS";
            }
        }
        return Integer.toHexString(value);
    }

    TranslationContext(TranslationSpec sourceSpec, TranslationSpec targetSpec, int translationFlags) {
        this.mSourceSpec = sourceSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSourceSpec);
        this.mTargetSpec = targetSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTargetSpec);
        this.mTranslationFlags = translationFlags;
        Preconditions.checkFlagsArgument(this.mTranslationFlags, 7);
    }

    public TranslationSpec getSourceSpec() {
        return this.mSourceSpec;
    }

    public TranslationSpec getTargetSpec() {
        return this.mTargetSpec;
    }

    public int getTranslationFlags() {
        return this.mTranslationFlags;
    }

    public String toString() {
        return "TranslationContext { sourceSpec = " + this.mSourceSpec + ", targetSpec = " + this.mTargetSpec + ", translationFlags = " + TranslationContext.translationFlagToString(this.mTranslationFlags) + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mSourceSpec, flags);
        dest.writeTypedObject(this.mTargetSpec, flags);
        dest.writeInt(this.mTranslationFlags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TranslationContext(Parcel in) {
        TranslationSpec sourceSpec = in.readTypedObject(TranslationSpec.CREATOR);
        TranslationSpec targetSpec = in.readTypedObject(TranslationSpec.CREATOR);
        int translationFlags = in.readInt();
        this.mSourceSpec = sourceSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSourceSpec);
        this.mTargetSpec = targetSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTargetSpec);
        this.mTranslationFlags = translationFlags;
        Preconditions.checkFlagsArgument(this.mTranslationFlags, 7);
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        private TranslationSpec mSourceSpec;
        private TranslationSpec mTargetSpec;
        private int mTranslationFlags;
        private long mBuilderFieldsSet = 0L;

        public Builder(TranslationSpec sourceSpec, TranslationSpec targetSpec) {
            this.mSourceSpec = sourceSpec;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mSourceSpec);
            this.mTargetSpec = targetSpec;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mTargetSpec);
        }

        public Builder setTranslationFlags(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mTranslationFlags = value;
            return this;
        }

        public TranslationContext build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mTranslationFlags = TranslationContext.defaultTranslationFlags();
            }
            TranslationContext o = new TranslationContext(this.mSourceSpec, this.mTargetSpec, this.mTranslationFlags);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 8L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TranslationFlag {
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }
    }
}

