/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.app.PendingIntent;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SynchronousResultReceiver;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import android.view.translation.ITranslationManager;
import android.view.translation.TranslationCapability;
import android.view.translation.TranslationContext;
import android.view.translation.Translator;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.SyncResultReceiver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class TranslationManager {
    private static final String TAG = "TranslationManager";
    static final int SYNC_CALLS_TIMEOUT_MS = 60000;
    public static final int STATUS_SYNC_CALL_SUCCESS = 1;
    public static final int STATUS_SYNC_CALL_FAIL = 2;
    public static final String EXTRA_CAPABILITIES = "translation_capabilities";
    @GuardedBy(value={"mLock"})
    private final ArrayMap<Pair<Integer, Integer>, ArrayList<PendingIntent>> mTranslationCapabilityUpdateListeners = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private final Map<Consumer<TranslationCapability>, IRemoteCallback> mCapabilityCallbacks = new ArrayMap<Consumer<TranslationCapability>, IRemoteCallback>();
    private static final Random ID_GENERATOR = new Random();
    private final Object mLock = new Object();
    private final Context mContext;
    private final ITranslationManager mService;
    @GuardedBy(value={"mLock"})
    private final SparseArray<Translator> mTranslators = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<TranslationContext, Integer> mTranslatorIds = new ArrayMap();
    private final Handler mHandler;
    private static final AtomicInteger sAvailableRequestId = new AtomicInteger(1);

    public TranslationManager(Context context, ITranslationManager service) {
        this.mContext = Objects.requireNonNull(context, "context cannot be null");
        this.mService = service;
        this.mHandler = Handler.createAsync(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOnDeviceTranslator(final TranslationContext translationContext, final Executor executor, final Consumer<Translator> callback) {
        Objects.requireNonNull(translationContext, "translationContext cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        Object object = this.mLock;
        synchronized (object) {
            int translatorId;
            if (this.mTranslatorIds.containsKey(translationContext)) {
                executor.execute(() -> callback.accept(this.mTranslators.get(this.mTranslatorIds.get(translationContext))));
                return;
            }
            while ((translatorId = Math.abs(ID_GENERATOR.nextInt())) == 0 || this.mTranslators.indexOfKey(translatorId) >= 0) {
            }
            final int tId = translatorId;
            new Translator(this.mContext, translationContext, translatorId, this, this.mHandler, this.mService, new Consumer<Translator>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(Translator translator) {
                    if (translator == null) {
                        long token = Binder.clearCallingIdentity();
                        try {
                            executor.execute(() -> callback.accept(null));
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                        }
                        return;
                    }
                    Object token = TranslationManager.this.mLock;
                    synchronized (token) {
                        TranslationManager.this.mTranslators.put(tId, translator);
                        TranslationManager.this.mTranslatorIds.put(translationContext, tId);
                    }
                    long token2 = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.accept(translator));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token2);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Translator createOnDeviceTranslator(TranslationContext translationContext) {
        Objects.requireNonNull(translationContext, "translationContext cannot be null");
        Object object = this.mLock;
        synchronized (object) {
            int translatorId;
            if (this.mTranslatorIds.containsKey(translationContext)) {
                return this.mTranslators.get(this.mTranslatorIds.get(translationContext));
            }
            while ((translatorId = Math.abs(ID_GENERATOR.nextInt())) == 0 || this.mTranslators.indexOfKey(translatorId) >= 0) {
            }
            Translator newTranslator = new Translator(this.mContext, translationContext, translatorId, this, this.mHandler, this.mService);
            newTranslator.start();
            try {
                if (!newTranslator.isSessionCreated()) {
                    return null;
                }
                this.mTranslators.put(translatorId, newTranslator);
                this.mTranslatorIds.put(translationContext, translatorId);
                return newTranslator;
            }
            catch (Translator.ServiceBinderReceiver.TimeoutException e) {
                Log.e(TAG, "Timed out getting create session: " + e);
                return null;
            }
        }
    }

    @Deprecated
    public Translator createTranslator(TranslationContext translationContext) {
        return this.createOnDeviceTranslator(translationContext);
    }

    public Set<TranslationCapability> getOnDeviceTranslationCapabilities(int sourceFormat, int targetFormat) {
        try {
            SynchronousResultReceiver receiver = new SynchronousResultReceiver();
            this.mService.onTranslationCapabilitiesRequest(sourceFormat, targetFormat, receiver, this.mContext.getUserId());
            SynchronousResultReceiver.Result result = receiver.awaitResult(60000L);
            if (result.resultCode != 1) {
                return Collections.emptySet();
            }
            Parcelable[] parcelables = result.bundle.getParcelableArray(EXTRA_CAPABILITIES);
            ArraySet<TranslationCapability> capabilities = new ArraySet<TranslationCapability>();
            for (Parcelable obj : parcelables) {
                if (!(obj instanceof TranslationCapability)) continue;
                capabilities.add((TranslationCapability)obj);
            }
            return capabilities;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (TimeoutException e) {
            Log.e(TAG, "Timed out getting supported translation capabilities: " + e);
            return Collections.emptySet();
        }
    }

    @Deprecated
    public Set<TranslationCapability> getTranslationCapabilities(int sourceFormat, int targetFormat) {
        return this.getOnDeviceTranslationCapabilities(sourceFormat, targetFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnDeviceTranslationCapabilityUpdateListener(Executor executor, Consumer<TranslationCapability> capabilityListener) {
        Objects.requireNonNull(executor, "executor should not be null");
        Objects.requireNonNull(capabilityListener, "capability listener should not be null");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCapabilityCallbacks.containsKey(capabilityListener)) {
                Log.w(TAG, "addOnDeviceTranslationCapabilityUpdateListener: the listener for " + capabilityListener + " already registered; ignoring.");
                return;
            }
            TranslationCapabilityRemoteCallback remoteCallback = new TranslationCapabilityRemoteCallback(executor, capabilityListener);
            try {
                this.mService.registerTranslationCapabilityCallback(remoteCallback, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCapabilityCallbacks.put(capabilityListener, remoteCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addOnDeviceTranslationCapabilityUpdateListener(int sourceFormat, int targetFormat, PendingIntent pendingIntent) {
        Objects.requireNonNull(pendingIntent, "pending intent should not be null");
        Object object = this.mLock;
        synchronized (object) {
            Pair<Integer, Integer> formatPair = new Pair<Integer, Integer>(sourceFormat, targetFormat);
            this.mTranslationCapabilityUpdateListeners.computeIfAbsent(formatPair, formats -> new ArrayList()).add(pendingIntent);
        }
    }

    @Deprecated
    public void addTranslationCapabilityUpdateListener(int sourceFormat, int targetFormat, PendingIntent pendingIntent) {
        this.addOnDeviceTranslationCapabilityUpdateListener(sourceFormat, targetFormat, pendingIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnDeviceTranslationCapabilityUpdateListener(Consumer<TranslationCapability> capabilityListener) {
        Objects.requireNonNull(capabilityListener, "capability callback should not be null");
        Object object = this.mLock;
        synchronized (object) {
            IRemoteCallback remoteCallback = this.mCapabilityCallbacks.get(capabilityListener);
            if (remoteCallback == null) {
                Log.w(TAG, "removeOnDeviceTranslationCapabilityUpdateListener: the capability listener not found; ignoring.");
                return;
            }
            try {
                this.mService.unregisterTranslationCapabilityCallback(remoteCallback, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCapabilityCallbacks.remove(capabilityListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeOnDeviceTranslationCapabilityUpdateListener(int sourceFormat, int targetFormat, PendingIntent pendingIntent) {
        Objects.requireNonNull(pendingIntent, "pending intent should not be null");
        Object object = this.mLock;
        synchronized (object) {
            Pair<Integer, Integer> formatPair = new Pair<Integer, Integer>(sourceFormat, targetFormat);
            if (this.mTranslationCapabilityUpdateListeners.containsKey(formatPair)) {
                ArrayList<PendingIntent> intents = this.mTranslationCapabilityUpdateListeners.get(formatPair);
                if (intents.contains(pendingIntent)) {
                    intents.remove(pendingIntent);
                } else {
                    Log.w(TAG, "pending intent=" + pendingIntent + " does not exist in mTranslationCapabilityUpdateListeners");
                }
            } else {
                Log.w(TAG, "format pair=" + formatPair + " does not exist in mTranslationCapabilityUpdateListeners");
            }
        }
    }

    @Deprecated
    public void removeTranslationCapabilityUpdateListener(int sourceFormat, int targetFormat, PendingIntent pendingIntent) {
        this.removeOnDeviceTranslationCapabilityUpdateListener(sourceFormat, targetFormat, pendingIntent);
    }

    public PendingIntent getOnDeviceTranslationSettingsActivityIntent() {
        SyncResultReceiver resultReceiver = new SyncResultReceiver(60000);
        try {
            this.mService.getServiceSettingsActivity(resultReceiver, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        try {
            return (PendingIntent)resultReceiver.getParcelableResult();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            Log.e(TAG, "Fail to get translation service settings activity.");
            return null;
        }
    }

    @Deprecated
    public PendingIntent getTranslationSettingsActivityIntent() {
        return this.getOnDeviceTranslationSettingsActivityIntent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTranslator(int id2) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTranslators.remove(id2);
            for (int i = 0; i < this.mTranslatorIds.size(); ++i) {
                if (this.mTranslatorIds.valueAt(i) != id2) continue;
                this.mTranslatorIds.removeAt(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AtomicInteger getAvailableRequestId() {
        Object object = this.mLock;
        synchronized (object) {
            return sAvailableRequestId;
        }
    }

    private static class TranslationCapabilityRemoteCallback
    extends IRemoteCallback.Stub {
        private final Executor mExecutor;
        private final Consumer<TranslationCapability> mListener;

        TranslationCapabilityRemoteCallback(Executor executor, Consumer<TranslationCapability> listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void sendResult(Bundle bundle) {
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.onTranslationCapabilityUpdate(bundle)));
        }

        private void onTranslationCapabilityUpdate(Bundle bundle) {
            TranslationCapability capability = (TranslationCapability)bundle.getParcelable(TranslationManager.EXTRA_CAPABILITIES);
            this.mListener.accept(capability);
        }
    }
}

