/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.os.Handler;

class DoubleDigitManager {
    private final long timeoutInMillis;
    private final CallBack mCallBack;
    private Integer intermediateDigit;

    public DoubleDigitManager(long timeoutInMillis, CallBack callBack) {
        this.timeoutInMillis = timeoutInMillis;
        this.mCallBack = callBack;
    }

    public void reportDigit(int digit) {
        if (this.intermediateDigit == null) {
            this.intermediateDigit = digit;
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (DoubleDigitManager.this.intermediateDigit != null) {
                        DoubleDigitManager.this.mCallBack.singleDigitFinal(DoubleDigitManager.this.intermediateDigit);
                        DoubleDigitManager.this.intermediateDigit = null;
                    }
                }
            }, this.timeoutInMillis);
            if (!this.mCallBack.singleDigitIntermediate(digit)) {
                this.intermediateDigit = null;
                this.mCallBack.singleDigitFinal(digit);
            }
        } else if (this.mCallBack.twoDigitsFinal(this.intermediateDigit, digit)) {
            this.intermediateDigit = null;
        }
    }

    static interface CallBack {
        public boolean singleDigitIntermediate(int var1);

        public void singleDigitFinal(int var1);

        public boolean twoDigitsFinal(int var1, int var2);
    }
}

