/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.ResourceCursorAdapter;
import android.widget.SearchView;
import android.widget.TextView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.WeakHashMap;

class SuggestionsAdapter
extends ResourceCursorAdapter
implements View.OnClickListener {
    private static final boolean DBG = false;
    private static final String LOG_TAG = "SuggestionsAdapter";
    private static final int QUERY_LIMIT = 50;
    static final int REFINE_NONE = 0;
    static final int REFINE_BY_ENTRY = 1;
    static final int REFINE_ALL = 2;
    private final SearchManager mSearchManager = (SearchManager)this.mContext.getSystemService("search");
    private final SearchView mSearchView;
    private final SearchableInfo mSearchable;
    private final Context mProviderContext;
    private final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private final int mCommitIconResId;
    private boolean mClosed = false;
    private int mQueryRefinement = 1;
    private ColorStateList mUrlColor;
    static final int INVALID_INDEX = -1;
    private int mText1Col = -1;
    private int mText2Col = -1;
    private int mText2UrlCol = -1;
    private int mIconName1Col = -1;
    private int mIconName2Col = -1;
    private int mFlagsCol = -1;
    private static final long DELETE_KEY_POST_DELAY = 500L;

    public SuggestionsAdapter(Context context, SearchView searchView, SearchableInfo searchable, WeakHashMap<String, Drawable.ConstantState> outsideDrawablesCache) {
        super(context, searchView.getSuggestionRowLayout(), null, true);
        this.mSearchView = searchView;
        this.mSearchable = searchable;
        this.mCommitIconResId = searchView.getSuggestionCommitIconResId();
        Context activityContext = this.mSearchable.getActivityContext(this.mContext);
        this.mProviderContext = this.mSearchable.getProviderContext(this.mContext, activityContext);
        this.mOutsideDrawablesCache = outsideDrawablesCache;
        this.getFilter().setDelayer(new Filter.Delayer(){
            private int mPreviousLength = 0;

            @Override
            public long getPostingDelay(CharSequence constraint) {
                if (constraint == null) {
                    return 0L;
                }
                long delay = constraint.length() < this.mPreviousLength ? 500L : 0L;
                this.mPreviousLength = constraint.length();
                return delay;
            }
        });
    }

    public void setQueryRefinement(int refineWhat) {
        this.mQueryRefinement = refineWhat;
    }

    public int getQueryRefinement() {
        return this.mQueryRefinement;
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
        String query = constraint == null ? "" : constraint.toString();
        Cursor cursor = null;
        if (this.mSearchView.getVisibility() != 0 || this.mSearchView.getWindowVisibility() != 0) {
            return null;
        }
        try {
            cursor = this.mSearchManager.getSuggestions(this.mSearchable, query, 50);
            if (cursor != null) {
                cursor.getCount();
                return cursor;
            }
        }
        catch (RuntimeException e) {
            Log.w(LOG_TAG, "Search suggestions query threw an exception.", e);
        }
        return null;
    }

    public void close() {
        this.changeCursor(null);
        this.mClosed = true;
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.updateSpinnerState(this.getCursor());
    }

    @Override
    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        this.updateSpinnerState(this.getCursor());
    }

    private void updateSpinnerState(Cursor cursor) {
        Bundle extras;
        Bundle bundle = extras = cursor != null ? cursor.getExtras() : null;
        if (extras != null && extras.getBoolean("in_progress")) {
            return;
        }
    }

    @Override
    public void changeCursor(Cursor c) {
        if (this.mClosed) {
            Log.w(LOG_TAG, "Tried to change cursor after adapter was closed.");
            if (c != null) {
                c.close();
            }
            return;
        }
        try {
            super.changeCursor(c);
            if (c != null) {
                this.mText1Col = c.getColumnIndex("suggest_text_1");
                this.mText2Col = c.getColumnIndex("suggest_text_2");
                this.mText2UrlCol = c.getColumnIndex("suggest_text_2_url");
                this.mIconName1Col = c.getColumnIndex("suggest_icon_1");
                this.mIconName2Col = c.getColumnIndex("suggest_icon_2");
                this.mFlagsCol = c.getColumnIndex("suggest_flags");
            }
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "error changing cursor and caching columns", e);
        }
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        View v = super.newView(context, cursor, parent);
        v.setTag(new ChildViewCache(v));
        ImageView iconRefine = (ImageView)v.findViewById(16908943);
        iconRefine.setImageResource(this.mCommitIconResId);
        return v;
    }

    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        ChildViewCache views = (ChildViewCache)view.getTag();
        int flags = 0;
        if (this.mFlagsCol != -1) {
            flags = cursor.getInt(this.mFlagsCol);
        }
        if (views.mText1 != null) {
            String text1 = SuggestionsAdapter.getStringOrNull(cursor, this.mText1Col);
            this.setViewText(views.mText1, text1);
        }
        if (views.mText2 != null) {
            CharSequence text2 = SuggestionsAdapter.getStringOrNull(cursor, this.mText2UrlCol);
            text2 = text2 != null ? this.formatUrl(context, text2) : SuggestionsAdapter.getStringOrNull(cursor, this.mText2Col);
            if (TextUtils.isEmpty(text2)) {
                if (views.mText1 != null) {
                    views.mText1.setSingleLine(false);
                    views.mText1.setMaxLines(2);
                }
            } else if (views.mText1 != null) {
                views.mText1.setSingleLine(true);
                views.mText1.setMaxLines(1);
            }
            this.setViewText(views.mText2, text2);
        }
        if (views.mIcon1 != null) {
            this.setViewDrawable(views.mIcon1, this.getIcon1(cursor), 4);
        }
        if (views.mIcon2 != null) {
            this.setViewDrawable(views.mIcon2, this.getIcon2(cursor), 8);
        }
        if (this.mQueryRefinement == 2 || this.mQueryRefinement == 1 && (flags & 1) != 0) {
            views.mIconRefine.setVisibility(0);
            views.mIconRefine.setTag(views.mText1.getText());
            views.mIconRefine.setOnClickListener(this);
        } else {
            views.mIconRefine.setVisibility(8);
        }
    }

    @Override
    public void onClick(View v) {
        Object tag = v.getTag();
        if (tag instanceof CharSequence) {
            this.mSearchView.onQueryRefine((CharSequence)tag);
        }
    }

    private CharSequence formatUrl(Context context, CharSequence url) {
        if (this.mUrlColor == null) {
            TypedValue colorValue = new TypedValue();
            context.getTheme().resolveAttribute(17957104, colorValue, true);
            this.mUrlColor = context.getColorStateList(colorValue.resourceId);
        }
        SpannableString text = new SpannableString(url);
        text.setSpan(new TextAppearanceSpan(null, 0, 0, this.mUrlColor, null), 0, url.length(), 33);
        return text;
    }

    private void setViewText(TextView v, CharSequence text) {
        v.setText(text);
        if (TextUtils.isEmpty(text)) {
            v.setVisibility(8);
        } else {
            v.setVisibility(0);
        }
    }

    private Drawable getIcon1(Cursor cursor) {
        if (this.mIconName1Col == -1) {
            return null;
        }
        String value = cursor.getString(this.mIconName1Col);
        Drawable drawable2 = this.getDrawableFromResourceValue(value);
        if (drawable2 != null) {
            return drawable2;
        }
        return this.getDefaultIcon1(cursor);
    }

    private Drawable getIcon2(Cursor cursor) {
        if (this.mIconName2Col == -1) {
            return null;
        }
        String value = cursor.getString(this.mIconName2Col);
        return this.getDrawableFromResourceValue(value);
    }

    private void setViewDrawable(ImageView v, Drawable drawable2, int nullVisibility) {
        v.setImageDrawable(drawable2);
        if (drawable2 == null) {
            v.setVisibility(nullVisibility);
        } else {
            v.setVisibility(0);
            drawable2.setVisible(false, false);
            drawable2.setVisible(true, false);
        }
    }

    @Override
    public CharSequence convertToString(Cursor cursor) {
        String text1;
        String data;
        if (cursor == null) {
            return null;
        }
        String query = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
        if (query != null) {
            return query;
        }
        if (this.mSearchable.shouldRewriteQueryFromData() && (data = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) != null) {
            return data;
        }
        if (this.mSearchable.shouldRewriteQueryFromText() && (text1 = SuggestionsAdapter.getColumnString(cursor, "suggest_text_1")) != null) {
            return text1;
        }
        return null;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        try {
            return super.getView(position, convertView, parent);
        }
        catch (RuntimeException e) {
            Log.w(LOG_TAG, "Search suggestions cursor threw exception.", e);
            View v = this.newView(this.mContext, this.mCursor, parent);
            if (v != null) {
                ChildViewCache views = (ChildViewCache)v.getTag();
                TextView tv = views.mText1;
                tv.setText(e.toString());
            }
            return v;
        }
    }

    @Override
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        try {
            return super.getDropDownView(position, convertView, parent);
        }
        catch (RuntimeException e) {
            Log.w(LOG_TAG, "Search suggestions cursor threw exception.", e);
            Context context = this.mDropDownContext == null ? this.mContext : this.mDropDownContext;
            View v = this.newDropDownView(context, this.mCursor, parent);
            if (v != null) {
                ChildViewCache views = (ChildViewCache)v.getTag();
                TextView tv = views.mText1;
                tv.setText(e.toString());
            }
            return v;
        }
    }

    private Drawable getDrawableFromResourceValue(String drawableId) {
        if (drawableId == null || drawableId.length() == 0 || "0".equals(drawableId)) {
            return null;
        }
        try {
            int resourceId = Integer.parseInt(drawableId);
            String drawableUri = "android.resource://" + this.mProviderContext.getPackageName() + "/" + resourceId;
            Drawable drawable2 = this.checkIconCache(drawableUri);
            if (drawable2 != null) {
                return drawable2;
            }
            drawable2 = this.mProviderContext.getDrawable(resourceId);
            this.storeInIconCache(drawableUri, drawable2);
            return drawable2;
        }
        catch (NumberFormatException nfe) {
            Drawable drawable3 = this.checkIconCache(drawableId);
            if (drawable3 != null) {
                return drawable3;
            }
            Uri uri = Uri.parse(drawableId);
            drawable3 = this.getDrawable(uri);
            this.storeInIconCache(drawableId, drawable3);
            return drawable3;
        }
        catch (Resources.NotFoundException nfe) {
            Log.w(LOG_TAG, "Icon resource not found: " + drawableId);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable getDrawable(Uri uri) {
        Drawable drawable2;
        String scheme = uri.getScheme();
        if ("android.resource".equals(scheme)) {
            ContentResolver.OpenResourceIdResult r = this.mProviderContext.getContentResolver().getResourceId(uri);
            try {
                return r.r.getDrawable(r.id, this.mProviderContext.getTheme());
            }
            catch (Resources.NotFoundException ex) {
                throw new FileNotFoundException("Resource does not exist: " + uri);
            }
        }
        InputStream stream = this.mProviderContext.getContentResolver().openInputStream(uri);
        if (stream == null) {
            throw new FileNotFoundException("Failed to open " + uri);
        }
        try {
            drawable2 = Drawable.createFromStream(stream, null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    Log.e(LOG_TAG, "Error closing icon stream for " + uri, ex);
                }
                throw throwable;
            }
            catch (FileNotFoundException fnfe) {
                Log.w(LOG_TAG, "Icon not found: " + uri + ", " + fnfe.getMessage());
                return null;
            }
        }
        try {
            stream.close();
        }
        catch (IOException ex) {
            Log.e(LOG_TAG, "Error closing icon stream for " + uri, ex);
        }
        return drawable2;
    }

    private Drawable checkIconCache(String resourceUri) {
        Drawable.ConstantState cached = this.mOutsideDrawablesCache.get(resourceUri);
        if (cached == null) {
            return null;
        }
        return cached.newDrawable();
    }

    private void storeInIconCache(String resourceUri, Drawable drawable2) {
        if (drawable2 != null) {
            this.mOutsideDrawablesCache.put(resourceUri, drawable2.getConstantState());
        }
    }

    private Drawable getDefaultIcon1(Cursor cursor) {
        Drawable drawable2 = this.getActivityIconWithCache(this.mSearchable.getSearchActivity());
        if (drawable2 != null) {
            return drawable2;
        }
        return this.mContext.getPackageManager().getDefaultActivityIcon();
    }

    private Drawable getActivityIconWithCache(ComponentName component) {
        String componentIconKey = component.flattenToShortString();
        if (this.mOutsideDrawablesCache.containsKey(componentIconKey)) {
            Drawable.ConstantState cached = this.mOutsideDrawablesCache.get(componentIconKey);
            return cached == null ? null : cached.newDrawable(this.mProviderContext.getResources());
        }
        Drawable drawable2 = this.getActivityIcon(component);
        Drawable.ConstantState toCache = drawable2 == null ? null : drawable2.getConstantState();
        this.mOutsideDrawablesCache.put(componentIconKey, toCache);
        return drawable2;
    }

    private Drawable getActivityIcon(ComponentName component) {
        ActivityInfo activityInfo;
        PackageManager pm = this.mContext.getPackageManager();
        try {
            activityInfo = pm.getActivityInfo(component, 128);
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.w(LOG_TAG, ex.toString());
            return null;
        }
        int iconId = activityInfo.getIconResource();
        if (iconId == 0) {
            return null;
        }
        String pkg = component.getPackageName();
        Drawable drawable2 = pm.getDrawable(pkg, iconId, activityInfo.applicationInfo);
        if (drawable2 == null) {
            Log.w(LOG_TAG, "Invalid icon resource " + iconId + " for " + component.flattenToShortString());
            return null;
        }
        return drawable2;
    }

    public static String getColumnString(Cursor cursor, String columnName) {
        int col = cursor.getColumnIndex(columnName);
        return SuggestionsAdapter.getStringOrNull(cursor, col);
    }

    private static String getStringOrNull(Cursor cursor, int col) {
        if (col == -1) {
            return null;
        }
        try {
            return cursor.getString(col);
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "unexpected error retrieving valid column from cursor, did the remote process die?", e);
            return null;
        }
    }

    private static class ChildViewCache {
        public final TextView mText1;
        public final TextView mText2;
        public final ImageView mIcon1;
        public final ImageView mIcon2;
        public final ImageView mIconRefine;

        public ChildViewCache(View v) {
            this.mText1 = (TextView)v.findViewById(16908308);
            this.mText2 = (TextView)v.findViewById(16908309);
            this.mIcon1 = (ImageView)v.findViewById(16908295);
            this.mIcon2 = (ImageView)v.findViewById(16908296);
            this.mIconRefine = (ImageView)v.findViewById(16908943);
        }
    }
}

