/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.text.TextUtils;
import android.text.method.TransformationMethod;
import android.text.method.TranslationTransformationMethod;
import android.util.Log;
import android.view.View;
import android.view.translation.ViewTranslationCallback;
import android.view.translation.ViewTranslationResponse;
import android.widget.TextView;

public class TextViewTranslationCallback
implements ViewTranslationCallback {
    private static final String TAG = "TextViewTranslationCb";
    private static final boolean DEBUG = Log.isLoggable("UiTranslation", 3);
    private TranslationTransformationMethod mTranslationTransformation;
    private boolean mIsShowingTranslation = false;
    private boolean mIsTextPaddingEnabled = false;
    private CharSequence mPaddedText;
    private int mAnimationDurationMillis = 250;
    private CharSequence mContentDescription;
    private static final char COMPAT_PAD_CHARACTER = '\u2002';
    private ValueAnimator mAnimator;

    private void clearTranslationTransformation() {
        if (DEBUG) {
            Log.v(TAG, "clearTranslationTransformation: " + this.mTranslationTransformation);
        }
        this.mTranslationTransformation = null;
    }

    @Override
    public boolean onShowTranslation(View view) {
        CharSequence translatedContentDescription;
        ViewTranslationResponse response = view.getViewTranslationResponse();
        if (response == null) {
            Log.e(TAG, "onShowTranslation() shouldn't be called before onViewTranslationResponse().");
            return false;
        }
        if (this.mTranslationTransformation == null) {
            TransformationMethod originalTranslationMethod = ((TextView)view).getTransformationMethod();
            this.mTranslationTransformation = new TranslationTransformationMethod(response, originalTranslationMethod);
        }
        TranslationTransformationMethod transformation = this.mTranslationTransformation;
        this.runWithAnimation((TextView)view, () -> {
            this.mIsShowingTranslation = true;
            ((TextView)view).setTransformationMethod(transformation);
        });
        if (response.getKeys().contains("android:content_description") && !TextUtils.isEmpty(translatedContentDescription = response.getValue("android:content_description").getText())) {
            this.mContentDescription = view.getContentDescription();
            view.setContentDescription(translatedContentDescription);
        }
        return true;
    }

    @Override
    public boolean onHideTranslation(View view) {
        if (view.getViewTranslationResponse() == null) {
            Log.e(TAG, "onHideTranslation() shouldn't be called before onViewTranslationResponse().");
            return false;
        }
        if (this.mTranslationTransformation != null) {
            TransformationMethod transformation = this.mTranslationTransformation.getOriginalTransformationMethod();
            this.runWithAnimation((TextView)view, () -> {
                this.mIsShowingTranslation = false;
                ((TextView)view).setTransformationMethod(transformation);
            });
            if (!TextUtils.isEmpty(this.mContentDescription)) {
                view.setContentDescription(this.mContentDescription);
            }
        } else {
            if (DEBUG) {
                Log.w(TAG, "onHideTranslation(): no translated text.");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean onClearTranslation(View view) {
        if (this.mTranslationTransformation == null) {
            if (DEBUG) {
                Log.w(TAG, "onClearTranslation(): no translated text.");
            }
            return false;
        }
        this.onHideTranslation(view);
        this.clearTranslationTransformation();
        this.mPaddedText = null;
        this.mContentDescription = null;
        return true;
    }

    boolean isShowingTranslation() {
        return this.mIsShowingTranslation;
    }

    @Override
    public void enableContentPadding() {
        this.mIsTextPaddingEnabled = true;
    }

    boolean isTextPaddingEnabled() {
        return this.mIsTextPaddingEnabled;
    }

    CharSequence getPaddedText(CharSequence text, CharSequence translatedText) {
        if (text == null) {
            return null;
        }
        if (this.mPaddedText == null) {
            this.mPaddedText = this.computePaddedText(text, translatedText);
        }
        return this.mPaddedText;
    }

    private CharSequence computePaddedText(CharSequence text, CharSequence translatedText) {
        if (translatedText == null) {
            return text;
        }
        int newLength = translatedText.length();
        if (newLength <= text.length()) {
            return text;
        }
        StringBuilder sb = new StringBuilder(newLength);
        sb.append(text);
        for (int i = text.length(); i < newLength; ++i) {
            sb.append('\u2002');
        }
        return sb;
    }

    @Override
    public void setAnimationDurationMillis(int durationMillis) {
        this.mAnimationDurationMillis = durationMillis;
    }

    private void runWithAnimation(final TextView view, final Runnable runnable) {
        if (this.mAnimator != null) {
            this.mAnimator.end();
        }
        int fadedOutColor = TextViewTranslationCallback.colorWithAlpha(view.getCurrentTextColor(), 0);
        this.mAnimator = ValueAnimator.ofArgb(view.getCurrentTextColor(), fadedOutColor);
        this.mAnimator.addUpdateListener(valueAnimator -> view.setTextColor((Integer)valueAnimator.getAnimatedValue()));
        this.mAnimator.setRepeatMode(2);
        this.mAnimator.setRepeatCount(1);
        this.mAnimator.setDuration(this.mAnimationDurationMillis);
        final ColorStateList originalColors = view.getTextColors();
        this.mAnimator.addListener(new Animator.AnimatorListener(){

            @Override
            public void onAnimationStart(Animator animation) {
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                view.setTextColor(originalColors);
                TextViewTranslationCallback.this.mAnimator = null;
            }

            @Override
            public void onAnimationCancel(Animator animation) {
            }

            @Override
            public void onAnimationRepeat(Animator animation) {
                runnable.run();
            }
        });
        this.mAnimator.start();
    }

    private static int colorWithAlpha(int color2, int newAlpha) {
        return Color.argb(newAlpha, Color.red(color2), Color.green(color2), Color.blue(color2));
    }
}

