/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.icu.text.DateFormatSymbols;
import android.icu.util.Calendar;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.Log;
import android.util.MathUtils;
import android.view.View;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.widget.FrameLayout;
import android.widget.TimePickerClockDelegate;
import android.widget.TimePickerSpinnerDelegate;
import com.android.internal.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public class TimePicker
extends FrameLayout {
    private static final String LOG_TAG = TimePicker.class.getSimpleName();
    public static final int MODE_SPINNER = 1;
    public static final int MODE_CLOCK = 2;
    @UnsupportedAppUsage
    private final TimePickerDelegate mDelegate;
    private final int mMode;

    public TimePicker(Context context) {
        this(context, null);
    }

    public TimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 16843933);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (this.getImportantForAutofill() == 0) {
            this.setImportantForAutofill(1);
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.TimePicker, attrs, a, defStyleAttr, defStyleRes);
        boolean isDialogMode = a.getBoolean(10, false);
        int requestedMode = a.getInt(8, 1);
        a.recycle();
        this.mMode = requestedMode == 2 && isDialogMode ? context.getResources().getInteger(17694989) : requestedMode;
        switch (this.mMode) {
            case 2: {
                this.mDelegate = new TimePickerClockDelegate(this, context, attrs, defStyleAttr, defStyleRes);
                break;
            }
            default: {
                this.mDelegate = new TimePickerSpinnerDelegate(this, context, attrs, defStyleAttr, defStyleRes);
            }
        }
        this.mDelegate.setAutoFillChangeListener((v, h, m) -> {
            AutofillManager afm = context.getSystemService(AutofillManager.class);
            if (afm != null) {
                afm.notifyValueChanged(this);
            }
        });
    }

    public int getMode() {
        return this.mMode;
    }

    public void setHour(int hour) {
        this.mDelegate.setHour(MathUtils.constrain(hour, 0, 23));
    }

    public int getHour() {
        return this.mDelegate.getHour();
    }

    public void setMinute(int minute) {
        this.mDelegate.setMinute(MathUtils.constrain(minute, 0, 59));
    }

    public int getMinute() {
        return this.mDelegate.getMinute();
    }

    @Deprecated
    public void setCurrentHour(Integer currentHour) {
        this.setHour(currentHour);
    }

    @Deprecated
    public Integer getCurrentHour() {
        return this.getHour();
    }

    @Deprecated
    public void setCurrentMinute(Integer currentMinute) {
        this.setMinute(currentMinute);
    }

    @Deprecated
    public Integer getCurrentMinute() {
        return this.getMinute();
    }

    public void setIs24HourView(Boolean is24HourView) {
        if (is24HourView == null) {
            return;
        }
        this.mDelegate.setIs24Hour(is24HourView);
    }

    public boolean is24HourView() {
        return this.mDelegate.is24Hour();
    }

    public void setOnTimeChangedListener(OnTimeChangedListener onTimeChangedListener) {
        this.mDelegate.setOnTimeChangedListener(onTimeChangedListener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mDelegate.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.mDelegate.isEnabled();
    }

    @Override
    public int getBaseline() {
        return this.mDelegate.getBaseline();
    }

    public boolean validateInput() {
        return this.mDelegate.validateInput();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return this.mDelegate.onSaveInstanceState(superState);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState ss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mDelegate.onRestoreInstanceState(ss);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return TimePicker.class.getName();
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        return this.mDelegate.dispatchPopulateAccessibilityEvent(event);
    }

    public View getHourView() {
        return this.mDelegate.getHourView();
    }

    public View getMinuteView() {
        return this.mDelegate.getMinuteView();
    }

    public View getAmView() {
        return this.mDelegate.getAmView();
    }

    public View getPmView() {
        return this.mDelegate.getPmView();
    }

    static String[] getAmPmStrings(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        DateFormatSymbols dfs = DateFormat.getIcuDateFormatSymbols(locale);
        String[] amPm = dfs.getAmPmStrings();
        String[] narrowAmPm = dfs.getAmpmNarrowStrings();
        String[] result = new String[]{amPm[0].length() > 4 ? narrowAmPm[0] : amPm[0], amPm[1].length() > 4 ? narrowAmPm[1] : amPm[1]};
        return result;
    }

    @Override
    public void dispatchProvideAutofillStructure(ViewStructure structure, int flags) {
        structure.setAutofillId(this.getAutofillId());
        this.onProvideAutofillStructure(structure, flags);
    }

    @Override
    public void autofill(AutofillValue value) {
        if (!this.isEnabled()) {
            return;
        }
        this.mDelegate.autofill(value);
    }

    @Override
    public int getAutofillType() {
        return this.isEnabled() ? 4 : 0;
    }

    @Override
    public AutofillValue getAutofillValue() {
        return this.isEnabled() ? this.mDelegate.getAutofillValue() : null;
    }

    static abstract class AbstractTimePickerDelegate
    implements TimePickerDelegate {
        protected final TimePicker mDelegator;
        protected final Context mContext;
        protected final Locale mLocale;
        protected OnTimeChangedListener mOnTimeChangedListener;
        protected OnTimeChangedListener mAutoFillChangeListener;
        private long mAutofilledValue;

        public AbstractTimePickerDelegate(TimePicker delegator, Context context) {
            this.mDelegator = delegator;
            this.mContext = context;
            this.mLocale = context.getResources().getConfiguration().locale;
        }

        @Override
        public void setOnTimeChangedListener(OnTimeChangedListener callback) {
            this.mOnTimeChangedListener = callback;
        }

        @Override
        public void setAutoFillChangeListener(OnTimeChangedListener callback) {
            this.mAutoFillChangeListener = callback;
        }

        @Override
        public void autofill(AutofillValue value) {
            if (value == null || !value.isDate()) {
                Log.w(LOG_TAG, value + " could not be autofilled into " + this);
                return;
            }
            long time = value.getDateValue();
            Calendar cal = Calendar.getInstance(this.mLocale);
            cal.setTimeInMillis(time);
            this.setDate(cal.get(11), cal.get(12));
            this.mAutofilledValue = time;
        }

        @Override
        public AutofillValue getAutofillValue() {
            if (this.mAutofilledValue != 0L) {
                return AutofillValue.forDate(this.mAutofilledValue);
            }
            Calendar cal = Calendar.getInstance(this.mLocale);
            cal.set(11, this.getHour());
            cal.set(12, this.getMinute());
            return AutofillValue.forDate(cal.getTimeInMillis());
        }

        protected void resetAutofilledValue() {
            this.mAutofilledValue = 0L;
        }

        protected static class SavedState
        extends View.BaseSavedState {
            private final int mHour;
            private final int mMinute;
            private final boolean mIs24HourMode;
            private final int mCurrentItemShowing;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

                @Override
                public SavedState createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            public SavedState(Parcelable superState, int hour, int minute, boolean is24HourMode) {
                this(superState, hour, minute, is24HourMode, 0);
            }

            public SavedState(Parcelable superState, int hour, int minute, boolean is24HourMode, int currentItemShowing) {
                super(superState);
                this.mHour = hour;
                this.mMinute = minute;
                this.mIs24HourMode = is24HourMode;
                this.mCurrentItemShowing = currentItemShowing;
            }

            private SavedState(Parcel in) {
                super(in);
                this.mHour = in.readInt();
                this.mMinute = in.readInt();
                this.mIs24HourMode = in.readInt() == 1;
                this.mCurrentItemShowing = in.readInt();
            }

            public int getHour() {
                return this.mHour;
            }

            public int getMinute() {
                return this.mMinute;
            }

            public boolean is24HourMode() {
                return this.mIs24HourMode;
            }

            public int getCurrentItemShowing() {
                return this.mCurrentItemShowing;
            }

            @Override
            public void writeToParcel(Parcel dest, int flags) {
                super.writeToParcel(dest, flags);
                dest.writeInt(this.mHour);
                dest.writeInt(this.mMinute);
                dest.writeInt(this.mIs24HourMode ? 1 : 0);
                dest.writeInt(this.mCurrentItemShowing);
            }
        }
    }

    static interface TimePickerDelegate {
        public void setHour(int var1);

        public int getHour();

        public void setMinute(int var1);

        public int getMinute();

        public void setDate(int var1, int var2);

        public void autofill(AutofillValue var1);

        public AutofillValue getAutofillValue();

        public void setIs24Hour(boolean var1);

        public boolean is24Hour();

        public boolean validateInput();

        public void setOnTimeChangedListener(OnTimeChangedListener var1);

        public void setAutoFillChangeListener(OnTimeChangedListener var1);

        public void setEnabled(boolean var1);

        public boolean isEnabled();

        public int getBaseline();

        public Parcelable onSaveInstanceState(Parcelable var1);

        public void onRestoreInstanceState(Parcelable var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public void onPopulateAccessibilityEvent(AccessibilityEvent var1);

        public View getHourView();

        public View getMinuteView();

        public View getAmView();

        public View getPmView();
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(TimePicker var1, int var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimePickerMode {
    }
}

