/*
 * Decompiled with CFR 0.152.
 */
package android.widget.inline;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.SurfaceControl;
import android.view.SurfaceControlViewHost;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;

public class InlineContentView
extends ViewGroup {
    private static final String TAG = "InlineContentView";
    private static final boolean DEBUG = false;
    private final SurfaceHolder.Callback mSurfaceCallback = new SurfaceHolder.Callback(){

        @Override
        public void surfaceCreated(SurfaceHolder holder) {
            SurfaceControl surfaceControl = InlineContentView.this.mSurfaceView.getSurfaceControl();
            surfaceControl.addOnReparentListener(InlineContentView.this.mOnReparentListener);
            InlineContentView.this.mSurfaceControlCallback.onCreated(surfaceControl);
        }

        @Override
        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        @Override
        public void surfaceDestroyed(SurfaceHolder holder) {
            SurfaceControl surfaceControl = InlineContentView.this.mSurfaceView.getSurfaceControl();
            surfaceControl.removeOnReparentListener(InlineContentView.this.mOnReparentListener);
            InlineContentView.this.mSurfaceControlCallback.onDestroyed(surfaceControl);
        }
    };
    private final SurfaceControl.OnReparentListener mOnReparentListener = new SurfaceControl.OnReparentListener(){

        @Override
        public void onReparent(SurfaceControl.Transaction transaction, SurfaceControl parent) {
            View parentSurfaceOwnerView;
            View view = parentSurfaceOwnerView = parent != null ? parent.getLocalOwnerView() : null;
            if (parentSurfaceOwnerView instanceof SurfaceView) {
                InlineContentView.this.mParentSurfaceOwnerView = new WeakReference<SurfaceView>((SurfaceView)parentSurfaceOwnerView);
            } else {
                InlineContentView.this.mParentSurfaceOwnerView = null;
            }
        }
    };
    private final ViewTreeObserver.OnDrawListener mOnDrawListener = new ViewTreeObserver.OnDrawListener(){

        @Override
        public void onDraw() {
            InlineContentView.this.computeParentPositionAndScale();
            int visibility = InlineContentView.this.isShown() ? 0 : 8;
            InlineContentView.this.mSurfaceView.setVisibility(visibility);
        }
    };
    private final SurfaceView mSurfaceView;
    private WeakReference<SurfaceView> mParentSurfaceOwnerView;
    private int[] mParentPosition;
    private PointF mParentScale;
    private SurfaceControlCallback mSurfaceControlCallback;
    private SurfacePackageUpdater mSurfacePackageUpdater;

    public InlineContentView(Context context) {
        this(context, null);
    }

    public InlineContentView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public InlineContentView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
        this.mSurfaceView.setEnableSurfaceClipping(true);
    }

    public SurfaceControl getSurfaceControl() {
        return this.mSurfaceView.getSurfaceControl();
    }

    @Override
    public void setClipBounds(Rect clipBounds) {
        super.setClipBounds(clipBounds);
        this.mSurfaceView.setClipBounds(clipBounds);
    }

    public InlineContentView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mSurfaceView = new SurfaceView(context, attrs, defStyleAttr, defStyleRes){

            protected void onSetSurfacePositionAndScaleRT(SurfaceControl.Transaction transaction, SurfaceControl surface, int positionLeft, int positionTop, float postScaleX, float postScaleY) {
                if (InlineContentView.this.mParentPosition != null) {
                    positionLeft = (int)((float)(positionLeft - InlineContentView.this.mParentPosition[0]) / ((InlineContentView)InlineContentView.this).mParentScale.x);
                    positionTop = (int)((float)(positionTop - InlineContentView.this.mParentPosition[1]) / ((InlineContentView)InlineContentView.this).mParentScale.y);
                }
                postScaleX = InlineContentView.this.getScaleX();
                postScaleY = InlineContentView.this.getScaleY();
                super.onSetSurfacePositionAndScaleRT(transaction, surface, positionLeft, positionTop, postScaleX, postScaleY);
            }
        };
        this.mSurfaceView.setZOrderOnTop(true);
        this.mSurfaceView.getHolder().setFormat(-2);
        this.addView(this.mSurfaceView);
        this.setImportantForAccessibility(2);
    }

    public void setChildSurfacePackageUpdater(SurfacePackageUpdater surfacePackageUpdater) {
        this.mSurfacePackageUpdater = surfacePackageUpdater;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mSurfacePackageUpdater != null) {
            this.mSurfacePackageUpdater.getSurfacePackage(sp -> {
                if (this.getViewRootImpl() != null) {
                    this.mSurfaceView.setChildSurfacePackage((SurfaceControlViewHost.SurfacePackage)sp);
                }
            });
        }
        this.mSurfaceView.setVisibility(this.getVisibility());
        this.getViewTreeObserver().addOnDrawListener(this.mOnDrawListener);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mSurfacePackageUpdater != null) {
            this.mSurfacePackageUpdater.onSurfacePackageReleased();
        }
        this.getViewTreeObserver().removeOnDrawListener(this.mOnDrawListener);
        this.mSurfaceView.setVisibility(8);
    }

    @Override
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mSurfaceView.layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    public void setSurfaceControlCallback(SurfaceControlCallback callback) {
        if (this.mSurfaceControlCallback != null) {
            this.mSurfaceView.getHolder().removeCallback(this.mSurfaceCallback);
        }
        this.mSurfaceControlCallback = callback;
        if (this.mSurfaceControlCallback != null) {
            this.mSurfaceView.getHolder().addCallback(this.mSurfaceCallback);
        }
    }

    public boolean isZOrderedOnTop() {
        return this.mSurfaceView.isZOrderedOnTop();
    }

    public boolean setZOrderedOnTop(boolean onTop) {
        return this.mSurfaceView.setZOrderedOnTop(onTop, true);
    }

    private void computeParentPositionAndScale() {
        SurfaceView parentSurfaceOwnerView;
        boolean contentPositionOrScaleChanged = false;
        SurfaceView surfaceView = parentSurfaceOwnerView = this.mParentSurfaceOwnerView != null ? (SurfaceView)this.mParentSurfaceOwnerView.get() : null;
        if (parentSurfaceOwnerView != null) {
            if (this.mParentPosition == null) {
                this.mParentPosition = new int[2];
            }
            int oldParentPositionX = this.mParentPosition[0];
            int oldParentPositionY = this.mParentPosition[1];
            parentSurfaceOwnerView.getLocationInSurface(this.mParentPosition);
            if (oldParentPositionX != this.mParentPosition[0] || oldParentPositionY != this.mParentPosition[1]) {
                contentPositionOrScaleChanged = true;
            }
            if (this.mParentScale == null) {
                this.mParentScale = new PointF();
            }
            float lastParentSurfaceWidth = parentSurfaceOwnerView.getSurfaceRenderPosition().width();
            float oldParentScaleX = this.mParentScale.x;
            this.mParentScale.x = lastParentSurfaceWidth > 0.0f ? lastParentSurfaceWidth / (float)parentSurfaceOwnerView.getWidth() : 1.0f;
            if (!contentPositionOrScaleChanged && Float.compare(oldParentScaleX, this.mParentScale.x) != 0) {
                contentPositionOrScaleChanged = true;
            }
            float lastParentSurfaceHeight = parentSurfaceOwnerView.getSurfaceRenderPosition().height();
            float oldParentScaleY = this.mParentScale.y;
            this.mParentScale.y = lastParentSurfaceHeight > 0.0f ? lastParentSurfaceHeight / (float)parentSurfaceOwnerView.getHeight() : 1.0f;
            if (!contentPositionOrScaleChanged && Float.compare(oldParentScaleY, this.mParentScale.y) != 0) {
                contentPositionOrScaleChanged = true;
            }
        } else if (this.mParentPosition != null || this.mParentScale != null) {
            contentPositionOrScaleChanged = true;
            this.mParentPosition = null;
            this.mParentScale = null;
        }
        if (contentPositionOrScaleChanged) {
            this.mSurfaceView.requestUpdateSurfacePositionAndScale();
        }
    }

    public static interface SurfacePackageUpdater {
        public void onSurfacePackageReleased();

        public void getSurfacePackage(Consumer<SurfaceControlViewHost.SurfacePackage> var1);
    }

    public static interface SurfaceControlCallback {
        public void onCreated(SurfaceControl var1);

        public void onDestroyed(SurfaceControl var1);
    }
}

