/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.IRemoteTransitionFinishedCallback;
import android.window.TransitionInfo;

public interface IRemoteTransition
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IRemoteTransition";

    public void startAnimation(IBinder var1, TransitionInfo var2, SurfaceControl.Transaction var3, IRemoteTransitionFinishedCallback var4) throws RemoteException;

    public void mergeAnimation(IBinder var1, TransitionInfo var2, SurfaceControl.Transaction var3, IBinder var4, IRemoteTransitionFinishedCallback var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteTransition {
        static final int TRANSACTION_startAnimation = 1;
        static final int TRANSACTION_mergeAnimation = 2;

        public Stub() {
            this.attachInterface(this, IRemoteTransition.DESCRIPTOR);
        }

        public static IRemoteTransition asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRemoteTransition.DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteTransition) {
                return (IRemoteTransition)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startAnimation";
                }
                case 2: {
                    return "mergeAnimation";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRemoteTransition.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    TransitionInfo _arg1 = 0 != data.readInt() ? TransitionInfo.CREATOR.createFromParcel(data) : null;
                    SurfaceControl.Transaction _arg2 = 0 != data.readInt() ? SurfaceControl.Transaction.CREATOR.createFromParcel(data) : null;
                    IRemoteTransitionFinishedCallback _arg3 = IRemoteTransitionFinishedCallback.Stub.asInterface(data.readStrongBinder());
                    this.startAnimation(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    TransitionInfo _arg1 = 0 != data.readInt() ? TransitionInfo.CREATOR.createFromParcel(data) : null;
                    SurfaceControl.Transaction _arg2 = 0 != data.readInt() ? SurfaceControl.Transaction.CREATOR.createFromParcel(data) : null;
                    IBinder _arg3 = data.readStrongBinder();
                    IRemoteTransitionFinishedCallback _arg4 = IRemoteTransitionFinishedCallback.Stub.asInterface(data.readStrongBinder());
                    this.mergeAnimation(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IRemoteTransition impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IRemoteTransition getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IRemoteTransition {
            private IBinder mRemote;
            public static IRemoteTransition sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRemoteTransition.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startAnimation(IBinder token, TransitionInfo info, SurfaceControl.Transaction t, IRemoteTransitionFinishedCallback finishCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRemoteTransition.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    if (info != null) {
                        _data.writeInt(1);
                        info.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (t != null) {
                        _data.writeInt(1);
                        t.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(finishCallback != null ? finishCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startAnimation(token, info, t, finishCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mergeAnimation(IBinder transition2, TransitionInfo info, SurfaceControl.Transaction t, IBinder mergeTarget, IRemoteTransitionFinishedCallback finishCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRemoteTransition.DESCRIPTOR);
                    _data.writeStrongBinder(transition2);
                    if (info != null) {
                        _data.writeInt(1);
                        info.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (t != null) {
                        _data.writeInt(1);
                        t.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(mergeTarget);
                    _data.writeStrongBinder(finishCallback != null ? finishCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().mergeAnimation(transition2, info, t, mergeTarget, finishCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRemoteTransition {
        @Override
        public void startAnimation(IBinder token, TransitionInfo info, SurfaceControl.Transaction t, IRemoteTransitionFinishedCallback finishCallback) throws RemoteException {
        }

        @Override
        public void mergeAnimation(IBinder transition2, TransitionInfo info, SurfaceControl.Transaction t, IBinder mergeTarget, IRemoteTransitionFinishedCallback finishCallback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

