/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.StartingWindowInfo;

public interface ITaskOrganizer
extends IInterface {
    public static final String DESCRIPTOR = "android.window.ITaskOrganizer";

    public void addStartingWindow(StartingWindowInfo var1, IBinder var2) throws RemoteException;

    public void removeStartingWindow(int var1, SurfaceControl var2, Rect var3, boolean var4) throws RemoteException;

    public void copySplashScreenView(int var1) throws RemoteException;

    public void onAppSplashScreenViewRemoved(int var1) throws RemoteException;

    public void onTaskAppeared(ActivityManager.RunningTaskInfo var1, SurfaceControl var2) throws RemoteException;

    public void onTaskVanished(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onTaskInfoChanged(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onImeDrawnOnTask(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskOrganizer {
        static final int TRANSACTION_addStartingWindow = 1;
        static final int TRANSACTION_removeStartingWindow = 2;
        static final int TRANSACTION_copySplashScreenView = 3;
        static final int TRANSACTION_onAppSplashScreenViewRemoved = 4;
        static final int TRANSACTION_onTaskAppeared = 5;
        static final int TRANSACTION_onTaskVanished = 6;
        static final int TRANSACTION_onTaskInfoChanged = 7;
        static final int TRANSACTION_onBackPressedOnTaskRoot = 8;
        static final int TRANSACTION_onImeDrawnOnTask = 9;

        public Stub() {
            this.attachInterface(this, ITaskOrganizer.DESCRIPTOR);
        }

        public static ITaskOrganizer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITaskOrganizer.DESCRIPTOR);
            if (iin != null && iin instanceof ITaskOrganizer) {
                return (ITaskOrganizer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addStartingWindow";
                }
                case 2: {
                    return "removeStartingWindow";
                }
                case 3: {
                    return "copySplashScreenView";
                }
                case 4: {
                    return "onAppSplashScreenViewRemoved";
                }
                case 5: {
                    return "onTaskAppeared";
                }
                case 6: {
                    return "onTaskVanished";
                }
                case 7: {
                    return "onTaskInfoChanged";
                }
                case 8: {
                    return "onBackPressedOnTaskRoot";
                }
                case 9: {
                    return "onImeDrawnOnTask";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITaskOrganizer.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    StartingWindowInfo _arg0 = 0 != data.readInt() ? StartingWindowInfo.CREATOR.createFromParcel(data) : null;
                    IBinder _arg1 = data.readStrongBinder();
                    this.addStartingWindow(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    SurfaceControl _arg1 = 0 != data.readInt() ? SurfaceControl.CREATOR.createFromParcel(data) : null;
                    Rect _arg2 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    boolean _arg3 = 0 != data.readInt();
                    this.removeStartingWindow(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.copySplashScreenView(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onAppSplashScreenViewRemoved(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    ActivityManager.RunningTaskInfo _arg0 = 0 != data.readInt() ? ActivityManager.RunningTaskInfo.CREATOR.createFromParcel(data) : null;
                    SurfaceControl _arg1 = 0 != data.readInt() ? SurfaceControl.CREATOR.createFromParcel(data) : null;
                    this.onTaskAppeared(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    ActivityManager.RunningTaskInfo _arg0 = 0 != data.readInt() ? ActivityManager.RunningTaskInfo.CREATOR.createFromParcel(data) : null;
                    this.onTaskVanished(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    ActivityManager.RunningTaskInfo _arg0 = 0 != data.readInt() ? ActivityManager.RunningTaskInfo.CREATOR.createFromParcel(data) : null;
                    this.onTaskInfoChanged(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    ActivityManager.RunningTaskInfo _arg0 = 0 != data.readInt() ? ActivityManager.RunningTaskInfo.CREATOR.createFromParcel(data) : null;
                    this.onBackPressedOnTaskRoot(_arg0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onImeDrawnOnTask(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITaskOrganizer impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITaskOrganizer getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITaskOrganizer {
            private IBinder mRemote;
            public static ITaskOrganizer sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITaskOrganizer.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addStartingWindow(StartingWindowInfo info, IBinder appToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    if (info != null) {
                        _data.writeInt(1);
                        info.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(appToken);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addStartingWindow(info, appToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeStartingWindow(int taskId, SurfaceControl leash, Rect frame, boolean playRevealAnimation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeInt(taskId);
                    if (leash != null) {
                        _data.writeInt(1);
                        leash.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (frame != null) {
                        _data.writeInt(1);
                        frame.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(playRevealAnimation ? 1 : 0);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeStartingWindow(taskId, leash, frame, playRevealAnimation);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void copySplashScreenView(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().copySplashScreenView(taskId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAppSplashScreenViewRemoved(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAppSplashScreenViewRemoved(taskId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskAppeared(ActivityManager.RunningTaskInfo taskInfo, SurfaceControl leash) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    if (taskInfo != null) {
                        _data.writeInt(1);
                        taskInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (leash != null) {
                        _data.writeInt(1);
                        leash.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTaskAppeared(taskInfo, leash);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskVanished(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    if (taskInfo != null) {
                        _data.writeInt(1);
                        taskInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTaskVanished(taskInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskInfoChanged(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    if (taskInfo != null) {
                        _data.writeInt(1);
                        taskInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTaskInfoChanged(taskInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    if (taskInfo != null) {
                        _data.writeInt(1);
                        taskInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBackPressedOnTaskRoot(taskInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImeDrawnOnTask(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskOrganizer.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onImeDrawnOnTask(taskId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITaskOrganizer {
        @Override
        public void addStartingWindow(StartingWindowInfo info, IBinder appToken) throws RemoteException {
        }

        @Override
        public void removeStartingWindow(int taskId, SurfaceControl leash, Rect frame, boolean playRevealAnimation) throws RemoteException {
        }

        @Override
        public void copySplashScreenView(int taskId) throws RemoteException {
        }

        @Override
        public void onAppSplashScreenViewRemoved(int taskId) throws RemoteException {
        }

        @Override
        public void onTaskAppeared(ActivityManager.RunningTaskInfo taskInfo, SurfaceControl leash) throws RemoteException {
        }

        @Override
        public void onTaskVanished(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onTaskInfoChanged(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onBackPressedOnTaskRoot(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onImeDrawnOnTask(int taskId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

