/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.SurfaceControl;
import java.util.Arrays;
import java.util.Objects;

public class PictureInPictureSurfaceTransaction
implements Parcelable {
    public final float mPositionX;
    public final float mPositionY;
    public final float[] mFloat9;
    public final float mRotation;
    public final float mCornerRadius;
    private final Rect mWindowCrop = new Rect();
    public static final Parcelable.Creator<PictureInPictureSurfaceTransaction> CREATOR = new Parcelable.Creator<PictureInPictureSurfaceTransaction>(){

        @Override
        public PictureInPictureSurfaceTransaction createFromParcel(Parcel in) {
            return new PictureInPictureSurfaceTransaction(in);
        }

        public PictureInPictureSurfaceTransaction[] newArray(int size) {
            return new PictureInPictureSurfaceTransaction[size];
        }
    };

    public PictureInPictureSurfaceTransaction(Parcel in) {
        this.mPositionX = in.readFloat();
        this.mPositionY = in.readFloat();
        this.mFloat9 = new float[9];
        in.readFloatArray(this.mFloat9);
        this.mRotation = in.readFloat();
        this.mCornerRadius = in.readFloat();
        this.mWindowCrop.set(Objects.requireNonNull(in.readTypedObject(Rect.CREATOR)));
    }

    public PictureInPictureSurfaceTransaction(float positionX, float positionY, float[] float9, float rotation, float cornerRadius, Rect windowCrop) {
        this.mPositionX = positionX;
        this.mPositionY = positionY;
        this.mFloat9 = Arrays.copyOf(float9, 9);
        this.mRotation = rotation;
        this.mCornerRadius = cornerRadius;
        if (windowCrop != null) {
            this.mWindowCrop.set(windowCrop);
        }
    }

    public PictureInPictureSurfaceTransaction(PictureInPictureSurfaceTransaction other) {
        this(other.mPositionX, other.mPositionY, other.mFloat9, other.mRotation, other.mCornerRadius, other.mWindowCrop);
    }

    public Matrix getMatrix() {
        Matrix matrix = new Matrix();
        matrix.setValues(this.mFloat9);
        return matrix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PictureInPictureSurfaceTransaction)) {
            return false;
        }
        PictureInPictureSurfaceTransaction that = (PictureInPictureSurfaceTransaction)o;
        return Objects.equals(Float.valueOf(this.mPositionX), Float.valueOf(that.mPositionX)) && Objects.equals(Float.valueOf(this.mPositionY), Float.valueOf(that.mPositionY)) && Arrays.equals(this.mFloat9, that.mFloat9) && Objects.equals(Float.valueOf(this.mRotation), Float.valueOf(that.mRotation)) && Objects.equals(Float.valueOf(this.mCornerRadius), Float.valueOf(that.mCornerRadius)) && Objects.equals(this.mWindowCrop, that.mWindowCrop);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mPositionX), Float.valueOf(this.mPositionY), Arrays.hashCode(this.mFloat9), Float.valueOf(this.mRotation), Float.valueOf(this.mCornerRadius), this.mWindowCrop);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeFloat(this.mPositionX);
        out.writeFloat(this.mPositionY);
        out.writeFloatArray(this.mFloat9);
        out.writeFloat(this.mRotation);
        out.writeFloat(this.mCornerRadius);
        out.writeTypedObject(this.mWindowCrop, 0);
    }

    public String toString() {
        Matrix matrix = this.getMatrix();
        return "PictureInPictureSurfaceTransaction( posX=" + this.mPositionX + " posY=" + this.mPositionY + " matrix=" + matrix.toShortString() + " rotation=" + this.mRotation + " cornerRadius=" + this.mCornerRadius + " crop=" + this.mWindowCrop + ")";
    }

    public static void apply(PictureInPictureSurfaceTransaction surfaceTransaction, SurfaceControl surfaceControl, SurfaceControl.Transaction tx) {
        Matrix matrix = surfaceTransaction.getMatrix();
        tx.setMatrix(surfaceControl, matrix, new float[9]).setPosition(surfaceControl, surfaceTransaction.mPositionX, surfaceTransaction.mPositionY).setWindowCrop(surfaceControl, surfaceTransaction.mWindowCrop).setCornerRadius(surfaceControl, surfaceTransaction.mCornerRadius);
    }
}

