/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.util.Singleton;
import android.util.Slog;
import android.window.SplashScreenView;
import java.util.ArrayList;

public interface SplashScreen {
    public static final int SPLASH_SCREEN_STYLE_EMPTY = 0;
    public static final int SPLASH_SCREEN_STYLE_ICON = 1;

    @SuppressLint(value={"ExecutorRegistration"})
    public void setOnExitAnimationListener(OnExitAnimationListener var1);

    public void clearOnExitAnimationListener();

    public void setSplashScreenTheme(int var1);

    public static class SplashScreenManagerGlobal {
        private static final String TAG = SplashScreen.class.getSimpleName();
        private final Object mGlobalLock = new Object();
        private final ArrayList<SplashScreenImpl> mImpls = new ArrayList();
        private static final Singleton<SplashScreenManagerGlobal> sInstance = new Singleton<SplashScreenManagerGlobal>(){

            @Override
            protected SplashScreenManagerGlobal create() {
                return new SplashScreenManagerGlobal();
            }
        };

        private SplashScreenManagerGlobal() {
            ActivityThread.currentActivityThread().registerSplashScreenManager(this);
        }

        public static SplashScreenManagerGlobal getInstance() {
            return sInstance.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addImpl(SplashScreenImpl impl) {
            Object object = this.mGlobalLock;
            synchronized (object) {
                this.mImpls.add(impl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeImpl(SplashScreenImpl impl) {
            Object object = this.mGlobalLock;
            synchronized (object) {
                this.mImpls.remove(impl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SplashScreenImpl findImpl(IBinder token) {
            Object object = this.mGlobalLock;
            synchronized (object) {
                for (SplashScreenImpl impl : this.mImpls) {
                    if (impl.mActivityToken != token) continue;
                    return impl;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tokenDestroyed(IBinder token) {
            Object object = this.mGlobalLock;
            synchronized (object) {
                SplashScreenImpl impl = this.findImpl(token);
                if (impl != null) {
                    this.removeImpl(impl);
                }
            }
        }

        public void handOverSplashScreenView(IBinder token, SplashScreenView splashScreenView) {
            this.transferSurface(splashScreenView);
            this.dispatchOnExitAnimation(token, splashScreenView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchOnExitAnimation(IBinder token, SplashScreenView view) {
            Object object = this.mGlobalLock;
            synchronized (object) {
                SplashScreenImpl impl = this.findImpl(token);
                if (impl == null) {
                    return;
                }
                if (impl.mExitAnimationListener == null) {
                    Slog.e(TAG, "cannot dispatch onExitAnimation to listener " + token);
                    return;
                }
                impl.mExitAnimationListener.onSplashScreenExit(view);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsExitListener(IBinder token) {
            Object object = this.mGlobalLock;
            synchronized (object) {
                SplashScreenImpl impl = this.findImpl(token);
                return impl != null && impl.mExitAnimationListener != null;
            }
        }

        private void transferSurface(SplashScreenView splashScreenView) {
            splashScreenView.transferSurface();
        }
    }

    public static class SplashScreenImpl
    implements SplashScreen {
        private static final String TAG = "SplashScreenImpl";
        private OnExitAnimationListener mExitAnimationListener;
        private final IBinder mActivityToken;
        private final SplashScreenManagerGlobal mGlobal;

        public SplashScreenImpl(Context context) {
            this.mActivityToken = context.getActivityToken();
            this.mGlobal = SplashScreenManagerGlobal.getInstance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOnExitAnimationListener(OnExitAnimationListener listener) {
            if (this.mActivityToken == null) {
                return;
            }
            Object object = this.mGlobal.mGlobalLock;
            synchronized (object) {
                if (listener != null) {
                    this.mExitAnimationListener = listener;
                    this.mGlobal.addImpl(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearOnExitAnimationListener() {
            if (this.mActivityToken == null) {
                return;
            }
            Object object = this.mGlobal.mGlobalLock;
            synchronized (object) {
                this.mExitAnimationListener = null;
                this.mGlobal.removeImpl(this);
            }
        }

        @Override
        public void setSplashScreenTheme(int themeId) {
            if (this.mActivityToken == null) {
                Log.w(TAG, "Couldn't persist the starting theme. This instance is not an Activity");
                return;
            }
            Activity activity = ActivityThread.currentActivityThread().getActivity(this.mActivityToken);
            if (activity == null) {
                return;
            }
            String themeName = themeId != 0 ? activity.getResources().getResourceName(themeId) : null;
            try {
                AppGlobals.getPackageManager().setSplashScreenTheme(activity.getComponentName().getPackageName(), themeName, activity.getUserId());
            }
            catch (RemoteException e) {
                Log.w(TAG, "Couldn't persist the starting theme", e);
            }
        }
    }

    public static interface OnExitAnimationListener {
        public void onSplashScreenExit(SplashScreenView var1);
    }

    public static @interface SplashScreenStyle {
    }
}

