/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.Trace;
import android.os._Original_Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.SurfaceControlViewHost;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.android.internal.policy.DecorView;
import com.android.internal.util.ContrastColorUtil;
import java.time.Duration;
import java.time.Instant;

public class SplashScreenView
extends FrameLayout {
    private static final String TAG = SplashScreenView.class.getSimpleName();
    private static final boolean DEBUG = _Original_Build.IS_DEBUGGABLE;
    private static final int LIGHT_BARS_MASK = 24;
    private static final int WINDOW_FLAG_MASK = -1946157056;
    private boolean mNotCopyable;
    private boolean mIsCopied;
    private int mInitBackgroundColor;
    private View mIconView;
    private Bitmap mParceledIconBitmap;
    private View mBrandingImageView;
    private Bitmap mParceledBrandingBitmap;
    private Bitmap mParceledIconBackgroundBitmap;
    private Duration mIconAnimationDuration;
    private Instant mIconAnimationStart;
    private Activity mHostActivity;
    private SurfaceControlViewHost.SurfacePackage mSurfacePackageCopy;
    private SurfaceControlViewHost.SurfacePackage mSurfacePackage;
    private SurfaceView mSurfaceView;
    private SurfaceControlViewHost mSurfaceHost;
    private RemoteCallback mClientCallback;
    private Window mWindow;
    private int mAppWindowFlags;
    private int mStatusBarColor;
    private int mNavigationBarColor;
    private int mSystemBarsAppearance;
    private boolean mHasRemoved;
    private boolean mNavigationContrastEnforced;
    private boolean mStatusContrastEnforced;
    private boolean mDecorFitsSystemWindows;

    public SplashScreenView(Context context) {
        super(context);
    }

    public SplashScreenView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void setNotCopyable() {
        this.mNotCopyable = true;
    }

    public boolean isCopyable() {
        return !this.mNotCopyable;
    }

    public void onCopied() {
        this.mIsCopied = true;
        if (this.mSurfaceView == null) {
            return;
        }
        if (DEBUG) {
            Log.d(TAG, "Setting SurfaceView's SurfacePackage to null.");
        }
        this.mSurfacePackage.release();
        this.mSurfacePackage = null;
    }

    public SurfaceControlViewHost getSurfaceHost() {
        return this.mSurfaceHost;
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setAlpha(this.mSurfaceView.getAlpha() * alpha);
        }
    }

    public Duration getIconAnimationDuration() {
        return this.mIconAnimationDuration;
    }

    public Instant getIconAnimationStart() {
        return this.mIconAnimationStart;
    }

    void transferSurface() {
        if (this.mSurfacePackage == null) {
            return;
        }
        if (DEBUG) {
            this.mSurfacePackage.getSurfaceControl().addOnReparentListener((transaction, parent) -> Log.e(TAG, String.format("SurfacePackage'surface reparented to %s", parent)));
            Log.d(TAG, "Transferring surface " + this.mSurfaceView.toString());
        }
        this.mSurfaceView.setChildSurfacePackage(this.mSurfacePackage);
    }

    void initIconAnimation(Drawable iconDrawable, long duration) {
        if (!(iconDrawable instanceof IconAnimateListener)) {
            return;
        }
        IconAnimateListener aniDrawable = (IconAnimateListener)((Object)iconDrawable);
        aniDrawable.prepareAnimate(duration, this::animationStartCallback);
    }

    private void animationStartCallback() {
        this.mIconAnimationStart = Instant.now();
    }

    public void remove() {
        if (this.mHasRemoved) {
            return;
        }
        this.setVisibility(8);
        if (this.mParceledIconBitmap != null) {
            if (this.mIconView instanceof ImageView) {
                ((ImageView)this.mIconView).setImageDrawable(null);
            } else if (this.mIconView != null) {
                this.mIconView.setBackground(null);
            }
            this.mParceledIconBitmap.recycle();
            this.mParceledIconBitmap = null;
        }
        if (this.mParceledBrandingBitmap != null) {
            this.mBrandingImageView.setBackground(null);
            this.mParceledBrandingBitmap.recycle();
            this.mParceledBrandingBitmap = null;
        }
        if (this.mParceledIconBackgroundBitmap != null) {
            if (this.mIconView != null) {
                this.mIconView.setBackground(null);
            }
            this.mParceledIconBackgroundBitmap.recycle();
            this.mParceledIconBackgroundBitmap = null;
        }
        if (this.mWindow != null) {
            DecorView decorView = (DecorView)this.mWindow.peekDecorView();
            if (DEBUG) {
                Log.d(TAG, "remove starting view");
            }
            if (decorView != null) {
                decorView.removeView(this);
            }
            this.restoreSystemUIColors();
            this.mWindow = null;
        }
        if (this.mHostActivity != null) {
            this.mHostActivity.setSplashScreenView(null);
            this.mHostActivity = null;
        }
        this.mHasRemoved = true;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.releaseAnimationSurfaceHost();
    }

    private void releaseAnimationSurfaceHost() {
        if (this.mSurfaceHost != null && !this.mIsCopied) {
            SurfaceControlViewHost finalSurfaceHost = this.mSurfaceHost;
            this.mSurfaceHost = null;
            finalSurfaceHost.getView().post(() -> {
                if (DEBUG) {
                    Log.d(TAG, "Shell removed splash screen. Releasing SurfaceControlViewHost on thread #" + Thread.currentThread().getId());
                }
                finalSurfaceHost.release();
            });
        } else if (this.mSurfacePackage != null && this.mSurfaceHost == null) {
            this.mSurfacePackage = null;
            this.mClientCallback.sendResult(null);
        }
    }

    public void attachHostActivityAndSetSystemUIColors(Activity activity, Window window) {
        activity.setSplashScreenView(this);
        this.mHostActivity = activity;
        this.mWindow = window;
        WindowManager.LayoutParams attr2 = window.getAttributes();
        this.mAppWindowFlags = attr2.flags;
        this.mStatusBarColor = window.getStatusBarColor();
        this.mNavigationBarColor = window.getNavigationBarColor();
        this.mSystemBarsAppearance = window.getInsetsController().getSystemBarsAppearance();
        this.mNavigationContrastEnforced = window.isNavigationBarContrastEnforced();
        this.mStatusContrastEnforced = window.isStatusBarContrastEnforced();
        this.mDecorFitsSystemWindows = window.decorFitsSystemWindows();
        SplashScreenView.applySystemBarsContrastColor(window.getInsetsController(), this.mInitBackgroundColor);
        window.addFlags(Integer.MIN_VALUE);
        window.clearFlags(0xC000000);
        window.setStatusBarColor(0);
        window.setNavigationBarColor(0);
        window.setDecorFitsSystemWindows(false);
        window.setStatusBarContrastEnforced(false);
        window.setNavigationBarContrastEnforced(false);
    }

    private void restoreSystemUIColors() {
        this.mWindow.setFlags(this.mAppWindowFlags, -1946157056);
        this.mWindow.setStatusBarColor(this.mStatusBarColor);
        this.mWindow.setNavigationBarColor(this.mNavigationBarColor);
        this.mWindow.getInsetsController().setSystemBarsAppearance(this.mSystemBarsAppearance, 24);
        this.mWindow.setDecorFitsSystemWindows(this.mDecorFitsSystemWindows);
        this.mWindow.setStatusBarContrastEnforced(this.mStatusContrastEnforced);
        this.mWindow.setNavigationBarContrastEnforced(this.mNavigationContrastEnforced);
    }

    public static void applySystemBarsContrastColor(WindowInsetsController windowInsetsController, int backgroundColor) {
        int lightBarAppearance = ContrastColorUtil.isColorLight(backgroundColor) ? 24 : 0;
        windowInsetsController.setSystemBarsAppearance(lightBarAppearance, 24);
    }

    public View getIconView() {
        return this.mIconView;
    }

    public View getBrandingView() {
        return this.mBrandingImageView;
    }

    public int getInitBackgroundColor() {
        return this.mInitBackgroundColor;
    }

    public static class SplashScreenViewParcelable
    implements Parcelable {
        private int mIconSize;
        private int mBackgroundColor;
        private Bitmap mIconBackground;
        private Bitmap mIconBitmap = null;
        private int mBrandingWidth;
        private int mBrandingHeight;
        private Bitmap mBrandingBitmap;
        private long mIconAnimationStartMillis;
        private long mIconAnimationDurationMillis;
        private SurfaceControlViewHost.SurfacePackage mSurfacePackage;
        private RemoteCallback mClientCallback;
        public static final Parcelable.Creator<SplashScreenViewParcelable> CREATOR = new Parcelable.Creator<SplashScreenViewParcelable>(){

            @Override
            public SplashScreenViewParcelable createFromParcel(Parcel source) {
                return new SplashScreenViewParcelable(source);
            }

            public SplashScreenViewParcelable[] newArray(int size) {
                return new SplashScreenViewParcelable[size];
            }
        };

        public SplashScreenViewParcelable(SplashScreenView view) {
            this.mIconSize = view.mIconView.getWidth();
            this.mBackgroundColor = view.getInitBackgroundColor();
            this.mIconBackground = this.copyDrawable(view.getIconView().getBackground());
            this.mSurfacePackage = view.mSurfacePackageCopy;
            if (this.mSurfacePackage == null) {
                this.mIconBitmap = this.copyDrawable(((ImageView)view.getIconView()).getDrawable());
            }
            this.mBrandingBitmap = this.copyDrawable(view.getBrandingView().getBackground());
            ViewGroup.LayoutParams params = view.getBrandingView().getLayoutParams();
            this.mBrandingWidth = params.width;
            this.mBrandingHeight = params.height;
            if (view.getIconAnimationStart() != null) {
                this.mIconAnimationStartMillis = view.getIconAnimationStart().toEpochMilli();
            }
            if (view.getIconAnimationDuration() != null) {
                this.mIconAnimationDurationMillis = view.getIconAnimationDuration().toMillis();
            }
        }

        private Bitmap copyDrawable(Drawable drawable2) {
            if (drawable2 != null) {
                Rect initialBounds = drawable2.copyBounds();
                int width = initialBounds.width();
                int height = initialBounds.height();
                Bitmap snapshot = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                Canvas bmpCanvas = new Canvas(snapshot);
                drawable2.setBounds(0, 0, width, height);
                drawable2.draw(bmpCanvas);
                Bitmap copyBitmap = snapshot.createAshmemBitmap();
                snapshot.recycle();
                return copyBitmap;
            }
            return null;
        }

        private SplashScreenViewParcelable(Parcel source) {
            this.readParcel(source);
        }

        private void readParcel(Parcel source) {
            this.mIconSize = source.readInt();
            this.mBackgroundColor = source.readInt();
            this.mIconBitmap = source.readTypedObject(Bitmap.CREATOR);
            this.mBrandingWidth = source.readInt();
            this.mBrandingHeight = source.readInt();
            this.mBrandingBitmap = source.readTypedObject(Bitmap.CREATOR);
            this.mIconAnimationStartMillis = source.readLong();
            this.mIconAnimationDurationMillis = source.readLong();
            this.mIconBackground = source.readTypedObject(Bitmap.CREATOR);
            this.mSurfacePackage = source.readTypedObject(SurfaceControlViewHost.SurfacePackage.CREATOR);
            this.mClientCallback = source.readTypedObject(RemoteCallback.CREATOR);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mIconSize);
            dest.writeInt(this.mBackgroundColor);
            dest.writeTypedObject(this.mIconBitmap, flags);
            dest.writeInt(this.mBrandingWidth);
            dest.writeInt(this.mBrandingHeight);
            dest.writeTypedObject(this.mBrandingBitmap, flags);
            dest.writeLong(this.mIconAnimationStartMillis);
            dest.writeLong(this.mIconAnimationDurationMillis);
            dest.writeTypedObject(this.mIconBackground, flags);
            dest.writeTypedObject(this.mSurfacePackage, flags);
            dest.writeTypedObject(this.mClientCallback, flags);
        }

        public void clearIfNeeded() {
            if (this.mIconBitmap != null) {
                this.mIconBitmap.recycle();
                this.mIconBitmap = null;
            }
            if (this.mBrandingBitmap != null) {
                this.mBrandingBitmap.recycle();
                this.mBrandingBitmap = null;
            }
        }

        int getIconSize() {
            return this.mIconSize;
        }

        int getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public void setClientCallback(RemoteCallback clientCallback) {
            this.mClientCallback = clientCallback;
        }
    }

    public static interface IconAnimateListener {
        public boolean prepareAnimate(long var1, Runnable var3);
    }

    public static class Builder {
        private final Context mContext;
        private int mIconSize;
        private int mBackgroundColor;
        private Bitmap mParceledIconBitmap;
        private Bitmap mParceledIconBackgroundBitmap;
        private Drawable mIconDrawable;
        private Drawable mOverlayDrawable;
        private Drawable mIconBackground;
        private SurfaceControlViewHost.SurfacePackage mSurfacePackage;
        private RemoteCallback mClientCallback;
        private int mBrandingImageWidth;
        private int mBrandingImageHeight;
        private Drawable mBrandingDrawable;
        private Bitmap mParceledBrandingBitmap;
        private Instant mIconAnimationStart;
        private Duration mIconAnimationDuration;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder createFromParcel(SplashScreenViewParcelable parcelable) {
            this.mIconSize = parcelable.getIconSize();
            this.mBackgroundColor = parcelable.getBackgroundColor();
            this.mSurfacePackage = parcelable.mSurfacePackage;
            if (this.mSurfacePackage == null && parcelable.mIconBitmap != null) {
                this.mIconDrawable = new BitmapDrawable(this.mContext.getResources(), parcelable.mIconBitmap);
                this.mParceledIconBitmap = parcelable.mIconBitmap;
            }
            if (parcelable.mIconBackground != null) {
                this.mIconBackground = new BitmapDrawable(this.mContext.getResources(), parcelable.mIconBackground);
                this.mParceledIconBackgroundBitmap = parcelable.mIconBackground;
            }
            if (parcelable.mBrandingBitmap != null) {
                this.setBrandingDrawable(new BitmapDrawable(this.mContext.getResources(), parcelable.mBrandingBitmap), parcelable.mBrandingWidth, parcelable.mBrandingHeight);
                this.mParceledBrandingBitmap = parcelable.mBrandingBitmap;
            }
            this.mIconAnimationStart = Instant.ofEpochMilli(parcelable.mIconAnimationStartMillis);
            this.mIconAnimationDuration = Duration.ofMillis(parcelable.mIconAnimationDurationMillis);
            this.mClientCallback = parcelable.mClientCallback;
            if (DEBUG) {
                Log.d(TAG, String.format("Building from parcel drawable: %s", this.mIconDrawable));
            }
            return this;
        }

        public Builder setIconSize(int iconSize) {
            this.mIconSize = iconSize;
            return this;
        }

        public Builder setBackgroundColor(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
            return this;
        }

        public Builder setOverlayDrawable(Drawable drawable2) {
            this.mOverlayDrawable = drawable2;
            return this;
        }

        public Builder setCenterViewDrawable(Drawable drawable2) {
            this.mIconDrawable = drawable2;
            return this;
        }

        public Builder setIconBackground(Drawable iconBackground) {
            this.mIconBackground = iconBackground;
            return this;
        }

        public Builder setAnimationDurationMillis(int duration) {
            this.mIconAnimationDuration = Duration.ofMillis(duration);
            return this;
        }

        public Builder setBrandingDrawable(Drawable branding, int width, int height) {
            this.mBrandingDrawable = branding;
            this.mBrandingImageWidth = width;
            this.mBrandingImageHeight = height;
            return this;
        }

        public SplashScreenView build() {
            Trace.traceBegin(32L, "SplashScreenView#build");
            LayoutInflater layoutInflater = LayoutInflater.from(this.mContext);
            SplashScreenView view = (SplashScreenView)layoutInflater.inflate(17367322, null, false);
            view.mInitBackgroundColor = this.mBackgroundColor;
            if (this.mOverlayDrawable != null) {
                view.setBackground(this.mOverlayDrawable);
            } else {
                view.setBackgroundColor(this.mBackgroundColor);
            }
            view.mClientCallback = this.mClientCallback;
            view.mBrandingImageView = view.findViewById(16909478);
            if (this.mIconDrawable instanceof IconAnimateListener || this.mSurfacePackage != null) {
                view.mIconView = this.createSurfaceView(view);
                view.initIconAnimation(this.mIconDrawable, this.mIconAnimationDuration != null ? this.mIconAnimationDuration.toMillis() : 0L);
                view.mIconAnimationStart = this.mIconAnimationStart;
                view.mIconAnimationDuration = this.mIconAnimationDuration;
            } else if (this.mIconSize != 0) {
                ImageView imageView = (ImageView)view.findViewById(16909479);
                assert (imageView != null);
                ViewGroup.LayoutParams params = imageView.getLayoutParams();
                params.width = this.mIconSize;
                params.height = this.mIconSize;
                imageView.setLayoutParams(params);
                if (this.mIconDrawable != null) {
                    imageView.setImageDrawable(this.mIconDrawable);
                }
                if (this.mIconBackground != null) {
                    imageView.setBackground(this.mIconBackground);
                }
                view.mIconView = imageView;
            }
            if (this.mOverlayDrawable != null || this.mIconDrawable == null) {
                view.setNotCopyable();
            }
            view.mParceledIconBackgroundBitmap = this.mParceledIconBackgroundBitmap;
            view.mParceledIconBitmap = this.mParceledIconBitmap;
            if (this.mBrandingImageHeight > 0 && this.mBrandingImageWidth > 0 && this.mBrandingDrawable != null) {
                ViewGroup.LayoutParams params = view.mBrandingImageView.getLayoutParams();
                params.width = this.mBrandingImageWidth;
                params.height = this.mBrandingImageHeight;
                view.mBrandingImageView.setLayoutParams(params);
                view.mBrandingImageView.setBackground(this.mBrandingDrawable);
            } else {
                view.mBrandingImageView.setVisibility(8);
            }
            if (this.mParceledBrandingBitmap != null) {
                view.mParceledBrandingBitmap = this.mParceledBrandingBitmap;
            }
            if (DEBUG) {
                Log.d(TAG, "Build " + view + "\nIcon: view: " + view.mIconView + " drawable: " + this.mIconDrawable + " size: " + this.mIconSize + "\nBranding: view: " + view.mBrandingImageView + " drawable: " + this.mBrandingDrawable + " size w: " + this.mBrandingImageWidth + " h: " + this.mBrandingImageHeight);
            }
            Trace.traceEnd(32L);
            return view;
        }

        private SurfaceView createSurfaceView(SplashScreenView view) {
            SurfaceView surfaceView = new SurfaceView(view.getContext());
            surfaceView.setPadding(0, 0, 0, 0);
            surfaceView.setBackground(this.mIconBackground);
            if (this.mSurfacePackage == null) {
                if (DEBUG) {
                    Log.d(TAG, "SurfaceControlViewHost created on thread " + Thread.currentThread().getId());
                }
                SurfaceControlViewHost viewHost = new SurfaceControlViewHost(this.mContext, this.mContext.getDisplay(), surfaceView.getHostToken());
                ImageView imageView = new ImageView(this.mContext);
                imageView.setBackground(this.mIconDrawable);
                viewHost.setView(imageView, this.mIconSize, this.mIconSize);
                SurfaceControlViewHost.SurfacePackage surfacePackage = viewHost.getSurfacePackage();
                surfaceView.setChildSurfacePackage(surfacePackage);
                view.mSurfacePackage = surfacePackage;
                view.mSurfaceHost = viewHost;
                view.mSurfacePackageCopy = new SurfaceControlViewHost.SurfacePackage(surfacePackage);
            } else {
                if (DEBUG) {
                    Log.d(TAG, "Using copy of SurfacePackage in the client");
                }
                view.mSurfacePackage = this.mSurfacePackage;
            }
            if (this.mIconSize != 0) {
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(this.mIconSize, this.mIconSize);
                lp.gravity = 17;
                surfaceView.setLayoutParams(lp);
                if (DEBUG) {
                    Log.d(TAG, "Icon size " + this.mIconSize);
                }
            }
            surfaceView.setUseAlpha();
            surfaceView.setZOrderOnTop(true);
            surfaceView.getHolder().setFormat(-3);
            view.addView(surfaceView);
            view.mSurfaceView = surfaceView;
            return surfaceView;
        }
    }
}

