/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.window.WindowContainerToken;
import java.util.ArrayList;
import java.util.List;

public class TransitionInfo
implements Parcelable {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_SHOW_WALLPAPER = 1;
    public static final int FLAG_IS_WALLPAPER = 2;
    public static final int FLAG_TRANSLUCENT = 4;
    public static final int FLAG_STARTING_WINDOW_TRANSFER_RECIPIENT = 8;
    public static final int FLAG_IS_VOICE_INTERACTION = 16;
    public static final int FLAG_FIRST_CUSTOM = 32;
    private final int mType;
    private final int mFlags;
    private final ArrayList<Change> mChanges = new ArrayList();
    private SurfaceControl mRootLeash;
    private final Point mRootOffset = new Point();
    public static final Parcelable.Creator<TransitionInfo> CREATOR = new Parcelable.Creator<TransitionInfo>(){

        @Override
        public TransitionInfo createFromParcel(Parcel in) {
            return new TransitionInfo(in);
        }

        public TransitionInfo[] newArray(int size) {
            return new TransitionInfo[size];
        }
    };

    public TransitionInfo(int type, int flags) {
        this.mType = type;
        this.mFlags = flags;
    }

    private TransitionInfo(Parcel in) {
        this.mType = in.readInt();
        this.mFlags = in.readInt();
        in.readList(this.mChanges, null);
        this.mRootLeash = new SurfaceControl();
        this.mRootLeash.readFromParcel(in);
        this.mRootOffset.readFromParcel(in);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeInt(this.mFlags);
        dest.writeList(this.mChanges);
        this.mRootLeash.writeToParcel(dest, flags);
        this.mRootOffset.writeToParcel(dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void setRootLeash(SurfaceControl leash, int offsetLeft, int offsetTop) {
        this.mRootLeash = leash;
        this.mRootOffset.set(offsetLeft, offsetTop);
    }

    public int getType() {
        return this.mType;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public SurfaceControl getRootLeash() {
        if (this.mRootLeash == null) {
            throw new IllegalStateException("Trying to get a leash which wasn't set");
        }
        return this.mRootLeash;
    }

    public Point getRootOffset() {
        return this.mRootOffset;
    }

    public List<Change> getChanges() {
        return this.mChanges;
    }

    public Change getChange(WindowContainerToken token) {
        for (int i = this.mChanges.size() - 1; i >= 0; --i) {
            if (!token.equals(this.mChanges.get(i).mContainer)) continue;
            return this.mChanges.get(i);
        }
        return null;
    }

    public void addChange(Change change) {
        this.mChanges.add(change);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{t=" + WindowManager.transitTypeToString(this.mType) + " f=" + Integer.toHexString(this.mFlags) + " ro=" + this.mRootOffset + " c=[");
        for (int i = 0; i < this.mChanges.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.mChanges.get(i));
        }
        sb.append("]}");
        return sb.toString();
    }

    public static String modeToString(@TransitionMode int mode) {
        switch (mode) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "OPEN";
            }
            case 2: {
                return "CLOSE";
            }
            case 3: {
                return "SHOW";
            }
            case 4: {
                return "HIDE";
            }
            case 6: {
                return "CHANGE";
            }
        }
        return "<unknown:" + mode + ">";
    }

    public static String flagsToString(@ChangeFlags int flags) {
        if (flags == 0) {
            return "NONE";
        }
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) != 0) {
            sb.append("SHOW_WALLPAPER");
        }
        if ((flags & 2) != 0) {
            sb.append("IS_WALLPAPER");
        }
        if ((flags & 4) != 0) {
            sb.append((sb.length() == 0 ? "" : "|") + "TRANSLUCENT");
        }
        if ((flags & 8) != 0) {
            sb.append((sb.length() == 0 ? "" : "|") + "STARTING_WINDOW_TRANSFER");
        }
        if ((flags & 0x10) != 0) {
            sb.append((sb.length() == 0 ? "" : "|") + "IS_VOICE_INTERACTION");
        }
        if ((flags & 0x20) != 0) {
            sb.append((sb.length() == 0 ? "" : "|") + "FIRST_CUSTOM");
        }
        return sb.toString();
    }

    public static boolean isIndependent(Change change, TransitionInfo info) {
        if (change.getParent() == null) {
            return true;
        }
        if (change.getMode() == 6) {
            return false;
        }
        Change parentChg = info.getChange(change.getParent());
        while (parentChg != null) {
            if (parentChg.getMode() != 6) {
                return false;
            }
            if (parentChg.getParent() == null) {
                return true;
            }
            parentChg = info.getChange(parentChg.getParent());
        }
        return false;
    }

    public static class Change
    implements Parcelable {
        private final WindowContainerToken mContainer;
        private WindowContainerToken mParent;
        private final SurfaceControl mLeash;
        @TransitionMode
        private int mMode = 0;
        @ChangeFlags
        private int mFlags = 0;
        private final Rect mStartAbsBounds = new Rect();
        private final Rect mEndAbsBounds = new Rect();
        private final Point mEndRelOffset = new Point();
        private ActivityManager.RunningTaskInfo mTaskInfo = null;
        private int mStartRotation = -1;
        private int mEndRotation = -1;
        public static final Parcelable.Creator<Change> CREATOR = new Parcelable.Creator<Change>(){

            @Override
            public Change createFromParcel(Parcel in) {
                return new Change(in);
            }

            public Change[] newArray(int size) {
                return new Change[size];
            }
        };

        public Change(WindowContainerToken container, SurfaceControl leash) {
            this.mContainer = container;
            this.mLeash = leash;
        }

        private Change(Parcel in) {
            this.mContainer = in.readTypedObject(WindowContainerToken.CREATOR);
            this.mParent = in.readTypedObject(WindowContainerToken.CREATOR);
            this.mLeash = new SurfaceControl();
            this.mLeash.readFromParcel(in);
            this.mMode = in.readInt();
            this.mFlags = in.readInt();
            this.mStartAbsBounds.readFromParcel(in);
            this.mEndAbsBounds.readFromParcel(in);
            this.mEndRelOffset.readFromParcel(in);
            this.mTaskInfo = in.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
            this.mStartRotation = in.readInt();
            this.mEndRotation = in.readInt();
        }

        public void setParent(WindowContainerToken parent) {
            this.mParent = parent;
        }

        public void setMode(@TransitionMode int mode) {
            this.mMode = mode;
        }

        public void setFlags(@ChangeFlags int flags) {
            this.mFlags = flags;
        }

        public void setStartAbsBounds(Rect rect) {
            this.mStartAbsBounds.set(rect);
        }

        public void setEndAbsBounds(Rect rect) {
            this.mEndAbsBounds.set(rect);
        }

        public void setEndRelOffset(int left, int top) {
            this.mEndRelOffset.set(left, top);
        }

        public void setTaskInfo(ActivityManager.RunningTaskInfo taskInfo) {
            this.mTaskInfo = taskInfo;
        }

        public void setRotation(int start, int end) {
            this.mStartRotation = start;
            this.mEndRotation = end;
        }

        public WindowContainerToken getContainer() {
            return this.mContainer;
        }

        public WindowContainerToken getParent() {
            return this.mParent;
        }

        @TransitionMode
        public int getMode() {
            return this.mMode;
        }

        @ChangeFlags
        public int getFlags() {
            return this.mFlags;
        }

        public Rect getStartAbsBounds() {
            return this.mStartAbsBounds;
        }

        public Rect getEndAbsBounds() {
            return this.mEndAbsBounds;
        }

        public Point getEndRelOffset() {
            return this.mEndRelOffset;
        }

        public SurfaceControl getLeash() {
            return this.mLeash;
        }

        public ActivityManager.RunningTaskInfo getTaskInfo() {
            return this.mTaskInfo;
        }

        public int getStartRotation() {
            return this.mStartRotation;
        }

        public int getEndRotation() {
            return this.mEndRotation;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeTypedObject(this.mContainer, flags);
            dest.writeTypedObject(this.mParent, flags);
            this.mLeash.writeToParcel(dest, flags);
            dest.writeInt(this.mMode);
            dest.writeInt(this.mFlags);
            this.mStartAbsBounds.writeToParcel(dest, flags);
            this.mEndAbsBounds.writeToParcel(dest, flags);
            this.mEndRelOffset.writeToParcel(dest, flags);
            dest.writeTypedObject(this.mTaskInfo, flags);
            dest.writeInt(this.mStartRotation);
            dest.writeInt(this.mEndRotation);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "{" + this.mContainer + "(" + this.mParent + ") leash=" + this.mLeash + " m=" + TransitionInfo.modeToString(this.mMode) + " f=" + TransitionInfo.flagsToString(this.mFlags) + " sb=" + this.mStartAbsBounds + " eb=" + this.mEndAbsBounds + " eo=" + this.mEndRelOffset + " r=" + this.mStartRotation + "->" + this.mEndRotation + "}";
        }
    }

    public static @interface ChangeFlags {
    }

    public static @interface TransitionMode {
    }
}

