/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityThread;
import android.app.IWindowToken;
import android.app.ResourcesManager;
import android.content.Context;
import android.content.res.Configuration;
import android.window.WindowContext;
import java.lang.ref.WeakReference;

public class WindowTokenClient
extends IWindowToken.Stub {
    private WeakReference<Context> mContextRef = null;
    private final ResourcesManager mResourcesManager = ResourcesManager.getInstance();

    public void attachContext(Context context) {
        if (this.mContextRef != null) {
            throw new IllegalStateException("Context is already attached.");
        }
        this.mContextRef = new WeakReference<Context>(context);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig, int newDisplayId) {
        boolean configChanged;
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        int currentDisplayId = context.getDisplayId();
        boolean displayChanged = newDisplayId != currentDisplayId;
        Configuration config = context.getResources().getConfiguration();
        boolean bl = configChanged = config.diff(newConfig) != 0;
        if (displayChanged || configChanged) {
            this.mResourcesManager.updateResourcesForActivity(this, newConfig, newDisplayId);
            if (context instanceof WindowContext) {
                ActivityThread.currentActivityThread().getHandler().post(() -> ((WindowContext)context).dispatchConfigurationChanged(newConfig));
            }
        }
        if (displayChanged) {
            context.updateDisplay(newDisplayId);
        }
    }

    @Override
    public void onWindowTokenRemoved() {
        Context context = (Context)this.mContextRef.get();
        if (context != null) {
            context.destroy();
            this.mContextRef.clear();
        }
    }
}

