/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone;

import com.android.i18n.timezone.ZoneInfoData;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class WallTime {
    private final GregorianCalendar calendar = new GregorianCalendar(0, 0, 0, 0, 0, 0);
    private int year;
    private int month;
    private int monthDay;
    private int hour;
    private int minute;
    private int second;
    private int weekDay;
    private int yearDay;
    private int isDst;
    private int gmtOffsetSeconds;

    public WallTime() {
        this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void localtime(int timeSeconds, ZoneInfoData zoneInfo) {
        try {
            int isDst;
            int offsetSeconds = zoneInfo.getRawOffset() / 1000;
            if (zoneInfo.mTransitions.length == 0) {
                isDst = 0;
            } else {
                int offsetIndex = zoneInfo.findOffsetIndexForTimeInSeconds(timeSeconds);
                if (offsetIndex == -1) {
                    offsetSeconds = zoneInfo.getEarliestRawOffset() / 1000;
                    isDst = 0;
                } else {
                    offsetSeconds += zoneInfo.mOffsets[offsetIndex];
                    isDst = zoneInfo.mIsDsts[offsetIndex];
                }
            }
            int wallTimeSeconds = WallTime.checked32BitAdd(timeSeconds, offsetSeconds);
            this.calendar.setTimeInMillis((long)wallTimeSeconds * 1000L);
            this.copyFieldsFromCalendar();
            this.isDst = isDst;
            this.gmtOffsetSeconds = offsetSeconds;
        }
        catch (CheckedArithmeticException checkedArithmeticException) {
            // empty catch block
        }
    }

    public int mktime(ZoneInfoData zoneInfo) {
        this.isDst = this.isDst > 0 ? (this.isDst = 1) : (this.isDst < 0 ? (this.isDst = -1) : 0);
        this.copyFieldsToCalendar();
        long longWallTimeSeconds = this.calendar.getTimeInMillis() / 1000L;
        if (Integer.MIN_VALUE > longWallTimeSeconds || longWallTimeSeconds > Integer.MAX_VALUE) {
            return -1;
        }
        try {
            int wallTimeSeconds = (int)longWallTimeSeconds;
            int rawOffsetSeconds = zoneInfo.getRawOffset() / 1000;
            int rawTimeSeconds = WallTime.checked32BitSubtract(wallTimeSeconds, rawOffsetSeconds);
            if (zoneInfo.mTransitions.length == 0) {
                if (this.isDst > 0) {
                    return -1;
                }
                this.copyFieldsFromCalendar();
                this.isDst = 0;
                this.gmtOffsetSeconds = rawOffsetSeconds;
                return rawTimeSeconds;
            }
            int initialTransitionIndex = zoneInfo.findTransitionIndex(rawTimeSeconds);
            if (this.isDst < 0) {
                Integer result = this.doWallTimeSearch(zoneInfo, initialTransitionIndex, wallTimeSeconds, true);
                return result == null ? -1 : result;
            }
            Integer result = this.doWallTimeSearch(zoneInfo, initialTransitionIndex, wallTimeSeconds, true);
            if (result == null) {
                result = this.doWallTimeSearch(zoneInfo, initialTransitionIndex, wallTimeSeconds, false);
            }
            if (result == null) {
                result = -1;
            }
            return result;
        }
        catch (CheckedArithmeticException e) {
            return -1;
        }
    }

    private Integer tryOffsetAdjustments(ZoneInfoData zoneInfo, int oldWallTimeSeconds, OffsetInterval targetInterval, int transitionIndex, int isDstToFind) throws CheckedArithmeticException {
        int[] offsetsToTry = WallTime.getOffsetsOfType(zoneInfo, transitionIndex, isDstToFind);
        for (int j = 0; j < offsetsToTry.length; ++j) {
            int rawOffsetSeconds = zoneInfo.getRawOffset() / 1000;
            int jOffsetSeconds = rawOffsetSeconds + offsetsToTry[j];
            int targetIntervalOffsetSeconds = targetInterval.getTotalOffsetSeconds();
            int adjustmentSeconds = targetIntervalOffsetSeconds - jOffsetSeconds;
            int adjustedWallTimeSeconds = WallTime.checked32BitAdd(oldWallTimeSeconds, adjustmentSeconds);
            if (!targetInterval.containsWallTime(adjustedWallTimeSeconds)) continue;
            int returnValue = WallTime.checked32BitSubtract(adjustedWallTimeSeconds, targetIntervalOffsetSeconds);
            this.calendar.setTimeInMillis((long)adjustedWallTimeSeconds * 1000L);
            this.copyFieldsFromCalendar();
            this.isDst = targetInterval.getIsDst();
            this.gmtOffsetSeconds = targetIntervalOffsetSeconds;
            return returnValue;
        }
        return null;
    }

    private static int[] getOffsetsOfType(ZoneInfoData zoneInfo, int startIndex, int isDst) {
        int[] offsets = new int[zoneInfo.mOffsets.length + 1];
        boolean[] seen = new boolean[zoneInfo.mOffsets.length];
        int numFound = 0;
        int delta = 0;
        boolean clampTop = false;
        boolean clampBottom = false;
        do {
            if ((delta *= -1) >= 0) {
                ++delta;
            }
            int transitionIndex = startIndex + delta;
            if (delta < 0 && transitionIndex < -1) {
                clampBottom = true;
                continue;
            }
            if (delta > 0 && transitionIndex >= zoneInfo.mTypes.length) {
                clampTop = true;
                continue;
            }
            if (transitionIndex == -1) {
                if (isDst != 0) continue;
                offsets[numFound++] = 0;
                continue;
            }
            int type = zoneInfo.mTypes[transitionIndex] & 0xFF;
            if (seen[type]) continue;
            if (zoneInfo.mIsDsts[type] == isDst) {
                offsets[numFound++] = zoneInfo.mOffsets[type];
            }
            seen[type] = true;
        } while (!clampTop || !clampBottom);
        int[] toReturn = new int[numFound];
        System.arraycopy(offsets, 0, toReturn, 0, numFound);
        return toReturn;
    }

    private Integer doWallTimeSearch(ZoneInfoData zoneInfo, int initialTransitionIndex, int wallTimeSeconds, boolean mustMatchDst) throws CheckedArithmeticException {
        int MAX_SEARCH_SECONDS = 86400;
        boolean clampTop = false;
        boolean clampBottom = false;
        int loop = 0;
        do {
            boolean endSearch;
            int isDstToFind;
            Integer returnValue;
            int transitionIndexDelta = (loop + 1) / 2;
            if (loop % 2 == 1) {
                transitionIndexDelta *= -1;
            }
            ++loop;
            if (transitionIndexDelta > 0 && clampTop || transitionIndexDelta < 0 && clampBottom) continue;
            int currentTransitionIndex = initialTransitionIndex + transitionIndexDelta;
            OffsetInterval offsetInterval = OffsetInterval.create(zoneInfo, currentTransitionIndex);
            if (offsetInterval == null) {
                clampTop |= transitionIndexDelta > 0;
                clampBottom |= transitionIndexDelta < 0;
                continue;
            }
            if (mustMatchDst) {
                if (offsetInterval.containsWallTime(wallTimeSeconds) && (this.isDst == -1 || offsetInterval.getIsDst() == this.isDst)) {
                    int totalOffsetSeconds = offsetInterval.getTotalOffsetSeconds();
                    int returnValue2 = WallTime.checked32BitSubtract(wallTimeSeconds, totalOffsetSeconds);
                    this.copyFieldsFromCalendar();
                    this.isDst = offsetInterval.getIsDst();
                    this.gmtOffsetSeconds = totalOffsetSeconds;
                    return returnValue2;
                }
            } else if (this.isDst != offsetInterval.getIsDst() && (returnValue = this.tryOffsetAdjustments(zoneInfo, wallTimeSeconds, offsetInterval, currentTransitionIndex, isDstToFind = this.isDst)) != null) {
                return returnValue;
            }
            if (transitionIndexDelta > 0) {
                boolean bl = endSearch = offsetInterval.getEndWallTimeSeconds() - (long)wallTimeSeconds > 86400L;
                if (!endSearch) continue;
                clampTop = true;
                continue;
            }
            if (transitionIndexDelta >= 0) continue;
            boolean bl = endSearch = (long)wallTimeSeconds - offsetInterval.getStartWallTimeSeconds() >= 86400L;
            if (!endSearch) continue;
            clampBottom = true;
        } while (!clampTop || !clampBottom);
        return null;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setMonthDay(int monthDay) {
        this.monthDay = monthDay;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public void setWeekDay(int weekDay) {
        this.weekDay = weekDay;
    }

    public void setYearDay(int yearDay) {
        this.yearDay = yearDay;
    }

    public void setIsDst(int isDst) {
        this.isDst = isDst;
    }

    public void setGmtOffset(int gmtoff) {
        this.gmtOffsetSeconds = gmtoff;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getMonthDay() {
        return this.monthDay;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getWeekDay() {
        return this.weekDay;
    }

    public int getYearDay() {
        return this.yearDay;
    }

    public int getGmtOffset() {
        return this.gmtOffsetSeconds;
    }

    public int getIsDst() {
        return this.isDst;
    }

    private void copyFieldsToCalendar() {
        this.calendar.set(1, this.year);
        this.calendar.set(2, this.month);
        this.calendar.set(5, this.monthDay);
        this.calendar.set(11, this.hour);
        this.calendar.set(12, this.minute);
        this.calendar.set(13, this.second);
        this.calendar.set(14, 0);
    }

    private void copyFieldsFromCalendar() {
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2);
        this.monthDay = this.calendar.get(5);
        this.hour = this.calendar.get(11);
        this.minute = this.calendar.get(12);
        this.second = this.calendar.get(13);
        this.weekDay = this.calendar.get(7) - 1;
        this.yearDay = this.calendar.get(6) - 1;
    }

    private static int checked32BitAdd(long a, int b) throws CheckedArithmeticException {
        long result = a + (long)b;
        if (result != (long)((int)result)) {
            throw new CheckedArithmeticException();
        }
        return (int)result;
    }

    private static int checked32BitSubtract(long a, int b) throws CheckedArithmeticException {
        long result = a - (long)b;
        if (result != (long)((int)result)) {
            throw new CheckedArithmeticException();
        }
        return (int)result;
    }

    private static int saturated32BitAdd(long a, int b) {
        long result = a + (long)b;
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (result < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)result;
    }

    private static class CheckedArithmeticException
    extends Exception {
        private CheckedArithmeticException() {
        }
    }

    static class OffsetInterval {
        private final int startWallTimeSeconds;
        private final int endWallTimeSeconds;
        private final int isDst;
        private final int totalOffsetSeconds;

        public static OffsetInterval create(ZoneInfoData zoneInfo, int transitionIndex) {
            if (transitionIndex < -1 || transitionIndex >= zoneInfo.mTransitions.length) {
                return null;
            }
            if (transitionIndex == -1) {
                int totalOffsetSeconds = zoneInfo.getEarliestRawOffset() / 1000;
                int isDst = 0;
                int startWallTimeSeconds = Integer.MIN_VALUE;
                int endWallTimeSeconds = WallTime.saturated32BitAdd(zoneInfo.mTransitions[0], totalOffsetSeconds);
                if (startWallTimeSeconds == endWallTimeSeconds) {
                    return null;
                }
                return new OffsetInterval(startWallTimeSeconds, endWallTimeSeconds, isDst, totalOffsetSeconds);
            }
            int rawOffsetSeconds = zoneInfo.getRawOffset() / 1000;
            int type = zoneInfo.mTypes[transitionIndex] & 0xFF;
            int totalOffsetSeconds = zoneInfo.mOffsets[type] + rawOffsetSeconds;
            int endWallTimeSeconds = transitionIndex == zoneInfo.mTransitions.length - 1 ? Integer.MAX_VALUE : WallTime.saturated32BitAdd(zoneInfo.mTransitions[transitionIndex + 1], totalOffsetSeconds);
            byte isDst = zoneInfo.mIsDsts[type];
            int startWallTimeSeconds = WallTime.saturated32BitAdd(zoneInfo.mTransitions[transitionIndex], totalOffsetSeconds);
            if (startWallTimeSeconds == endWallTimeSeconds) {
                return null;
            }
            return new OffsetInterval(startWallTimeSeconds, endWallTimeSeconds, isDst, totalOffsetSeconds);
        }

        private OffsetInterval(int startWallTimeSeconds, int endWallTimeSeconds, int isDst, int totalOffsetSeconds) {
            this.startWallTimeSeconds = startWallTimeSeconds;
            this.endWallTimeSeconds = endWallTimeSeconds;
            this.isDst = isDst;
            this.totalOffsetSeconds = totalOffsetSeconds;
        }

        public boolean containsWallTime(long wallTimeSeconds) {
            return wallTimeSeconds >= (long)this.startWallTimeSeconds && wallTimeSeconds < (long)this.endWallTimeSeconds;
        }

        public int getIsDst() {
            return this.isDst;
        }

        public int getTotalOffsetSeconds() {
            return this.totalOffsetSeconds;
        }

        public long getEndWallTimeSeconds() {
            return this.endWallTimeSeconds;
        }

        public long getStartWallTimeSeconds() {
            return this.startWallTimeSeconds;
        }
    }
}

