/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.ims.ImsFeatureContainer;

public interface IImsServiceFeatureCallback
extends IInterface {
    public void imsFeatureCreated(ImsFeatureContainer var1) throws RemoteException;

    public void imsFeatureRemoved(int var1) throws RemoteException;

    public void imsStatusChanged(int var1) throws RemoteException;

    public void updateCapabilities(long var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsServiceFeatureCallback {
        public static final String DESCRIPTOR = "com.android.ims.internal.IImsServiceFeatureCallback";
        static final int TRANSACTION_imsFeatureCreated = 1;
        static final int TRANSACTION_imsFeatureRemoved = 2;
        static final int TRANSACTION_imsStatusChanged = 3;
        static final int TRANSACTION_updateCapabilities = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IImsServiceFeatureCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IImsServiceFeatureCallback) {
                return (IImsServiceFeatureCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "imsFeatureCreated";
                }
                case 2: {
                    return "imsFeatureRemoved";
                }
                case 3: {
                    return "imsStatusChanged";
                }
                case 4: {
                    return "updateCapabilities";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    ImsFeatureContainer _arg0 = 0 != data.readInt() ? ImsFeatureContainer.CREATOR.createFromParcel(data) : null;
                    this.imsFeatureCreated(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.imsFeatureRemoved(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.imsStatusChanged(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.updateCapabilities(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IImsServiceFeatureCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IImsServiceFeatureCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IImsServiceFeatureCallback {
            private IBinder mRemote;
            public static IImsServiceFeatureCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void imsFeatureCreated(ImsFeatureContainer feature) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (feature != null) {
                        _data.writeInt(1);
                        feature.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().imsFeatureCreated(feature);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void imsFeatureRemoved(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().imsFeatureRemoved(reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void imsStatusChanged(int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().imsStatusChanged(status);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateCapabilities(long capabilities) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(capabilities);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateCapabilities(capabilities);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsServiceFeatureCallback {
        @Override
        public void imsFeatureCreated(ImsFeatureContainer feature) throws RemoteException {
        }

        @Override
        public void imsFeatureRemoved(int reason) throws RemoteException {
        }

        @Override
        public void imsStatusChanged(int status) throws RemoteException {
        }

        @Override
        public void updateCapabilities(long capabilities) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

