/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.app.prediction.AppPredictor;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.DeviceConfig;
import android.service.chooser.ChooserTarget;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ChooserActivityLogger;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.app.ResolverListController;
import com.android.internal.app.chooser.ChooserTargetInfo;
import com.android.internal.app.chooser.DisplayResolveInfo;
import com.android.internal.app.chooser.MultiDisplayResolveInfo;
import com.android.internal.app.chooser.SelectableTargetInfo;
import com.android.internal.app.chooser.TargetInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChooserListAdapter
extends ResolverListAdapter {
    private static final String TAG = "ChooserListAdapter";
    private static final boolean DEBUG = false;
    private boolean mEnableStackedApps = true;
    public static final int NO_POSITION = -1;
    public static final int TARGET_BAD = -1;
    public static final int TARGET_CALLER = 0;
    public static final int TARGET_SERVICE = 1;
    public static final int TARGET_STANDARD = 2;
    public static final int TARGET_STANDARD_AZ = 3;
    private static final int MAX_SUGGESTED_APP_TARGETS = 4;
    private static final int MAX_CHOOSER_TARGETS_PER_APP = 2;
    public static final float CALLER_TARGET_SCORE_BOOST = 900.0f;
    public static final float SHORTCUT_TARGET_SCORE_BOOST = 90.0f;
    private final int mMaxShortcutTargetsPerApp;
    private final ChooserListCommunicator mChooserListCommunicator;
    private final SelectableTargetInfo.SelectableTargetInfoCommunicator mSelectableTargetInfoCommunicator;
    private final ChooserActivityLogger mChooserActivityLogger;
    private int mNumShortcutResults = 0;
    private Map<DisplayResolveInfo, ResolverListAdapter.LoadIconTask> mIconLoaders = new HashMap<DisplayResolveInfo, ResolverListAdapter.LoadIconTask>();
    private boolean mApplySharingAppLimits;
    private ChooserTargetInfo mPlaceHolderTargetInfo = new ChooserActivity.PlaceHolderTargetInfo();
    private final List<ChooserTargetInfo> mServiceTargets = new ArrayList<ChooserTargetInfo>();
    private final List<DisplayResolveInfo> mCallerTargets = new ArrayList<DisplayResolveInfo>();
    private final ChooserActivity.BaseChooserTargetComparator mBaseTargetComparator = new ChooserActivity.BaseChooserTargetComparator();
    private boolean mListViewDataChanged = false;
    private List<DisplayResolveInfo> mSortedList = new ArrayList<DisplayResolveInfo>();
    private AppPredictor mAppPredictor;
    private AppPredictor.Callback mAppPredictorCallback;

    public ChooserListAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, boolean filterLastUsed, ResolverListController resolverListController, ChooserListCommunicator chooserListCommunicator, SelectableTargetInfo.SelectableTargetInfoCommunicator selectableTargetInfoCommunicator, PackageManager packageManager, ChooserActivityLogger chooserActivityLogger) {
        super(context, payloadIntents, null, rList, filterLastUsed, resolverListController, chooserListCommunicator, false);
        this.mMaxShortcutTargetsPerApp = context.getResources().getInteger(17694851);
        this.mChooserListCommunicator = chooserListCommunicator;
        this.createPlaceHolders();
        this.mSelectableTargetInfoCommunicator = selectableTargetInfoCommunicator;
        this.mChooserActivityLogger = chooserActivityLogger;
        if (initialIntents != null) {
            for (int i = 0; i < initialIntents.length; ++i) {
                Intent ii = initialIntents[i];
                if (ii == null) continue;
                ResolveInfo ri = null;
                ActivityInfo ai = null;
                ComponentName cn = ii.getComponent();
                if (cn != null) {
                    try {
                        ai = packageManager.getActivityInfo(ii.getComponent(), 0);
                        ri = new ResolveInfo();
                        ri.activityInfo = ai;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
                if (ai == null) {
                    ri = packageManager.resolveActivity(ii, 65536);
                    ActivityInfo activityInfo = ai = ri != null ? ri.activityInfo : null;
                }
                if (ai == null) {
                    Log.w(TAG, "No activity found for " + ii);
                    continue;
                }
                UserManager userManager = (UserManager)context.getSystemService("user");
                if (ii instanceof LabeledIntent) {
                    LabeledIntent li = (LabeledIntent)ii;
                    ri.resolvePackageName = li.getSourcePackage();
                    ri.labelRes = li.getLabelResource();
                    ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                    ri.iconResourceId = ri.icon = li.getIconResource();
                }
                if (userManager.isManagedProfile()) {
                    ri.noResourceId = true;
                    ri.icon = 0;
                }
                this.mCallerTargets.add(new DisplayResolveInfo(ii, ri, ii, this.makePresentationGetter(ri)));
                if (this.mCallerTargets.size() == 4) break;
            }
        }
        this.mApplySharingAppLimits = DeviceConfig.getBoolean("systemui", "apply_sharing_app_limits_in_sysui", true);
    }

    AppPredictor getAppPredictor() {
        return this.mAppPredictor;
    }

    @Override
    public void handlePackagesChanged() {
        this.createPlaceHolders();
        this.mChooserListCommunicator.onHandlePackagesChanged(this);
    }

    @Override
    public void notifyDataSetChanged() {
        if (!this.mListViewDataChanged) {
            this.mChooserListCommunicator.sendListViewUpdateMessage(this.getUserHandle());
            this.mListViewDataChanged = true;
        }
    }

    void refreshListView() {
        if (this.mListViewDataChanged) {
            super.notifyDataSetChanged();
        }
        this.mListViewDataChanged = false;
    }

    private void createPlaceHolders() {
        this.mNumShortcutResults = 0;
        this.mServiceTargets.clear();
        for (int i = 0; i < this.mChooserListCommunicator.getMaxRankedTargets(); ++i) {
            this.mServiceTargets.add(this.mPlaceHolderTargetInfo);
        }
    }

    @Override
    View onCreateView(ViewGroup parent) {
        return this.mInflater.inflate(17367278, parent, false);
    }

    @Override
    protected void onBindView(View view, TargetInfo info, int position) {
        ResolverListAdapter.ViewHolder holder = (ResolverListAdapter.ViewHolder)view.getTag();
        if (info == null) {
            holder.icon.setImageDrawable(this.mContext.getDrawable(17303428));
            return;
        }
        if (!(info instanceof DisplayResolveInfo)) {
            holder.bindLabel(info.getDisplayLabel(), info.getExtendedInfo(), this.alwaysShowSubLabel());
            holder.bindIcon(info);
            if (info instanceof SelectableTargetInfo) {
                DisplayResolveInfo rInfo = ((SelectableTargetInfo)info).getDisplayResolveInfo();
                CharSequence appName = rInfo != null ? rInfo.getDisplayLabel() : "";
                CharSequence extendedInfo = info.getExtendedInfo();
                String contentDescription = String.join((CharSequence)" ", info.getDisplayLabel(), extendedInfo != null ? extendedInfo : "", appName);
                holder.updateContentDescription(contentDescription);
            }
        } else {
            DisplayResolveInfo dri = (DisplayResolveInfo)info;
            holder.bindLabel(dri.getDisplayLabel(), dri.getExtendedInfo(), this.alwaysShowSubLabel());
            ResolverListAdapter.LoadIconTask task = this.mIconLoaders.get(dri);
            if (task == null) {
                task = new ResolverListAdapter.LoadIconTask(this, dri, holder);
                this.mIconLoaders.put(dri, task);
                task.execute(new Void[0]);
            } else {
                task.setViewHolder(holder);
            }
        }
        if (info instanceof ChooserActivity.PlaceHolderTargetInfo) {
            int maxWidth = this.mContext.getResources().getDimensionPixelSize(17105043);
            holder.text.setMaxWidth(maxWidth);
            holder.text.setBackground(this.mContext.getResources().getDrawable(17302110, this.mContext.getTheme()));
            holder.itemView.setBackground(null);
        } else {
            holder.text.setMaxWidth(Integer.MAX_VALUE);
            holder.text.setBackground(null);
            holder.itemView.setBackground(holder.defaultItemViewBackground);
        }
        if (info instanceof MultiDisplayResolveInfo) {
            Drawable bkg = this.mContext.getDrawable(17302112);
            holder.text.setPaddingRelative(0, 0, bkg.getIntrinsicWidth(), 0);
            holder.text.setBackground(bkg);
        } else if (info.isPinned() && this.getPositionTargetType(position) == 2) {
            Drawable bkg = this.mContext.getDrawable(17302113);
            holder.text.setPaddingRelative(bkg.getIntrinsicWidth(), 0, 0, 0);
            holder.text.setBackground(bkg);
        } else {
            holder.text.setBackground(null);
            holder.text.setPaddingRelative(0, 0, 0, 0);
        }
    }

    void updateAlphabeticalList() {
        new AsyncTask<Void, Void, List<DisplayResolveInfo>>(){

            protected List<DisplayResolveInfo> doInBackground(Void ... voids) {
                ArrayList<DisplayResolveInfo> allTargets = new ArrayList<DisplayResolveInfo>();
                allTargets.addAll(ChooserListAdapter.this.mDisplayList);
                allTargets.addAll(ChooserListAdapter.this.mCallerTargets);
                if (!ChooserListAdapter.this.mEnableStackedApps) {
                    return allTargets;
                }
                HashMap<String, DisplayResolveInfo> consolidated = new HashMap<String, DisplayResolveInfo>();
                for (DisplayResolveInfo info : allTargets) {
                    String packageName = info.getResolvedComponentName().getPackageName();
                    DisplayResolveInfo multiDri = (DisplayResolveInfo)consolidated.get(packageName);
                    if (multiDri == null) {
                        consolidated.put(packageName, info);
                        continue;
                    }
                    if (multiDri instanceof MultiDisplayResolveInfo) {
                        ((MultiDisplayResolveInfo)multiDri).addTarget(info);
                        continue;
                    }
                    MultiDisplayResolveInfo multiDisplayResolveInfo = new MultiDisplayResolveInfo(packageName, multiDri);
                    multiDisplayResolveInfo.addTarget(info);
                    consolidated.put(packageName, multiDisplayResolveInfo);
                }
                ArrayList<DisplayResolveInfo> groupedTargets = new ArrayList<DisplayResolveInfo>();
                groupedTargets.addAll(consolidated.values());
                Collections.sort(groupedTargets, new ChooserActivity.AzInfoComparator(ChooserListAdapter.this.mContext));
                return groupedTargets;
            }

            @Override
            protected void onPostExecute(List<DisplayResolveInfo> newList) {
                ChooserListAdapter.this.mSortedList = newList;
                ChooserListAdapter.this.notifyDataSetChanged();
            }
        }.execute(new Void[0]);
    }

    @Override
    public int getCount() {
        return this.getRankedTargetCount() + this.getAlphaTargetCount() + this.getSelectableServiceTargetCount() + this.getCallerTargetCount();
    }

    @Override
    public int getUnfilteredCount() {
        int appTargets = super.getUnfilteredCount();
        if (appTargets > this.mChooserListCommunicator.getMaxRankedTargets()) {
            appTargets += this.mChooserListCommunicator.getMaxRankedTargets();
        }
        return appTargets + this.getSelectableServiceTargetCount() + this.getCallerTargetCount();
    }

    public int getCallerTargetCount() {
        return this.mCallerTargets.size();
    }

    public int getSelectableServiceTargetCount() {
        int count = 0;
        for (ChooserTargetInfo info : this.mServiceTargets) {
            if (!(info instanceof SelectableTargetInfo)) continue;
            ++count;
        }
        return count;
    }

    public int getServiceTargetCount() {
        if (this.mChooserListCommunicator.isSendAction(this.mChooserListCommunicator.getTargetIntent()) && !ActivityManager.isLowRamDeviceStatic()) {
            return Math.min(this.mServiceTargets.size(), this.mChooserListCommunicator.getMaxRankedTargets());
        }
        return 0;
    }

    int getAlphaTargetCount() {
        int groupedCount = this.mSortedList.size();
        int ungroupedCount = this.mCallerTargets.size() + this.mDisplayList.size();
        return ungroupedCount > this.mChooserListCommunicator.getMaxRankedTargets() ? groupedCount : 0;
    }

    public int getRankedTargetCount() {
        int spacesAvailable = this.mChooserListCommunicator.getMaxRankedTargets() - this.getCallerTargetCount();
        return Math.min(spacesAvailable, super.getCount());
    }

    public int getPositionTargetType(int position) {
        int offset = 0;
        int serviceTargetCount = this.getServiceTargetCount();
        if (position < serviceTargetCount) {
            return 1;
        }
        int callerTargetCount = this.getCallerTargetCount();
        if (position - (offset += serviceTargetCount) < callerTargetCount) {
            return 0;
        }
        int rankedTargetCount = this.getRankedTargetCount();
        if (position - (offset += callerTargetCount) < rankedTargetCount) {
            return 2;
        }
        int standardTargetCount = this.getAlphaTargetCount();
        if (position - (offset += rankedTargetCount) < standardTargetCount) {
            return 3;
        }
        return -1;
    }

    @Override
    public TargetInfo getItem(int position) {
        return this.targetInfoForPosition(position, true);
    }

    @Override
    public TargetInfo targetInfoForPosition(int position, boolean filtered) {
        int serviceTargetCount;
        if (position == -1) {
            return null;
        }
        int offset = 0;
        int n = serviceTargetCount = filtered ? this.getServiceTargetCount() : this.getSelectableServiceTargetCount();
        if (position < serviceTargetCount) {
            return this.mServiceTargets.get(position);
        }
        int callerTargetCount = this.getCallerTargetCount();
        if (position - (offset += serviceTargetCount) < callerTargetCount) {
            return this.mCallerTargets.get(position - offset);
        }
        int rankedTargetCount = this.getRankedTargetCount();
        if (position - (offset += callerTargetCount) < rankedTargetCount) {
            return filtered ? super.getItem(position - offset) : this.getDisplayResolveInfo(position - offset);
        }
        if (position - (offset += rankedTargetCount) < this.getAlphaTargetCount() && !this.mSortedList.isEmpty()) {
            return this.mSortedList.get(position - offset);
        }
        return null;
    }

    @Override
    protected boolean shouldAddResolveInfo(DisplayResolveInfo dri) {
        for (TargetInfo targetInfo : this.mCallerTargets) {
            if (!this.mResolverListCommunicator.resolveInfoMatch(dri.getResolveInfo(), targetInfo.getResolveInfo())) continue;
            return false;
        }
        return super.shouldAddResolveInfo(dri);
    }

    public List<ChooserTargetInfo> getSurfacedTargetInfo() {
        int maxSurfacedTargets = this.mChooserListCommunicator.getMaxRankedTargets();
        return this.mServiceTargets.subList(0, Math.min(maxSurfacedTargets, this.getSelectableServiceTargetCount()));
    }

    public void addServiceResults(DisplayResolveInfo origTarget, List<ChooserTarget> targets, int targetType, Map<ChooserTarget, ShortcutInfo> directShareToShortcutInfos, List<ChooserActivity.ChooserTargetServiceConnection> pendingChooserTargetServiceConnections) {
        if (targets.size() == 0) {
            return;
        }
        float baseScore = this.getBaseScore(origTarget, targetType);
        Collections.sort(targets, this.mBaseTargetComparator);
        boolean isShortcutResult = targetType == 2 || targetType == 3;
        int maxTargets = isShortcutResult ? this.mMaxShortcutTargetsPerApp : 2;
        int targetsLimit = this.mApplySharingAppLimits ? Math.min(targets.size(), maxTargets) : targets.size();
        float lastScore = 0.0f;
        boolean shouldNotify = false;
        int count = targetsLimit;
        for (int i = 0; i < count; ++i) {
            UserHandle userHandle;
            Context contextAsUser;
            boolean isInserted;
            ChooserTarget target = targets.get(i);
            float targetScore = target.getScore();
            if (this.mApplySharingAppLimits) {
                targetScore *= baseScore;
                if (i > 0 && targetScore >= lastScore) {
                    targetScore = lastScore * 0.95f;
                }
            }
            if ((isInserted = this.insertServiceTarget(new SelectableTargetInfo(contextAsUser = this.mContext.createContextAsUser(userHandle = this.getUserHandle(), 0), origTarget, target, targetScore, this.mSelectableTargetInfoCommunicator, isShortcutResult ? directShareToShortcutInfos.get(target) : null))) && isShortcutResult) {
                ++this.mNumShortcutResults;
            }
            shouldNotify |= isInserted;
            lastScore = targetScore;
        }
        if (shouldNotify) {
            this.notifyDataSetChanged();
        }
    }

    int getNumServiceTargetsForExpand() {
        return this.mNumShortcutResults;
    }

    public float getBaseScore(DisplayResolveInfo target, int targetType) {
        if (target == null) {
            return 900.0f;
        }
        float score = super.getScore(target);
        if (targetType == 2 || targetType == 3) {
            return score * 90.0f;
        }
        return score;
    }

    public void completeServiceTargetLoading() {
        this.mServiceTargets.removeIf(o -> o instanceof ChooserActivity.PlaceHolderTargetInfo);
        if (this.mServiceTargets.isEmpty()) {
            this.mServiceTargets.add(new ChooserActivity.EmptyTargetInfo());
            this.mChooserActivityLogger.logSharesheetEmptyDirectShareRow();
        }
        this.notifyDataSetChanged();
    }

    private boolean insertServiceTarget(ChooserTargetInfo chooserTargetInfo) {
        if (this.mServiceTargets.size() == 1 && this.mServiceTargets.get(0) instanceof ChooserActivity.EmptyTargetInfo) {
            return false;
        }
        for (ChooserTargetInfo otherTargetInfo : this.mServiceTargets) {
            if (!chooserTargetInfo.isSimilar(otherTargetInfo)) continue;
            return false;
        }
        int currentSize = this.mServiceTargets.size();
        float newScore = chooserTargetInfo.getModifiedScore();
        for (int i = 0; i < Math.min(currentSize, this.mChooserListCommunicator.getMaxRankedTargets()); ++i) {
            ChooserTargetInfo serviceTarget = this.mServiceTargets.get(i);
            if (serviceTarget == null) {
                this.mServiceTargets.set(i, chooserTargetInfo);
                return true;
            }
            if (!(newScore > serviceTarget.getModifiedScore())) continue;
            this.mServiceTargets.add(i, chooserTargetInfo);
            return true;
        }
        if (currentSize < this.mChooserListCommunicator.getMaxRankedTargets()) {
            this.mServiceTargets.add(chooserTargetInfo);
            return true;
        }
        return false;
    }

    public ChooserTarget getChooserTargetForValue(int value) {
        return this.mServiceTargets.get(value).getChooserTarget();
    }

    @Override
    protected boolean alwaysShowSubLabel() {
        return true;
    }

    @Override
    AsyncTask<List<ResolverActivity.ResolvedComponentInfo>, Void, List<ResolverActivity.ResolvedComponentInfo>> createSortingTask(final boolean doPostProcessing) {
        return new AsyncTask<List<ResolverActivity.ResolvedComponentInfo>, Void, List<ResolverActivity.ResolvedComponentInfo>>(){

            protected List<ResolverActivity.ResolvedComponentInfo> doInBackground(List<ResolverActivity.ResolvedComponentInfo> ... params) {
                ChooserListAdapter.this.mResolverListController.topK(params[0], ChooserListAdapter.this.mChooserListCommunicator.getMaxRankedTargets());
                return params[0];
            }

            @Override
            protected void onPostExecute(List<ResolverActivity.ResolvedComponentInfo> sortedComponents) {
                ChooserListAdapter.this.processSortedList(sortedComponents, doPostProcessing);
                if (doPostProcessing) {
                    ChooserListAdapter.this.mChooserListCommunicator.updateProfileViewButton();
                    ChooserListAdapter.this.notifyDataSetChanged();
                }
            }
        };
    }

    public void setAppPredictor(AppPredictor appPredictor) {
        this.mAppPredictor = appPredictor;
    }

    public void setAppPredictorCallback(AppPredictor.Callback appPredictorCallback) {
        this.mAppPredictorCallback = appPredictorCallback;
    }

    public void destroyAppPredictor() {
        if (this.getAppPredictor() != null) {
            this.getAppPredictor().unregisterPredictionUpdates(this.mAppPredictorCallback);
            this.getAppPredictor().destroy();
            this.setAppPredictor(null);
        }
    }

    static interface ChooserListCommunicator
    extends ResolverListAdapter.ResolverListCommunicator {
        public int getMaxRankedTargets();

        public void sendListViewUpdateMessage(UserHandle var1);

        public boolean isSendAction(Intent var1);
    }
}

