/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.ComponentName;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.app.chooser.DisplayResolveInfo;
import com.android.internal.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ChooserTargetActionsDialogFragment
extends DialogFragment
implements DialogInterface.OnClickListener {
    protected ArrayList<DisplayResolveInfo> mTargetInfos = new ArrayList();
    protected UserHandle mUserHandle;
    public static final String USER_HANDLE_KEY = "user_handle";
    public static final String TARGET_INFOS_KEY = "target_infos";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.setStateFromBundle(savedInstanceState);
        } else {
            this.setStateFromBundle(this.getArguments());
        }
    }

    void setStateFromBundle(Bundle b) {
        this.mTargetInfos = (ArrayList)b.get(TARGET_INFOS_KEY);
        this.mUserHandle = (UserHandle)b.get(USER_HANDLE_KEY);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(USER_HANDLE_KEY, this.mUserHandle);
        outState.putParcelableArrayList(TARGET_INFOS_KEY, this.mTargetInfos);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.setStateFromBundle(savedInstanceState);
        } else {
            this.setStateFromBundle(this.getArguments());
        }
        Optional.of(this.getDialog()).map(Dialog::getWindow).ifPresent(window -> window.setBackgroundDrawable(new ColorDrawable(0)));
        List<Pair<Drawable, CharSequence>> items = this.mTargetInfos.stream().map(dri -> new Pair<Drawable, CharSequence>(this.getItemIcon((DisplayResolveInfo)dri), this.getItemLabel((DisplayResolveInfo)dri))).collect(Collectors.toList());
        View v = inflater.inflate(17367127, container, false);
        TextView title = (TextView)v.findViewById(16908310);
        ImageView icon = (ImageView)v.findViewById(16908294);
        RecyclerView rv = (RecyclerView)v.findViewById(16909139);
        ResolverListAdapter.ResolveInfoPresentationGetter pg = this.getProvidingAppPresentationGetter();
        title.setText(pg.getLabel());
        icon.setImageDrawable(pg.getIcon(this.mUserHandle));
        rv.setAdapter(new VHAdapter(items));
        return v;
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        this.pinComponent(this.mTargetInfos.get(which).getResolvedComponentName());
        ((ChooserActivity)this.getActivity()).handlePackagesChanged();
        this.dismiss();
    }

    private void pinComponent(ComponentName name) {
        SharedPreferences sp = ChooserActivity.getPinnedSharedPrefs(this.getContext());
        String key = name.flattenToString();
        boolean currentVal = sp.getBoolean(name.flattenToString(), false);
        if (currentVal) {
            sp.edit().remove(key).apply();
        } else {
            sp.edit().putBoolean(key, true).apply();
        }
    }

    private Drawable getPinIcon(boolean isPinned) {
        return isPinned ? this.getContext().getDrawable(17302372) : this.getContext().getDrawable(17302360);
    }

    private CharSequence getPinLabel(boolean isPinned, CharSequence targetLabel) {
        return isPinned ? this.getResources().getString(17041535, targetLabel) : this.getResources().getString(17041191, targetLabel);
    }

    protected CharSequence getItemLabel(DisplayResolveInfo dri) {
        PackageManager pm = this.getContext().getPackageManager();
        return this.getPinLabel(dri.isPinned(), dri.getResolveInfo().loadLabel(pm));
    }

    protected Drawable getItemIcon(DisplayResolveInfo dri) {
        return this.getPinIcon(dri.isPinned());
    }

    private ResolverListAdapter.ResolveInfoPresentationGetter getProvidingAppPresentationGetter() {
        ActivityManager am = (ActivityManager)this.getContext().getSystemService("activity");
        int iconDpi = am.getLauncherLargeIconDensity();
        return new ResolverListAdapter.ResolveInfoPresentationGetter(this.getContext(), iconDpi, this.mTargetInfos.get(0).getResolveInfo());
    }

    class VH
    extends RecyclerView.ViewHolder {
        TextView mLabel;
        ImageView mIcon;

        VH(View itemView) {
            super(itemView);
            this.mLabel = (TextView)itemView.findViewById(16909525);
            this.mIcon = (ImageView)itemView.findViewById(16908294);
        }

        public void bind(Pair<Drawable, CharSequence> item, int position) {
            this.mLabel.setText((CharSequence)item.second);
            if (item.first == null) {
                this.mIcon.setVisibility(8);
            } else {
                this.mIcon.setVisibility(0);
                this.mIcon.setImageDrawable((Drawable)item.first);
            }
            this.itemView.setOnClickListener(v -> ChooserTargetActionsDialogFragment.this.onClick(ChooserTargetActionsDialogFragment.this.getDialog(), position));
        }
    }

    class VHAdapter
    extends RecyclerView.Adapter<VH> {
        List<Pair<Drawable, CharSequence>> mItems;

        VHAdapter(List<Pair<Drawable, CharSequence>> items) {
            this.mItems = items;
        }

        @Override
        public VH onCreateViewHolder(ViewGroup parent, int viewType) {
            return new VH(LayoutInflater.from(parent.getContext()).inflate(17367128, parent, false));
        }

        @Override
        public void onBindViewHolder(VH holder, int position) {
            holder.bind(this.mItems.get(position), position);
        }

        @Override
        public int getItemCount() {
            return this.mItems.size();
        }
    }
}

