/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.compat;

import android.compat.Compatibility;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashSet;
import java.util.Set;

public class CompatibilityChangeConfig
implements Parcelable {
    private final Compatibility.ChangeConfig mChangeConfig;
    public static final Parcelable.Creator<CompatibilityChangeConfig> CREATOR = new Parcelable.Creator<CompatibilityChangeConfig>(){

        @Override
        public CompatibilityChangeConfig createFromParcel(Parcel in) {
            return new CompatibilityChangeConfig(in);
        }

        public CompatibilityChangeConfig[] newArray(int size) {
            return new CompatibilityChangeConfig[size];
        }
    };

    public CompatibilityChangeConfig(Compatibility.ChangeConfig changeConfig) {
        this.mChangeConfig = changeConfig;
    }

    public Set<Long> enabledChanges() {
        return this.mChangeConfig.getEnabledSet();
    }

    public Set<Long> disabledChanges() {
        return this.mChangeConfig.getDisabledSet();
    }

    public boolean isChangeEnabled(long changeId) {
        if (this.mChangeConfig.isForceEnabled(changeId)) {
            return true;
        }
        if (this.mChangeConfig.isForceDisabled(changeId)) {
            return false;
        }
        throw new IllegalStateException("Change " + changeId + " is not defined.");
    }

    private CompatibilityChangeConfig(Parcel in) {
        long[] enabledArray = in.createLongArray();
        long[] disabledArray = in.createLongArray();
        Set<Long> enabled = CompatibilityChangeConfig.toLongSet(enabledArray);
        Set<Long> disabled = CompatibilityChangeConfig.toLongSet(disabledArray);
        this.mChangeConfig = new Compatibility.ChangeConfig(enabled, disabled);
    }

    private static Set<Long> toLongSet(long[] values) {
        HashSet<Long> ret = new HashSet<Long>();
        for (long value : values) {
            ret.add(value);
        }
        return ret;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        long[] enabled = this.mChangeConfig.getEnabledChangesArray();
        long[] disabled = this.mChangeConfig.getDisabledChangesArray();
        dest.writeLongArray(enabled);
        dest.writeLongArray(disabled);
    }
}

