/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.compat;

import android.content.pm.ApplicationInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.internal.compat.CompatibilityChangeConfig;
import com.android.internal.compat.CompatibilityChangeInfo;
import com.android.internal.compat.CompatibilityOverrideConfig;
import com.android.internal.compat.CompatibilityOverridesToRemoveConfig;
import com.android.internal.compat.IOverrideValidator;

public interface IPlatformCompat
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.compat.IPlatformCompat";

    public void reportChange(long var1, ApplicationInfo var3) throws RemoteException;

    public void reportChangeByPackageName(long var1, String var3, int var4) throws RemoteException;

    public void reportChangeByUid(long var1, int var3) throws RemoteException;

    public boolean isChangeEnabled(long var1, ApplicationInfo var3) throws RemoteException;

    public boolean isChangeEnabledByPackageName(long var1, String var3, int var4) throws RemoteException;

    public boolean isChangeEnabledByUid(long var1, int var3) throws RemoteException;

    public void setOverrides(CompatibilityChangeConfig var1, String var2) throws RemoteException;

    public void putOverridesOnReleaseBuilds(CompatibilityOverrideConfig var1, String var2) throws RemoteException;

    public void setOverridesForTest(CompatibilityChangeConfig var1, String var2) throws RemoteException;

    public boolean clearOverride(long var1, String var3) throws RemoteException;

    public boolean clearOverrideForTest(long var1, String var3) throws RemoteException;

    public void removeOverridesOnReleaseBuilds(CompatibilityOverridesToRemoveConfig var1, String var2) throws RemoteException;

    public int enableTargetSdkChanges(String var1, int var2) throws RemoteException;

    public int disableTargetSdkChanges(String var1, int var2) throws RemoteException;

    public void clearOverrides(String var1) throws RemoteException;

    public void clearOverridesForTest(String var1) throws RemoteException;

    public CompatibilityChangeConfig getAppConfig(ApplicationInfo var1) throws RemoteException;

    public CompatibilityChangeInfo[] listAllChanges() throws RemoteException;

    public CompatibilityChangeInfo[] listUIChanges() throws RemoteException;

    public IOverrideValidator getOverrideValidator() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPlatformCompat {
        static final int TRANSACTION_reportChange = 1;
        static final int TRANSACTION_reportChangeByPackageName = 2;
        static final int TRANSACTION_reportChangeByUid = 3;
        static final int TRANSACTION_isChangeEnabled = 4;
        static final int TRANSACTION_isChangeEnabledByPackageName = 5;
        static final int TRANSACTION_isChangeEnabledByUid = 6;
        static final int TRANSACTION_setOverrides = 7;
        static final int TRANSACTION_putOverridesOnReleaseBuilds = 8;
        static final int TRANSACTION_setOverridesForTest = 9;
        static final int TRANSACTION_clearOverride = 10;
        static final int TRANSACTION_clearOverrideForTest = 11;
        static final int TRANSACTION_removeOverridesOnReleaseBuilds = 12;
        static final int TRANSACTION_enableTargetSdkChanges = 13;
        static final int TRANSACTION_disableTargetSdkChanges = 14;
        static final int TRANSACTION_clearOverrides = 15;
        static final int TRANSACTION_clearOverridesForTest = 16;
        static final int TRANSACTION_getAppConfig = 17;
        static final int TRANSACTION_listAllChanges = 18;
        static final int TRANSACTION_listUIChanges = 19;
        static final int TRANSACTION_getOverrideValidator = 20;

        public Stub() {
            this.attachInterface(this, IPlatformCompat.DESCRIPTOR);
        }

        public static IPlatformCompat asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPlatformCompat.DESCRIPTOR);
            if (iin != null && iin instanceof IPlatformCompat) {
                return (IPlatformCompat)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "reportChange";
                }
                case 2: {
                    return "reportChangeByPackageName";
                }
                case 3: {
                    return "reportChangeByUid";
                }
                case 4: {
                    return "isChangeEnabled";
                }
                case 5: {
                    return "isChangeEnabledByPackageName";
                }
                case 6: {
                    return "isChangeEnabledByUid";
                }
                case 7: {
                    return "setOverrides";
                }
                case 8: {
                    return "putOverridesOnReleaseBuilds";
                }
                case 9: {
                    return "setOverridesForTest";
                }
                case 10: {
                    return "clearOverride";
                }
                case 11: {
                    return "clearOverrideForTest";
                }
                case 12: {
                    return "removeOverridesOnReleaseBuilds";
                }
                case 13: {
                    return "enableTargetSdkChanges";
                }
                case 14: {
                    return "disableTargetSdkChanges";
                }
                case 15: {
                    return "clearOverrides";
                }
                case 16: {
                    return "clearOverridesForTest";
                }
                case 17: {
                    return "getAppConfig";
                }
                case 18: {
                    return "listAllChanges";
                }
                case 19: {
                    return "listUIChanges";
                }
                case 20: {
                    return "getOverrideValidator";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPlatformCompat.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    ApplicationInfo _arg1 = 0 != data.readInt() ? ApplicationInfo.CREATOR.createFromParcel(data) : null;
                    this.reportChange(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.reportChangeByPackageName(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    this.reportChangeByUid(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    ApplicationInfo _arg1 = 0 != data.readInt() ? ApplicationInfo.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.isChangeEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _result = this.isChangeEnabledByPackageName(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    boolean _result = this.isChangeEnabledByUid(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    CompatibilityChangeConfig _arg0 = 0 != data.readInt() ? CompatibilityChangeConfig.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    this.setOverrides(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    CompatibilityOverrideConfig _arg0 = 0 != data.readInt() ? CompatibilityOverrideConfig.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    this.putOverridesOnReleaseBuilds(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    CompatibilityChangeConfig _arg0 = 0 != data.readInt() ? CompatibilityChangeConfig.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    this.setOverridesForTest(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    boolean _result = this.clearOverride(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    boolean _result = this.clearOverrideForTest(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    CompatibilityOverridesToRemoveConfig _arg0 = 0 != data.readInt() ? CompatibilityOverridesToRemoveConfig.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    this.removeOverridesOnReleaseBuilds(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _result = this.enableTargetSdkChanges(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _result = this.disableTargetSdkChanges(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.clearOverrides(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.clearOverridesForTest(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    ApplicationInfo _arg0 = 0 != data.readInt() ? ApplicationInfo.CREATOR.createFromParcel(data) : null;
                    CompatibilityChangeConfig _result = this.getAppConfig(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.listAllChanges();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.listUIChanges();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    IOverrideValidator _result = this.getOverrideValidator();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IPlatformCompat impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IPlatformCompat getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPlatformCompat {
            private IBinder mRemote;
            public static IPlatformCompat sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPlatformCompat.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportChange(long changeId, ApplicationInfo appInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    if (appInfo != null) {
                        _data.writeInt(1);
                        appInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportChange(changeId, appInfo);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportChangeByPackageName(long changeId, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportChangeByPackageName(changeId, packageName, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportChangeByUid(long changeId, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportChangeByUid(changeId, uid);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isChangeEnabled(long changeId, ApplicationInfo appInfo) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    if (appInfo != null) {
                        _data.writeInt(1);
                        appInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isChangeEnabled(changeId, appInfo);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isChangeEnabledByPackageName(long changeId, String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isChangeEnabledByPackageName(changeId, packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isChangeEnabledByUid(long changeId, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isChangeEnabledByUid(changeId, uid);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOverrides(CompatibilityChangeConfig overrides, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    if (overrides != null) {
                        _data.writeInt(1);
                        overrides.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setOverrides(overrides, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void putOverridesOnReleaseBuilds(CompatibilityOverrideConfig overrides, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    if (overrides != null) {
                        _data.writeInt(1);
                        overrides.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().putOverridesOnReleaseBuilds(overrides, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOverridesForTest(CompatibilityChangeConfig overrides, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    if (overrides != null) {
                        _data.writeInt(1);
                        overrides.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setOverridesForTest(overrides, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean clearOverride(long changeId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().clearOverride(changeId, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean clearOverrideForTest(long changeId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().clearOverrideForTest(changeId, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOverridesOnReleaseBuilds(CompatibilityOverridesToRemoveConfig overridesToRemove, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    if (overridesToRemove != null) {
                        _data.writeInt(1);
                        overridesToRemove.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeOverridesOnReleaseBuilds(overridesToRemove, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int enableTargetSdkChanges(String packageName, int targetSdkVersion) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(targetSdkVersion);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().enableTargetSdkChanges(packageName, targetSdkVersion);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int disableTargetSdkChanges(String packageName, int targetSdkVersion) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(targetSdkVersion);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().disableTargetSdkChanges(packageName, targetSdkVersion);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearOverrides(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearOverrides(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearOverridesForTest(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearOverridesForTest(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompatibilityChangeConfig getAppConfig(ApplicationInfo appInfo) throws RemoteException {
                CompatibilityChangeConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    if (appInfo != null) {
                        _data.writeInt(1);
                        appInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CompatibilityChangeConfig compatibilityChangeConfig = Stub.getDefaultImpl().getAppConfig(appInfo);
                        return compatibilityChangeConfig;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? CompatibilityChangeConfig.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompatibilityChangeInfo[] listAllChanges() throws RemoteException {
                CompatibilityChangeInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CompatibilityChangeInfo[] compatibilityChangeInfoArray = Stub.getDefaultImpl().listAllChanges();
                        return compatibilityChangeInfoArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(CompatibilityChangeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompatibilityChangeInfo[] listUIChanges() throws RemoteException {
                CompatibilityChangeInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CompatibilityChangeInfo[] compatibilityChangeInfoArray = Stub.getDefaultImpl().listUIChanges();
                        return compatibilityChangeInfoArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(CompatibilityChangeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOverrideValidator getOverrideValidator() throws RemoteException {
                IOverrideValidator _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IOverrideValidator iOverrideValidator = Stub.getDefaultImpl().getOverrideValidator();
                        return iOverrideValidator;
                    }
                    _reply.readException();
                    _result = IOverrideValidator.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IPlatformCompat {
        @Override
        public void reportChange(long changeId, ApplicationInfo appInfo) throws RemoteException {
        }

        @Override
        public void reportChangeByPackageName(long changeId, String packageName, int userId) throws RemoteException {
        }

        @Override
        public void reportChangeByUid(long changeId, int uid) throws RemoteException {
        }

        @Override
        public boolean isChangeEnabled(long changeId, ApplicationInfo appInfo) throws RemoteException {
            return false;
        }

        @Override
        public boolean isChangeEnabledByPackageName(long changeId, String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isChangeEnabledByUid(long changeId, int uid) throws RemoteException {
            return false;
        }

        @Override
        public void setOverrides(CompatibilityChangeConfig overrides, String packageName) throws RemoteException {
        }

        @Override
        public void putOverridesOnReleaseBuilds(CompatibilityOverrideConfig overrides, String packageName) throws RemoteException {
        }

        @Override
        public void setOverridesForTest(CompatibilityChangeConfig overrides, String packageName) throws RemoteException {
        }

        @Override
        public boolean clearOverride(long changeId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean clearOverrideForTest(long changeId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void removeOverridesOnReleaseBuilds(CompatibilityOverridesToRemoveConfig overridesToRemove, String packageName) throws RemoteException {
        }

        @Override
        public int enableTargetSdkChanges(String packageName, int targetSdkVersion) throws RemoteException {
            return 0;
        }

        @Override
        public int disableTargetSdkChanges(String packageName, int targetSdkVersion) throws RemoteException {
            return 0;
        }

        @Override
        public void clearOverrides(String packageName) throws RemoteException {
        }

        @Override
        public void clearOverridesForTest(String packageName) throws RemoteException {
        }

        @Override
        public CompatibilityChangeConfig getAppConfig(ApplicationInfo appInfo) throws RemoteException {
            return null;
        }

        @Override
        public CompatibilityChangeInfo[] listAllChanges() throws RemoteException {
            return null;
        }

        @Override
        public CompatibilityChangeInfo[] listUIChanges() throws RemoteException {
            return null;
        }

        @Override
        public IOverrideValidator getOverrideValidator() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

