/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content.om;

import android.content.pm.parsing.ApkLite;
import android.content.pm.parsing.ApkLiteParseUtils;
import android.content.pm.parsing.result.ParseResult;
import android.content.pm.parsing.result.ParseTypeImpl;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class OverlayScanner {
    private final ArrayMap<String, ParsedOverlayInfo> mParsedOverlayInfos = new ArrayMap();

    public ParsedOverlayInfo getParsedInfo(String packageName) {
        return this.mParsedOverlayInfos.get(packageName);
    }

    Collection<ParsedOverlayInfo> getAllParsedInfos() {
        return this.mParsedOverlayInfos.values();
    }

    public void scanDir(File partitionOverlayDir) {
        if (!partitionOverlayDir.exists() || !partitionOverlayDir.isDirectory()) {
            return;
        }
        if (!partitionOverlayDir.canRead()) {
            Log.w("OverlayConfig", "Directory " + partitionOverlayDir + " cannot be read");
            return;
        }
        File[] files = partitionOverlayDir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            ParsedOverlayInfo info;
            File f = files[i];
            if (f.isDirectory()) {
                this.scanDir(f);
            }
            if (!f.isFile() || !f.getPath().endsWith(".apk") || (info = this.parseOverlayManifest(f)) == null) continue;
            this.mParsedOverlayInfos.put(info.packageName, info);
        }
    }

    @VisibleForTesting
    public ParsedOverlayInfo parseOverlayManifest(File overlayApk) {
        ParseTypeImpl input = ParseTypeImpl.forParsingWithoutPlatformCompat();
        ParseResult<ApkLite> ret = ApkLiteParseUtils.parseApkLite(input.reset(), overlayApk, 0);
        if (ret.isError()) {
            Log.w("OverlayConfig", "Got exception loading overlay.", ret.getException());
            return null;
        }
        ApkLite apkLite = ret.getResult();
        return apkLite.getTargetPackageName() == null ? null : new ParsedOverlayInfo(apkLite.getPackageName(), apkLite.getTargetPackageName(), apkLite.getTargetSdkVersion(), apkLite.isOverlayIsStatic(), apkLite.getOverlayPriority(), new File(apkLite.getPath()));
    }

    public static class ParsedOverlayInfo {
        public final String packageName;
        public final String targetPackageName;
        public final int targetSdkVersion;
        public final boolean isStatic;
        public final int priority;
        public final File path;

        public ParsedOverlayInfo(String packageName, String targetPackageName, int targetSdkVersion, boolean isStatic, int priority, File path) {
            this.packageName = packageName;
            this.targetPackageName = targetPackageName;
            this.targetSdkVersion = targetSdkVersion;
            this.isStatic = isStatic;
            this.priority = priority;
            this.path = path;
        }

        public String toString() {
            return this.getClass().getSimpleName() + String.format("{packageName=%s, targetPackageName=%s, targetSdkVersion=%s, isStatic=%s, priority=%s, path=%s}", this.packageName, this.targetPackageName, this.targetSdkVersion, this.isStatic, this.priority, this.path);
        }
    }
}

