/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

public class CancellationGroup {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private ArrayList<CountDownLatch> mLatchList = null;
    @GuardedBy(value={"mLock"})
    private boolean mCanceled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerLatch(CountDownLatch latch) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCanceled) {
                return false;
            }
            if (this.mLatchList == null) {
                this.mLatchList = new ArrayList(1);
            }
            this.mLatchList.add(latch);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterLatch(CountDownLatch latch) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLatchList != null) {
                this.mLatchList.remove(latch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCanceled) {
                this.mCanceled = true;
                if (this.mLatchList != null) {
                    this.mLatchList.forEach(CountDownLatch::countDown);
                    this.mLatchList.clear();
                    this.mLatchList = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCanceled;
        }
    }
}

