/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.inputmethod.InputMethodInfo;
import com.android.internal.inputmethod.ThrowableHolder;
import java.util.ArrayList;
import java.util.List;

public interface IInputMethodInfoListResultCallback
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.inputmethod.IInputMethodInfoListResultCallback";

    public void onResult(List<InputMethodInfo> var1) throws RemoteException;

    public void onError(ThrowableHolder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodInfoListResultCallback {
        static final int TRANSACTION_onResult = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, IInputMethodInfoListResultCallback.DESCRIPTOR);
        }

        public static IInputMethodInfoListResultCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInputMethodInfoListResultCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IInputMethodInfoListResultCallback) {
                return (IInputMethodInfoListResultCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onResult";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInputMethodInfoListResultCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    ArrayList<InputMethodInfo> _arg0 = data.createTypedArrayList(InputMethodInfo.CREATOR);
                    this.onResult(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ThrowableHolder _arg0 = 0 != data.readInt() ? ThrowableHolder.CREATOR.createFromParcel(data) : null;
                    this.onError(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IInputMethodInfoListResultCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IInputMethodInfoListResultCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IInputMethodInfoListResultCallback {
            private IBinder mRemote;
            public static IInputMethodInfoListResultCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInputMethodInfoListResultCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(List<InputMethodInfo> result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodInfoListResultCallback.DESCRIPTOR);
                    _data.writeTypedList(result);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onResult(result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(ThrowableHolder exception) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputMethodInfoListResultCallback.DESCRIPTOR);
                    if (exception != null) {
                        _data.writeInt(1);
                        exception.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onError(exception);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputMethodInfoListResultCallback {
        @Override
        public void onResult(List<InputMethodInfo> result) throws RemoteException {
        }

        @Override
        public void onError(ThrowableHolder exception) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

