/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.listeners;

import java.util.concurrent.Executor;
import java.util.function.Supplier;

public interface ListenerExecutor {
    default public <TListener> void executeSafely(Executor executor, Supplier<TListener> listenerSupplier, ListenerOperation<TListener> operation) {
        this.executeSafely(executor, listenerSupplier, operation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <TListener, TListenerOperation extends ListenerOperation<TListener>> void executeSafely(Executor executor, Supplier<TListener> listenerSupplier, TListenerOperation operation, FailureCallback<TListenerOperation> failureCallback) {
        if (operation == null) {
            return;
        }
        Object listener = listenerSupplier.get();
        if (listener == null) {
            return;
        }
        boolean executing = false;
        boolean preexecute = false;
        try {
            operation.onPreExecute();
            preexecute = true;
            executor.execute(() -> {
                boolean success = false;
                try {
                    if (listener == listenerSupplier.get()) {
                        operation.operate(listener);
                        success = true;
                    }
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    operation.onFailure(e);
                    if (failureCallback != null) {
                        failureCallback.onFailure(operation, e);
                    }
                }
                finally {
                    operation.onPostExecute(success);
                    operation.onComplete(success);
                }
            });
            executing = true;
        }
        finally {
            if (!executing) {
                if (preexecute) {
                    operation.onPostExecute(false);
                }
                operation.onComplete(false);
            }
        }
    }

    public static interface FailureCallback<TListenerOperation extends ListenerOperation<?>> {
        public void onFailure(TListenerOperation var1, Exception var2);
    }

    public static interface ListenerOperation<TListener> {
        public void operate(TListener var1) throws Exception;

        default public void onPreExecute() {
        }

        default public void onFailure(Exception e) {
        }

        default public void onPostExecute(boolean success) {
        }

        default public void onComplete(boolean success) {
        }
    }
}

