/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.crypto;

import android.net.IpSecAlgorithm;
import android.util.SparseArray;
import com.android.internal.net.ipsec.ike.crypto.IkeCombinedModeCipher;
import com.android.internal.net.ipsec.ike.crypto.IkeCrypto;
import com.android.internal.net.ipsec.ike.crypto.IkeNormalModeCipher;
import com.android.internal.net.ipsec.ike.message.IkeSaPayload;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public abstract class IkeCipher
extends IkeCrypto {
    private static final int KEY_LEN_3DES = 24;
    private static final int KEY_LEN_CHACHA20_POLY1305 = 32;
    private static final int IV_LEN_3DES = 8;
    private static final int IV_LEN_AES_CBC = 16;
    private static final int IV_LEN_AES_CTR = 8;
    private static final int IV_LEN_AES_GCM = 8;
    private static final int IV_LEN_CHACHA20_POLY1305 = 8;
    private static final int SALT_LEN_AES_GCM = 4;
    private static final int SALT_LEN_AES_CTR = 4;
    private static final int SALT_LEN_AES_CHACHA20_POLY1305 = 4;
    private static final int BLOCK_SIZE_CHACHA_POLY = 4;
    protected static final int SALT_LEN_NOT_INCLUDED = 0;
    protected static final int BLOCK_SIZE_NOT_SPECIFIED = 0;
    private static final SparseArray<String> IKE_ALGO_TO_IPSEC_ALGO = new SparseArray();
    private final boolean mIsAead;
    private final int mIvLen;
    private final int mBlockSize;
    protected final int mSaltLen;
    protected final Cipher mCipher;

    protected IkeCipher(int algorithmId, int keyLength, int ivLength, String algorithmName, boolean isAead, int saltLen, int blockSize) {
        super(algorithmId, keyLength, algorithmName);
        this.mIvLen = ivLength;
        this.mIsAead = isAead;
        this.mSaltLen = saltLen;
        try {
            this.mCipher = Cipher.getInstance(this.getAlgorithmName());
            this.mBlockSize = blockSize == 0 ? this.mCipher.getBlockSize() : blockSize;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Failed to construct " + this.getTypeString(), e);
        }
    }

    public static IkeCipher create(IkeSaPayload.EncryptionTransform encryptionTransform) {
        int algorithmId = encryptionTransform.id;
        switch (algorithmId) {
            case 3: {
                return new IkeNormalModeCipher(algorithmId, 24, 8, "DESede/CBC/NoPadding");
            }
            case 12: {
                return new IkeNormalModeCipher(algorithmId, encryptionTransform.getSpecifiedKeyLength() / 8, 16, "AES/CBC/NoPadding");
            }
            case 13: {
                return new IkeNormalModeCipher(algorithmId, encryptionTransform.getSpecifiedKeyLength() / 8, 8, "AES/CTR/NoPadding", 4);
            }
            case 18: 
            case 19: 
            case 20: {
                return new IkeCombinedModeCipher(algorithmId, encryptionTransform.getSpecifiedKeyLength() / 8, 8, "AES/GCM/NoPadding", 4);
            }
            case 28: {
                return new IkeCombinedModeCipher(algorithmId, 32, 8, "ChaCha20/Poly1305/NoPadding", 4, 4);
            }
        }
        throw new IllegalArgumentException("Unrecognized Encryption Algorithm ID: " + algorithmId);
    }

    public boolean isAead() {
        return this.mIsAead;
    }

    public int getBlockSize() {
        return this.mBlockSize;
    }

    public int getIvLen() {
        return this.mIvLen;
    }

    public byte[] generateIv() {
        byte[] iv = new byte[this.getIvLen()];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    protected void validateKeyLenOrThrow(byte[] key) {
        if (key.length != this.getKeyLength()) {
            throw new IllegalArgumentException("Expected key with length of : " + this.getKeyLength() + " Received key with length of : " + key.length);
        }
    }

    @Override
    public int getKeyLength() {
        return super.getKeyLength() + this.mSaltLen;
    }

    public static String getIpSecAlgorithmName(int ikeAlgoId) {
        return IKE_ALGO_TO_IPSEC_ALGO.get(ikeAlgoId);
    }

    protected abstract IpSecAlgorithm buildIpSecAlgorithmWithKeyImpl(byte[] var1);

    public IpSecAlgorithm buildIpSecAlgorithmWithKey(byte[] key) {
        this.validateKeyLenOrThrow(key);
        if (IkeCipher.getIpSecAlgorithmName(this.getAlgorithmId()) == null) {
            throw new IllegalStateException("Unsupported algorithm " + this.getAlgorithmId() + " in IPsec");
        }
        return this.buildIpSecAlgorithmWithKeyImpl(key);
    }

    @Override
    public String getTypeString() {
        return "Encryption Algorithm";
    }

    static {
        IKE_ALGO_TO_IPSEC_ALGO.put(12, "cbc(aes)");
        IKE_ALGO_TO_IPSEC_ALGO.put(13, "rfc3686(ctr(aes))");
        IKE_ALGO_TO_IPSEC_ALGO.put(18, "rfc4106(gcm(aes))");
        IKE_ALGO_TO_IPSEC_ALGO.put(19, "rfc4106(gcm(aes))");
        IKE_ALGO_TO_IPSEC_ALGO.put(20, "rfc4106(gcm(aes))");
        IKE_ALGO_TO_IPSEC_ALGO.put(28, "rfc7539esp(chacha20,poly1305)");
    }
}

