/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.crypto;

import android.net.IpSecAlgorithm;
import android.util.SparseArray;
import com.android.internal.net.ipsec.ike.crypto.AesXCbcImpl;
import com.android.internal.net.ipsec.ike.crypto.IkeMac;
import com.android.internal.net.ipsec.ike.message.IkeSaPayload;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public class IkeMacIntegrity
extends IkeMac {
    private static final SparseArray<String> IKE_ALGO_TO_IPSEC_ALGO = new SparseArray();
    private final int mChecksumLength;

    private IkeMacIntegrity(int algorithmId, int keyLength, String algorithmName, boolean isJceSupported, int checksumLength) {
        super(algorithmId, keyLength, algorithmName, isJceSupported);
        this.mChecksumLength = checksumLength;
    }

    public static IkeMacIntegrity create(IkeSaPayload.IntegrityTransform integrityTransform) {
        int algorithmId = integrityTransform.id;
        int keyLength = 0;
        String algorithmName = "";
        boolean isJceSupported = true;
        int checksumLength = 0;
        switch (algorithmId) {
            case 0: {
                throw new IllegalArgumentException("Integrity algorithm is not found.");
            }
            case 2: {
                keyLength = 20;
                algorithmName = "HmacSHA1";
                checksumLength = 12;
                break;
            }
            case 5: {
                keyLength = 16;
                isJceSupported = false;
                algorithmName = "ALGO_NAME_JCE_UNSUPPORTED";
                checksumLength = 12;
                break;
            }
            case 8: {
                keyLength = 16;
                algorithmName = "AESCMAC";
                checksumLength = 12;
                break;
            }
            case 12: {
                keyLength = 32;
                algorithmName = "HmacSHA256";
                checksumLength = 16;
                break;
            }
            case 13: {
                keyLength = 48;
                algorithmName = "HmacSHA384";
                checksumLength = 24;
                break;
            }
            case 14: {
                keyLength = 64;
                algorithmName = "HmacSHA512";
                checksumLength = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized Integrity Algorithm ID: " + algorithmId);
            }
        }
        return new IkeMacIntegrity(algorithmId, keyLength, algorithmName, isJceSupported, checksumLength);
    }

    @Override
    public byte[] signBytes(byte[] keyBytes, byte[] dataToSign) {
        if (this.getAlgorithmId() == 5) {
            try {
                return new AesXCbcImpl().mac(keyBytes, dataToSign, true);
            }
            catch (IllegalStateException | GeneralSecurityException e) {
                throw new IllegalArgumentException("Failed to generate MAC: ", e);
            }
        }
        return super.signBytes(keyBytes, dataToSign);
    }

    public int getChecksumLen() {
        return this.mChecksumLength;
    }

    public byte[] generateChecksum(byte[] keyBytes, byte[] dataToAuthenticate) {
        if (this.getKeyLength() != keyBytes.length) {
            throw new IllegalArgumentException("Expected key length: " + this.getKeyLength() + " Received key length: " + keyBytes.length);
        }
        byte[] signedBytes = this.signBytes(keyBytes, dataToAuthenticate);
        return Arrays.copyOfRange(signedBytes, 0, this.mChecksumLength);
    }

    public static String getIpSecAlgorithmName(int ikeAlgoId) {
        return IKE_ALGO_TO_IPSEC_ALGO.get(ikeAlgoId);
    }

    public IpSecAlgorithm buildIpSecAlgorithmWithKey(byte[] key) {
        if (key.length != this.getKeyLength()) {
            throw new IllegalArgumentException("Expected key with length of : " + this.getKeyLength() + " Received key with length of : " + key.length);
        }
        if (IkeMacIntegrity.getIpSecAlgorithmName(this.getAlgorithmId()) == null) {
            throw new IllegalStateException("Unsupported algorithm " + this.getAlgorithmId() + " in IPsec");
        }
        return new IpSecAlgorithm(IkeMacIntegrity.getIpSecAlgorithmName(this.getAlgorithmId()), key, this.mChecksumLength * 8);
    }

    @Override
    public String getTypeString() {
        return "Integrity Algorithm.";
    }

    static {
        IKE_ALGO_TO_IPSEC_ALGO.put(2, "hmac(sha1)");
        IKE_ALGO_TO_IPSEC_ALGO.put(5, "xcbc(aes)");
        IKE_ALGO_TO_IPSEC_ALGO.put(8, "cmac(aes)");
        IKE_ALGO_TO_IPSEC_ALGO.put(12, "hmac(sha256)");
        IKE_ALGO_TO_IPSEC_ALGO.put(13, "hmac(sha384)");
        IKE_ALGO_TO_IPSEC_ALGO.put(14, "hmac(sha512)");
    }
}

