/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.crypto;

import android.net.IpSecAlgorithm;
import com.android.internal.net.ipsec.ike.crypto.IkeCipher;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class IkeNormalModeCipher
extends IkeCipher {
    static final byte[] AES_CTR_INITIAL_COUNTER = new byte[]{0, 0, 0, 1};

    IkeNormalModeCipher(int algorithmId, int keyLength, int ivLength, String algorithmName) {
        this(algorithmId, keyLength, ivLength, algorithmName, 0);
    }

    IkeNormalModeCipher(int algorithmId, int keyLength, int ivLength, String algorithmName, int saltLen) {
        super(algorithmId, keyLength, ivLength, algorithmName, false, saltLen, 0);
    }

    private byte[] doCipherAction(byte[] data, byte[] keyBytes, byte[] ivBytes, int opmode) throws IllegalBlockSizeException {
        if (this.getKeyLength() != keyBytes.length) {
            throw new IllegalArgumentException("Expected key length: " + this.getKeyLength() + " Received key length: " + keyBytes.length);
        }
        try {
            byte[] secretKeyBytes = Arrays.copyOfRange(keyBytes, 0, keyBytes.length - this.mSaltLen);
            byte[] salt = Arrays.copyOfRange(keyBytes, secretKeyBytes.length, keyBytes.length);
            byte[] nonce = IkeNormalModeCipher.concatenateByteArray(salt, ivBytes);
            if (this.getAlgorithmId() == 13) {
                nonce = IkeNormalModeCipher.concatenateByteArray(nonce, AES_CTR_INITIAL_COUNTER);
            }
            SecretKeySpec key = new SecretKeySpec(secretKeyBytes, this.getAlgorithmName());
            IvParameterSpec iv = new IvParameterSpec(nonce);
            this.mCipher.init(opmode, (Key)key, iv);
            ByteBuffer inputBuffer = ByteBuffer.wrap(data);
            ByteBuffer outputBuffer = ByteBuffer.allocate(data.length);
            this.mCipher.doFinal(inputBuffer, outputBuffer);
            return outputBuffer.array();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | ShortBufferException e) {
            String errorMessage = 1 == opmode ? "Failed to encrypt data: " : "Failed to decrypt data: ";
            throw new IllegalArgumentException(errorMessage, e);
        }
    }

    public byte[] encrypt(byte[] paddedData, byte[] keyBytes, byte[] ivBytes) {
        try {
            return this.doCipherAction(paddedData, keyBytes, ivBytes, 1);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Failed to encrypt data: ", e);
        }
    }

    public byte[] decrypt(byte[] encryptedData, byte[] keyBytes, byte[] ivBytes) throws IllegalBlockSizeException {
        return this.doCipherAction(encryptedData, keyBytes, ivBytes, 2);
    }

    @Override
    protected IpSecAlgorithm buildIpSecAlgorithmWithKeyImpl(byte[] key) {
        return new IpSecAlgorithm(IkeNormalModeCipher.getIpSecAlgorithmName(this.getAlgorithmId()), key);
    }

    private static byte[] concatenateByteArray(byte[] left, byte[] right) {
        byte[] result = new byte[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }
}

