/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.hardware.SensorManager;
import android.os.BatteryStats;
import android.os.Bundle;
import android.os.MemoryFile;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.telephony.TelephonyManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.AmbientDisplayPowerCalculator;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.BluetoothPowerCalculator;
import com.android.internal.os.CameraPowerCalculator;
import com.android.internal.os.CpuPowerCalculator;
import com.android.internal.os.CustomMeasuredPowerCalculator;
import com.android.internal.os.FlashlightPowerCalculator;
import com.android.internal.os.GnssPowerCalculator;
import com.android.internal.os.IdlePowerCalculator;
import com.android.internal.os.MediaPowerCalculator;
import com.android.internal.os.MemoryPowerCalculator;
import com.android.internal.os.MobileRadioPowerCalculator;
import com.android.internal.os.PhonePowerCalculator;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.ScreenPowerCalculator;
import com.android.internal.os.SensorPowerCalculator;
import com.android.internal.os.SystemServicePowerCalculator;
import com.android.internal.os.UserPowerCalculator;
import com.android.internal.os.WakelockPowerCalculator;
import com.android.internal.os.WifiPowerCalculator;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public class BatteryStatsHelper {
    static final boolean DEBUG = false;
    private static final String TAG = BatteryStatsHelper.class.getSimpleName();
    private static BatteryStats sStatsXfer;
    private static Intent sBatteryBroadcastXfer;
    private static ArrayMap<File, BatteryStats> sFileXfer;
    private final Context mContext;
    private final boolean mCollectBatteryBroadcast;
    private final boolean mWifiOnly;
    private List<PowerCalculator> mPowerCalculators;
    @UnsupportedAppUsage
    private IBatteryStats mBatteryInfo;
    private BatteryStats mStats;
    private Intent mBatteryBroadcast;
    @UnsupportedAppUsage
    private PowerProfile mPowerProfile;
    private String[] mSystemPackageArray;
    private String[] mServicepackageArray;
    private PackageManager mPackageManager;
    @UnsupportedAppUsage
    private final List<BatterySipper> mUsageList = new ArrayList<BatterySipper>();
    private final List<BatterySipper> mMobilemsppList = new ArrayList<BatterySipper>();
    private int mStatsType = 0;
    long mRawRealtimeUs;
    long mRawUptimeUs;
    long mBatteryRealtimeUs;
    long mBatteryUptimeUs;
    long mBatteryTimeRemainingUs;
    long mChargeTimeRemainingUs;
    private long mStatsPeriod = 0L;
    private double mMaxPower = 1.0;
    private double mMaxRealPower = 1.0;
    private double mComputedPower;
    private double mTotalPower;
    private double mMinDrainedPower;
    private double mMaxDrainedPower;

    public static boolean checkWifiOnly(Context context) {
        TelephonyManager tm = context.getSystemService(TelephonyManager.class);
        if (tm == null) {
            return false;
        }
        return !tm.isDataCapable();
    }

    @UnsupportedAppUsage
    public BatteryStatsHelper(Context context) {
        this(context, true);
    }

    @UnsupportedAppUsage
    public BatteryStatsHelper(Context context, boolean collectBatteryBroadcast) {
        this(context, collectBatteryBroadcast, BatteryStatsHelper.checkWifiOnly(context));
    }

    @UnsupportedAppUsage
    public BatteryStatsHelper(Context context, boolean collectBatteryBroadcast, boolean wifiOnly) {
        this.mContext = context;
        this.mCollectBatteryBroadcast = collectBatteryBroadcast;
        this.mWifiOnly = wifiOnly;
        this.mPackageManager = context.getPackageManager();
        Resources resources = context.getResources();
        this.mSystemPackageArray = resources.getStringArray(17235995);
        this.mServicepackageArray = resources.getStringArray(17235994);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeStatsHistoryInFile(String fname) {
        ArrayMap<File, BatteryStats> arrayMap = sFileXfer;
        synchronized (arrayMap) {
            File path = BatteryStatsHelper.makeFilePath(this.mContext, fname);
            sFileXfer.put(path, this.getStats());
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(path);
                Parcel hist = Parcel.obtain();
                this.getStats().writeToParcelWithoutUids(hist, 0);
                byte[] histData = hist.marshall();
                fout.write(histData);
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to write history to file", e);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BatteryStats statsFromFile(Context context, String fname) {
        ArrayMap<File, BatteryStats> arrayMap = sFileXfer;
        synchronized (arrayMap) {
            block15: {
                BatteryStats batteryStats;
                File path = BatteryStatsHelper.makeFilePath(context, fname);
                BatteryStats stats = sFileXfer.get(path);
                if (stats != null) {
                    return stats;
                }
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(path);
                    byte[] data = BatteryStatsHelper.readFully(fin);
                    Parcel parcel = Parcel.obtain();
                    parcel.unmarshall(data, 0, data.length);
                    parcel.setDataPosition(0);
                    batteryStats = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
                }
                catch (IOException e) {
                    Log.w(TAG, "Unable to read history to file", e);
                    break block15;
                }
                return batteryStats;
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return BatteryStatsHelper.getStats(IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats")), true);
        }
    }

    @UnsupportedAppUsage
    public static void dropFile(Context context, String fname) {
        BatteryStatsHelper.makeFilePath(context, fname).delete();
    }

    private static File makeFilePath(Context context, String fname) {
        return new File(context.getFilesDir(), fname);
    }

    @UnsupportedAppUsage
    public void clearStats() {
        this.mStats = null;
    }

    @UnsupportedAppUsage
    public BatteryStats getStats() {
        return this.getStats(true);
    }

    public BatteryStats getStats(boolean updateAll) {
        if (this.mStats == null) {
            this.load(updateAll);
        }
        return this.mStats;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public Intent getBatteryBroadcast() {
        if (this.mBatteryBroadcast == null && this.mCollectBatteryBroadcast) {
            this.load();
        }
        return this.mBatteryBroadcast;
    }

    public PowerProfile getPowerProfile() {
        return this.mPowerProfile;
    }

    public void create(BatteryStats stats) {
        this.mPowerProfile = new PowerProfile(this.mContext);
        this.mStats = stats;
    }

    @UnsupportedAppUsage
    public void create(Bundle icicle) {
        if (icicle != null) {
            this.mStats = sStatsXfer;
            this.mBatteryBroadcast = sBatteryBroadcastXfer;
        }
        this.mBatteryInfo = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mPowerProfile = new PowerProfile(this.mContext);
    }

    @UnsupportedAppUsage
    public void storeState() {
        sStatsXfer = this.mStats;
        sBatteryBroadcastXfer = this.mBatteryBroadcast;
    }

    public static String makemAh(double power) {
        return PowerCalculator.formatCharge(power);
    }

    @UnsupportedAppUsage
    public void refreshStats(int statsType, int asUser) {
        SparseArray<UserHandle> users = new SparseArray<UserHandle>(1);
        users.put(asUser, new UserHandle(asUser));
        this.refreshStats(statsType, users);
    }

    @UnsupportedAppUsage
    public void refreshStats(int statsType, List<UserHandle> asUsers) {
        int n = asUsers.size();
        SparseArray<UserHandle> users = new SparseArray<UserHandle>(n);
        for (int i = 0; i < n; ++i) {
            UserHandle userHandle = asUsers.get(i);
            users.put(userHandle.getIdentifier(), userHandle);
        }
        this.refreshStats(statsType, users);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void refreshStats(int statsType, SparseArray<UserHandle> asUsers) {
        this.refreshStats(statsType, asUsers, SystemClock.elapsedRealtime() * 1000L, SystemClock.uptimeMillis() * 1000L);
    }

    public void refreshStats(int statsType, SparseArray<UserHandle> asUsers, long rawRealtimeUs, long rawUptimeUs) {
        if (statsType != 0) {
            Log.w(TAG, "refreshStats called for statsType " + statsType + " but only STATS_SINCE_CHARGED is supported. Using STATS_SINCE_CHARGED instead.");
        }
        this.getStats();
        this.mMaxPower = 0.0;
        this.mMaxRealPower = 0.0;
        this.mComputedPower = 0.0;
        this.mTotalPower = 0.0;
        this.mUsageList.clear();
        this.mMobilemsppList.clear();
        if (this.mStats == null) {
            return;
        }
        if (this.mPowerCalculators == null) {
            this.mPowerCalculators = new ArrayList<PowerCalculator>();
            this.mPowerCalculators.add(new CpuPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new MemoryPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new WakelockPowerCalculator(this.mPowerProfile));
            if (!this.mWifiOnly) {
                this.mPowerCalculators.add(new MobileRadioPowerCalculator(this.mPowerProfile));
            }
            this.mPowerCalculators.add(new WifiPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new BluetoothPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new SensorPowerCalculator(this.mContext.getSystemService(SensorManager.class)));
            this.mPowerCalculators.add(new GnssPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new CameraPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new FlashlightPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new MediaPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new PhonePowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new ScreenPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new AmbientDisplayPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new SystemServicePowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new IdlePowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new CustomMeasuredPowerCalculator(this.mPowerProfile));
            this.mPowerCalculators.add(new UserPowerCalculator());
        }
        int size = this.mPowerCalculators.size();
        for (int i = 0; i < size; ++i) {
            this.mPowerCalculators.get(i).reset();
        }
        this.mStatsType = statsType;
        this.mRawUptimeUs = rawUptimeUs;
        this.mRawRealtimeUs = rawRealtimeUs;
        this.mBatteryUptimeUs = this.mStats.getBatteryUptime(rawUptimeUs);
        this.mBatteryRealtimeUs = this.mStats.getBatteryRealtime(rawRealtimeUs);
        this.mBatteryTimeRemainingUs = this.mStats.computeBatteryTimeRemaining(rawRealtimeUs);
        this.mChargeTimeRemainingUs = this.mStats.computeChargeTimeRemaining(rawRealtimeUs);
        this.mStatsPeriod = this.mStats.computeBatteryRealtime(rawRealtimeUs, this.mStatsType);
        this.mMinDrainedPower = (double)this.mStats.getLowDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.mMaxDrainedPower = (double)this.mStats.getHighDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.processAppUsage(asUsers);
        Collections.sort(this.mUsageList);
        Collections.sort(this.mMobilemsppList, (lhs, rhs) -> Double.compare(rhs.mobilemspp, lhs.mobilemspp));
        if (!this.mUsageList.isEmpty()) {
            this.mMaxRealPower = this.mMaxPower = this.mUsageList.get((int)0).totalPowerMah;
            int usageListCount = this.mUsageList.size();
            for (int i = 0; i < usageListCount; ++i) {
                this.mComputedPower += this.mUsageList.get((int)i).totalPowerMah;
            }
        }
        this.mTotalPower = this.mComputedPower;
        if (this.mStats.getLowDischargeAmountSinceCharge() > 1) {
            int index;
            BatterySipper bs;
            if (this.mMinDrainedPower > this.mComputedPower) {
                double amount = this.mMinDrainedPower - this.mComputedPower;
                this.mTotalPower = this.mMinDrainedPower;
                bs = new BatterySipper(BatterySipper.DrainType.UNACCOUNTED, null, amount);
                index = Collections.binarySearch(this.mUsageList, bs);
                if (index < 0) {
                    index = -(index + 1);
                }
                this.mUsageList.add(index, bs);
                this.mMaxPower = Math.max(this.mMaxPower, amount);
            } else if (this.mMaxDrainedPower < this.mComputedPower) {
                double amount = this.mComputedPower - this.mMaxDrainedPower;
                bs = new BatterySipper(BatterySipper.DrainType.OVERCOUNTED, null, amount);
                index = Collections.binarySearch(this.mUsageList, bs);
                if (index < 0) {
                    index = -(index + 1);
                }
                this.mUsageList.add(index, bs);
                this.mMaxPower = Math.max(this.mMaxPower, amount);
            }
        }
        double hiddenPowerMah = this.removeHiddenBatterySippers(this.mUsageList);
        double totalRemainingPower = this.getTotalPower() - hiddenPowerMah;
        if (Math.abs(totalRemainingPower) > 0.001) {
            int size2 = this.mUsageList.size();
            for (int i = 0; i < size2; ++i) {
                BatterySipper sipper = this.mUsageList.get(i);
                if (sipper.shouldHide) continue;
                sipper.proportionalSmearMah = hiddenPowerMah * ((sipper.totalPowerMah + sipper.screenPowerMah) / totalRemainingPower);
                sipper.sumPower();
            }
        }
    }

    private void processAppUsage(SparseArray<UserHandle> asUsers) {
        int i;
        SparseArray<? extends BatteryStats.Uid> uidStats = this.mStats.getUidStats();
        ArrayList<BatterySipper> sippers = new ArrayList<BatterySipper>(uidStats.size());
        int size = uidStats.size();
        for (int iu = 0; iu < size; ++iu) {
            BatteryStats.Uid u = uidStats.valueAt(iu);
            sippers.add(new BatterySipper(BatterySipper.DrainType.APP, u, 0.0));
        }
        size = this.mPowerCalculators.size();
        for (i = 0; i < size; ++i) {
            PowerCalculator calculator = this.mPowerCalculators.get(i);
            calculator.calculate(sippers, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType, asUsers);
        }
        for (i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper sipper = (BatterySipper)sippers.get(i);
            double totalPower = sipper.sumPower();
            if (totalPower == 0.0 && sipper.getUid() != 0) continue;
            if (sipper.drainType == BatterySipper.DrainType.APP) {
                sipper.computeMobilemspp();
                if (sipper.mobilemspp != 0.0) {
                    this.mMobilemsppList.add(sipper);
                }
            }
            if (sipper.isAggregated) continue;
            this.mUsageList.add(sipper);
        }
    }

    @UnsupportedAppUsage
    public List<BatterySipper> getUsageList() {
        return this.mUsageList;
    }

    public List<BatterySipper> getMobilemsppList() {
        return this.mMobilemsppList;
    }

    public long getStatsPeriod() {
        return this.mStatsPeriod;
    }

    public int getStatsType() {
        return this.mStatsType;
    }

    @UnsupportedAppUsage
    public double getMaxPower() {
        return this.mMaxPower;
    }

    public double getMaxRealPower() {
        return this.mMaxRealPower;
    }

    @UnsupportedAppUsage
    public double getTotalPower() {
        return this.mTotalPower;
    }

    public double getComputedPower() {
        return this.mComputedPower;
    }

    public double getMinDrainedPower() {
        return this.mMinDrainedPower;
    }

    public double getMaxDrainedPower() {
        return this.mMaxDrainedPower;
    }

    public static byte[] readFully(FileInputStream stream) throws IOException {
        return BatteryStatsHelper.readFully(stream, stream.available());
    }

    public static byte[] readFully(FileInputStream stream, int avail) throws IOException {
        int pos = 0;
        byte[] data = new byte[avail];
        int amt;
        while ((amt = stream.read(data, pos, data.length - pos)) > 0) {
            avail = stream.available();
            if (avail <= data.length - (pos += amt)) continue;
            byte[] newData = new byte[pos + avail];
            System.arraycopy(data, 0, newData, 0, pos);
            data = newData;
        }
        return data;
    }

    public double removeHiddenBatterySippers(List<BatterySipper> sippers) {
        double proportionalSmearPowerMah = 0.0;
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper sipper = sippers.get(i);
            sipper.shouldHide = this.shouldHideSipper(sipper);
            if (!sipper.shouldHide || sipper.drainType == BatterySipper.DrainType.OVERCOUNTED || sipper.drainType == BatterySipper.DrainType.SCREEN || sipper.drainType == BatterySipper.DrainType.AMBIENT_DISPLAY || sipper.drainType == BatterySipper.DrainType.UNACCOUNTED || sipper.drainType == BatterySipper.DrainType.BLUETOOTH || sipper.drainType == BatterySipper.DrainType.WIFI || sipper.drainType == BatterySipper.DrainType.IDLE) continue;
            proportionalSmearPowerMah += sipper.totalPowerMah;
        }
        return proportionalSmearPowerMah;
    }

    public boolean shouldHideSipper(BatterySipper sipper) {
        BatterySipper.DrainType drainType = sipper.drainType;
        return drainType == BatterySipper.DrainType.IDLE || drainType == BatterySipper.DrainType.CELL || drainType == BatterySipper.DrainType.SCREEN || drainType == BatterySipper.DrainType.AMBIENT_DISPLAY || drainType == BatterySipper.DrainType.UNACCOUNTED || drainType == BatterySipper.DrainType.OVERCOUNTED || this.isTypeService(sipper) || this.isTypeSystem(sipper);
    }

    public boolean isTypeService(BatterySipper sipper) {
        String[] packages = this.mPackageManager.getPackagesForUid(sipper.getUid());
        if (packages == null) {
            return false;
        }
        for (String packageName : packages) {
            if (!ArrayUtils.contains(this.mServicepackageArray, packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeSystem(BatterySipper sipper) {
        int uid = sipper.uidObj == null ? -1 : sipper.getUid();
        sipper.mPackages = this.mPackageManager.getPackagesForUid(uid);
        if (uid >= 0 && uid < 10000) {
            return true;
        }
        if (sipper.mPackages != null) {
            for (String packageName : sipper.mPackages) {
                if (!ArrayUtils.contains(this.mSystemPackageArray, packageName)) continue;
                return true;
            }
        }
        return false;
    }

    public long convertUsToMs(long timeUs) {
        return timeUs / 1000L;
    }

    public long convertMsToUs(long timeMs) {
        return timeMs * 1000L;
    }

    @VisibleForTesting
    public void setPackageManager(PackageManager packageManager) {
        this.mPackageManager = packageManager;
    }

    @VisibleForTesting
    public void setSystemPackageArray(String[] array2) {
        this.mSystemPackageArray = array2;
    }

    @VisibleForTesting
    public void setServicePackageArray(String[] array2) {
        this.mServicepackageArray = array2;
    }

    @UnsupportedAppUsage
    private void load() {
        this.load(true);
    }

    private void load(boolean updateAll) {
        if (this.mBatteryInfo == null) {
            return;
        }
        this.mStats = BatteryStatsHelper.getStats(this.mBatteryInfo, updateAll);
        if (this.mCollectBatteryBroadcast) {
            this.mBatteryBroadcast = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }
    }

    private static BatteryStatsImpl getStats(IBatteryStats service, boolean updateAll) {
        block10: {
            BatteryStatsImpl batteryStatsImpl;
            ParcelFileDescriptor pfd = service.getStatisticsStream(updateAll);
            if (pfd == null) break block10;
            ParcelFileDescriptor.AutoCloseInputStream fis = new ParcelFileDescriptor.AutoCloseInputStream(pfd);
            try {
                BatteryStatsImpl stats;
                byte[] data = BatteryStatsHelper.readFully(fis, MemoryFile.getSize(pfd.getFileDescriptor()));
                Parcel parcel = Parcel.obtain();
                parcel.unmarshall(data, 0, data.length);
                parcel.setDataPosition(0);
                batteryStatsImpl = stats = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            ((FileInputStream)fis).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Log.w(TAG, "Unable to read statistics stream", e);
                    }
                }
                catch (RemoteException e) {
                    Log.w(TAG, "RemoteException:", e);
                }
            }
            ((FileInputStream)fis).close();
            return batteryStatsImpl;
        }
        return new BatteryStatsImpl();
    }

    static {
        sFileXfer = new ArrayMap();
    }
}

