/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.Parcel;
import com.android.internal.os.BatteryStatsHistory;
import java.util.List;

public class BatteryStatsHistoryIterator {
    private static final boolean DEBUG = false;
    private static final String TAG = "BatteryStatsHistoryItr";
    private final BatteryStatsHistory mBatteryStatsHistory;
    private final BatteryStats.HistoryStepDetails mReadHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    private final String[] mReadHistoryStrings;
    private final int[] mReadHistoryUids;

    public BatteryStatsHistoryIterator(BatteryStatsHistory history, List<BatteryStats.HistoryTag> historyTagPool) {
        this.mBatteryStatsHistory = history;
        this.mBatteryStatsHistory.startIteratingHistory();
        this.mReadHistoryStrings = new String[historyTagPool.size()];
        this.mReadHistoryUids = new int[historyTagPool.size()];
        for (int i = historyTagPool.size() - 1; i >= 0; --i) {
            BatteryStats.HistoryTag tag = historyTagPool.get(i);
            int idx = tag.poolIdx;
            this.mReadHistoryStrings[idx] = tag.string;
            this.mReadHistoryUids[idx] = tag.uid;
        }
    }

    public boolean next(BatteryStats.HistoryItem out) {
        Parcel p = this.mBatteryStatsHistory.getNextParcel(out);
        if (p == null) {
            this.mBatteryStatsHistory.finishIteratingHistory();
            return false;
        }
        long lastRealtimeMs = out.time;
        long lastWalltimeMs = out.currentTime;
        this.readHistoryDelta(p, out);
        if (out.cmd != 5 && out.cmd != 7 && lastWalltimeMs != 0L) {
            out.currentTime = lastWalltimeMs + (out.time - lastRealtimeMs);
        }
        return true;
    }

    void readHistoryDelta(Parcel src, BatteryStats.HistoryItem cur) {
        int batteryLevelInt;
        int firstToken = src.readInt();
        int deltaTimeToken = firstToken & 0x7FFFF;
        cur.cmd = 0;
        cur.numReadInts = 1;
        if (deltaTimeToken < 524285) {
            cur.time += (long)deltaTimeToken;
        } else {
            if (deltaTimeToken == 524285) {
                cur.readFromParcel(src);
                return;
            }
            if (deltaTimeToken == 524286) {
                int delta = src.readInt();
                cur.time += (long)delta;
                ++cur.numReadInts;
            } else {
                long delta = src.readLong();
                cur.time += delta;
                cur.numReadInts += 2;
            }
        }
        if ((firstToken & 0x80000) != 0) {
            batteryLevelInt = src.readInt();
            BatteryStatsHistoryIterator.readBatteryLevelInt(batteryLevelInt, cur);
            ++cur.numReadInts;
        } else {
            batteryLevelInt = 0;
        }
        if ((firstToken & 0x100000) != 0) {
            int stateInt = src.readInt();
            cur.states = firstToken & 0xFE000000 | stateInt & 0xFFFFFF;
            cur.batteryStatus = (byte)(stateInt >> 29 & 7);
            cur.batteryHealth = (byte)(stateInt >> 26 & 7);
            cur.batteryPlugType = (byte)(stateInt >> 24 & 3);
            switch (cur.batteryPlugType) {
                case 1: {
                    cur.batteryPlugType = 1;
                    break;
                }
                case 2: {
                    cur.batteryPlugType = (byte)2;
                    break;
                }
                case 3: {
                    cur.batteryPlugType = (byte)4;
                }
            }
            ++cur.numReadInts;
        } else {
            cur.states = firstToken & 0xFE000000 | cur.states & 0xFFFFFF;
        }
        if ((firstToken & 0x200000) != 0) {
            cur.states2 = src.readInt();
        }
        if ((firstToken & 0x400000) != 0) {
            int indexes = src.readInt();
            int wakeLockIndex = indexes & 0xFFFF;
            int wakeReasonIndex = indexes >> 16 & 0xFFFF;
            if (wakeLockIndex != 65535) {
                cur.wakelockTag = cur.localWakelockTag;
                this.readHistoryTag(wakeLockIndex, cur.wakelockTag);
            } else {
                cur.wakelockTag = null;
            }
            if (wakeReasonIndex != 65535) {
                cur.wakeReasonTag = cur.localWakeReasonTag;
                this.readHistoryTag(wakeReasonIndex, cur.wakeReasonTag);
            } else {
                cur.wakeReasonTag = null;
            }
            ++cur.numReadInts;
        } else {
            cur.wakelockTag = null;
            cur.wakeReasonTag = null;
        }
        if ((firstToken & 0x800000) != 0) {
            cur.eventTag = cur.localEventTag;
            int codeAndIndex = src.readInt();
            cur.eventCode = codeAndIndex & 0xFFFF;
            int index = codeAndIndex >> 16 & 0xFFFF;
            this.readHistoryTag(index, cur.eventTag);
            ++cur.numReadInts;
        } else {
            cur.eventCode = 0;
        }
        if ((batteryLevelInt & 1) != 0) {
            cur.stepDetails = this.mReadHistoryStepDetails;
            cur.stepDetails.readFromParcel(src);
        } else {
            cur.stepDetails = null;
        }
        if ((firstToken & 0x1000000) != 0) {
            cur.batteryChargeUah = src.readInt();
        }
        cur.modemRailChargeMah = src.readDouble();
        cur.wifiRailChargeMah = src.readDouble();
    }

    int getHistoryStringPoolSize() {
        return this.mReadHistoryStrings.length;
    }

    int getHistoryStringPoolBytes() {
        int totalChars = 0;
        for (int i = this.mReadHistoryStrings.length - 1; i >= 0; --i) {
            if (this.mReadHistoryStrings[i] == null) continue;
            totalChars += this.mReadHistoryStrings[i].length() + 1;
        }
        return this.mReadHistoryStrings.length * 12 + totalChars * 2;
    }

    String getHistoryTagPoolString(int index) {
        return this.mReadHistoryStrings[index];
    }

    int getHistoryTagPoolUid(int index) {
        return this.mReadHistoryUids[index];
    }

    private void readHistoryTag(int index, BatteryStats.HistoryTag tag) {
        if (index < this.mReadHistoryStrings.length) {
            tag.string = this.mReadHistoryStrings[index];
            tag.uid = this.mReadHistoryUids[index];
        } else {
            tag.string = null;
            tag.uid = 0;
        }
        tag.poolIdx = index;
    }

    private static void readBatteryLevelInt(int batteryLevelInt, BatteryStats.HistoryItem out) {
        out.batteryLevel = (byte)((batteryLevelInt & 0xFE000000) >>> 25);
        out.batteryTemperature = (short)((batteryLevelInt & 0x1FF8000) >>> 15);
        out.batteryVoltage = (char)((batteryLevelInt & 0x7FFE) >>> 1);
    }
}

