/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class CustomMeasuredPowerCalculator
extends PowerCalculator {
    public CustomMeasuredPowerCalculator(PowerProfile powerProfile) {
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        int i;
        double[] totalAppPowerMah = null;
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder.getUidBatteryConsumerBuilders();
        for (int i2 = uidBatteryConsumerBuilders.size() - 1; i2 >= 0; --i2) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i2);
            totalAppPowerMah = this.calculateApp(app, app.getBatteryStatsUid(), totalAppPowerMah);
        }
        double[] customMeasuredPowerMah = this.calculateMeasuredEnergiesMah(batteryStats.getCustomConsumerMeasuredBatteryConsumptionUC());
        if (customMeasuredPowerMah != null) {
            AggregateBatteryConsumer.Builder deviceBatteryConsumerBuilder = builder.getAggregateBatteryConsumerBuilder(0);
            for (i = 0; i < customMeasuredPowerMah.length; ++i) {
                deviceBatteryConsumerBuilder.setConsumedPowerForCustomComponent(1000 + i, customMeasuredPowerMah[i]);
            }
        }
        if (totalAppPowerMah != null) {
            AggregateBatteryConsumer.Builder appsBatteryConsumerBuilder = builder.getAggregateBatteryConsumerBuilder(1);
            for (i = 0; i < totalAppPowerMah.length; ++i) {
                appsBatteryConsumerBuilder.setConsumedPowerForCustomComponent(1000 + i, totalAppPowerMah[i]);
            }
        }
    }

    private double[] calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, double[] totalPowerMah) {
        double[] newTotalPowerMah = null;
        double[] customMeasuredPowerMah = this.calculateMeasuredEnergiesMah(u.getCustomConsumerMeasuredBatteryConsumptionUC());
        if (customMeasuredPowerMah != null) {
            if (totalPowerMah == null) {
                newTotalPowerMah = new double[customMeasuredPowerMah.length];
            } else if (totalPowerMah.length != customMeasuredPowerMah.length) {
                newTotalPowerMah = new double[customMeasuredPowerMah.length];
                System.arraycopy(totalPowerMah, 0, newTotalPowerMah, 0, customMeasuredPowerMah.length);
            } else {
                newTotalPowerMah = totalPowerMah;
            }
            for (int i = 0; i < customMeasuredPowerMah.length; ++i) {
                app.setConsumedPowerForCustomComponent(1000 + i, customMeasuredPowerMah[i]);
                int n = i;
                newTotalPowerMah[n] = newTotalPowerMah[n] + customMeasuredPowerMah[i];
            }
        }
        return newTotalPowerMah;
    }

    @Override
    protected void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        this.updateCustomMeasuredPowerMah(app, u.getCustomConsumerMeasuredBatteryConsumptionUC());
    }

    private void updateCustomMeasuredPowerMah(BatterySipper sipper, long[] measuredChargeUC) {
        sipper.customMeasuredPowerMah = this.calculateMeasuredEnergiesMah(measuredChargeUC);
    }

    private double[] calculateMeasuredEnergiesMah(long[] measuredChargeUC) {
        if (measuredChargeUC == null) {
            return null;
        }
        double[] measuredEnergiesMah = new double[measuredChargeUC.length];
        for (int i = 0; i < measuredChargeUC.length; ++i) {
            measuredEnergiesMah[i] = CustomMeasuredPowerCalculator.uCtoMah(measuredChargeUC[i]);
        }
        return measuredEnergiesMah;
    }
}

