/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import java.util.List;

public class GnssPowerCalculator
extends PowerCalculator {
    private final double mAveragePowerGnssOn;
    private final double[] mAveragePowerPerSignalQuality;

    public GnssPowerCalculator(PowerProfile profile) {
        this.mAveragePowerGnssOn = profile.getAveragePowerOrDefault("gps.on", -1.0);
        this.mAveragePowerPerSignalQuality = new double[2];
        for (int i = 0; i < 2; ++i) {
            this.mAveragePowerPerSignalQuality[i] = profile.getAveragePower("gps.signalqualitybased", i);
        }
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        double appsPowerMah = 0.0;
        double averageGnssPowerMa = this.getAverageGnssPower(batteryStats, rawRealtimeUs, 0);
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            long consumptionUC = app.getBatteryStatsUid().getGnssMeasuredBatteryConsumptionUC();
            int powerModel = GnssPowerCalculator.getPowerModel(consumptionUC, query);
            appsPowerMah += this.calculateApp(app, app.getBatteryStatsUid(), powerModel, rawRealtimeUs, averageGnssPowerMa, consumptionUC);
        }
        long consumptionUC = batteryStats.getGnssMeasuredBatteryConsumptionUC();
        int powerModel = GnssPowerCalculator.getPowerModel(consumptionUC, query);
        double powerMah = powerModel == 2 ? GnssPowerCalculator.uCtoMah(consumptionUC) : appsPowerMah;
        builder.getAggregateBatteryConsumerBuilder(0).setConsumedPower(10, powerMah, powerModel);
        builder.getAggregateBatteryConsumerBuilder(1).setConsumedPower(10, appsPowerMah, powerModel);
    }

    private double calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, int powerModel, long rawRealtimeUs, double averageGnssPowerMa, long measuredChargeUC) {
        double powerMah;
        long durationMs = this.computeDuration(u, rawRealtimeUs, 0);
        switch (powerModel) {
            case 2: {
                powerMah = GnssPowerCalculator.uCtoMah(measuredChargeUC);
                break;
            }
            default: {
                powerMah = this.computePower(durationMs, averageGnssPowerMa);
            }
        }
        ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(10, durationMs)).setConsumedPower(10, powerMah, powerModel);
        return powerMah;
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        double averageGnssPowerMa = this.getAverageGnssPower(batteryStats, rawRealtimeUs, statsType);
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper app = sippers.get(i);
            if (app.drainType != BatterySipper.DrainType.APP) continue;
            long consumptionUC = app.uidObj.getGnssMeasuredBatteryConsumptionUC();
            int powerModel = GnssPowerCalculator.getPowerModel(consumptionUC);
            this.calculateApp(app, app.uidObj, powerModel, rawRealtimeUs, averageGnssPowerMa, consumptionUC);
        }
    }

    private void calculateApp(BatterySipper app, BatteryStats.Uid u, int powerModel, long rawRealtimeUs, double averageGnssPowerMa, long measuredChargeUC) {
        double powerMah;
        long durationMs = this.computeDuration(u, rawRealtimeUs, 0);
        switch (powerModel) {
            case 2: {
                powerMah = GnssPowerCalculator.uCtoMah(measuredChargeUC);
                break;
            }
            default: {
                powerMah = this.computePower(durationMs, averageGnssPowerMa);
            }
        }
        app.gpsTimeMs = durationMs;
        app.gpsPowerMah = powerMah;
    }

    private long computeDuration(BatteryStats.Uid u, long rawRealtimeUs, int statsType) {
        SparseArray<? extends BatteryStats.Uid.Sensor> sensorStats = u.getSensorStats();
        BatteryStats.Uid.Sensor sensor = sensorStats.get(-10000);
        if (sensor == null) {
            return 0L;
        }
        BatteryStats.Timer timer = sensor.getSensorTime();
        return timer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
    }

    private double computePower(long sensorTime, double averageGnssPowerMa) {
        return (double)sensorTime * averageGnssPowerMa / 3600000.0;
    }

    private double getAverageGnssPower(BatteryStats stats, long rawRealtimeUs, int statsType) {
        double averagePower = this.mAveragePowerGnssOn;
        if (averagePower != -1.0) {
            return averagePower;
        }
        averagePower = 0.0;
        long totalTime = 0L;
        double totalPower = 0.0;
        for (int i = 0; i < 2; ++i) {
            long timePerLevel = stats.getGpsSignalQualityTime(i, rawRealtimeUs, statsType);
            totalTime += timePerLevel;
            totalPower += this.mAveragePowerPerSignalQuality[i] * (double)timePerLevel;
        }
        if (totalTime != 0L) {
            averagePower = totalPower / (double)totalTime;
        }
        return averagePower;
    }
}

